/*
 * Decompiled with CFR 0.152.
 */
package net.revenj.database.postgres.converters;

import net.revenj.database.postgres.PostgresBuffer;
import net.revenj.database.postgres.PostgresReader;
import net.revenj.database.postgres.converters.Converter;
import net.revenj.database.postgres.converters.HstoreConverter$;
import net.revenj.database.postgres.converters.LongConverter$;
import net.revenj.database.postgres.converters.PostgresTuple;
import net.revenj.database.postgres.converters.RecordTuple;
import net.revenj.database.postgres.converters.StringConverter$;
import net.revenj.storage.S3;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IndexedSeq;
import scala.collection.immutable.Map;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public final class S3Converter$
implements Converter<S3> {
    public static final S3Converter$ MODULE$ = new S3Converter$();
    private static final String dbName;
    private static IndexedSeq<S3> net$revenj$database$postgres$converters$Converter$$emptyCollection;
    private static Some<IndexedSeq<S3>> net$revenj$database$postgres$converters$Converter$$someEmptyCollection;
    private static IndexedSeq<Option<S3>> net$revenj$database$postgres$converters$Converter$$emptyOptionCollection;
    private static Some<IndexedSeq<Option<S3>>> net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection;

    static {
        Converter.$init$((Converter)MODULE$);
        dbName = "s3";
    }

    public Object parse(PostgresReader reader, int context) {
        return Converter.parse$((Converter)this, (PostgresReader)reader, (int)context);
    }

    public Option<S3> parseOption(PostgresReader reader, int context) {
        return Converter.parseOption$((Converter)this, (PostgresReader)reader, (int)context);
    }

    public IndexedSeq<S3> parseCollection(PostgresReader reader, int context) {
        return Converter.parseCollection$((Converter)this, (PostgresReader)reader, (int)context);
    }

    public IndexedSeq<Option<S3>> parseNullableCollection(PostgresReader reader, int context) {
        return Converter.parseNullableCollection$((Converter)this, (PostgresReader)reader, (int)context);
    }

    public Option<IndexedSeq<S3>> parseCollectionOption(PostgresReader reader, int context) {
        return Converter.parseCollectionOption$((Converter)this, (PostgresReader)reader, (int)context);
    }

    public Option<IndexedSeq<Option<S3>>> parseNullableCollectionOption(PostgresReader reader, int context) {
        return Converter.parseNullableCollectionOption$((Converter)this, (PostgresReader)reader, (int)context);
    }

    public PostgresTuple toTuple(Option<S3> value) {
        return Converter.toTuple$((Converter)this, value);
    }

    public IndexedSeq<S3> net$revenj$database$postgres$converters$Converter$$emptyCollection() {
        return net$revenj$database$postgres$converters$Converter$$emptyCollection;
    }

    public Some<IndexedSeq<S3>> net$revenj$database$postgres$converters$Converter$$someEmptyCollection() {
        return net$revenj$database$postgres$converters$Converter$$someEmptyCollection;
    }

    public IndexedSeq<Option<S3>> net$revenj$database$postgres$converters$Converter$$emptyOptionCollection() {
        return net$revenj$database$postgres$converters$Converter$$emptyOptionCollection;
    }

    public Some<IndexedSeq<Option<S3>>> net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection() {
        return net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection;
    }

    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$emptyCollection_$eq(IndexedSeq<S3> x$1) {
        net$revenj$database$postgres$converters$Converter$$emptyCollection = x$1;
    }

    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$someEmptyCollection_$eq(Some<IndexedSeq<S3>> x$1) {
        net$revenj$database$postgres$converters$Converter$$someEmptyCollection = x$1;
    }

    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$emptyOptionCollection_$eq(IndexedSeq<Option<S3>> x$1) {
        net$revenj$database$postgres$converters$Converter$$emptyOptionCollection = x$1;
    }

    public final void net$revenj$database$postgres$converters$Converter$_setter_$net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection_$eq(Some<IndexedSeq<Option<S3>>> x$1) {
        net$revenj$database$postgres$converters$Converter$$someEmptyOptionCollection = x$1;
    }

    private String toDatabase(S3 value) {
        String map = HstoreConverter$.MODULE$.toTuple(value.metadata()).buildTuple(false);
        String name = value.name().isEmpty() ? "" : S3Converter$.escape$1((String)value.name().get());
        String mimeType = value.mimeType().isEmpty() ? "" : S3Converter$.escape$1((String)value.mimeType().get());
        return new StringBuilder(13).append("(").append(value.bucket()).append(",").append(value.key()).append(",").append(value.length()).append(",\"").append(name).append("\",\"").append(mimeType).append("\",\"").append(S3Converter$.escape$1(map)).append("\")").toString();
    }

    public void serializeURI(PostgresBuffer sw, S3 value) {
        String str = this.toDatabase(value);
        sw.addToBuffer(str);
    }

    public void serializeCompositeURI(PostgresBuffer sw, S3 value) {
        String str = this.toDatabase(value);
        StringConverter$.MODULE$.serializeCompositeURI(sw, str);
    }

    public String dbName() {
        return dbName;
    }

    public S3 default() {
        return null;
    }

    public S3 parseRaw(PostgresReader reader, int start, int context) {
        return this.parseS3(reader, context, context > 0 ? context << 1 : 1);
    }

    private S3 parseS3(PostgresReader reader, int context, int innerContext) {
        reader.read(context);
        String bucket = (String)StringConverter$.MODULE$.parse(reader, innerContext);
        String key = (String)StringConverter$.MODULE$.parse(reader, innerContext);
        long length = LongConverter$.MODULE$.parse(reader, innerContext);
        Option name = StringConverter$.MODULE$.parseOption(reader, innerContext);
        Option mimeType = StringConverter$.MODULE$.parseOption(reader, innerContext);
        Map metadata = (Map)HstoreConverter$.MODULE$.parse(reader, innerContext);
        reader.read(context + 1);
        return new S3(bucket, key, length, (Option<String>)name, (Option<String>)mimeType, (Map<String, String>)metadata);
    }

    public S3 parseCollectionItem(PostgresReader reader, int context) {
        if (reader.read() == 78) {
            reader.read(4);
            return null;
        }
        return this.parseS3(reader, context, context == 0 ? 1 : context << 1);
    }

    public Option<S3> parseNullableCollectionItem(PostgresReader reader, int context) {
        if (reader.read() == 78) {
            reader.read(4);
            return None$.MODULE$;
        }
        return new Some((Object)this.parseS3(reader, context, context == 0 ? 1 : context << 1));
    }

    public PostgresTuple toTuple(S3 value) {
        return new RecordTuple(new PostgresTuple[]{StringConverter$.MODULE$.toTuple(value.bucket()), StringConverter$.MODULE$.toTuple(value.key()), LongConverter$.MODULE$.toTuple(value.length()), StringConverter$.MODULE$.toTuple(value.name()), StringConverter$.MODULE$.toTuple(value.mimeType()), HstoreConverter$.MODULE$.toTuple(value.metadata())});
    }

    private static final String escape$1(String input) {
        return input.replace("\\", "\\\\").replace("\"", "\\\"");
    }

    private S3Converter$() {
    }
}

