/*
 * Decompiled with CFR 0.152.
 */
package net.rk4z.beacon;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.rk4z.beacon.CancellableEvent;
import net.rk4z.beacon.Event;
import net.rk4z.beacon.EventHook;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J.\u0010\u000e\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000bH\u0007J.\u0010\u0013\u001a\u00020\u000f\"\b\b\u0000\u0010\u0010*\u00020\t2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u0002H\u00100\b2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u00100\u000bH\u0007J+\u0010\u0014\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u0002H\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J+\u0010\u0019\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u0002H\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J+\u0010\u001a\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u0002H\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u0018J=\u0010\u001b\u001a\b\u0012\u0004\u0012\u0002H\u00100\u001c\"\b\b\u0000\u0010\u0010*\u00020\t2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00100\u001e\"\u0002H\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u001fJ;\u0010 \u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u0002H\u00102\u0006\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010%J;\u0010&\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u0002H\u00102\u0006\u0010'\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010%J3\u0010(\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u0002H\u00102\u0006\u0010)\u001a\u00020*2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010+J?\u0010,\u001a\u0002H\u0010\"\b\b\u0000\u0010\u0010*\u00020\t2\u0006\u0010\u0015\u001a\u0002H\u00102\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u0002H\u0010\u0012\u0004\u0012\u00020\u000f0.2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010/J=\u00100\u001a\b\u0012\u0004\u0012\u0002H\u00100\u001c\"\b\b\u0000\u0010\u0010*\u00020\t2\u0012\u0010\u001d\u001a\n\u0012\u0006\b\u0001\u0012\u0002H\u00100\u001e\"\u0002H\u00102\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0007\u00a2\u0006\u0002\u0010\u001fJ\b\u00101\u001a\u00020\u000fH\u0007J\b\u00102\u001a\u00020\u000fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R0\u0010\u0006\u001a$\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\t0\b\u0012\u0012\u0012\u0010\u0012\f\u0012\n\u0012\u0006\b\u0000\u0012\u00020\t0\u000b0\n0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lnet/rk4z/beacon/EventBus;", "", "<init>", "()V", "logger", "Lorg/slf4j/Logger;", "registry", "", "Ljava/lang/Class;", "Lnet/rk4z/beacon/Event;", "Ljava/util/concurrent/CopyOnWriteArrayList;", "Lnet/rk4z/beacon/EventHook;", "asyncExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "registerEventHook", "", "T", "eventClass", "eventHook", "unregisterEventHook", "post", "event", "enableDebugLog", "", "(Lnet/rk4z/beacon/Event;Ljava/lang/Boolean;)Lnet/rk4z/beacon/Event;", "postAsync", "postSynchronous", "postParallel", "", "events", "", "([Lnet/rk4z/beacon/Event;Ljava/lang/Boolean;)Ljava/util/List;", "postDelayed", "delay", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "(Lnet/rk4z/beacon/Event;JLjava/util/concurrent/TimeUnit;Ljava/lang/Boolean;)Lnet/rk4z/beacon/Event;", "postWithTimeout", "timeout", "postRepeated", "repeatCount", "", "(Lnet/rk4z/beacon/Event;ILjava/lang/Boolean;)Lnet/rk4z/beacon/Event;", "postWithCallback", "callback", "Lkotlin/Function1;", "(Lnet/rk4z/beacon/Event;Lkotlin/jvm/functions/Function1;Ljava/lang/Boolean;)Lnet/rk4z/beacon/Event;", "postInOrder", "initialize", "shutdown", "beacon"})
@SourceDebugExtension(value={"SMAP\nEventBus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventBus.kt\nnet/rk4z/beacon/EventBus\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,482:1\n381#2,7:483\n1010#3,2:490\n1557#3:496\n1628#3,3:497\n11102#4:492\n11437#4,3:493\n*S KotlinDebug\n*F\n+ 1 EventBus.kt\nnet/rk4z/beacon/EventBus\n*L\n41#1:483,7\n47#1:490,2\n226#1:496\n226#1:497,3\n220#1:492\n220#1:493,3\n*E\n"})
public final class EventBus {
    @NotNull
    public static final EventBus INSTANCE = new EventBus();
    @NotNull
    private static final Logger logger;
    @NotNull
    private static final Map<Class<? extends Event>, CopyOnWriteArrayList<EventHook<? super Event>>> registry;
    private static ScheduledExecutorService asyncExecutor;

    private EventBus() {
    }

    @JvmStatic
    public static final <T extends Event> void registerEventHook(@NotNull Class<T> eventClass, @NotNull EventHook<T> eventHook) {
        EventHook<T> hook;
        CopyOnWriteArrayList<EventHook<? super Event>> handlers;
        CopyOnWriteArrayList<EventHook<Event>> copyOnWriteArrayList;
        Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
        Intrinsics.checkNotNullParameter(eventHook, (String)"eventHook");
        Map<Class<? extends Event>, CopyOnWriteArrayList<EventHook<? super Event>>> $this$getOrPut$iv = registry;
        boolean $i$f$getOrPut = false;
        CopyOnWriteArrayList<EventHook<? super Event>> value$iv = $this$getOrPut$iv.get(eventClass);
        if (value$iv == null) {
            boolean bl = false;
            CopyOnWriteArrayList answer$iv = new CopyOnWriteArrayList();
            $this$getOrPut$iv.put(eventClass, answer$iv);
            copyOnWriteArrayList = answer$iv;
        } else {
            copyOnWriteArrayList = value$iv;
        }
        if (!(handlers = copyOnWriteArrayList).contains(hook = eventHook)) {
            handlers.add(hook);
            List $this$sortBy$iv = handlers;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        EventHook it = (EventHook)a;
                        boolean bl = false;
                        Comparable comparable = Integer.valueOf(it.getPriority().getV());
                        it = (EventHook)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority().getV()));
                    }
                });
            }
            logger.info("Registered event hook for " + eventClass.getSimpleName() + " with priority " + eventHook.getPriority());
        }
    }

    @JvmStatic
    public static final <T extends Event> void unregisterEventHook(@NotNull Class<T> eventClass, @NotNull EventHook<T> eventHook) {
        block0: {
            Intrinsics.checkNotNullParameter(eventClass, (String)"eventClass");
            Intrinsics.checkNotNullParameter(eventHook, (String)"eventHook");
            CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(eventClass);
            if (copyOnWriteArrayList == null) break block0;
            copyOnWriteArrayList.remove(eventHook);
        }
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T post(@NotNull T event, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling event: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        } else {
            logger.debug("Calling event: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        }
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(event.getClass());
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        Iterator<EventHook<? super Event>> iterator = target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<EventHook<? super Event>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            EventHook<? super Event> eventHook = iterator2.next();
            if (event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) {
                logger.debug("Event " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is cancelled");
                break;
            }
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !((Boolean)function0.invoke()).booleanValue() : false) continue;
            Object object2 = INSTANCE;
            try {
                EventBus $this$post_u24lambda_u243 = object2;
                boolean bl = false;
                ScheduledExecutorService scheduledExecutorService = asyncExecutor;
                if (scheduledExecutorService == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
                    scheduledExecutorService = null;
                }
                Future<?> future = scheduledExecutorService.submit(() -> EventBus.post$lambda$3$lambda$2(eventHook, event));
                Object obj = eventHook.getTimeout() != null ? future.get(eventHook.getTimeout(), TimeUnit.MILLISECONDS) : future.get();
                if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
                    logger.info("Handled event: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                } else {
                    logger.debug("Handled event: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it = object = throwable;
            boolean bl = false;
            logger.error("Exception while executing handler: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
        return event;
    }

    public static /* synthetic */ Event post$default(Event event, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return EventBus.post(event, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T postAsync(@NotNull T event, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling event asynchronously: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        } else {
            logger.debug("Calling event asynchronously: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        }
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(event.getClass());
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        Iterator<EventHook<? super Event>> iterator = target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<EventHook<? super Event>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            EventHook<? super Event> eventHook = iterator2.next();
            if (event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) {
                logger.debug("Event " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is cancelled");
                break;
            }
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !((Boolean)function0.invoke()).booleanValue() : false) continue;
            ScheduledExecutorService scheduledExecutorService = asyncExecutor;
            if (scheduledExecutorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
                scheduledExecutorService = null;
            }
            scheduledExecutorService.submit(() -> EventBus.postAsync$lambda$8(eventHook, event, enableDebugLog));
        }
        return event;
    }

    public static /* synthetic */ Event postAsync$default(Event event, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return EventBus.postAsync(event, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T postSynchronous(@NotNull T event, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling event synchronously: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        } else {
            logger.debug("Calling event synchronously: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        }
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(event.getClass());
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        Iterator<EventHook<? super Event>> iterator = target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<EventHook<? super Event>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            EventHook<? super Event> eventHook = iterator2.next();
            if (event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) {
                logger.debug("Event " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is cancelled");
                break;
            }
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !((Boolean)function0.invoke()).booleanValue() : false) continue;
            Object object2 = INSTANCE;
            try {
                EventBus $this$postSynchronous_u24lambda_u249 = object2;
                boolean bl = false;
                eventHook.getHandler().invoke(event);
                if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
                    logger.info("Handled event synchronously: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                } else {
                    logger.debug("Handled event synchronously: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it = object = throwable;
            boolean bl = false;
            logger.error("Exception while executing handler: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
        return event;
    }

    public static /* synthetic */ Event postSynchronous$default(Event event, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return EventBus.postSynchronous(event, bl);
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final <T extends Event> List<T> postParallel(@NotNull T[] events, @Nullable Boolean enableDebugLog) {
        Collection collection;
        Object $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling events in parallel");
        } else {
            logger.debug("Calling events in parallel");
        }
        Object $this$map$iv = events;
        boolean $i$f$map = false;
        T[] TArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((T[])$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (Future item$iv$iv : $this$mapTo$iv$iv) {
            void event;
            void var11_12 = item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            ScheduledExecutorService scheduledExecutorService = asyncExecutor;
            if (scheduledExecutorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
                scheduledExecutorService = null;
            }
            collection.add(scheduledExecutorService.submit(() -> EventBus.postParallel$lambda$12$lambda$11((Event)event)));
        }
        List futures = (List)destination$iv$iv;
        $this$map$iv = futures;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, (int)10));
        $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Event event;
            Future item$iv$iv;
            Object item$iv$iv2 = iterator.next();
            item$iv$iv = (Future)item$iv$iv2;
            collection = destination$iv$iv;
            boolean bl = false;
            try {
                void future;
                event = (Event)future.get();
            }
            catch (Exception e) {
                logger.error("Exception while executing parallel event: " + e.getMessage(), (Throwable)e);
                throw e;
            }
            collection.add(event);
        }
        return (List)destination$iv$iv;
    }

    public static /* synthetic */ List postParallel$default(Event[] eventArray, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return EventBus.postParallel((Event[])eventArray, (Boolean)bl);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T postDelayed(@NotNull T event, long delay, @NotNull TimeUnit timeUnit, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling event with delay: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        } else {
            logger.debug("Calling event with delay: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        }
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(event.getClass());
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        ScheduledExecutorService scheduledExecutorService = asyncExecutor;
        if (scheduledExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
            scheduledExecutorService = null;
        }
        scheduledExecutorService.schedule(() -> EventBus.postDelayed$lambda$16(target, event, enableDebugLog), delay, timeUnit);
        return event;
    }

    public static /* synthetic */ Event postDelayed$default(Event event, long l, TimeUnit timeUnit, Boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return EventBus.postDelayed(event, l, timeUnit, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T postWithTimeout(@NotNull T event, long timeout, @NotNull TimeUnit timeUnit, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling event with timeout: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        } else {
            logger.debug("Calling event with timeout: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        }
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(event.getClass());
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        Iterator<EventHook<? super Event>> iterator = target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator<EventHook<? super Event>> iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            EventHook<? super Event> eventHook = iterator2.next();
            if (event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) {
                logger.debug("Event " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is cancelled");
                break;
            }
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !((Boolean)function0.invoke()).booleanValue() : false) continue;
            ScheduledExecutorService scheduledExecutorService = asyncExecutor;
            if (scheduledExecutorService == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
                scheduledExecutorService = null;
            }
            Future<?> future = scheduledExecutorService.submit(() -> EventBus.postWithTimeout$lambda$17(eventHook, event));
            Object object2 = INSTANCE;
            try {
                EventBus $this$postWithTimeout_u24lambda_u2418 = object2;
                boolean bl = false;
                future.get(timeout, timeUnit);
                if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
                    logger.info("Handled event with timeout: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                } else {
                    logger.debug("Handled event with timeout: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it = object = throwable;
            boolean bl = false;
            logger.error("Exception while executing handler: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
        return event;
    }

    public static /* synthetic */ Event postWithTimeout$default(Event event, long l, TimeUnit timeUnit, Boolean bl, int n, Object object) {
        if ((n & 8) != 0) {
            bl = false;
        }
        return EventBus.postWithTimeout(event, l, timeUnit, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T postRepeated(@NotNull T event, int repeatCount, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling event repeated: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        } else {
            logger.debug("Calling event repeated: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        }
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(event.getClass());
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        int i = 1;
        if (i <= repeatCount) {
            while (true) {
                Iterator<EventHook<? super Event>> iterator;
                logger.debug("Repeat count: " + i + " of " + repeatCount);
                Intrinsics.checkNotNullExpressionValue(target.iterator(), (String)"iterator(...)");
                while (iterator.hasNext()) {
                    Object object;
                    EventHook<? super Event> eventHook = iterator.next();
                    if (event instanceof CancellableEvent && ((CancellableEvent)event).isCancelled()) {
                        logger.debug("Event " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " is cancelled");
                        break;
                    }
                    if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
                    Function0<Boolean> function0 = eventHook.getCondition();
                    if (function0 != null ? !((Boolean)function0.invoke()).booleanValue() : false) continue;
                    Object object2 = INSTANCE;
                    try {
                        EventBus $this$postRepeated_u24lambda_u2420 = object2;
                        boolean bl = false;
                        eventHook.getHandler().invoke(event);
                        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
                            logger.info("Handled event repeated: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                        } else {
                            logger.debug("Handled event repeated: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                        }
                        object = Result.constructor-impl((Object)Unit.INSTANCE);
                    }
                    catch (Throwable bl) {
                        object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
                    }
                    object2 = object;
                    Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
                    if (throwable == null) continue;
                    Object it = object = throwable;
                    boolean bl = false;
                    logger.error("Exception while executing handler: " + ((Throwable)it).getMessage(), (Throwable)it);
                }
                if (i == repeatCount) break;
                ++i;
            }
        }
        return event;
    }

    public static /* synthetic */ Event postRepeated$default(Event event, int n, Boolean bl, int n2, Object object) {
        if ((n2 & 4) != 0) {
            bl = false;
        }
        return EventBus.postRepeated(event, n, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> T postWithCallback(@NotNull T event, @NotNull Function1<? super T, Unit> callback, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(event, (String)"event");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling event with callback: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        } else {
            logger.debug("Calling event with callback: " + Reflection.getOrCreateKotlinClass(event.getClass()).getSimpleName());
        }
        CopyOnWriteArrayList<EventHook<? super Event>> copyOnWriteArrayList = registry.get(event.getClass());
        if (copyOnWriteArrayList == null) {
            return event;
        }
        CopyOnWriteArrayList<EventHook<? super Event>> target = copyOnWriteArrayList;
        ScheduledExecutorService scheduledExecutorService = asyncExecutor;
        if (scheduledExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
            scheduledExecutorService = null;
        }
        scheduledExecutorService.submit(() -> EventBus.postWithCallback$lambda$24(target, event, callback, enableDebugLog));
        return event;
    }

    public static /* synthetic */ Event postWithCallback$default(Event event, Function1 function1, Boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = false;
        }
        return EventBus.postWithCallback(event, function1, bl);
    }

    @JvmStatic
    @NotNull
    public static final <T extends Event> List<T> postInOrder(@NotNull T[] events, @Nullable Boolean enableDebugLog) {
        Intrinsics.checkNotNullParameter(events, (String)"events");
        if (Intrinsics.areEqual((Object)enableDebugLog, (Object)true)) {
            logger.info("Calling events in order");
        } else {
            logger.debug("Calling events in order");
        }
        List processedEvents = new ArrayList();
        for (T event : events) {
            Event processedEvent = EventBus.post$default(event, null, 2, null);
            processedEvents.add(processedEvent);
        }
        return processedEvents;
    }

    public static /* synthetic */ List postInOrder$default(Event[] eventArray, Boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return EventBus.postInOrder((Event[])eventArray, (Boolean)bl);
    }

    @JvmStatic
    public static final void initialize() {
        asyncExecutor = Executors.newScheduledThreadPool(Runtime.getRuntime().availableProcessors());
        Runtime.getRuntime().addShutdownHook(new Thread(EventBus::initialize$lambda$25));
        logger.info("EventBus initialized");
    }

    @JvmStatic
    public static final void shutdown() {
        ScheduledExecutorService scheduledExecutorService = asyncExecutor;
        if (scheduledExecutorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
            scheduledExecutorService = null;
        }
        scheduledExecutorService.shutdown();
        ScheduledExecutorService scheduledExecutorService2 = asyncExecutor;
        if (scheduledExecutorService2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"asyncExecutor");
            scheduledExecutorService2 = null;
        }
        scheduledExecutorService2.awaitTermination(10L, TimeUnit.SECONDS);
        registry.clear();
        logger.info("EventBus shutdown");
    }

    private static final void post$lambda$3$lambda$2(EventHook $eventHook, Event $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        $eventHook.getHandler().invoke((Object)$event);
    }

    private static final void postAsync$lambda$8(EventHook $eventHook, Event $event, Boolean $enableDebugLog) {
        block5: {
            Throwable throwable;
            Object $this$postAsync_u24lambda_u248_u24lambda_u245;
            Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
            Object object = INSTANCE;
            try {
                $this$postAsync_u24lambda_u248_u24lambda_u245 = object;
                boolean bl = false;
                $eventHook.getHandler().invoke((Object)$event);
                $this$postAsync_u24lambda_u248_u24lambda_u245 = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                $this$postAsync_u24lambda_u248_u24lambda_u245 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object = $this$postAsync_u24lambda_u248_u24lambda_u245;
            if (Result.isSuccess-impl((Object)object)) {
                Unit it = (Unit)object;
                boolean bl = false;
                if (Intrinsics.areEqual((Object)$enableDebugLog, (Object)true)) {
                    logger.info("Handled event asynchronously: " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass($eventHook.getHandlerClass().getClass()).getSimpleName());
                } else {
                    logger.debug("Handled event asynchronously: " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass($eventHook.getHandlerClass().getClass()).getSimpleName());
                }
            }
            Throwable throwable2 = Result.exceptionOrNull-impl((Object)object);
            if (throwable2 == null) break block5;
            Throwable it = throwable = throwable2;
            boolean bl = false;
            logger.error("Exception while executing handler asynchronously: " + it.getMessage(), it);
        }
    }

    private static final Event postParallel$lambda$12$lambda$11(Event $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        return EventBus.post$default($event, null, 2, null);
    }

    private static final void postDelayed$lambda$16(CopyOnWriteArrayList $target, Event $event, Boolean $enableDebugLog) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Iterator iterator = $target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            EventHook eventHook = (EventHook)iterator2.next();
            if ($event instanceof CancellableEvent && ((CancellableEvent)$event).isCancelled()) {
                logger.debug("Event " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " is cancelled");
                break;
            }
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !((Boolean)function0.invoke()).booleanValue() : false) continue;
            Object object2 = INSTANCE;
            try {
                EventBus $this$postDelayed_u24lambda_u2416_u24lambda_u2414 = object2;
                boolean bl = false;
                eventHook.getHandler().invoke((Object)$event);
                if (Intrinsics.areEqual((Object)$enableDebugLog, (Object)true)) {
                    logger.info("Handled event with delay: " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                } else {
                    logger.debug("Handled event with delay: " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it = object = throwable;
            boolean bl = false;
            logger.error("Exception while executing handler: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
    }

    private static final void postWithTimeout$lambda$17(EventHook $eventHook, Event $event) {
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        $eventHook.getHandler().invoke((Object)$event);
    }

    private static final void postWithCallback$lambda$24(CopyOnWriteArrayList $target, Event $event, Function1 $callback, Boolean $enableDebugLog) {
        Intrinsics.checkNotNullParameter((Object)$target, (String)"$target");
        Intrinsics.checkNotNullParameter((Object)$event, (String)"$event");
        Intrinsics.checkNotNullParameter((Object)$callback, (String)"$callback");
        Iterator iterator = $target.iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            Object object;
            EventHook eventHook = (EventHook)iterator2.next();
            if ($event instanceof CancellableEvent && ((CancellableEvent)$event).isCancelled()) {
                logger.debug("Event " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " is cancelled");
                break;
            }
            if (!eventHook.getIgnoresCondition() && !eventHook.getHandlerClass().handleEvents()) continue;
            Function0<Boolean> function0 = eventHook.getCondition();
            if (function0 != null ? !((Boolean)function0.invoke()).booleanValue() : false) continue;
            Object object2 = INSTANCE;
            try {
                EventBus $this$postWithCallback_u24lambda_u2424_u24lambda_u2422 = object2;
                boolean bl = false;
                eventHook.getHandler().invoke((Object)$event);
                if (Intrinsics.areEqual((Object)$enableDebugLog, (Object)true)) {
                    logger.info("Handled event with callback: " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                } else {
                    logger.debug("Handled event with callback: " + Reflection.getOrCreateKotlinClass($event.getClass()).getSimpleName() + " with " + Reflection.getOrCreateKotlinClass(eventHook.getHandlerClass().getClass()).getSimpleName());
                }
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable bl) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
            }
            object2 = object;
            Throwable throwable = Result.exceptionOrNull-impl((Object)object2);
            if (throwable == null) continue;
            Object it = object = throwable;
            boolean bl = false;
            logger.error("Exception while executing handler: " + ((Throwable)it).getMessage(), (Throwable)it);
        }
        $callback.invoke((Object)$event);
    }

    private static final void initialize$lambda$25() {
        EventBus.shutdown();
    }

    static {
        Logger logger = LoggerFactory.getLogger(EventBus.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        EventBus.logger = logger;
        registry = new LinkedHashMap();
    }
}

