/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core;

import java.util.HashMap;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.RoboconfError;
import org.junit.Test;

public class ErrorCodeTest {
    @Test
    public void testCodesUnicity() {
        HashMap<ErrorCode.ErrorCategory, ErrorCode> categoryToLastCode = new HashMap<ErrorCode.ErrorCategory, ErrorCode>();
        for (ErrorCode code : ErrorCode.values()) {
            ErrorCode lastCode = (ErrorCode)categoryToLastCode.get(code.getCategory());
            if (lastCode != null) {
                Assert.assertTrue((String)("RoboconfError code " + code + " is already used."), (code.getErrorId() > lastCode.getErrorId() ? 1 : 0) != 0);
            }
            categoryToLastCode.put(code.getCategory(), code);
        }
    }

    @Test
    public void testCodesPrefixes() {
        HashMap<ErrorCode.ErrorCategory, String> categoryToPrefix = new HashMap<ErrorCode.ErrorCategory, String>();
        categoryToPrefix.put(ErrorCode.ErrorCategory.CONVERSION, "CO_");
        categoryToPrefix.put(ErrorCode.ErrorCategory.PARSING, "P_");
        categoryToPrefix.put(ErrorCode.ErrorCategory.PARSING_MODEL, "PM_");
        categoryToPrefix.put(ErrorCode.ErrorCategory.RUNTIME_MODEL, "RM_");
        categoryToPrefix.put(ErrorCode.ErrorCategory.EXECUTION, "EXEC_");
        categoryToPrefix.put(ErrorCode.ErrorCategory.PROJECT, "PROJ_");
        categoryToPrefix.put(ErrorCode.ErrorCategory.RECIPES, "REC_");
        for (ErrorCode code : ErrorCode.values()) {
            String prefix = (String)categoryToPrefix.get(code.getCategory());
            Assert.assertNotNull((String)("No prefix was found for " + code), (Object)prefix);
            Assert.assertTrue((String)("Invalid prefix for " + code + ". " + prefix + " was expected."), (boolean)code.toString().startsWith(prefix));
        }
    }

    @Test
    public void testCodesUpperCase() {
        for (ErrorCode code : ErrorCode.values()) {
            Assert.assertEquals((String)(code + " should be in upper case."), (String)code.toString(), (String)code.toString().toUpperCase());
        }
    }

    @Test
    public void testToString() {
        for (ErrorCode code : ErrorCode.values()) {
            RoboconfError re = new RoboconfError(code);
            Assert.assertEquals((Object)code, (Object)re.getErrorCode());
            Assert.assertNotNull((Object)re.toString());
        }
    }
}

