/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.agents;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import net.roboconf.core.agents.DataHelpers;
import org.junit.Test;

public class DataHelpersTest {
    public static final String MESSAGING_IP = "messaging.ip";
    public static final String MESSAGING_USERNAME = "messaging.username";
    public static final String MESSAGING_PASSWORD = "messaging.password";

    @Test
    public void testWriteAndRead() throws Exception {
        String rawProperties = DataHelpers.writeUserDataAsString(DataHelpersTest.msgCfg("192.168.1.24", "user", "pwd"), (String)"app", (String)"/root");
        Properties props = DataHelpers.readUserData((String)rawProperties);
        Assert.assertEquals((String)"app", (String)props.getProperty("application.name"));
        Assert.assertEquals((String)"/root", (String)props.getProperty("scoped.instance.path"));
        Assert.assertEquals((String)"192.168.1.24", (String)props.getProperty(MESSAGING_IP));
        Assert.assertEquals((String)"pwd", (String)props.getProperty(MESSAGING_PASSWORD));
        Assert.assertEquals((String)"user", (String)props.getProperty(MESSAGING_USERNAME));
        rawProperties = DataHelpers.writeUserDataAsString(DataHelpersTest.msgCfg(null, "user", "pwd"), (String)"app", (String)"/root");
        props = DataHelpers.readUserData((String)rawProperties);
        Assert.assertEquals((String)"app", (String)props.getProperty("application.name"));
        Assert.assertEquals((String)"/root", (String)props.getProperty("scoped.instance.path"));
        Assert.assertEquals(null, (String)props.getProperty(MESSAGING_IP));
        Assert.assertEquals((String)"pwd", (String)props.getProperty(MESSAGING_PASSWORD));
        Assert.assertEquals((String)"user", (String)props.getProperty(MESSAGING_USERNAME));
        rawProperties = DataHelpers.writeUserDataAsString(DataHelpersTest.msgCfg("192.168.1.24", null, "pwd"), (String)"app", (String)"/root");
        props = DataHelpers.readUserData((String)rawProperties);
        Assert.assertEquals((String)"app", (String)props.getProperty("application.name"));
        Assert.assertEquals((String)"/root", (String)props.getProperty("scoped.instance.path"));
        Assert.assertEquals((String)"192.168.1.24", (String)props.getProperty(MESSAGING_IP));
        Assert.assertEquals((String)"pwd", (String)props.getProperty(MESSAGING_PASSWORD));
        Assert.assertEquals(null, (String)props.getProperty(MESSAGING_USERNAME));
        rawProperties = DataHelpers.writeUserDataAsString(DataHelpersTest.msgCfg("192.168.1.24", "user", null), (String)"app", (String)"root");
        props = DataHelpers.readUserData((String)rawProperties);
        Assert.assertEquals((String)"app", (String)props.getProperty("application.name"));
        Assert.assertEquals((String)"root", (String)props.getProperty("scoped.instance.path"));
        Assert.assertEquals((String)"192.168.1.24", (String)props.getProperty(MESSAGING_IP));
        Assert.assertEquals(null, (String)props.getProperty(MESSAGING_PASSWORD));
        Assert.assertEquals((String)"user", (String)props.getProperty(MESSAGING_USERNAME));
        rawProperties = DataHelpers.writeUserDataAsString(DataHelpersTest.msgCfg("192.168.1.24", "user", "pwd"), null, (String)"root");
        props = DataHelpers.readUserData((String)rawProperties);
        Assert.assertEquals(null, (String)props.getProperty("application.name"));
        Assert.assertEquals((String)"root", (String)props.getProperty("scoped.instance.path"));
        Assert.assertEquals((String)"192.168.1.24", (String)props.getProperty(MESSAGING_IP));
        Assert.assertEquals((String)"pwd", (String)props.getProperty(MESSAGING_PASSWORD));
        Assert.assertEquals((String)"user", (String)props.getProperty(MESSAGING_USERNAME));
        rawProperties = DataHelpers.writeUserDataAsString(DataHelpersTest.msgCfg("192.168.1.24", "user", "pwd"), (String)"app", null);
        props = DataHelpers.readUserData((String)rawProperties);
        Assert.assertEquals((String)"app", (String)props.getProperty("application.name"));
        Assert.assertEquals(null, (String)props.getProperty("scoped.instance.path"));
        Assert.assertEquals((String)"192.168.1.24", (String)props.getProperty(MESSAGING_IP));
        Assert.assertEquals((String)"pwd", (String)props.getProperty(MESSAGING_PASSWORD));
        Assert.assertEquals((String)"user", (String)props.getProperty(MESSAGING_USERNAME));
        rawProperties = DataHelpers.writeUserDataAsString(DataHelpersTest.msgCfg("192.168.1.24:9120", "user", "pwd"), (String)"app", null);
        props = DataHelpers.readUserData((String)rawProperties);
        Assert.assertEquals((String)"app", (String)props.getProperty("application.name"));
        Assert.assertEquals(null, (String)props.getProperty("scoped.instance.path"));
        Assert.assertEquals((String)"192.168.1.24:9120", (String)props.getProperty(MESSAGING_IP));
        Assert.assertEquals((String)"pwd", (String)props.getProperty(MESSAGING_PASSWORD));
        Assert.assertEquals((String)"user", (String)props.getProperty(MESSAGING_USERNAME));
    }

    private static Map<String, String> msgCfg(String ip, String user, String pass) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put(MESSAGING_IP, ip);
        result.put(MESSAGING_USERNAME, user);
        result.put(MESSAGING_PASSWORD, pass);
        return Collections.unmodifiableMap(result);
    }
}

