/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.ParsingModelIo;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.utils.Utils;
import org.junit.Test;

public class ParsingModelIoTest {
    private static final String PATH = "/configurations/valid";

    @Test
    public void testFileTypes() throws Exception {
        LinkedHashMap<String, Integer> fileNameToFileType = new LinkedHashMap<String, Integer>();
        fileNameToFileType.put("commented-import-1.graph", 3);
        fileNameToFileType.put("only-import-1.graph", 3);
        fileNameToFileType.put("commented-import-3.graph", 3);
        fileNameToFileType.put("only-component-3.graph", 1);
        fileNameToFileType.put("only-component-4.graph", 1);
        fileNameToFileType.put("real-lamp-all-in-one.graph", 1);
        fileNameToFileType.put("real-lamp-all-in-one-flex.graph", 1);
        fileNameToFileType.put("real-lamp-components.graph", 1);
        fileNameToFileType.put("commented-component-2.graph", 1);
        fileNameToFileType.put("instance-single.instances", 2);
        fileNameToFileType.put("instance-multiple.instances", 2);
        fileNameToFileType.put("instance-imbricated-3.instances", 2);
        for (Map.Entry entry : fileNameToFileType.entrySet()) {
            File f = TestUtils.findTestFile("/configurations/valid/" + (String)entry.getKey());
            FileDefinition rel = ParsingModelIo.readConfigurationFile((File)f, (boolean)false);
            Assert.assertEquals((String)("Invalid file type for " + (String)entry.getKey()), (int)((Integer)entry.getValue()), (int)rel.getFileType());
            Assert.assertEquals((String)((String)entry.getKey()), (int)0, (int)rel.getParsingErrors().size());
        }
    }

    @Test
    public void testInvalidFileType() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/mix.txt");
        FileDefinition def = ParsingModelIo.readConfigurationFile((File)f, (boolean)true);
        Assert.assertEquals((int)1, (int)def.getParsingErrors().size());
        Assert.assertEquals((Object)ErrorCode.P_INVALID_FILE_TYPE, (Object)((ParsingError)def.getParsingErrors().iterator().next()).getErrorCode());
    }

    @Test
    public void testComplexInstances() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/complex-instances.instances");
        FileDefinition def = ParsingModelIo.readConfigurationFile((File)f, (boolean)true);
        Assert.assertEquals((int)0, (int)def.getParsingErrors().size());
        ArrayList toProcess = new ArrayList();
        toProcess.addAll(def.getBlocks());
        ArrayList<BlockInstanceOf> instances = new ArrayList<BlockInstanceOf>();
        while (!toProcess.isEmpty()) {
            AbstractBlock currentBlock = (AbstractBlock)toProcess.remove(0);
            if (currentBlock.getInstructionType() != 6) continue;
            BlockInstanceOf blockInstanceOf = (BlockInstanceOf)currentBlock;
            instances.add(blockInstanceOf);
            toProcess.addAll(blockInstanceOf.getInnerBlocks());
        }
        Assert.assertEquals((int)8, (int)instances.size());
    }

    @Test
    public void testLoadingAndWritingOfValidFile() throws Exception {
        List<File> validFiles = TestUtils.findTestFiles(PATH);
        for (File f : validFiles) {
            if ("instance-with-space-after.instances".equals(f.getName())) continue;
            ParsingModelIoTest.testLoadingAndWritingOfValidFile(f);
        }
    }

    @Test(expected=IOException.class)
    public void saveRelatrionFileRequiresTargetFile() throws Exception {
        FileDefinition def = new FileDefinition((File)null);
        ParsingModelIo.saveRelationsFile((FileDefinition)def, (boolean)true, (String)"\n ");
    }

    private static void testLoadingAndWritingOfValidFile(File f) throws Exception {
        FileDefinition rel = ParsingModelIo.readConfigurationFile((File)f, (boolean)false);
        Assert.assertTrue((String)(f.getName() + ": parsing errors were found."), (boolean)rel.getParsingErrors().isEmpty());
        String fileContent = Utils.readFileContent((File)f);
        fileContent = fileContent.replaceAll("\r?\n", System.getProperty("line.separator"));
        String s = ParsingModelIo.writeConfigurationFile((FileDefinition)rel, (boolean)true, null);
        Assert.assertEquals((String)(f.getName() + ": serialized model is different from the source."), (String)fileContent, (String)s);
        s = ParsingModelIo.writeConfigurationFile((FileDefinition)rel, (boolean)false, null);
        Assert.assertFalse((String)(f.getName() + ": serialized model should not contain a comment delimiter."), (boolean)s.contains("#"));
        rel = ParsingModelIo.readConfigurationFile((File)f, (boolean)true);
        Assert.assertTrue((String)(f.getName() + ": parsing errors were found."), (boolean)rel.getParsingErrors().isEmpty());
        s = ParsingModelIo.writeConfigurationFile((FileDefinition)rel, (boolean)true, null);
        Assert.assertFalse((String)(f.getName() + ": serialized model should not contain a comment delimiter."), (boolean)s.contains("#"));
        s = ParsingModelIo.writeConfigurationFile((FileDefinition)rel, (boolean)false, null);
        Assert.assertFalse((String)(f.getName() + ": serialized model should not contain a comment delimiter."), (boolean)s.contains("#"));
    }

    public static void main(String[] args) {
        try {
            File f = TestUtils.findTestFile("/configurations/valid/commented-import-2.graph");
            ParsingModelIoTest.testLoadingAndWritingOfValidFile(f);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

