/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.ParsingModelValidator;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.model.ParsingError;
import org.junit.Test;

public class ParsingModelValidatorTest {
    @Test
    public void testUknown() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        AbstractBlock block = new AbstractBlock(file){

            public int getInstructionType() {
                return 501;
            }
        };
        Collection errors = ParsingModelValidator.validate((AbstractBlock)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_BLOCK_TYPE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testImport() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        BlockImport block = new BlockImport(file);
        block.setUri("another-file.txt");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockImport)block).size());
        block.setUri("http://server/another-file.txt");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockImport)block).size());
        block.setUri("");
        Collection errors = ParsingModelValidator.validate((BlockImport)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_IMPORT_LOCATION, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testBlank() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        BlockBlank block = new BlockBlank(file, "");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockBlank)block).size());
        block = new BlockBlank(file, "\t\n");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockBlank)block).size());
        block = new BlockBlank(file, "\t  \n   \n  ");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockBlank)block).size());
        block = new BlockBlank(file, "\nInvalid blank line\n");
        Collection errors = ParsingModelValidator.validate((BlockBlank)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_MALFORMED_BLANK, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testComment() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        BlockComment block = new BlockComment(file, "# some comment");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((AbstractBlock)block).size());
        block = new BlockComment(file, "##### some comment");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockComment)block).size());
        block = new BlockComment(file, "# comment 1\n#comment 2\n# Comment number blabla");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockComment)block).size());
        block = new BlockComment(file, "# Comment 1\nOops, I forgot the sharp symbol\n# Another comment");
        Collection errors = ParsingModelValidator.validate((BlockComment)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_MALFORMED_COMMENT, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testProperty() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        BlockProperty block = new BlockProperty(file);
        block.setNameAndValue("installer", "");
        Collection errors = ParsingModelValidator.validate((AbstractBlock)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("installer", "installerName");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("installer", "installer-name");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("installer", "installer.name");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("installer", "installer#name");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_INSTALLER_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("children", "");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("children", "facet1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("children", "facet1, facet2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("children", "facet1 , facet2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("children", "facet1 , facet2, facet3453_, facet-, facet.");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("children", "-facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_CHILD_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("children", ".facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_CHILD_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("children", "facet#");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_CHILD_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("children", "facet;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_CHILD_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("children", "facet with spaces");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.setNameAndValue("children", "facet with\ttabs");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_CHILD_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", "");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", "facet1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("facets", "_facet1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("facets", "facet1, facet2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("facets", "facet1 , facet2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("facets", "facet1 , facet2, facet3453_, facet-, facet.");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("facets", "-facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", ".facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", "54_facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", "facet#");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", "facet;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", "facet with spaces");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.setNameAndValue("facets", "facet with special ch@r@cters");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("facets", "facet1, , facet2");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_REFERENCED_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", "");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", "facet1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("extends", "_facet1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("extends", "facet1, facet2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("extends", "facet1 , facet2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("extends", "facet1 , facet2, facet3453_, facet-, facet.");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("extends", "-facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", ".facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", "54_facet");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", "facet#");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", "facet;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", "facet with spaces");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.setNameAndValue("extends", "facet with\ttabs and speci@l");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("extends", "facet1,,facet2");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_REFERENCED_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "var1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("exports", "_var1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("exports", "var1 , var2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("exports", "var1=value1, var2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("exports", "var1 = value1 , var2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("exports", "var1, var2 = value2");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("exports", "var1, var2 = value2 , var3");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("exports", "-var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", ".var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "2var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "var#");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "var;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "var1, var2;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "var1; var2;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "var2, , var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_VARIABLE_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("exports", "var#, var2;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)2, (int)errors.size());
        for (ParsingError parsingError : errors) {
            Assert.assertEquals((Object)ErrorCode.PM_INVALID_EXPORTED_VAR_NAME, (Object)parsingError.getErrorCode());
        }
        block.setNameAndValue("imports", "");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", "c.var1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("imports", "_c.var1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("imports", "_c._var1");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("imports", "c.var1, c2.var");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("imports", "c.var1 , c2.var");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("imports", "var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INCOMPLETE_IMPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", "var.");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INCOMPLETE_IMPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", "c.var, var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INCOMPLETE_IMPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", "var, var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)2, (int)errors.size());
        for (ParsingError parsingError : errors) {
            Assert.assertEquals((Object)ErrorCode.PM_INCOMPLETE_IMPORTED_VAR_NAME, (Object)parsingError.getErrorCode());
        }
        block.setNameAndValue("imports", "var#");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_IMPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", "-var");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_IMPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", ".var");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_IMPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", "c.var, var;");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_IMPORTED_VAR_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("imports", "-var, var!");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)2, (int)errors.size());
        for (ParsingError parsingError : errors) {
            Assert.assertEquals((Object)ErrorCode.PM_INVALID_IMPORTED_VAR_NAME, (Object)parsingError.getErrorCode());
        }
        block.setNameAndValue("imports", ", comp.var1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_VARIABLE_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("count", "");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("count", "a");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_INSTANCE_COUNT, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("count", "woo");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_INSTANCE_COUNT, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("count", "-5");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_INSTANCE_COUNT, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("count", "2.3");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_INSTANCE_COUNT, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("count", "1");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_USELESS_INSTANCE_COUNT, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("count", "3");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("channels", "whatever, there is no validation yet");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockProperty)block).size());
        block.setNameAndValue("An Invalid Property", "");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_PROPERTY_VALUE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setNameAndValue("An Invalid Property", "some value");
        errors = ParsingModelValidator.validate((BlockProperty)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_UNKNOWN_PROPERTY_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testFacet() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        BlockFacet block = new BlockFacet(file);
        block.setName("facet");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockFacet)block).size());
        block.setName("Facet");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockFacet)block).size());
        block.setName("_facet");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockFacet)block).size());
        block.setName("facet#");
        Collection errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("facet name");
        errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.setName("facet n@me");
        errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName(".facet");
        errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("facet.");
        errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_DOT_IS_NOT_ALLOWED, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("facet.name");
        errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_DOT_IS_NOT_ALLOWED, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("");
        errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_FACET_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("name");
        block.getInnerBlocks().add(new BlockProperty(file, "whatever", "whatever"));
        errors = ParsingModelValidator.validate((BlockFacet)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_PROPERTY_NOT_APPLIABLE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testComponent() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        BlockComponent block = new BlockComponent(file);
        block.setName("component");
        Collection errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.setName("_component");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockComponent)block).size());
        block.setName("component#");
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("component name");
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.setName("component n*me");
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName(".component");
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("component.");
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_DOT_IS_NOT_ALLOWED, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("component.name");
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_DOT_IS_NOT_ALLOWED, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("");
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("name");
        block.getInnerBlocks().add(new BlockProperty(file, "extends", "facet1"));
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.getInnerBlocks().add(new BlockProperty(file, "whatever", "whatever"));
        errors = ParsingModelValidator.validate((BlockComponent)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_PROPERTY_NOT_APPLIABLE, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testInstanceOf() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        BlockInstanceOf block = new BlockInstanceOf(file);
        block.setName("component");
        Collection errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_MISSING_INSTANCE_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.getInnerBlocks().add(new BlockProperty(file, "name", "Any name"));
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.getInnerBlocks().clear();
        block.getInnerBlocks().add(new BlockProperty(file, "name", "Any name?"));
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_INSTANCE_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.getInnerBlocks().clear();
        block.getInnerBlocks().add(new BlockProperty(file, "name", "AnyName"));
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockInstanceOf)block).size());
        block.setName("_component");
        Assert.assertEquals((int)0, (int)ParsingModelValidator.validate((BlockInstanceOf)block).size());
        block.setName("component#");
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("component name");
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)0, (int)errors.size());
        block.setName("component n@me");
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName(".component");
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("component.");
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_DOT_IS_NOT_ALLOWED, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("component.name");
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_DOT_IS_NOT_ALLOWED, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("");
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_EMPTY_COMPONENT_NAME, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.setName("name");
        block.getInnerBlocks().add(new BlockProperty(file, "extends", "anyPropertyToOverride"));
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)0, (int)errors.size());
        BlockProperty childBlock = new BlockProperty(file, "extends", "anyPropertyToOverride");
        block.getInnerBlocks().add(childBlock);
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PM_DUPLICATE_PROPERTY, (Object)((ParsingError)errors.iterator().next()).getErrorCode());
        block.getInnerBlocks().remove(childBlock);
        childBlock = new BlockProperty(file, "extends", "anyPropertyToOverride"){

            public int getInstructionType() {
                return 502;
            }
        };
        block.getInnerBlocks().add(childBlock);
        errors = ParsingModelValidator.validate((BlockInstanceOf)block);
        Assert.assertEquals((int)2, (int)errors.size());
        Iterator iterator = errors.iterator();
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_BLOCK_TYPE, (Object)((ParsingError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.PM_INVALID_INSTANCE_ELEMENT, (Object)((ParsingError)iterator.next()).getErrorCode());
    }
}

