/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.converters.FromGraphDefinition;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.RuntimeModelValidator;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.helpers.ComponentHelpers;
import org.junit.Test;

public class FromGraphDefinitionTest {
    @Test
    public void test_simpleInstaller() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/simple-installer.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((String)"my-own-installer", (String)((Component)graphs.getRootComponents().iterator().next()).getInstallerName());
    }

    @Test
    public void test_duplicateInstaller() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/component-duplicate-property.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)1, (int)fromDef.getErrors().size());
        Assert.assertEquals((Object)ErrorCode.PM_DUPLICATE_PROPERTY, (Object)((ParsingError)fromDef.getErrors().iterator().next()).getErrorCode());
    }

    @Test
    public void test_conflictingNames() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/conflicting-names.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Iterator it = fromDef.getErrors().iterator();
        Assert.assertEquals((Object)ErrorCode.CO_CONFLICTING_NAME, (Object)((ParsingError)it.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.CO_CONFLICTING_NAME, (Object)((ParsingError)it.next()).getErrorCode());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((String)"type", (String)((Component)graphs.getRootComponents().iterator().next()).getName());
    }

    @Test
    public void test_inexistingChildInComponent() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/inexisting-child-in-component.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Iterator it = fromDef.getErrors().iterator();
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_CHILD, (Object)((ParsingError)it.next()).getErrorCode());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((String)"root", (String)((Component)graphs.getRootComponents().iterator().next()).getName());
    }

    @Test
    public void test_inexistingChildInFacet() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/inexisting-child-in-facet.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Iterator it = fromDef.getErrors().iterator();
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_CHILD, (Object)((ParsingError)it.next()).getErrorCode());
        Assert.assertFalse((boolean)it.hasNext());
        Assert.assertEquals((int)0, (int)graphs.getRootComponents().size());
    }

    @Test
    public void testGraphWithWrongImport() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/graph-with-invalid-import.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Iterator iterator = fromDef.getErrors().iterator();
        Assert.assertEquals((Object)ErrorCode.CO_UNREACHABLE_FILE, (Object)((ParsingError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testDuplicateComponent() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/duplicate-component.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)2, (int)fromDef.getErrors().size());
        for (ParsingError error : fromDef.getErrors()) {
            Assert.assertEquals((Object)ErrorCode.CO_ALREADY_DEFINED_COMPONENT, (Object)error.getErrorCode());
        }
    }

    @Test
    public void testDuplicateFacet() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/duplicate-facet.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)3, (int)fromDef.getErrors().size());
        for (ParsingError error : fromDef.getErrors()) {
            Assert.assertEquals((Object)ErrorCode.CO_ALREADY_DEFINED_FACET, (Object)error.getErrorCode());
        }
    }

    @Test
    public void testUnresolvedFacet() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/unresolved-facet.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)1, (int)fromDef.getErrors().size());
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_FACET, (Object)((ParsingError)fromDef.getErrors().iterator().next()).getErrorCode());
    }

    @Test
    public void testUnresolvedExtendedFacet() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/unresolved-extended-facet.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)1, (int)fromDef.getErrors().size());
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_FACET, (Object)((ParsingError)fromDef.getErrors().iterator().next()).getErrorCode());
    }

    @Test
    public void testUnresolvableFacet() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/unresolvable-facet.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)1, (int)fromDef.getErrors().size());
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_FACET, (Object)((ParsingError)fromDef.getErrors().iterator().next()).getErrorCode());
    }

    @Test
    public void testSelfOptionalImports() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/component-optional-imports.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Component componentA = ComponentHelpers.findComponent((Graphs)graphs, (String)"A");
        Assert.assertTrue((boolean)componentA.exportedVariables.containsKey("port"));
        Assert.assertTrue((boolean)componentA.exportedVariables.containsKey("ip"));
        Map exportedVariables = ComponentHelpers.findAllExportedVariables((Component)componentA);
        Assert.assertTrue((boolean)exportedVariables.containsKey("A.port"));
        Assert.assertTrue((boolean)exportedVariables.containsKey("A.ip"));
        ImportedVariable var = (ImportedVariable)componentA.importedVariables.get("A.port");
        Assert.assertNotNull((Object)var);
        Assert.assertTrue((boolean)var.isOptional());
        var = (ImportedVariable)componentA.importedVariables.get("A.ip");
        Assert.assertNotNull((Object)var);
        Assert.assertTrue((boolean)var.isOptional());
    }

    @Test
    public void testComplexHierarchy() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/complex-hierarchy.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Graphs)graphs).size());
        Component root = ComponentHelpers.findComponent((Graphs)graphs, (String)"root");
        Assert.assertNotNull((Object)root);
        Collection ancestors = ComponentHelpers.findAllAncestors((Component)root);
        Assert.assertEquals((int)0, (int)ancestors.size());
        Collection children = ComponentHelpers.findAllChildren((Component)root);
        Assert.assertEquals((int)1, (int)children.size());
        Component tomcat = (Component)children.iterator().next();
        Assert.assertEquals((String)"Tomcat", (String)tomcat.getName());
        ancestors = ComponentHelpers.findAllAncestors((Component)tomcat);
        Assert.assertEquals((int)1, (int)ancestors.size());
        Assert.assertEquals((Object)root, ancestors.iterator().next());
        children = ComponentHelpers.findAllChildren((Component)tomcat);
        Assert.assertEquals((int)1, (int)children.size());
        Component app = (Component)children.iterator().next();
        Assert.assertEquals((String)"App", (String)app.getName());
    }

    @Test
    public void testIDsWithSpaces() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/real-lamp-all-in-one-flex.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Component component = ComponentHelpers.findComponent((Graphs)graphs, (String)"hello world");
        Assert.assertNotNull((Object)component);
        Assert.assertTrue((boolean)component.getFacets().contains(new Facet("war archive")));
        component = ComponentHelpers.findComponent((Graphs)graphs, (String)"ecom");
        Assert.assertNotNull((Object)component);
        Assert.assertTrue((boolean)component.getFacets().contains(new Facet("war archive")));
    }

    @Test
    public void testInexistingChildren_components() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/component-inexisting-children.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)2, (int)fromDef.getErrors().size());
        ParsingError[] errors = fromDef.getErrors().toArray(new ParsingError[2]);
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_CHILD, (Object)errors[0].getErrorCode());
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_CHILD, (Object)errors[1].getErrorCode());
    }

    @Test
    public void testInexistingChildren_facets() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/component-inexisting-child-facet.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)1, (int)fromDef.getErrors().size());
        ParsingError[] errors = fromDef.getErrors().toArray(new ParsingError[1]);
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_CHILD, (Object)errors[0].getErrorCode());
        Assert.assertTrue((boolean)errors[0].getDetails().contains("Fa3"));
    }

    @Test
    public void testInexistingExtendedComponent() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/component-extends-inexisting-component.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        fromDef.buildGraphs(f);
        Assert.assertEquals((int)1, (int)fromDef.getErrors().size());
        ParsingError[] errors = fromDef.getErrors().toArray(new ParsingError[1]);
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_COMPONENT, (Object)errors[0].getErrorCode());
    }

    @Test
    public void testExternalImport() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/component-external-imports.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Component componentA = ComponentHelpers.findComponent((Graphs)graphs, (String)"A");
        Assert.assertTrue((boolean)componentA.exportedVariables.containsKey("port"));
        Assert.assertTrue((boolean)componentA.exportedVariables.containsKey("ip"));
        Map exportedVariables = ComponentHelpers.findAllExportedVariables((Component)componentA);
        Assert.assertTrue((boolean)exportedVariables.containsKey("A.port"));
        Assert.assertTrue((boolean)exportedVariables.containsKey("A.ip"));
        ImportedVariable var = (ImportedVariable)componentA.importedVariables.get("A.port");
        Assert.assertNotNull((Object)var);
        Assert.assertTrue((boolean)var.isOptional());
        Assert.assertFalse((boolean)var.isExternal());
        var = (ImportedVariable)componentA.importedVariables.get("A.ip");
        Assert.assertNotNull((Object)var);
        Assert.assertTrue((boolean)var.isOptional());
        Assert.assertFalse((boolean)var.isExternal());
        var = (ImportedVariable)componentA.importedVariables.get("App.toto");
        Assert.assertNotNull((Object)var);
        Assert.assertFalse((boolean)var.isOptional());
        Assert.assertTrue((boolean)var.isExternal());
        var = (ImportedVariable)componentA.importedVariables.get("App2.ip");
        Assert.assertNotNull((Object)var);
        Assert.assertTrue((boolean)var.isOptional());
        Assert.assertTrue((boolean)var.isExternal());
    }

    @Test
    public void testExplodedExportsAndImports() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/only-component-4.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs g = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Component tomcat = ComponentHelpers.findComponent((Graphs)g, (String)"tomcat");
        Assert.assertNotNull((Object)tomcat);
        Assert.assertEquals((int)2, (int)tomcat.exportedVariables.size());
        Assert.assertEquals((String)"8080", (String)((String)tomcat.exportedVariables.get("db.port")));
        Assert.assertNull(tomcat.exportedVariables.get("db.ip"));
        Component apache = ComponentHelpers.findComponent((Graphs)g, (String)"apache");
        Assert.assertNotNull((Object)apache);
        Assert.assertEquals((int)2, (int)apache.importedVariables.size());
        Assert.assertNotNull(apache.importedVariables.get("tomcat.port"));
        Assert.assertTrue((boolean)((ImportedVariable)apache.importedVariables.get("tomcat.port")).isOptional());
        Assert.assertNotNull(apache.importedVariables.get("tomcat.ip"));
        Assert.assertFalse((boolean)((ImportedVariable)apache.importedVariables.get("tomcat.ip")).isOptional());
    }
}

