/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.dsl.ParsingModelIo;
import net.roboconf.core.dsl.ParsingModelValidator;
import net.roboconf.core.dsl.converters.FromGraphDefinition;
import net.roboconf.core.dsl.converters.FromGraphs;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.tests.ComplexApplicationFactory1;
import net.roboconf.core.model.RuntimeModelValidator;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.helpers.ComponentHelpers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FromGraphsTest {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void testFromGraphs_noFacet() throws Exception {
        Graphs graphs = new Graphs();
        Component cA = new Component("A").installerName("target");
        graphs.getRootComponents().add(cA);
        cA.exportedVariables.put("A.port", "9000");
        cA.exportedVariables.put("A.ip", null);
        cA.addImportedVariable(new ImportedVariable("B.port", false, false));
        cA.addImportedVariable(new ImportedVariable("B.ip", true, false));
        Component cB = new Component("B").installerName("target");
        graphs.getRootComponents().add(cB);
        cB.exportedVariables.put("B.port", "9000");
        cB.exportedVariables.put("B.ip", null);
        this.compareGraphs(graphs, false);
    }

    @Test
    public void testFromGraphs_oneFacet() throws Exception {
        Graphs graphs = new Graphs();
        Component cA = new Component("A").installerName("target");
        graphs.getRootComponents().add(cA);
        cA.addImportedVariable(new ImportedVariable("facetF.props", false, false));
        cA.exportedVariables.put("A.port", "9000");
        cA.exportedVariables.put("A.ip", null);
        cA.addImportedVariable(new ImportedVariable("B.port", true, false));
        cA.addImportedVariable(new ImportedVariable("B.ip", true, false));
        Component cB = new Component("B").installerName("target");
        graphs.getRootComponents().add(cB);
        Facet facetF = new Facet("facetF");
        facetF.exportedVariables.put("facetF.props", "something");
        cB.associateFacet(facetF);
        cB.exportedVariables.put("B.port", "9000");
        cB.exportedVariables.put("B.ip", null);
        this.compareGraphs(graphs, false);
    }

    @Test
    public void testFromGraphs_threeFacets() throws Exception {
        Graphs graphs = new Graphs();
        Component cA = new Component("A").installerName("target");
        graphs.getRootComponents().add(cA);
        Facet facet = new Facet("my-facet-1");
        facet.exportedVariables.put("data", "coucou");
        cA.associateFacet(facet);
        cA.exportedVariables.put("A.port", "9000");
        cA.exportedVariables.put("A.ip", null);
        cA.addImportedVariable(new ImportedVariable("B.port", true, false));
        cA.addImportedVariable(new ImportedVariable("B.ip", true, false));
        cA.addImportedVariable(new ImportedVariable("facetF.props", false, false));
        Component cB = new Component("B").installerName("target");
        graphs.getRootComponents().add(cB);
        facet = new Facet("facetF");
        facet.exportedVariables.put("facetF.props", "some value");
        cB.associateFacet(facet);
        facet = new Facet("my-facet-2");
        facet.exportedVariables.put("my-facet-2.woo", "woo");
        cB.associateFacet(facet);
        cB.exportedVariables.put("B.port", "9000");
        cB.exportedVariables.put("B.ip", null);
        this.compareGraphs(graphs, false);
    }

    @Test
    public void testFromGraphs_complexApplication() throws Exception {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        this.compareGraphs(app.getGraphs(), false);
    }

    @Test
    public void testFromGraphs_withComments() throws Exception {
        Graphs graphs = new Graphs();
        Component cA = new Component("A").installerName("target");
        graphs.getRootComponents().add(cA);
        Facet facet = new Facet("my-facet-1");
        facet.exportedVariables.put("my-facet-1.data", "coucou");
        cA.associateFacet(facet);
        cA.exportedVariables.put("A.port", "9000");
        cA.exportedVariables.put("A.ip", null);
        cA.addImportedVariable(new ImportedVariable("B.ip", true, false));
        cA.addImportedVariable(new ImportedVariable("facetF.props", false, false));
        Component cB = new Component("B").installerName("installer B");
        cB.exportedVariables.put("B.port", "9000");
        cB.exportedVariables.put("B.ip", null);
        facet = new Facet("facetF");
        facet.exportedVariables.put("facetF.props", "some value");
        cB.associateFacet(facet);
        facet = new Facet("my-facet-2");
        facet.exportedVariables.put("my-facet-2.woo", "woo");
        cB.associateFacet(facet);
        Component cC = new Component("C").installerName("installer C");
        for (Facet f : cB.getFacets()) {
            cC.associateFacet(f);
        }
        cC.exportedVariables.put("my-facet-2.woo", "woo");
        cC.exportedVariables.put("C.port", "9000");
        cC.exportedVariables.put("facetF.props", "something else");
        cA.addChild((AbstractType)cB);
        cA.addChild((AbstractType)cC);
        this.compareGraphs(graphs, true);
    }

    @Test
    public void testFromGraphs_withInheritance() throws Exception {
        Graphs graphs = new Graphs();
        Component cA = new Component("A").installerName("target");
        graphs.getRootComponents().add(cA);
        cA.exportedVariables.put("A.port", "9000");
        cA.exportedVariables.put("A.ip", null);
        Component cB = new Component("B").installerName("target");
        cB.extendComponent(cA);
        graphs.getRootComponents().add(cB);
        cB.exportedVariables.put("A.port", "9000");
        cB.exportedVariables.put("A.ip", null);
        this.compareGraphs(graphs, false);
    }

    @Test
    public void testFromGraphs_withExternal() throws Exception {
        Graphs graphs = new Graphs();
        Component cA = new Component("A").installerName("target");
        graphs.getRootComponents().add(cA);
        cA.exportedVariables.put("A.port", "9000");
        cA.exportedVariables.put("A.ip", null);
        cA.addImportedVariable(new ImportedVariable("B.port", false, true));
        cA.addImportedVariable(new ImportedVariable("B.ip", true, false));
        Component cB = new Component("B").installerName("target");
        graphs.getRootComponents().add(cB);
        cB.exportedVariables.put("B.port", "9000");
        cB.exportedVariables.put("B.ip", null);
        this.compareGraphs(graphs, false);
    }

    private void compareGraphs(Graphs graphs, boolean writeComments) throws Exception {
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Graphs)graphs).size());
        File targetFile = this.testFolder.newFile("roboconf_test.graph");
        FileDefinition defToWrite = new FromGraphs().buildFileDefinition(graphs, targetFile, writeComments);
        ParsingModelIo.saveRelationsFile((FileDefinition)defToWrite, (boolean)writeComments, (String)System.getProperty("line.separator"));
        FileDefinition def = ParsingModelIo.readConfigurationFile((File)targetFile, (boolean)true);
        Assert.assertEquals((int)0, (int)def.getParsingErrors().size());
        Assert.assertEquals((int)1, (int)def.getFileType());
        Collection validationErrors = ParsingModelValidator.validate((FileDefinition)def);
        Assert.assertEquals((int)0, (int)validationErrors.size());
        FromGraphDefinition fromDef = new FromGraphDefinition(null);
        Graphs readGraphs = fromDef.buildGraphs(targetFile);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Graphs)readGraphs).size());
        List readComponents = ComponentHelpers.findAllComponents((Graphs)readGraphs);
        Assert.assertEquals((int)ComponentHelpers.findAllComponents((Graphs)graphs).size(), (int)readComponents.size());
        for (Component readComponent : readComponents) {
            Component originalComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)readComponent.getName());
            Assert.assertNotNull((String)readComponent.getName(), (Object)originalComponent);
            Assert.assertEquals((Object)readComponent.getExtendedComponent(), (Object)originalComponent.getExtendedComponent());
            Assert.assertEquals((String)readComponent.getInstallerName(), (String)originalComponent.getInstallerName());
            Assert.assertEquals((int)readComponent.exportedVariables.size(), (int)originalComponent.exportedVariables.size());
            Assert.assertEquals((int)readComponent.importedVariables.size(), (int)originalComponent.importedVariables.size());
            for (Map.Entry entry : readComponent.exportedVariables.entrySet()) {
                Assert.assertTrue((String)readComponent.getName(), (boolean)originalComponent.exportedVariables.containsKey(entry.getKey()));
                String value = (String)originalComponent.exportedVariables.get(entry.getKey());
                Assert.assertEquals((String)readComponent.getName(), (String)((String)entry.getValue()), (String)value);
            }
            for (ImportedVariable var : readComponent.importedVariables.values()) {
                String junitMsg = readComponent.getName() + " :: " + var;
                ImportedVariable originalVar = (ImportedVariable)originalComponent.importedVariables.get(var.getName());
                Assert.assertNotNull((String)("Imports did not match for " + junitMsg), (Object)originalVar);
                Assert.assertEquals((String)junitMsg, (boolean)originalVar.isOptional(), (boolean)var.isOptional());
                Assert.assertEquals((String)junitMsg, (boolean)originalVar.isExternal(), (boolean)var.isExternal());
            }
        }
    }
}

