/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.converters.FromInstanceDefinition;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import org.junit.Test;

public class FromInstanceDefinitionTest {
    @Test
    public void testDuplicateInstance() throws Exception {
        Component vmComponent = new Component("VM").installerName("target");
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("tomcat.ip", null);
        tomcatComponent.exportedVariables.put("tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent);
        File f = TestUtils.findTestFile("/configurations/invalid/duplicate-instance.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        fromDef.buildInstances(graphs, f);
        Iterator iterator = fromDef.getErrors().iterator();
        Assert.assertEquals((Object)ErrorCode.CO_ALREADY_DEFINED_INSTANCE, (Object)((ParsingError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.CO_ALREADY_DEFINED_INSTANCE, (Object)((ParsingError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testInexistingComponent() throws Exception {
        Component vmComponent = new Component("VM").installerName("target");
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("tomcat.ip", null);
        tomcatComponent.exportedVariables.put("tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent);
        File f = TestUtils.findTestFile("/configurations/invalid/inexisting-component.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        fromDef.buildInstances(graphs, f);
        Iterator iterator = fromDef.getErrors().iterator();
        Assert.assertEquals((Object)ErrorCode.CO_INEXISTING_COMPONENT, (Object)((ParsingError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testInstanceWithExtraData() throws Exception {
        Component vmComponent = new Component("VM").installerName("target");
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("tomcat.ip", null);
        tomcatComponent.exportedVariables.put("tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent);
        File f = TestUtils.findTestFile("/configurations/valid/instance-with-extra-data.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((int)1, (int)rootInstances.size());
        Instance vmInstance = (Instance)rootInstances.iterator().next();
        Assert.assertEquals((int)1, (int)vmInstance.getChildren().size());
        Assert.assertEquals((String)"VM1", (String)vmInstance.getName());
        Assert.assertEquals((int)1, (int)vmInstance.data.size());
        Assert.assertEquals((String)"192.168.1.10", (String)((String)vmInstance.data.get("ec2.elastic.ip")));
    }

    @Test
    public void testComponentResolutionWhenSurroundingSpaces() throws Exception {
        Component vmComponent = new Component("VM").installerName("target");
        Component aComponent = new Component("A").installerName("whatever");
        vmComponent.addChild((AbstractType)aComponent);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent);
        File f = TestUtils.findTestFile("/configurations/valid/instance-with-space-after.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Iterator iterator = fromDef.getErrors().iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertEquals((int)2, (int)rootInstances.size());
        for (Instance rootInstance : rootInstances) {
            Assert.assertEquals((int)1, (int)rootInstance.getChildren().size());
            Instance instance = (Instance)rootInstance.getChildren().iterator().next();
            Assert.assertEquals((String)"A", (String)instance.getComponent().getName());
            Assert.assertEquals((String)"A ", (String)instance.getName());
        }
    }

    @Test
    public void testInstancesWithWrongImport() throws Exception {
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(new Component("VM").installerName("target"));
        File f = TestUtils.findTestFile("/configurations/invalid/instances-with-inexisting-import.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        fromDef.buildInstances(graphs, f);
        Iterator iterator = fromDef.getErrors().iterator();
        Assert.assertEquals((Object)ErrorCode.CO_UNREACHABLE_FILE, (Object)((ParsingError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testComplexInstances() throws Exception {
        Graphs graphs = new Graphs();
        Component vmComponent = new Component("VM").installerName("target");
        graphs.getRootComponents().add(vmComponent);
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("Tomcat.ip", null);
        tomcatComponent.exportedVariables.put("Tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Component warComponent = new Component("WAR").installerName("script");
        tomcatComponent.addChild((AbstractType)warComponent);
        File f = TestUtils.findTestFile("/configurations/valid/complex-instances.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Application app = new Application(new ApplicationTemplate());
        app.getRootInstances().addAll(rootInstances);
        Assert.assertEquals((int)3, (int)rootInstances.size());
        Assert.assertEquals((int)8, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1/i-tomcat"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1/i-tomcat/i-war"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-2"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-3"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-3/i-tomcat-1"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-3/i-tomcat-2"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-3/i-tomcat-2/i-war"));
    }

    @Test
    public void test_N_Instantiations() throws Exception {
        Graphs graphs = new Graphs();
        Component vmComponent = new Component("VM").installerName("target");
        graphs.getRootComponents().add(vmComponent);
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("Tomcat.ip", null);
        tomcatComponent.exportedVariables.put("Tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Component warComponent = new Component("WAR").installerName("script");
        tomcatComponent.addChild((AbstractType)warComponent);
        File f = TestUtils.findTestFile("/configurations/valid/n-instances.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Application app = new Application(new ApplicationTemplate());
        app.getRootInstances().addAll(rootInstances);
        Assert.assertEquals((int)14, (int)rootInstances.size());
        Assert.assertEquals((int)3688, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1/i-tomcat"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1/i-tomcat/i-war"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-2"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-01"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-01/i-tomcat-1"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-01/i-tomcat-1/i-war001"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-12"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-12/i-tomcat-1"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-12/i-tomcat-1/i-war001"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-09"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-09/i-tomcat-3"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-09/i-tomcat-3/i-war001"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-09"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-09/i-tomcat-2"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-09/i-tomcat-2/i-war101"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-09/i-tomcat-2/i-war025"));
    }

    @Test
    public void test_N_medium_Instantiations() throws Exception {
        Graphs graphs = new Graphs();
        Component vmComponent = new Component("VM").installerName("target");
        graphs.getRootComponents().add(vmComponent);
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("Tomcat.ip", null);
        tomcatComponent.exportedVariables.put("Tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Component warComponent = new Component("WAR").installerName("script");
        tomcatComponent.addChild((AbstractType)warComponent);
        File f = TestUtils.findTestFile("/configurations/valid/n-medium-instances.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Application app = new Application(new ApplicationTemplate());
        app.getRootInstances().addAll(rootInstances);
        Assert.assertEquals((int)3, (int)rootInstances.size());
        Assert.assertEquals((int)2045, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1/i-tomcat"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-1/i-tomcat/i-war"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-2"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-/i-tomcat-0001"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-/i-tomcat-0001/i-war"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-/i-tomcat-1001"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-/i-tomcat-1001/i-war"));
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-/i-tomcat-1001/i-war1"));
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/i-vm-/i-tomcat-1001/i-war01"));
    }

    @Test
    public void test_N_InstantiationsWithConflict() throws Exception {
        Graphs graphs = new Graphs();
        Component vmComponent = new Component("VM").installerName("target");
        graphs.getRootComponents().add(vmComponent);
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("Tomcat.ip", null);
        tomcatComponent.exportedVariables.put("Tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Component warComponent = new Component("WAR").installerName("script");
        tomcatComponent.addChild((AbstractType)warComponent);
        File f = TestUtils.findTestFile("/configurations/invalid/instanceof-name-conflict-with-count.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)1, (int)fromDef.getErrors().size());
        Assert.assertEquals((Object)ErrorCode.CO_CONFLICTING_INFERRED_INSTANCE, (Object)((ParsingError)fromDef.getErrors().iterator().next()).getErrorCode());
        Application app = new Application(new ApplicationTemplate());
        app.getRootInstances().addAll(rootInstances);
        Assert.assertEquals((int)5, (int)rootInstances.size());
    }

    @Test
    public void testRuntimeData() throws Exception {
        Graphs graphs = new Graphs();
        Component vmComponent = new Component("vm").installerName("target");
        graphs.getRootComponents().add(vmComponent);
        File f = TestUtils.findTestFile("/configurations/valid/single-runtime-instance.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((int)1, (int)rootInstances.size());
        Instance instance = (Instance)rootInstances.iterator().next();
        Assert.assertEquals((String)"vm 1", (String)instance.getName());
        Assert.assertEquals((Object)vmComponent, (Object)instance.getComponent());
        Assert.assertEquals((Object)Instance.InstanceStatus.DEPLOYED_STARTED, (Object)instance.getStatus());
        Assert.assertEquals((int)3, (int)instance.data.size());
        Assert.assertEquals((String)"127.0.0.1", (String)((String)instance.data.get("ip")));
        Assert.assertEquals((String)"mach-ID", (String)((String)instance.data.get("machine-id")));
        Assert.assertEquals((String)"something different", (String)((String)instance.data.get("whatever")));
    }
}

