/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.converters;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.dsl.ParsingModelIo;
import net.roboconf.core.dsl.ParsingModelValidator;
import net.roboconf.core.dsl.converters.FromInstanceDefinition;
import net.roboconf.core.dsl.converters.FromInstances;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.RuntimeModelValidator;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class FromInstancesTest {
    @Rule
    public TemporaryFolder testFolder = new TemporaryFolder();

    @Test
    public void testZeroInstance() throws Exception {
        FileDefinition def = new FromInstances().buildFileDefinition(new ArrayList(0), new File("whatever.txt"), false, false);
        Assert.assertEquals((int)2, (int)def.getFileType());
        Assert.assertEquals((int)0, (int)def.getBlocks().size());
    }

    @Test
    public void testOneInstance() throws Exception {
        Graphs graphs = this.buildGraphs();
        Component vmComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"VM");
        Assert.assertNotNull((Object)vmComponent);
        Instance inst = new Instance("inst").component(vmComponent);
        this.compareInstances(graphs, Arrays.asList(inst), false, false);
    }

    @Test
    public void testOneInstanceWithChildren() throws Exception {
        Graphs graphs = this.buildGraphs();
        Component vmComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"VM");
        Assert.assertNotNull((Object)vmComponent);
        Component tomcatComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"Tomcat");
        Assert.assertNotNull((Object)tomcatComponent);
        Component warComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"WAR");
        Assert.assertNotNull((Object)warComponent);
        Instance vm = new Instance("i-vm").component(vmComponent);
        Instance tomcat = new Instance("i-tomcat").component(tomcatComponent);
        Instance war = new Instance("i-war").component(warComponent);
        tomcat.overriddenExports.put("Tomcat.port", "9004");
        InstanceHelpers.insertChild((Instance)vm, (Instance)tomcat);
        InstanceHelpers.insertChild((Instance)tomcat, (Instance)war);
        vm.channel("channel1").channel("channel2");
        war.data.put("prop1", "value1");
        war.data.put("prop2", "value2");
        this.compareInstances(graphs, Arrays.asList(vm), false, true);
    }

    @Test
    public void testComplexInstances() throws Exception {
        Graphs graphs = this.buildGraphs();
        Component vmComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"VM");
        Assert.assertNotNull((Object)vmComponent);
        Component tomcatComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"Tomcat");
        Assert.assertNotNull((Object)tomcatComponent);
        Component warComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"WAR");
        Assert.assertNotNull((Object)warComponent);
        Instance vm = new Instance("i-vm-1").component(vmComponent);
        Instance tomcat = new Instance("i-tomcat").component(tomcatComponent);
        Instance war = new Instance("i-war").component(warComponent);
        tomcat.overriddenExports.put("Tomcat.port", "9004");
        InstanceHelpers.insertChild((Instance)vm, (Instance)tomcat);
        InstanceHelpers.insertChild((Instance)tomcat, (Instance)war);
        Instance vm2 = new Instance("i-vm-2").component(vmComponent);
        Instance vm3 = new Instance("i-vm-3").component(vmComponent);
        Instance tomcat2 = new Instance("i-tomcat-1").component(tomcatComponent);
        Instance tomcat3 = new Instance("i-tomcat-2").component(tomcatComponent);
        Instance war2 = new Instance("i-war").component(warComponent);
        tomcat3.overriddenExports.put("Tomcat.port", "9081");
        InstanceHelpers.insertChild((Instance)vm3, (Instance)tomcat2);
        InstanceHelpers.insertChild((Instance)vm3, (Instance)tomcat3);
        InstanceHelpers.insertChild((Instance)tomcat3, (Instance)war2);
        this.compareInstances(graphs, Arrays.asList(vm, vm2, vm3), false, true);
    }

    @Test
    public void testOneInstanceWithComments() throws Exception {
        Graphs graphs = this.buildGraphs();
        Component vmComponent = ComponentHelpers.findComponent((Graphs)graphs, (String)"VM");
        Assert.assertNotNull((Object)vmComponent);
        Instance inst = new Instance("inst").component(vmComponent);
        this.compareInstances(graphs, Arrays.asList(inst), true, false);
    }

    @Test
    public void testExtraData() throws Exception {
        Component vmComponent = new Component("VM").installerName("target");
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("tomcat.ip", null);
        tomcatComponent.exportedVariables.put("tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent);
        File f = TestUtils.findTestFile("/configurations/valid/instance-with-extra-data.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((int)1, (int)rootInstances.size());
        Instance vmInstance = (Instance)rootInstances.iterator().next();
        Assert.assertEquals((int)1, (int)vmInstance.getChildren().size());
        Assert.assertEquals((String)"VM1", (String)vmInstance.getName());
        Assert.assertEquals((int)1, (int)vmInstance.data.size());
        Assert.assertEquals((String)"192.168.1.10", (String)((String)vmInstance.data.get("ec2.elastic.ip")));
        this.compareInstances(graphs, Arrays.asList(vmInstance), true, true);
    }

    private Graphs buildGraphs() {
        Graphs graphs = new Graphs();
        Component vmComponent = new Component("VM").installerName("target");
        graphs.getRootComponents().add(vmComponent);
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("Tomcat.ip", null);
        tomcatComponent.exportedVariables.put("Tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Component warComponent = new Component("WAR").installerName("script");
        tomcatComponent.addChild((AbstractType)warComponent);
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Graphs)graphs).size());
        return graphs;
    }

    private void compareInstances(Graphs graphs, List<Instance> rootInstances, boolean writeComments, boolean saveRuntimeInformation) throws Exception {
        for (Instance rootInstance : rootInstances) {
            List allTheInstances = InstanceHelpers.buildHierarchicalList((Instance)rootInstance);
            Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Collection)allTheInstances).size());
        }
        File targetFile = this.testFolder.newFile("roboconf_test.instances");
        FileDefinition defToWrite = new FromInstances().buildFileDefinition(rootInstances, targetFile, writeComments, saveRuntimeInformation);
        ParsingModelIo.saveRelationsFile((FileDefinition)defToWrite, (boolean)writeComments, (String)System.getProperty("line.separator"));
        FileDefinition def = ParsingModelIo.readConfigurationFile((File)targetFile, (boolean)true);
        Assert.assertEquals((int)0, (int)def.getParsingErrors().size());
        Assert.assertEquals((int)2, (int)def.getFileType());
        Collection validationErrors = ParsingModelValidator.validate((FileDefinition)def);
        Assert.assertEquals((int)0, (int)validationErrors.size());
        FromInstanceDefinition fromDef = new FromInstanceDefinition(null);
        Collection newRootInstances = fromDef.buildInstances(graphs, targetFile);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        for (Instance rootInstance : newRootInstances) {
            List allTheInstances = InstanceHelpers.buildHierarchicalList((Instance)rootInstance);
            Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Collection)allTheInstances).size());
        }
        Assert.assertEquals((int)rootInstances.size(), (int)newRootInstances.size());
        for (Instance rootInstance : rootInstances) {
            Application tempApp = new Application(new ApplicationTemplate());
            tempApp.getRootInstances().addAll(newRootInstances);
            String rootInstancePath = InstanceHelpers.computeInstancePath((Instance)rootInstance);
            Instance newRootInstance = InstanceHelpers.findInstanceByPath((AbstractApplication)tempApp, (String)rootInstancePath);
            Assert.assertNotNull((Object)newRootInstance);
            List instances = InstanceHelpers.buildHierarchicalList((Instance)rootInstance);
            List newInstances = InstanceHelpers.buildHierarchicalList((Instance)newRootInstance);
            Assert.assertEquals((int)instances.size(), (int)newInstances.size());
            instances.removeAll(newInstances);
            Assert.assertEquals((int)0, (int)instances.size());
            for (Instance newInstance : newInstances) {
                String newPath = InstanceHelpers.computeInstancePath((Instance)newInstance);
                Instance instance = InstanceHelpers.findInstanceByPath((Instance)rootInstance, (String)newPath);
                Assert.assertNotNull((Object)instance);
                Assert.assertEquals((Object)instance.channels, (Object)newInstance.channels);
                Assert.assertEquals((Object)instance.getComponent(), (Object)newInstance.getComponent());
                Assert.assertEquals((Object)instance.getStatus(), (Object)newInstance.getStatus());
                Assert.assertEquals((int)instance.getChildren().size(), (int)newInstance.getChildren().size());
                Assert.assertEquals((Object)instance.data, (Object)newInstance.data);
                Assert.assertEquals((int)instance.overriddenExports.size(), (int)newInstance.overriddenExports.size());
                for (Map.Entry entry : instance.overriddenExports.entrySet()) {
                    Assert.assertTrue((String)instance.getName(), (boolean)newInstance.overriddenExports.containsKey(entry.getKey()));
                    String value = (String)newInstance.overriddenExports.get(entry.getKey());
                    Assert.assertEquals((String)instance.getName(), (String)((String)entry.getValue()), (String)value);
                }
            }
        }
    }
}

