/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.dsl.parsing;

import java.io.File;
import junit.framework.Assert;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import org.junit.Test;

public class CrapForCodeCoverageTest {
    @Test
    public void testCrap() {
        FileDefinition def = new FileDefinition(new File("whatever"));
        BlockImport imp = new BlockImport(def);
        Assert.assertNotNull((Object)imp.toString());
        imp.setUri("http://an-import.uri");
        Assert.assertNotNull((Object)imp.toString());
        BlockComment comment = new BlockComment(imp.getDeclaringFile(), "we don't ware");
        Assert.assertNotNull((Object)comment.toString());
        comment = new BlockComment(def, null);
        Assert.assertNotNull((Object)comment.toString());
        BlockComponent comp = new BlockComponent(def);
        Assert.assertNull((Object)comp.toString());
        comp.setName("woo");
        Assert.assertEquals((String)"woo", (String)comp.toString());
        BlockFacet facet = new BlockFacet(def);
        Assert.assertNull((Object)facet.toString());
        facet.setName("woo 2");
        Assert.assertEquals((String)"woo 2", (String)facet.toString());
        BlockProperty prop = new BlockProperty(def);
        Assert.assertNotNull((Object)prop.toString());
        prop.setName("you");
        Assert.assertNotNull((Object)prop.toString());
        prop.setValue("whatever");
        Assert.assertNotNull((Object)prop.toString());
        BlockBlank blank = new BlockBlank(def, null);
        Assert.assertNotNull((Object)blank.toString());
        blank = new BlockBlank(def, "...");
        Assert.assertNotNull((Object)blank.toString());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInvalidDefinition() {
        new BlockProperty(null);
    }
}

