/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.dsl.parsing;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.ParsingModelIo;
import net.roboconf.core.dsl.converters.FromGraphDefinition;
import net.roboconf.core.dsl.parsing.AbstractBlock;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.BlockComponent;
import net.roboconf.core.dsl.parsing.BlockImport;
import net.roboconf.core.dsl.parsing.BlockInstanceOf;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.dsl.parsing.FileDefinitionParser;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.utils.Utils;
import org.junit.Test;

public class FileDefinitionParserTest {
    @Test
    public void testRecognizeComment() {
        String[] invalidLines;
        int code;
        FileDefinitionParser parser;
        String[] validLines;
        ArrayList blocks = new ArrayList();
        for (String line : validLines = new String[]{"# ok", "#", "     # woo ", "  ###############"}) {
            blocks.clear();
            parser = new FileDefinitionParser(null, false);
            code = parser.recognizeComment(line, blocks);
            Assert.assertEquals((String)("Expected a YES code for '" + line + "'"), (int)1, (int)code);
            Assert.assertEquals((String)("No pasing error was expected for '" + line + "'"), (int)0, (int)parser.getFileRelations().getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + line + "'"), (int)1, (int)blocks.size());
            Assert.assertEquals((String)("Expected ONE comment block for '" + line + "'"), (int)4, (int)((AbstractBlock)blocks.iterator().next()).getInstructionType());
        }
        for (String line : validLines) {
            blocks.clear();
            parser = new FileDefinitionParser(null, true);
            code = parser.recognizeComment(line, blocks);
            Assert.assertEquals((String)("Expected a YES code for '" + line + "'"), (int)1, (int)code);
            Assert.assertEquals((String)("No pasing error was expected for '" + line + "'"), (int)0, (int)parser.getFileRelations().getParsingErrors().size());
            Assert.assertEquals((String)("Expected ZERO block to be registered for '" + line + "'"), (int)0, (int)blocks.size());
        }
        for (String line : invalidLines = new String[]{"", "   \t", "something", "something # with a comment after"}) {
            blocks.clear();
            FileDefinitionParser parser2 = new FileDefinitionParser(null, true);
            int code2 = parser2.recognizeComment(line, blocks);
            Assert.assertEquals((String)("Expected a NO code for '" + line + "'"), (int)2, (int)code2);
            Assert.assertEquals((String)("No pasing error was expected for '" + line + "'"), (int)0, (int)parser2.getFileRelations().getParsingErrors().size());
            Assert.assertEquals((String)("Expected ZERO block to be registered for '" + line + "'"), (int)0, (int)blocks.size());
        }
    }

    @Test
    public void testRecognizeBlank() {
        String[] invalidLines;
        String[] validLines;
        ArrayList blocks = new ArrayList();
        for (String line : validLines = new String[]{"  ", ""}) {
            blocks.clear();
            FileDefinitionParser parser = new FileDefinitionParser(null, false);
            int code = parser.recognizeBlankLine(line, blocks);
            Assert.assertEquals((String)("Expected a YES code for '" + line + "'"), (int)1, (int)code);
            Assert.assertEquals((String)("No pasing error was expected for '" + line + "'"), (int)0, (int)parser.getFileRelations().getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + line + "'"), (int)1, (int)blocks.size());
            Assert.assertEquals((String)("Expected ONE blank block for '" + line + "'"), (int)5, (int)((AbstractBlock)blocks.iterator().next()).getInstructionType());
        }
        for (String line : invalidLines = new String[]{"#", "something", "  something with spaces before an after  "}) {
            blocks.clear();
            FileDefinitionParser parser = new FileDefinitionParser(null, false);
            int code = parser.recognizeBlankLine(line, blocks);
            Assert.assertEquals((String)("Expected a NO code for '" + line + "'"), (int)2, (int)code);
            Assert.assertEquals((String)("No pasing error was expected for '" + line + "'"), (int)0, (int)parser.getFileRelations().getParsingErrors().size());
            Assert.assertEquals((String)("Expected ZERO block to be registered for '" + line + "'"), (int)0, (int)blocks.size());
        }
    }

    @Test
    public void testSplitFromInlineComment() {
        String[] parts;
        String theLine;
        FileDefinitionParser parser;
        String[][] beforeToAfter;
        for (String[] line : beforeToAfter = new String[][]{{"import facets.rcf;", "# import the facets"}, {"import facets.rcf;", "\t# import the facets"}, {"import facets.rcf;", "#"}, {"import facets.rcf;", ""}, {"import facets.rcf;     ", ""}, {"import facets.rcf;", " #### import the facets"}, {"", " #### import the facets"}, {"", " # "}, {"", "#"}}) {
            parser = new FileDefinitionParser(null, false);
            theLine = line[0] + line[1];
            parts = parser.splitFromInlineComment(theLine);
            Assert.assertEquals((String)("Test failed for '" + theLine + "'"), (String)line[0], (String)parts[0]);
            Assert.assertEquals((String)("Test failed for '" + theLine + "'"), (String)line[1], (String)parts[1]);
        }
        for (String[] line : beforeToAfter) {
            parser = new FileDefinitionParser(null, true);
            theLine = line[0] + line[1];
            parts = parser.splitFromInlineComment(theLine);
            Assert.assertEquals((String)("Test failed for '" + theLine + "'"), (String)line[0], (String)parts[0]);
            Assert.assertEquals((String)("Comment should be empty for '" + theLine + "'"), (String)"", (String)parts[1]);
        }
    }

    @Test
    public void testRecognizeImport() {
        FileDefinitionParser parser;
        String[] invalidLines;
        FileDefinition def;
        String[][] commentedLines;
        String[] validLines;
        for (String line : validLines = new String[]{"import facets.rcf;", "IMPORT facets.rcf;", "import http://some-host.com/some/path/facets.rcf;", "import http://some-host.com/some/path/?file=facets.rcf;", "   import   facets.rcf ;  ", "import facets.rcf; # with an inline comment"}) {
            FileDefinitionParser parser2 = new FileDefinitionParser(null, false);
            int code = parser2.recognizeImport(line);
            FileDefinition def2 = parser2.getFileRelations();
            Assert.assertEquals((String)("Expected a YES code for '" + line + "'"), (int)1, (int)code);
            Assert.assertEquals((String)("No pasing error was expected for '" + line + "'"), (int)0, (int)def2.getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + line + "'"), (int)1, (int)def2.getBlocks().size());
            BlockImport imp = (BlockImport)def2.getBlocks().iterator().next();
            Assert.assertEquals((String)("Expected ONE import block for '" + line + "'"), (int)1, (int)imp.getInstructionType());
            Assert.assertFalse((String)("URI cannot be empty for '" + line + "'"), (boolean)Utils.isEmptyOrWhitespaces((String)imp.getUri()));
            Assert.assertEquals((String)("URI cannot have surrounding spaces '" + line + "'"), (String)imp.getUri(), (String)imp.getUri().trim());
            Assert.assertNotSame((String)("URI cannot be the entire line for '" + line + "'"), (Object)imp.getUri(), (Object)line);
            Assert.assertTrue((String)("The URI was not found in '" + line + "'"), (boolean)line.contains(imp.getUri()));
        }
        for (String[] line : commentedLines = new String[][]{{"import facets.rcf;", ""}, {"import facets.rcf;", "# stuck comment"}, {"import facets.rcf;", "#"}, {"import facets.rcf;", "\t# some in-line comment   "}}) {
            FileDefinitionParser parser3 = new FileDefinitionParser(null, false);
            String theLine = line[0] + line[1];
            int code = parser3.recognizeImport(theLine);
            def = parser3.getFileRelations();
            Assert.assertEquals((String)("Expected a YES code for '" + theLine + "'"), (int)1, (int)code);
            Assert.assertEquals((String)("No pasing error was expected for '" + theLine + "'"), (int)0, (int)def.getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + theLine + "'"), (int)1, (int)def.getBlocks().size());
            BlockImport imp = (BlockImport)def.getBlocks().iterator().next();
            Assert.assertEquals((String)("Expected ONE import block for '" + theLine + "'"), (int)1, (int)imp.getInstructionType());
            String expected = Utils.isEmptyOrWhitespaces((String)line[1]) ? null : line[1];
            Assert.assertEquals((String)("Invalid in-line comment for '" + theLine + "'"), (String)expected, (String)imp.getInlineComment());
        }
        for (String line : invalidLines = new String[]{"imports facets.rcf;", "IPORT facets.rcf;", "facet", "", " #"}) {
            parser = new FileDefinitionParser(null, false);
            int code = parser.recognizeImport(line);
            Assert.assertEquals((String)("Expected a NO code for '" + line + "'"), (int)2, (int)code);
        }
        LinkedHashMap<String, ErrorCode> invalidLineToErrorCode = new LinkedHashMap<String, ErrorCode>();
        invalidLineToErrorCode.put("import facets.rcf", ErrorCode.P_IMPORT_ENDS_WITH_SEMI_COLON);
        invalidLineToErrorCode.put("import facets.rcf ; facet toto {", ErrorCode.P_ONE_BLOCK_PER_LINE);
        invalidLineToErrorCode.put("import facets.rcf ; invalid comment", ErrorCode.P_ONE_BLOCK_PER_LINE);
        invalidLineToErrorCode.put("import facets.rcf ;;", ErrorCode.P_ONE_BLOCK_PER_LINE);
        for (Map.Entry entry : invalidLineToErrorCode.entrySet()) {
            String line = (String)entry.getKey();
            parser = new FileDefinitionParser(null, false);
            int code = parser.recognizeImport((String)entry.getKey());
            def = parser.getFileRelations();
            Assert.assertEquals((String)("Expected a YES code for '" + line + "'"), (int)1, (int)code);
            Assert.assertEquals((String)("A pasing error was expected for '" + line + "'"), (int)1, (int)def.getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + line + "'"), (int)1, (int)def.getBlocks().size());
            Assert.assertEquals((String)("Expected ONE import block for '" + line + "'"), (int)1, (int)((AbstractBlock)def.getBlocks().iterator().next()).getInstructionType());
            ParsingError error = (ParsingError)def.getParsingErrors().iterator().next();
            Assert.assertEquals((String)("Expecting parsing error for '" + line + "'"), (Object)((ErrorCode)entry.getValue()).getCategory(), (Object)ErrorCode.ErrorCategory.PARSING);
            Assert.assertEquals((String)("Invalid error code for '" + line + "'"), entry.getValue(), (Object)error.getErrorCode());
        }
    }

    @Test
    public void testRecognizeProperty() {
        String[] invalidLines;
        int code;
        BlockComponent holder;
        String[][] commentedLines;
        String[] validLines;
        FileDefinition file = new FileDefinition(new File("some-file"));
        for (String line : validLines = new String[]{"property: value;", "   property : value  ;", "PROPERTY: value; # with an inline comment", "property: value1, value2  ,  value3;", "property:;"}) {
            FileDefinitionParser parser = new FileDefinitionParser(null, false);
            BlockComponent holder2 = new BlockComponent(file);
            int code2 = parser.recognizeProperty(line, (AbstractBlockHolder)holder2);
            Assert.assertEquals((String)("Expected a YES code for '" + line + "'"), (int)1, (int)code2);
            Assert.assertEquals((String)("No pasing error was expected for '" + line + "'"), (int)0, (int)parser.getFileRelations().getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + line + "'"), (int)1, (int)holder2.getInnerBlocks().size());
            BlockProperty prop = (BlockProperty)holder2.getInnerBlocks().iterator().next();
            Assert.assertEquals((String)("Expected ONE property for '" + line + "'"), (int)0, (int)prop.getInstructionType());
            Assert.assertEquals((String)("Invalid property name for '" + line + "'"), (String)"property", (String)prop.getName().toLowerCase());
        }
        for (String[] line : commentedLines = new String[][]{{"property: value;", ""}, {"property: value;", "# stuck comment"}, {"property: value;", "#"}, {"property: value1, value2;", "\t# some in-line comment   "}}) {
            FileDefinitionParser parser = new FileDefinitionParser(null, false);
            String theLine = line[0] + line[1];
            holder = new BlockComponent(file);
            code = parser.recognizeProperty(theLine, (AbstractBlockHolder)holder);
            Assert.assertEquals((String)("Expected a YES code for '" + theLine + "'"), (int)1, (int)code);
            Assert.assertEquals((String)("No pasing error was expected for '" + theLine + "'"), (int)0, (int)parser.getFileRelations().getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + theLine + "'"), (int)1, (int)holder.getInnerBlocks().size());
            BlockProperty prop = (BlockProperty)holder.getInnerBlocks().iterator().next();
            Assert.assertEquals((String)("Expected ONE property for '" + theLine + "'"), (int)0, (int)prop.getInstructionType());
            String expected = Utils.isEmptyOrWhitespaces((String)line[1]) ? null : line[1];
            Assert.assertEquals((String)("Invalid in-line comment for '" + theLine + "'"), (String)expected, (String)prop.getInlineComment());
        }
        for (String line : invalidLines = new String[]{"property = value;", "property", "facet", "", " #"}) {
            FileDefinitionParser parser = new FileDefinitionParser(null, false);
            holder = new BlockComponent(file);
            code = parser.recognizeProperty(line, (AbstractBlockHolder)holder);
            Assert.assertEquals((String)("Expected a NO code for '" + line + "'"), (int)2, (int)code);
        }
        LinkedHashMap<String, ErrorCode> invalidLineToErrorCode = new LinkedHashMap<String, ErrorCode>();
        invalidLineToErrorCode.put("property: value", ErrorCode.P_PROPERTY_ENDS_WITH_SEMI_COLON);
        invalidLineToErrorCode.put("property:", ErrorCode.P_PROPERTY_ENDS_WITH_SEMI_COLON);
        invalidLineToErrorCode.put("property: value ; facet toto {", ErrorCode.P_ONE_BLOCK_PER_LINE);
        invalidLineToErrorCode.put("property: value ; invalid comment", ErrorCode.P_ONE_BLOCK_PER_LINE);
        invalidLineToErrorCode.put("property: value;;", ErrorCode.P_ONE_BLOCK_PER_LINE);
        for (Map.Entry entry : invalidLineToErrorCode.entrySet()) {
            String line;
            line = (String)entry.getKey();
            FileDefinitionParser parser = new FileDefinitionParser(null, false);
            holder = new BlockComponent(file);
            FileDefinition def = parser.getFileRelations();
            int code3 = parser.recognizeProperty(line, (AbstractBlockHolder)holder);
            Assert.assertEquals((String)("Expected a YES code for '" + line + "'"), (int)1, (int)code3);
            Assert.assertEquals((String)("A pasing error was expected for '" + line + "'"), (int)1, (int)def.getParsingErrors().size());
            Assert.assertEquals((String)("Expected ONE block to be registered for '" + line + "'"), (int)1, (int)holder.getInnerBlocks().size());
            Assert.assertEquals((String)("Expected ONE property for '" + line + "'"), (int)0, (int)((AbstractBlock)holder.getInnerBlocks().iterator().next()).getInstructionType());
            ParsingError error = (ParsingError)def.getParsingErrors().iterator().next();
            Assert.assertEquals((String)("Expecting parsing error for '" + line + "'"), (Object)((ErrorCode)entry.getValue()).getCategory(), (Object)ErrorCode.ErrorCategory.PARSING);
            Assert.assertEquals((String)("Invalid error code for '" + line + "'"), entry.getValue(), (Object)error.getErrorCode());
        }
    }

    @Test
    public void testMergeContiguousRegions() {
        FileDefinition file = new FileDefinition(new File("some-file"));
        FileDefinitionParser parser = new FileDefinitionParser(null, false);
        ArrayList<Object> blocks = new ArrayList<Object>();
        blocks.add(new BlockImport(file));
        blocks.add(new BlockImport(file));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)2, (int)blocks.size());
        blocks.clear();
        blocks.add(new BlockProperty(file));
        blocks.add(new BlockProperty(file));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)2, (int)blocks.size());
        blocks.clear();
        blocks.add(new BlockComment(file, "# comment 1"));
        blocks.add(new BlockComment(file, "# comment 2"));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)1, (int)blocks.size());
        Assert.assertEquals((int)4, (int)((AbstractBlock)blocks.get(0)).getInstructionType());
        blocks.clear();
        blocks.add(new BlockComment(file, "# comment 1"));
        blocks.add(new BlockBlank(file, ""));
        blocks.add(new BlockComment(file, "# comment 2"));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)3, (int)blocks.size());
        blocks.clear();
        blocks.add(new BlockComment(file, "# comment 1"));
        blocks.add(new BlockBlank(file, ""));
        blocks.add(new BlockComment(file, "# comment 2"));
        blocks.add(new BlockComment(file, "# comment 3"));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)3, (int)blocks.size());
        Assert.assertEquals((int)4, (int)((AbstractBlock)blocks.get(0)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)blocks.get(1)).getInstructionType());
        Assert.assertEquals((int)4, (int)((AbstractBlock)blocks.get(0)).getInstructionType());
        blocks.clear();
        blocks.add(new BlockBlank(file, ""));
        blocks.add(new BlockBlank(file, ""));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)1, (int)blocks.size());
        Assert.assertEquals((int)5, (int)((AbstractBlock)blocks.get(0)).getInstructionType());
        blocks.clear();
        blocks.add(new BlockBlank(file, ""));
        blocks.add(new BlockComment(file, "# comment 1"));
        blocks.add(new BlockBlank(file, ""));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)3, (int)blocks.size());
        blocks.clear();
        blocks.add(new BlockBlank(file, ""));
        blocks.add(new BlockBlank(file, ""));
        blocks.add(new BlockComment(file, "# comment 1"));
        blocks.add(new BlockBlank(file, ""));
        parser.mergeContiguousRegions(blocks);
        Assert.assertEquals((int)3, (int)blocks.size());
        Assert.assertEquals((int)5, (int)((AbstractBlock)blocks.get(0)).getInstructionType());
        Assert.assertEquals((int)4, (int)((AbstractBlock)blocks.get(1)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)blocks.get(0)).getInstructionType());
    }

    @Test
    public void testRecognizeFacet() throws Exception {
        LinkedHashMap<String, ParsingError> resourceNameToErrorCode = new LinkedHashMap<String, ParsingError>();
        resourceNameToErrorCode.put("facet-invalid-property.graph", new ParsingError(ErrorCode.P_INVALID_PROPERTY, null, 2));
        resourceNameToErrorCode.put("facet-invalid-end.graph", new ParsingError(ErrorCode.P_C_C_BRACKET_EXTRA_CHARACTERS, null, 3));
        resourceNameToErrorCode.put("facet-missing-closing-cb.graph", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 3));
        resourceNameToErrorCode.put("facet-missing-opening-cb.graph", new ParsingError(ErrorCode.P_O_C_BRACKET_MISSING, null, 1));
        resourceNameToErrorCode.put("facet-extra-char.graph", new ParsingError(ErrorCode.P_O_C_BRACKET_EXTRA_CHARACTERS, null, 1));
        resourceNameToErrorCode.put("facet-line-number.graph", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 6));
        this.testRecognizePropertiesHolder(resourceNameToErrorCode, 2);
    }

    @Test
    public void testRecognizeComponent() throws Exception {
        LinkedHashMap<String, ParsingError> resourceNameToErrorCode = new LinkedHashMap<String, ParsingError>();
        resourceNameToErrorCode.put("component-invalid-property.graph", new ParsingError(ErrorCode.P_INVALID_PROPERTY, null, 2));
        resourceNameToErrorCode.put("component-invalid-end.graph", new ParsingError(ErrorCode.P_C_C_BRACKET_EXTRA_CHARACTERS, null, 3));
        resourceNameToErrorCode.put("component-missing-closing-cb.graph", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 3));
        resourceNameToErrorCode.put("component-missing-opening-cb.graph", new ParsingError(ErrorCode.P_O_C_BRACKET_MISSING, null, 1));
        resourceNameToErrorCode.put("component-extra-char.graph", new ParsingError(ErrorCode.P_O_C_BRACKET_EXTRA_CHARACTERS, null, 1));
        resourceNameToErrorCode.put("component-line-number.graph", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 6));
        this.testRecognizePropertiesHolder(resourceNameToErrorCode, 3);
    }

    @Test
    public void testRecognizeInstanceOf() throws Exception {
        LinkedHashMap<String, ParsingError> resourceNameToErrorCode = new LinkedHashMap<String, ParsingError>();
        resourceNameToErrorCode.put("instanceof-invalid-property.instances", new ParsingError(ErrorCode.P_INVALID_PROPERTY_OR_INSTANCE, null, 2));
        resourceNameToErrorCode.put("instanceof-invalid-property-2.instances", new ParsingError(ErrorCode.P_INVALID_PROPERTY_OR_INSTANCE, null, 3));
        resourceNameToErrorCode.put("instanceof-invalid-end.instances", new ParsingError(ErrorCode.P_C_C_BRACKET_EXTRA_CHARACTERS, null, 3));
        resourceNameToErrorCode.put("instanceof-missing-closing-cb.instances", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 3));
        resourceNameToErrorCode.put("instanceof-missing-opening-cb.instances", new ParsingError(ErrorCode.P_O_C_BRACKET_MISSING, null, 1));
        resourceNameToErrorCode.put("instanceof-extra-char.instances", new ParsingError(ErrorCode.P_O_C_BRACKET_EXTRA_CHARACTERS, null, 1));
        resourceNameToErrorCode.put("instanceof-line-number.instances", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 6));
        resourceNameToErrorCode.put("instanceof-imbricated-invalid-property.instances", new ParsingError(ErrorCode.P_INVALID_PROPERTY_OR_INSTANCE, null, 4));
        resourceNameToErrorCode.put("instanceof-imbricated-invalid-end.instances", new ParsingError(ErrorCode.P_C_C_BRACKET_EXTRA_CHARACTERS, null, 5));
        resourceNameToErrorCode.put("instanceof-imbricated-missing-closing-cb.instances", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 7));
        resourceNameToErrorCode.put("instanceof-imbricated-missing-opening-cb.instances", new ParsingError(ErrorCode.P_O_C_BRACKET_MISSING, null, 3));
        resourceNameToErrorCode.put("instanceof-imbricated-extra-char.instances", new ParsingError(ErrorCode.P_O_C_BRACKET_EXTRA_CHARACTERS, null, 3));
        resourceNameToErrorCode.put("instanceof-very-imbricated-invalid-property.instances", new ParsingError(ErrorCode.P_INVALID_PROPERTY_OR_INSTANCE, null, 5));
        resourceNameToErrorCode.put("instanceof-very-imbricated-invalid-end.instances", new ParsingError(ErrorCode.P_C_C_BRACKET_EXTRA_CHARACTERS, null, 6));
        resourceNameToErrorCode.put("instanceof-very-imbricated-missing-closing-cb.instances", new ParsingError(ErrorCode.P_C_C_BRACKET_MISSING, null, 8));
        resourceNameToErrorCode.put("instanceof-very-imbricated-missing-opening-cb.instances", new ParsingError(ErrorCode.P_O_C_BRACKET_MISSING, null, 5));
        resourceNameToErrorCode.put("instanceof-very-imbricated-extra-char.instances", new ParsingError(ErrorCode.P_O_C_BRACKET_EXTRA_CHARACTERS, null, 4));
        this.testRecognizePropertiesHolder(resourceNameToErrorCode, 6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testRecognizePropertiesHolder(Map<String, ParsingError> resourceNameToErrorCode, int blockType) throws Exception {
        String root = "/configurations/invalid/";
        for (Map.Entry<String, ParsingError> entry : resourceNameToErrorCode.entrySet()) {
            BufferedReader br = null;
            try {
                File f = TestUtils.findTestFile("/configurations/invalid/" + entry.getKey());
                Assert.assertNotNull((Object)f);
                Assert.assertTrue((String)f.getName(), (boolean)f.exists());
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), "UTF-8"));
                String line = br.readLine();
                Assert.assertNotNull((Object)line);
                FileDefinitionParser parser = new FileDefinitionParser(f, false);
                parser.currentLineNumber = 1;
                if (blockType == 2) {
                    parser.recognizeFacet(line, br);
                } else if (blockType == 3) {
                    parser.recognizeComponent(line, br);
                } else if (blockType == 6) {
                    parser.recognizeInstanceOf(line, br, null);
                } else {
                    Assert.fail((String)"Invalid block type.");
                }
                Assert.assertEquals((String)("ONE pasing error was expected for '" + entry.getKey() + "'"), (int)1, (int)parser.getFileRelations().getParsingErrors().size());
                ParsingError error = (ParsingError)parser.getFileRelations().getParsingErrors().iterator().next();
                Assert.assertEquals((String)("Expected error code " + entry.getValue().getErrorCode() + " for '" + entry.getKey() + "'"), (Object)entry.getValue().getErrorCode(), (Object)error.getErrorCode());
                Assert.assertEquals((String)("Expected error line to be " + entry.getValue().getLine() + " for '" + entry.getKey() + "'"), (int)entry.getValue().getLine(), (int)error.getLine());
                Assert.assertEquals((String)("Expected a parsing error for '" + entry.getKey() + "'"), (Object)ErrorCode.ErrorCategory.PARSING, (Object)error.getErrorCode().getCategory());
                Assert.assertEquals((Object)f, (Object)error.getFile());
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(br);
                throw throwable;
            }
            Utils.closeQuietly((Reader)br);
        }
    }

    @Test
    public void testComplexInstancesParsing() {
        FileDefinition def;
        File f;
        try {
            f = TestUtils.findTestFile("/configurations/valid/instance-imbricated-3.instances");
            def = ParsingModelIo.readConfigurationFile((File)f, (boolean)false);
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to find the file.");
            return;
        }
        Assert.assertEquals((int)2, (int)def.getFileType());
        Assert.assertEquals((Object)f, (Object)def.getEditedFile());
        Assert.assertEquals((int)0, (int)def.getParsingErrors().size());
        Assert.assertEquals((int)4, (int)((AbstractBlock)def.getBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)def.getBlocks().get(1)).getInstructionType());
        Assert.assertEquals((int)6, (int)((AbstractBlock)def.getBlocks().get(2)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)def.getBlocks().get(3)).getInstructionType());
        Assert.assertEquals((int)6, (int)((AbstractBlock)def.getBlocks().get(4)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)def.getBlocks().get(5)).getInstructionType());
        Assert.assertEquals((int)6, (int)def.getBlocks().size());
        BlockInstanceOf block = (BlockInstanceOf)def.getBlocks().get(2);
        Assert.assertEquals((String)"vm", (String)block.getName());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)block.getInnerBlocks().get(1)).getInstructionType());
        Assert.assertEquals((int)6, (int)((AbstractBlock)block.getInnerBlocks().get(2)).getInstructionType());
        Assert.assertEquals((int)3, (int)block.getInnerBlocks().size());
        Assert.assertEquals((String)"name", (String)((BlockProperty)block.getInnerBlocks().get(0)).getName());
        Assert.assertEquals((String)"vm1", (String)((BlockProperty)block.getInnerBlocks().get(0)).getValue());
        Assert.assertFalse((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(0)).getInlineComment()));
        block = (BlockInstanceOf)block.getInnerBlocks().get(2);
        Assert.assertEquals((String)"server", (String)block.getName());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(1)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)block.getInnerBlocks().get(2)).getInstructionType());
        Assert.assertEquals((int)6, (int)((AbstractBlock)block.getInnerBlocks().get(3)).getInstructionType());
        Assert.assertEquals((int)4, (int)block.getInnerBlocks().size());
        Assert.assertEquals((String)"name", (String)((BlockProperty)block.getInnerBlocks().get(0)).getName());
        Assert.assertEquals((String)"server", (String)((BlockProperty)block.getInnerBlocks().get(0)).getValue());
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(0)).getInlineComment()));
        Assert.assertEquals((String)"port", (String)((BlockProperty)block.getInnerBlocks().get(1)).getName());
        Assert.assertEquals((String)"9878", (String)((BlockProperty)block.getInnerBlocks().get(1)).getValue());
        block = (BlockInstanceOf)block.getInnerBlocks().get(3);
        Assert.assertEquals((String)"web-app1", (String)block.getName());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)1, (int)block.getInnerBlocks().size());
        Assert.assertEquals((String)"name", (String)((BlockProperty)block.getInnerBlocks().get(0)).getName());
        Assert.assertEquals((String)"web-app1-1", (String)((BlockProperty)block.getInnerBlocks().get(0)).getValue());
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(0)).getInlineComment()));
        block = (BlockInstanceOf)def.getBlocks().get(4);
        Assert.assertEquals((String)"vm", (String)block.getName());
        Assert.assertEquals((int)5, (int)((AbstractBlock)block.getInnerBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(1)).getInstructionType());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(2)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)block.getInnerBlocks().get(3)).getInstructionType());
        Assert.assertEquals((int)6, (int)((AbstractBlock)block.getInnerBlocks().get(4)).getInstructionType());
        Assert.assertEquals((int)5, (int)block.getInnerBlocks().size());
        Assert.assertEquals((String)"name", (String)((BlockProperty)block.getInnerBlocks().get(1)).getName());
        Assert.assertEquals((String)"vm-", (String)((BlockProperty)block.getInnerBlocks().get(1)).getValue());
        Assert.assertFalse((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(1)).getInlineComment()));
        Assert.assertEquals((String)"count", (String)((BlockProperty)block.getInnerBlocks().get(2)).getName());
        Assert.assertEquals((String)"7", (String)((BlockProperty)block.getInnerBlocks().get(2)).getValue());
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(2)).getInlineComment()));
        block = (BlockInstanceOf)block.getInnerBlocks().get(4);
        Assert.assertEquals((String)"server", (String)block.getName());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(1)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)block.getInnerBlocks().get(2)).getInstructionType());
        Assert.assertEquals((int)6, (int)((AbstractBlock)block.getInnerBlocks().get(3)).getInstructionType());
        Assert.assertEquals((int)4, (int)block.getInnerBlocks().size());
        Assert.assertEquals((String)"name", (String)((BlockProperty)block.getInnerBlocks().get(0)).getName());
        Assert.assertEquals((String)"server4osgi", (String)((BlockProperty)block.getInnerBlocks().get(0)).getValue());
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(0)).getInlineComment()));
        Assert.assertEquals((String)"port", (String)((BlockProperty)block.getInnerBlocks().get(1)).getName());
        Assert.assertEquals((String)"9878", (String)((BlockProperty)block.getInnerBlocks().get(1)).getValue());
        block = (BlockInstanceOf)block.getInnerBlocks().get(3);
        Assert.assertEquals((String)"osgi-container", (String)block.getName());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)5, (int)((AbstractBlock)block.getInnerBlocks().get(1)).getInstructionType());
        Assert.assertEquals((int)6, (int)((AbstractBlock)block.getInnerBlocks().get(2)).getInstructionType());
        Assert.assertEquals((int)3, (int)block.getInnerBlocks().size());
        Assert.assertEquals((String)"name", (String)((BlockProperty)block.getInnerBlocks().get(0)).getName());
        Assert.assertEquals((String)"osgi-container-app", (String)((BlockProperty)block.getInnerBlocks().get(0)).getValue());
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(0)).getInlineComment()));
        block = (BlockInstanceOf)block.getInnerBlocks().get(2);
        Assert.assertEquals((String)"bundle", (String)block.getName());
        Assert.assertEquals((int)4, (int)((AbstractBlock)block.getInnerBlocks().get(0)).getInstructionType());
        Assert.assertEquals((int)0, (int)((AbstractBlock)block.getInnerBlocks().get(1)).getInstructionType());
        Assert.assertEquals((int)2, (int)block.getInnerBlocks().size());
        Assert.assertEquals((String)"name", (String)((BlockProperty)block.getInnerBlocks().get(1)).getName());
        Assert.assertEquals((String)"my-bundle", (String)((BlockProperty)block.getInnerBlocks().get(1)).getValue());
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)((BlockProperty)block.getInnerBlocks().get(1)).getInlineComment()));
    }

    @Test
    public void testParsingWithRuntimeInformation() {
        FileDefinition def;
        File f;
        try {
            f = TestUtils.findTestFile("/configurations/valid/single-runtime-instance.instances");
            def = ParsingModelIo.readConfigurationFile((File)f, (boolean)false);
        }
        catch (Exception e) {
            Assert.fail((String)"Failed to find the file.");
            return;
        }
        Assert.assertEquals((int)2, (int)def.getFileType());
        Assert.assertEquals((Object)f, (Object)def.getEditedFile());
        Assert.assertEquals((int)0, (int)def.getParsingErrors().size());
    }

    @Test
    public void testLoadGraph_withImportedVariables_andInheritance() throws Exception {
        File file = TestUtils.findTestFile("/configurations/valid/extending-component-with-imported-variables.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(file.getParentFile());
        Graphs graph = fromDef.buildGraphs(file);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((int)4, (int)ComponentHelpers.findAllComponents((Graphs)graph).size());
        Component vmComponent = ComponentHelpers.findComponent((Graphs)graph, (String)"VM");
        Component dbComponent = ComponentHelpers.findComponent((Graphs)graph, (String)"db");
        Component serverComponent = ComponentHelpers.findComponent((Graphs)graph, (String)"server");
        Component myServerComponent = ComponentHelpers.findComponent((Graphs)graph, (String)"my-server");
        Collection children = ComponentHelpers.findAllChildren((Component)vmComponent);
        Assert.assertEquals((int)3, (int)children.size());
        Assert.assertTrue((boolean)children.contains(dbComponent));
        Assert.assertTrue((boolean)children.contains(serverComponent));
        Assert.assertTrue((boolean)children.contains(myServerComponent));
        Assert.assertNotNull(serverComponent.importedVariables.get("db.ip"));
        Assert.assertTrue((boolean)((ImportedVariable)serverComponent.importedVariables.get("db.ip")).isOptional());
        Assert.assertNotNull(serverComponent.importedVariables.get("db.port"));
        Assert.assertTrue((boolean)((ImportedVariable)serverComponent.importedVariables.get("db.port")).isOptional());
        Map imports = ComponentHelpers.findAllImportedVariables((Component)serverComponent);
        Assert.assertEquals((int)2, (int)imports.size());
        Assert.assertNotNull(imports.get("db.ip"));
        Assert.assertTrue((boolean)((ImportedVariable)imports.get("db.ip")).isOptional());
        Assert.assertNotNull(imports.get("db.port"));
        Assert.assertTrue((boolean)((ImportedVariable)imports.get("db.port")).isOptional());
        Assert.assertNotNull(myServerComponent.importedVariables.get("db.ip"));
        Assert.assertFalse((boolean)((ImportedVariable)myServerComponent.importedVariables.get("db.ip")).isOptional());
        Assert.assertNull(myServerComponent.importedVariables.get("db.port"));
        imports = ComponentHelpers.findAllImportedVariables((Component)myServerComponent);
        Assert.assertEquals((int)2, (int)imports.size());
        Assert.assertNotNull(imports.get("db.ip"));
        Assert.assertFalse((boolean)((ImportedVariable)imports.get("db.ip")).isOptional());
        Assert.assertNotNull(imports.get("db.port"));
        Assert.assertTrue((boolean)((ImportedVariable)imports.get("db.port")).isOptional());
    }

    @Test
    public void testNextLine() throws Exception {
        FileDefinitionParser parser = new FileDefinitionParser(new File("whatever"), true);
        Assert.assertEquals((int)0, (int)parser.currentLineNumber);
        StringBuilder sb = new StringBuilder();
        sb.append("# this is a comment\n");
        sb.append("\n");
        sb.append("VM {\n");
        sb.append("\tinstaller: target; # !!!\n");
        sb.append("\n");
        sb.append("}\n");
        sb.append("\r\n");
        sb.append("\n");
        BufferedReader br = new BufferedReader(new StringReader(sb.toString()));
        Assert.assertEquals((String)"# this is a comment", (String)parser.nextLine(br));
        Assert.assertEquals((int)1, (int)parser.currentLineNumber);
        Assert.assertEquals((String)"", (String)parser.nextLine(br));
        Assert.assertEquals((int)2, (int)parser.currentLineNumber);
        Assert.assertEquals((String)"VM {", (String)parser.nextLine(br));
        Assert.assertEquals((int)3, (int)parser.currentLineNumber);
        Assert.assertEquals((String)"\tinstaller: target; # !!!", (String)parser.nextLine(br));
        Assert.assertEquals((int)4, (int)parser.currentLineNumber);
        Assert.assertEquals((String)"", (String)parser.nextLine(br));
        Assert.assertEquals((int)5, (int)parser.currentLineNumber);
        Assert.assertEquals((String)"}", (String)parser.nextLine(br));
        Assert.assertEquals((int)6, (int)parser.currentLineNumber);
        Assert.assertEquals((String)"", (String)parser.nextLine(br));
        Assert.assertEquals((int)7, (int)parser.currentLineNumber);
        Assert.assertEquals((String)"", (String)parser.nextLine(br));
        Assert.assertEquals((int)8, (int)parser.currentLineNumber);
    }
}

