/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.dsl.parsing;

import java.io.File;
import junit.framework.Assert;
import net.roboconf.core.dsl.parsing.BlockBlank;
import net.roboconf.core.dsl.parsing.BlockComment;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.dsl.parsing.FileDefinitionSerializer;
import org.junit.Test;

public class FileDefinitionSerializerTest {
    @Test
    public void testRepairedBlank() {
        FileDefinition def = new FileDefinition(new File("whatever"));
        BlockBlank block = new BlockBlank(def, "invalid blank block");
        FileDefinitionSerializer serializer = new FileDefinitionSerializer();
        String s = serializer.write(block, true);
        Assert.assertEquals((String)System.getProperty("line.separator"), (String)s);
    }

    @Test
    public void testRepairedComment() {
        FileDefinition def = new FileDefinition(new File("whatever"));
        BlockComment block = new BlockComment(def, "invalid comment \n\t # followed by a valid \n#comment");
        FileDefinitionSerializer serializer = new FileDefinitionSerializer();
        String s = serializer.write(block, true);
        String expected = "# invalid comment \n\t # followed by a valid \n#comment\n".replace("\n", System.getProperty("line.separator"));
        Assert.assertEquals((String)expected, (String)s);
    }
}

