/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.tests;

import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;

public class ComplexApplicationFactory1 {
    public static final String ROOT_1 = "root1";
    public static final String ROOT_2 = "root2";
    public static final String GLASSFISH = "glassfish";
    public static final String TOMCAT = "tomcat";
    public static final String TOMCAT_8 = "tomcat8";
    public static final String MYSQL = "MySql";
    public static final String MONGO_DB = "MongoDB";
    public static final String APP_1 = "app1";
    public static final String APP_2 = "app2";
    public static final String APP_3 = "app3";
    public static final String FACET_VM = "VM";
    public static final String FACET_DEPLOYABLE = "deployable";
    public static final String FACET_JEE = "JEE";
    public static final String FACET_WEB = "Web";
    public static final String FACET_DATABASE = "Database";
    public static final String FACET_STORAGE = "Storage";

    private ComplexApplicationFactory1() {
    }

    public static ApplicationTemplate newApplication() {
        ApplicationTemplate app = new ApplicationTemplate("name").qualifier("test").dslId("roboconf-1.0");
        Graphs graph = new Graphs();
        app.setGraphs(graph);
        Facet facetVm = new Facet(FACET_VM);
        Facet facetDeployable = new Facet(FACET_DEPLOYABLE);
        facetVm.addChild((AbstractType)facetDeployable);
        facetVm.exportedVariables.put("ip", null);
        Component root1 = new Component(ROOT_1).installerName("target");
        root1.associateFacet(facetVm);
        graph.getRootComponents().add(root1);
        Component root2 = new Component(ROOT_2).installerName("target");
        root2.associateFacet(facetVm);
        graph.getRootComponents().add(root2);
        Facet facetJee = new Facet(FACET_JEE);
        facetJee.exportedVariables.put("server-suffix", "/path");
        facetJee.extendFacet(facetDeployable);
        Facet facetWeb = new Facet(FACET_WEB);
        facetWeb.exportedVariables.put("server-suffix", "/path");
        facetWeb.extendFacet(facetDeployable);
        Facet facetDb = new Facet(FACET_DATABASE);
        facetDb.exportedVariables.put("port", "3306");
        facetDb.extendFacet(facetDeployable);
        Facet facetStorage = new Facet(FACET_STORAGE);
        facetStorage.extendFacet(facetDb);
        Component glassfish = new Component(GLASSFISH).installerName("puppet");
        glassfish.associateFacet(facetWeb);
        glassfish.associateFacet(facetJee);
        Component tomcat = new Component(TOMCAT).installerName("puppet");
        tomcat.associateFacet(facetWeb);
        Component tomcat8 = new Component(TOMCAT_8);
        tomcat8.extendComponent(tomcat);
        Component mySql = new Component(MYSQL).installerName("script");
        mySql.exportedVariables.put("ip", null);
        mySql.exportedVariables.put("port", "3306");
        mySql.associateFacet(facetDb);
        Component mongoWithoutFacet = new Component(MONGO_DB).installerName("Chef");
        mongoWithoutFacet.exportedVariables.put("ip", null);
        mongoWithoutFacet.exportedVariables.put("port", "28017");
        root1.addChild((AbstractType)mongoWithoutFacet);
        Component app1 = new Component(APP_1).installerName("file");
        app1.addImportedVariable(new ImportedVariable("Database.port", true, false));
        tomcat.addChild((AbstractType)app1);
        Component app2 = new Component(APP_2).installerName("file");
        app2.addImportedVariable(new ImportedVariable("MySql.ip", false, false));
        app2.addImportedVariable(new ImportedVariable("MySql.port", true, false));
        app2.addImportedVariable(new ImportedVariable("MongoDB.ip", true, false));
        app2.addImportedVariable(new ImportedVariable("MongoDB.port", true, false));
        tomcat.addChild((AbstractType)app2);
        Component app3 = new Component(APP_3).installerName("file");
        tomcat8.addChild((AbstractType)app3);
        return app;
    }
}

