/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.tests;

import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;

public class TestApplicationTemplate
extends ApplicationTemplate {
    private static final long serialVersionUID = -8616929491081715953L;
    private final Instance tomcatVm;
    private final Instance mySqlVm;
    private final Instance tomcat;
    private final Instance mySql;
    private final Instance war;

    public TestApplicationTemplate() {
        this.setName("test-app");
        this.setQualifier("test");
        Component vmComponent = new Component("vm").installerName("target");
        this.tomcatVm = new Instance("tomcat-vm").component(vmComponent);
        this.mySqlVm = new Instance("mysql-vm").component(vmComponent);
        Component tomcatComponent = new Component("tomcat").installerName("puppet");
        this.tomcat = new Instance("tomcat-server").component(tomcatComponent);
        Component mySqlComponent = new Component("mysql").installerName("puppet");
        mySqlComponent.exportedVariables.put("mysql.port", "3306");
        mySqlComponent.exportedVariables.put("mysql.ip", null);
        this.mySql = new Instance("mysql-server").component(mySqlComponent);
        Component warComponent = new Component("war").installerName("script");
        warComponent.exportedVariables.put("war.port", "8080");
        warComponent.exportedVariables.put("war.ip", null);
        warComponent.addImportedVariable(new ImportedVariable("mysql.port", false, false));
        warComponent.addImportedVariable(new ImportedVariable("mysql.ip", false, false));
        this.war = new Instance("hello-world").component(warComponent);
        InstanceHelpers.insertChild((Instance)this.tomcatVm, (Instance)this.tomcat);
        InstanceHelpers.insertChild((Instance)this.tomcat, (Instance)this.war);
        InstanceHelpers.insertChild((Instance)this.mySqlVm, (Instance)this.mySql);
        vmComponent.addChild((AbstractType)mySqlComponent);
        vmComponent.addChild((AbstractType)tomcatComponent);
        tomcatComponent.addChild((AbstractType)warComponent);
        this.setGraphs(new Graphs());
        this.getGraphs().getRootComponents().add(vmComponent);
        this.getRootInstances().add(this.mySqlVm);
        this.getRootInstances().add(this.tomcatVm);
    }

    public Instance getTomcatVm() {
        return this.tomcatVm;
    }

    public Instance getMySqlVm() {
        return this.mySqlVm;
    }

    public Instance getTomcat() {
        return this.tomcat;
    }

    public Instance getMySql() {
        return this.mySql;
    }

    public Instance getWar() {
        return this.war;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && obj instanceof TestApplicationTemplate;
    }

    public int hashCode() {
        return super.hashCode();
    }
}

