/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.internal.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import junit.framework.Assert;
import net.roboconf.core.dsl.ParsingModelIoTest;
import net.roboconf.core.utils.Utils;

public class TestUtils {
    public static List<File> findTestFiles(String dirName) throws IOException, URISyntaxException {
        URL url = ParsingModelIoTest.class.getResource(dirName);
        File dir = new File(url.toURI());
        if (!dir.exists()) {
            throw new IOException("Could not resolve the resource directory.");
        }
        File[] resources = dir.listFiles();
        if (resources == null) {
            throw new IOException("Could not list the resource files.");
        }
        return Arrays.asList(resources);
    }

    public static File findTestFile(String fileName) throws IOException, URISyntaxException {
        return TestUtils.findTestFile(fileName, ParsingModelIoTest.class);
    }

    public static File findApplicationDirectory(String appName) throws IOException {
        String suffix = "core/roboconf-core/src/test/resources/applications/" + appName;
        File result = new File("../../" + suffix).getCanonicalFile();
        return result;
    }

    public static File findTestFile(String fileName, Class<?> clazz) throws IOException, URISyntaxException {
        File file;
        URL url = clazz.getResource(fileName);
        if (url == null || !(file = new File(url.toURI())).exists()) {
            throw new IOException("Could not find the resource file.");
        }
        return file;
    }

    public static String readUriContent(URI uri) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        InputStream in = null;
        try {
            in = uri.toURL().openStream();
            Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)out);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return out.toString("UTF-8");
    }

    public static Map<String, String> buildZipContent() {
        LinkedHashMap<String, String> entryToContent = new LinkedHashMap<String, String>();
        entryToContent.put("readme.txt", "This is a readme file.");
        entryToContent.put("graph/main.graph", "import facets.graph;\nimport components.graph;");
        entryToContent.put("graph/facets.graph", "# nothing yet");
        entryToContent.put("graph/components.graph", "# nothing here too");
        entryToContent.put("descriptor/application-descriptor.properties", "application-name = Unit Test");
        entryToContent.put("instances/initial-deployment.instances", "# No instance");
        entryToContent.put("some/very/low/folder/demo.txt", "Whatever...");
        entryToContent.put("graph/", null);
        entryToContent.put("anotherdir/", null);
        entryToContent.put("anotherdir/deeper/", null);
        return entryToContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createZipFile(Map<String, String> entryToContent, File targetZipFile) throws IOException {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(new FileOutputStream(targetZipFile));
            for (Map.Entry<String, String> entry : entryToContent.entrySet()) {
                zos.putNextEntry(new ZipEntry(entry.getKey()));
                if (entry.getValue() != null) {
                    ByteArrayInputStream is = new ByteArrayInputStream(entry.getValue().getBytes("UTF-8"));
                    try {
                        Utils.copyStreamUnsafelyUseWithCaution((InputStream)is, (OutputStream)zos);
                    }
                    finally {
                        Utils.closeQuietly((InputStream)is);
                    }
                }
                zos.closeEntry();
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(zos);
            throw throwable;
        }
        Utils.closeQuietly((OutputStream)zos);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void compareZipContent(File zipFile, Map<String, String> entryToContent) throws IOException {
        File tempDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        if (!tempDir.mkdir()) {
            Assert.fail((String)"Failed to create a temporary directory.");
        }
        try {
            Utils.extractZipArchive((File)zipFile, (File)tempDir);
            TestUtils.compareUnzippedContent(tempDir, entryToContent);
        }
        catch (Throwable throwable) {
            Utils.deleteFilesRecursively((File[])new File[]{tempDir});
            throw throwable;
        }
        Utils.deleteFilesRecursively((File[])new File[]{tempDir});
    }

    public static void compareUnzippedContent(File rootDirectory, Map<String, String> entryToContent) throws IOException {
        for (Map.Entry<String, String> entry : entryToContent.entrySet()) {
            File extractedFile = new File(rootDirectory, entry.getKey());
            Assert.assertTrue((String)("Missing entry: " + entry.getKey()), (boolean)extractedFile.exists());
            if (entry.getValue() == null) {
                Assert.assertTrue((String)(entry.getKey() + " was supposed to be a directory."), (boolean)extractedFile.isDirectory());
                continue;
            }
            Assert.assertTrue((String)(entry.getKey() + " was supposed to be a file."), (boolean)extractedFile.isFile());
            String fileContent = Utils.readFileContent((File)extractedFile);
            Assert.assertEquals((String)entry.getValue(), (String)fileContent);
        }
    }

    public static <T> T getInternalField(Object o, String fieldName, Class<T> clazz) throws IllegalAccessException {
        Object fieldValue = null;
        for (Class<?> c = o.getClass(); c != null && fieldValue == null; c = c.getSuperclass()) {
            try {
                Field field = c.getDeclaredField(fieldName);
                field.setAccessible(true);
                fieldValue = field.get(o);
                continue;
            }
            catch (NoSuchFieldException e) {
                // empty catch block
            }
        }
        return clazz.cast(fieldValue);
    }
}

