/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.logging;

import java.util.Date;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import junit.framework.Assert;
import net.roboconf.core.logging.RoboconfLogFormatter;
import org.junit.Test;

public class RoboconfLogFormatterTest {
    @Test
    public void testFindMaxLevelLength() {
        int max = RoboconfLogFormatter.findMaxLevelLength();
        Assert.assertTrue((max >= Level.ALL.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.CONFIG.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.FINE.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.FINER.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.FINEST.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.INFO.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.OFF.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.SEVERE.toString().length() ? 1 : 0) != 0);
        Assert.assertTrue((max >= Level.WARNING.toString().length() ? 1 : 0) != 0);
    }

    @Test
    public void testFormat() {
        LogRecord record = new LogRecord(Level.FINER, "This is an error log message.");
        record.setLoggerName("my.logger.name");
        record.setSourceClassName("my.package.Class");
        record.setSourceMethodName("myMethod");
        record.setMillis(new Date().getTime());
        String s = new RoboconfLogFormatter().format(record);
        Assert.assertEquals((int)2, (int)s.split("\n").length);
        Assert.assertTrue((boolean)s.contains("\n" + record.getMessage()));
        Assert.assertTrue((boolean)s.startsWith("["));
        String fullName = record.getSourceClassName() + "#" + record.getSourceMethodName() + "\n";
        Assert.assertTrue((boolean)s.contains(fullName));
    }
}

