/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.util.UUID;
import junit.framework.Assert;
import net.roboconf.core.model.ApplicationDescriptor;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ApplicationDescriptorTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testSaveAndLoad() throws Exception {
        ApplicationDescriptor desc1 = new ApplicationDescriptor();
        this.saveAndCompare(desc1);
        desc1.setDescription(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.setName(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.setTemplateName("my-tpl");
        this.saveAndCompare(desc1);
        desc1.setTemplateQualifier("version 1");
        this.saveAndCompare(desc1);
        desc1.setDescription("A string\nwith\nmany\n\tline\nbreaks!");
        this.saveAndCompare(desc1);
    }

    private void saveAndCompare(ApplicationDescriptor desc) throws Exception {
        File f = this.folder.newFile();
        ApplicationTemplate tpl = new ApplicationTemplate(desc.getTemplateName()).qualifier(desc.getTemplateQualifier());
        Application app = new Application(desc.getName(), tpl).description(desc.getDescription());
        ApplicationDescriptor.save((File)f, (Application)app);
        ApplicationDescriptor desc2 = ApplicationDescriptor.load((File)f);
        Assert.assertEquals((String)desc.getDescription(), (String)desc2.getDescription());
        Assert.assertEquals((String)desc.getName(), (String)desc2.getName());
        Assert.assertEquals((String)desc.getTemplateName(), (String)desc2.getTemplateName());
        Assert.assertEquals((String)desc.getTemplateQualifier(), (String)desc2.getTemplateQualifier());
    }
}

