/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.util.UUID;
import junit.framework.Assert;
import net.roboconf.core.model.ApplicationTemplateDescriptor;
import net.roboconf.core.utils.Utils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ApplicationTemplateDescriptorTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testSaveAndLoad() throws Exception {
        ApplicationTemplateDescriptor desc1 = new ApplicationTemplateDescriptor();
        this.saveAndCompare(desc1);
        desc1.setDescription(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.setName(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.setQualifier(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.setDslId(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.setGraphEntryPoint(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.setInstanceEntryPoint(UUID.randomUUID().toString());
        this.saveAndCompare(desc1);
        desc1.externalExports.put("Test.to", "to");
        this.saveAndCompare(desc1);
        desc1.externalExports.put("Test2.to", "too");
        this.saveAndCompare(desc1);
        desc1.setExternalExportsPrefix("whatever");
        this.saveAndCompare(desc1);
    }

    @Test
    public void testInvalidExternalExports() throws Exception {
        File f = this.folder.newFile();
        Utils.writeStringInto((String)"exports = toto IS titi", (File)f);
        ApplicationTemplateDescriptor desc = ApplicationTemplateDescriptor.load((File)f);
        Assert.assertEquals((int)0, (int)desc.externalExports.size());
        Assert.assertEquals((int)1, (int)desc.invalidExternalExports.size());
        Assert.assertEquals((String)"toto IS titi", (String)((String)desc.invalidExternalExports.iterator().next()));
    }

    private void saveAndCompare(ApplicationTemplateDescriptor desc1) throws Exception {
        File f = this.folder.newFile();
        ApplicationTemplateDescriptor.save((File)f, (ApplicationTemplateDescriptor)desc1);
        ApplicationTemplateDescriptor desc2 = ApplicationTemplateDescriptor.load((File)f);
        Assert.assertEquals((String)desc1.getDescription(), (String)desc2.getDescription());
        Assert.assertEquals((String)desc1.getName(), (String)desc2.getName());
        Assert.assertEquals((String)desc1.getQualifier(), (String)desc2.getQualifier());
        Assert.assertEquals((String)desc1.getDslId(), (String)desc2.getDslId());
        Assert.assertEquals((String)desc1.getGraphEntryPoint(), (String)desc2.getGraphEntryPoint());
        Assert.assertEquals((String)desc1.getInstanceEntryPoint(), (String)desc2.getInstanceEntryPoint());
        Assert.assertEquals((Object)desc1.externalExports, (Object)desc2.externalExports);
        Assert.assertEquals((Object)desc1.invalidExternalExports, (Object)desc2.invalidExternalExports);
    }
}

