/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.RecipesValidator;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.utils.ProgramUtils;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RecipesValidatorTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();
    private final Logger logger = Logger.getLogger(this.getClass().getName());

    private boolean puppetIsInstalled() throws IOException {
        int exitCode;
        try {
            exitCode = ProgramUtils.executeCommand((Logger)this.logger, (String[])new String[]{"puppet", "-v"}, null, null);
        }
        catch (IOException | InterruptedException e) {
            exitCode = 1;
        }
        return exitCode == 0;
    }

    @Test
    public void testScriptValidation_noScriptAtAll() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("script");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "scripts").mkdirs());
        Assert.assertEquals((int)0, (int)RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp).size());
    }

    @Test
    public void testScriptValidation_success() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("script");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "scripts").mkdirs());
        Utils.writeStringInto((String)"\ntest", (File)new File(directory, "scripts/test.sh"));
        Assert.assertEquals((int)0, (int)RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp).size());
    }

    @Test
    public void testScriptValidation_noScriptsDirectory() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("script");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)directory.mkdirs());
        Utils.writeStringInto((String)"", (File)new File(directory, "test.sh"));
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_SCRIPT_NO_SCRIPTS_DIR, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_noModule() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)directory.mkdirs());
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_HAS_NO_RBCF_MODULE, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_twoModules() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto").mkdirs());
        Assert.assertTrue((boolean)new File(directory, "roBoconf_titi").mkdirs());
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_HAS_TOO_MANY_RBCF_MODULES, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_oneModuleButWildCardImports() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        comp.addImportedVariable(new ImportedVariable("Other.*", true, false));
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto").mkdirs());
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_DISLIKES_WILDCARD_IMPORTS, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_invalidUpdatePp() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/update.pp");
        File inputFile = TestUtils.findTestFile("/recipes/invalid-update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_MISSING_PARAM_IMPORT_DIFF, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_validUpdatePp() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/update.pp");
        File inputFile = TestUtils.findTestFile("/recipes/update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)0, (int)errors.size());
    }

    @Test
    public void testPuppetValidation_invalidInitPp() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/init.pp");
        File inputFile = TestUtils.findTestFile("/recipes/invalid-update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_MISSING_PARAM_IMPORT_DIFF, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_invalidUpdatePp_validInitPp() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/init.pp");
        File inputFile = TestUtils.findTestFile("/recipes/invalid-update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        targetFile = new File(directory, "roboconf_toto/manifests/update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_MISSING_PARAM_IMPORT_DIFF, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_onlyStartPp() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/start.pp");
        File inputFile = TestUtils.findTestFile("/recipes/invalid-update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)0, (int)errors.size());
    }

    @Test
    public void testPuppetValidation_missingRunningState() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/start.pp");
        File inputFile = TestUtils.findTestFile("/recipes/missing-running-state.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_MISSING_PARAM_RUNNING_STATE, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_missingParameterFromImports() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        comp.addImportedVariable(new ImportedVariable("Test.ip", true, false));
        comp.addImportedVariable(new ImportedVariable("Test.port", true, false));
        comp.addImportedVariable(new ImportedVariable("Oops.ip", true, false));
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/start.pp");
        File inputFile = TestUtils.findTestFile("/recipes/update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)2, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_MISSING_PARAM_FROM_IMPORT, (Object)((ModelError)errors.get(0)).getErrorCode());
        Assert.assertTrue((boolean)((ModelError)errors.get(0)).getDetails().contains("Parameter: test"));
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_MISSING_PARAM_FROM_IMPORT, (Object)((ModelError)errors.get(1)).getErrorCode());
        Assert.assertTrue((boolean)((ModelError)errors.get(1)).getDetails().contains("Parameter: oops"));
    }

    @Test
    public void testPuppetValidation_invalidPuppetClass() throws Exception {
        Assume.assumeTrue((boolean)this.puppetIsInstalled());
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        comp.addImportedVariable(new ImportedVariable("Test.ip", true, false));
        comp.addImportedVariable(new ImportedVariable("Test.port", true, false));
        comp.addImportedVariable(new ImportedVariable("Oops.ip", true, false));
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/start.pp");
        Utils.writeStringInto((String)"Not a valid puppet class...", (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_SYNTAX_ERROR, (Object)((ModelError)errors.get(0)).getErrorCode());
    }

    @Test
    public void testPuppetValidation_withMatchingImport() throws Exception {
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        comp.addImportedVariable(new ImportedVariable("WithInit.value", true, false));
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/start.pp");
        File inputFile = TestUtils.findTestFile("/recipes/update.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)0, (int)errors.size());
    }

    @Test
    public void testPuppetValidation_invalidSyntax() throws Exception {
        Assume.assumeTrue((boolean)this.puppetIsInstalled());
        File appDir = this.folder.newFolder();
        Component comp = new Component("toto").installerName("puppet");
        File directory = ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)comp);
        Assert.assertTrue((boolean)new File(directory, "roboconf_toto/manifests").mkdirs());
        File targetFile = new File(directory, "roboconf_toto/manifests/start.pp");
        File inputFile = TestUtils.findTestFile("/recipes/invalid-syntax.pp");
        Utils.copyStream((File)inputFile, (File)targetFile);
        List errors = RecipesValidator.validateComponentRecipes((File)appDir, (Component)comp);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.REC_PUPPET_SYNTAX_ERROR, (Object)((ModelError)errors.get(0)).getErrorCode());
    }
}

