/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.RoboconfError;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.ApplicationTemplateDescriptor;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.SourceReference;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.RoboconfErrorHelpers;
import net.roboconf.core.utils.Utils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RuntimeModelIoTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testLoadApplication_Lamp_Legacy_1() throws Exception {
        File directory = TestUtils.findTestFile("/applications/lamp-legacy-with-only-components");
        RuntimeModelIo.ApplicationLoadResult result = RuntimeModelIo.loadApplication((File)directory);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.applicationTemplate);
        Assert.assertEquals((int)4, (int)result.loadErrors.size());
        for (RoboconfError error : result.loadErrors) {
            Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)error.getErrorCode());
        }
        Assert.assertEquals((String)"Legacy LAMP", (String)result.applicationTemplate.getName());
        Assert.assertEquals((String)"A sample LAMP application", (String)result.applicationTemplate.getDescription());
        Assert.assertEquals((String)"sample", (String)result.applicationTemplate.getQualifier());
        Assert.assertNotNull((Object)result.applicationTemplate.getGraphs());
        Graphs g = result.applicationTemplate.getGraphs();
        Assert.assertEquals((int)1, (int)g.getRootComponents().size());
        Component vmComponent = (Component)g.getRootComponents().iterator().next();
        Assert.assertEquals((String)"VM", (String)vmComponent.getName());
        Assert.assertEquals((String)"target", (String)vmComponent.getInstallerName());
        Assert.assertEquals((int)3, (int)vmComponent.getChildren().size());
        for (Component childComponent : ComponentHelpers.findAllChildren((Component)vmComponent)) {
            SourceReference sr;
            Map exportedVariables = ComponentHelpers.findAllExportedVariables((Component)childComponent);
            Map importedVariables = ComponentHelpers.findAllImportedVariables((Component)childComponent);
            Collection children = ComponentHelpers.findAllChildren((Component)childComponent);
            if ("Tomcat".equals(childComponent.getName())) {
                Assert.assertEquals((String)"puppet", (String)childComponent.getInstallerName());
                Assert.assertEquals((int)0, (int)children.size());
                Assert.assertEquals((int)2, (int)exportedVariables.size());
                Assert.assertTrue((boolean)exportedVariables.containsKey("Tomcat.ip"));
                Assert.assertEquals((String)"8009", (String)((String)exportedVariables.get("Tomcat.portAJP")));
                Assert.assertEquals((int)2, (int)importedVariables.size());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.ip")).isOptional());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.ip")).isExternal());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.port")).isOptional());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.port")).isExternal());
                sr = (SourceReference)result.getObjectToSource().get(childComponent);
                Assert.assertNotNull((Object)sr);
                Assert.assertEquals((Object)new File(directory, "graph/lamp.graph"), (Object)sr.getSourceFile());
                Assert.assertEquals((int)22, (int)sr.getLine());
                continue;
            }
            if ("MySQL".equals(childComponent.getName())) {
                Assert.assertEquals((String)"puppet", (String)childComponent.getInstallerName());
                Assert.assertEquals((int)0, (int)children.size());
                Assert.assertEquals((int)2, (int)exportedVariables.size());
                Assert.assertTrue((boolean)exportedVariables.containsKey("MySQL.ip"));
                Assert.assertNull(exportedVariables.get("MySQL.port"));
                Assert.assertEquals((int)0, (int)importedVariables.size());
                sr = (SourceReference)result.getObjectToSource().get(childComponent);
                Assert.assertNotNull((Object)sr);
                Assert.assertEquals((Object)new File(directory, "graph/lamp.graph"), (Object)sr.getSourceFile());
                Assert.assertEquals((int)16, (int)sr.getLine());
                continue;
            }
            if ("Apache".equals(childComponent.getName())) {
                Assert.assertEquals((String)"puppet", (String)childComponent.getInstallerName());
                Assert.assertEquals((int)0, (int)children.size());
                Assert.assertEquals((int)0, (int)exportedVariables.size());
                Assert.assertEquals((int)2, (int)childComponent.importedVariables.size());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.ip")).isOptional());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.ip")).isExternal());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.portAJP")).isOptional());
                Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.portAJP")).isExternal());
                sr = (SourceReference)result.getObjectToSource().get(childComponent);
                Assert.assertNotNull((Object)sr);
                Assert.assertEquals((Object)new File(directory, "graph/lamp.graph"), (Object)sr.getSourceFile());
                Assert.assertEquals((int)30, (int)sr.getLine());
                continue;
            }
            Assert.fail((String)"Unrecognized child.");
        }
        Assert.assertEquals((int)3, (int)result.applicationTemplate.getRootInstances().size());
        for (Instance i : result.applicationTemplate.getRootInstances()) {
            Instance child;
            if ("Apache VM".equals(i.getName())) {
                Assert.assertEquals((String)"VM", (String)i.getComponent().getName());
                Assert.assertEquals((int)1, (int)i.getChildren().size());
                child = (Instance)i.getChildren().iterator().next();
                Assert.assertEquals((int)0, (int)child.getChildren().size());
                Assert.assertEquals((Object)i, (Object)child.getParent());
                Assert.assertEquals((String)"Apache", (String)child.getName());
                Assert.assertEquals((String)"Apache", (String)child.getComponent().getName());
                continue;
            }
            if ("MySQL VM".equals(i.getName())) {
                Assert.assertEquals((String)"VM", (String)i.getComponent().getName());
                Assert.assertEquals((int)1, (int)i.getChildren().size());
                child = (Instance)i.getChildren().iterator().next();
                Assert.assertEquals((int)0, (int)child.getChildren().size());
                Assert.assertEquals((Object)i, (Object)child.getParent());
                Assert.assertEquals((String)"MySQL", (String)child.getName());
                Assert.assertEquals((String)"MySQL", (String)child.getComponent().getName());
                Map exportedVariables = InstanceHelpers.findAllExportedVariables((Instance)child);
                Assert.assertEquals((String)"3306", (String)((String)exportedVariables.get("MySQL.port")));
                Assert.assertNull(child.getComponent().exportedVariables.get("MySQL.port"));
                Assert.assertNull(child.getComponent().exportedVariables.get("port"));
                continue;
            }
            if ("Tomcat VM 1".equals(i.getName())) {
                Assert.assertEquals((String)"VM", (String)i.getComponent().getName());
                Assert.assertEquals((int)1, (int)i.getChildren().size());
                child = (Instance)i.getChildren().iterator().next();
                Assert.assertEquals((int)0, (int)child.getChildren().size());
                Assert.assertEquals((Object)i, (Object)child.getParent());
                Assert.assertEquals((String)"Tomcat", (String)child.getName());
                Assert.assertEquals((String)"Tomcat", (String)child.getComponent().getName());
                continue;
            }
            Assert.fail((String)"Unrecognized instance.");
        }
    }

    @Test
    public void testLoadApplication_Lamp_Legacy_2() throws Exception {
        File directory = TestUtils.findTestFile("/applications/lamp-legacy-with-facets-and-so-on");
        RuntimeModelIo.ApplicationLoadResult result = RuntimeModelIo.loadApplication((File)directory);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.applicationTemplate);
        Assert.assertEquals((int)3, (int)result.loadErrors.size());
        for (RoboconfError error : result.loadErrors) {
            Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)error.getErrorCode());
        }
        Assert.assertEquals((String)"Legacy LAMP", (String)result.applicationTemplate.getName());
        Assert.assertEquals((String)"A sample LAMP application", (String)result.applicationTemplate.getDescription());
        Assert.assertEquals((String)"sample", (String)result.applicationTemplate.getQualifier());
        Assert.assertEquals((String)"roboconf-1.0", (String)result.applicationTemplate.getDslId());
        Assert.assertNotNull((Object)result.applicationTemplate.getGraphs());
        Graphs g = result.applicationTemplate.getGraphs();
        Assert.assertEquals((int)3, (int)g.getRootComponents().size());
        HashSet<String> rootComponentNames = new HashSet<String>();
        for (Component c : g.getRootComponents()) {
            rootComponentNames.add(c.getName());
            Assert.assertEquals((String)"target", (String)ComponentHelpers.findComponentInstaller((Component)c));
            Collection facets = ComponentHelpers.findAllFacets((Component)c);
            Assert.assertEquals((int)1, (int)facets.size());
            Assert.assertEquals((String)"Virtual_Machine", (String)((Facet)facets.iterator().next()).getName());
            Assert.assertEquals((int)3, (int)ComponentHelpers.findAllChildren((Component)c).size());
            for (Component childComponent : ComponentHelpers.findAllChildren((Component)c)) {
                Map exportedVariables = ComponentHelpers.findAllExportedVariables((Component)childComponent);
                Map importedVariables = ComponentHelpers.findAllImportedVariables((Component)childComponent);
                Collection children = ComponentHelpers.findAllChildren((Component)childComponent);
                if ("Tomcat".equals(childComponent.getName())) {
                    Assert.assertEquals((String)"puppet", (String)childComponent.getInstallerName());
                    Assert.assertEquals((int)0, (int)children.size());
                    Assert.assertEquals((int)1, (int)childComponent.getFacets().size());
                    Assert.assertEquals((String)"deployable", (String)((Facet)childComponent.getFacets().iterator().next()).getName());
                    Assert.assertEquals((int)2, (int)exportedVariables.size());
                    Assert.assertTrue((boolean)exportedVariables.containsKey("Tomcat.ip"));
                    Assert.assertEquals((String)"8009", (String)((String)exportedVariables.get("Tomcat.portAJP")));
                    Assert.assertEquals((int)2, (int)importedVariables.size());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.ip")).isOptional());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.ip")).isExternal());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.port")).isOptional());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("MySQL.port")).isExternal());
                    continue;
                }
                if ("MySQL".equals(childComponent.getName())) {
                    Assert.assertEquals((String)"puppet", (String)childComponent.getInstallerName());
                    Assert.assertEquals((int)0, (int)children.size());
                    Assert.assertEquals((int)1, (int)childComponent.getFacets().size());
                    Assert.assertEquals((String)"deployable", (String)((Facet)childComponent.getFacets().iterator().next()).getName());
                    Assert.assertEquals((int)2, (int)exportedVariables.size());
                    Assert.assertTrue((boolean)exportedVariables.containsKey("MySQL.ip"));
                    Assert.assertEquals((String)"3306", (String)((String)exportedVariables.get("MySQL.port")));
                    Assert.assertEquals((int)0, (int)importedVariables.size());
                    continue;
                }
                if ("Apache".equals(childComponent.getName())) {
                    Assert.assertEquals((String)"puppet", (String)childComponent.getInstallerName());
                    Assert.assertEquals((int)0, (int)children.size());
                    Assert.assertEquals((int)0, (int)exportedVariables.size());
                    Assert.assertEquals((int)1, (int)childComponent.getFacets().size());
                    Assert.assertEquals((String)"deployable", (String)((Facet)childComponent.getFacets().iterator().next()).getName());
                    Assert.assertEquals((int)2, (int)importedVariables.size());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.ip")).isOptional());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.ip")).isExternal());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.portAJP")).isOptional());
                    Assert.assertFalse((boolean)((ImportedVariable)importedVariables.get("Tomcat.portAJP")).isExternal());
                    continue;
                }
                Assert.fail((String)"Unrecognized child.");
            }
        }
        Assert.assertEquals((int)3, (int)rootComponentNames.size());
        Assert.assertTrue((boolean)rootComponentNames.contains("VM"));
        Assert.assertTrue((boolean)rootComponentNames.contains("VM_EC2"));
        Assert.assertTrue((boolean)rootComponentNames.contains("VM_Openstack"));
        Component vmOpenstack = ComponentHelpers.findComponent((Graphs)g, (String)"VM_Openstack");
        Map exportedVariables = ComponentHelpers.findAllExportedVariables((Component)vmOpenstack);
        Assert.assertEquals((int)4, (int)exportedVariables.size());
        Assert.assertEquals((String)"else", (String)((String)exportedVariables.get("VM_Openstack.something")));
        Assert.assertNull(exportedVariables.get("Virtual_Machine.ip"));
        Assert.assertTrue((boolean)exportedVariables.containsKey("Virtual_Machine.ip"));
        Assert.assertTrue((boolean)exportedVariables.containsKey("VM_Openstack.ip"));
        Assert.assertTrue((boolean)exportedVariables.containsKey("VM.ip"));
        Assert.assertEquals((Object)ComponentHelpers.findComponent((Graphs)g, (String)"VM"), (Object)vmOpenstack.getExtendedComponent());
        Assert.assertNotNull((Object)vmOpenstack.getExtendedComponent());
        HashSet<String> expectedPaths = new HashSet<String>();
        expectedPaths.add("/Apache VM");
        expectedPaths.add("/Apache VM/Apache");
        expectedPaths.add("/MySQL VM");
        expectedPaths.add("/MySQL VM/MySQL");
        expectedPaths.add("/Tomcat VM 1");
        expectedPaths.add("/Tomcat VM 1/Tomcat");
        expectedPaths.add("/Tomcat VM 2");
        expectedPaths.add("/Tomcat VM 2/Tomcat");
        expectedPaths.add("/Tomcat VM 3");
        expectedPaths.add("/Tomcat VM 3/Tomcat");
        HashSet<String> realPaths = new HashSet<String>();
        for (Instance inst : InstanceHelpers.getAllInstances((AbstractApplication)result.getApplicationTemplate())) {
            realPaths.add(InstanceHelpers.computeInstancePath((Instance)inst));
        }
        Assert.assertEquals((int)expectedPaths.size(), (int)realPaths.size());
        realPaths.removeAll(expectedPaths);
        Assert.assertEquals((int)0, (int)realPaths.size());
        Instance tomcat1 = InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/Tomcat VM 1/Tomcat");
        Instance tomcat2 = InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/Tomcat VM 2/Tomcat");
        Instance tomcat3 = InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/Tomcat VM 3/Tomcat");
        Assert.assertEquals((Object)tomcat1.getComponent(), (Object)tomcat2.getComponent());
        Assert.assertEquals((Object)tomcat1.getComponent(), (Object)tomcat3.getComponent());
        Assert.assertEquals((Object)tomcat1.channels, (Object)tomcat2.channels);
        Assert.assertEquals((Object)tomcat1.channels, (Object)tomcat3.channels);
        Assert.assertEquals((int)0, (int)tomcat1.getChildren().size());
        Assert.assertEquals((int)1, (int)tomcat1.overriddenExports.size());
        Assert.assertEquals((String)"9021", (String)((String)tomcat1.overriddenExports.get("portAJP")));
        Assert.assertEquals((String)"9021", (String)((String)InstanceHelpers.findAllExportedVariables((Instance)tomcat1).get("Tomcat.portAJP")));
        Assert.assertEquals((int)0, (int)tomcat2.getChildren().size());
        Assert.assertEquals((int)1, (int)tomcat2.overriddenExports.size());
        Assert.assertEquals((String)"9021", (String)((String)tomcat2.overriddenExports.get("portAJP")));
        Assert.assertEquals((String)"9021", (String)((String)InstanceHelpers.findAllExportedVariables((Instance)tomcat2).get("Tomcat.portAJP")));
        Assert.assertEquals((int)0, (int)tomcat3.getChildren().size());
        Assert.assertEquals((int)1, (int)tomcat3.overriddenExports.size());
        Assert.assertEquals((String)"9021", (String)((String)tomcat3.overriddenExports.get("portAJP")));
        Assert.assertEquals((String)"9021", (String)((String)InstanceHelpers.findAllExportedVariables((Instance)tomcat3).get("Tomcat.portAJP")));
    }

    @Test
    public void testLoadApplication_Mongo() throws Exception {
        File directory = TestUtils.findTestFile("/applications/mongo");
        RuntimeModelIo.ApplicationLoadResult result = RuntimeModelIo.loadApplication((File)directory);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.applicationTemplate);
        Assert.assertEquals((int)0, (int)result.applicationTemplate.externalExports.size());
        Assert.assertEquals((int)2, (int)result.loadErrors.size());
        for (RoboconfError error : result.loadErrors) {
            Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)error.getErrorCode());
        }
        Assert.assertEquals((String)"Mongo", (String)result.applicationTemplate.getName());
        Assert.assertNotNull((Object)result.applicationTemplate.getGraphs());
        Graphs g = result.applicationTemplate.getGraphs();
        Assert.assertEquals((int)1, (int)g.getRootComponents().size());
        Component vmComponent = (Component)g.getRootComponents().iterator().next();
        Assert.assertEquals((String)"VM", (String)vmComponent.getName());
        Assert.assertEquals((String)"target", (String)vmComponent.getInstallerName());
        Assert.assertEquals((int)0, (int)vmComponent.getFacets().size());
        Collection children = ComponentHelpers.findAllChildren((Component)vmComponent);
        Assert.assertEquals((int)1, (int)children.size());
        Component childComponent = (Component)children.iterator().next();
        Assert.assertEquals((String)"puppet", (String)childComponent.getInstallerName());
        Assert.assertEquals((int)0, (int)childComponent.getChildren().size());
        Assert.assertEquals((int)2, (int)childComponent.exportedVariables.size());
        Assert.assertNull(childComponent.exportedVariables.get("Mongo.ip"));
        Assert.assertEquals((String)"27017", (String)((String)ComponentHelpers.findAllExportedVariables((Component)childComponent).get("Mongo.port")));
        Assert.assertEquals((int)2, (int)childComponent.importedVariables.size());
        Assert.assertTrue((boolean)childComponent.importedVariables.containsKey("Mongo.ip"));
        Assert.assertTrue((boolean)childComponent.importedVariables.containsKey("Mongo.port"));
    }

    @Test
    public void testLoadApplication_AppWithExternalDependencies() throws Exception {
        File directory = TestUtils.findTestFile("/applications/app-with-external-dependencies");
        RuntimeModelIo.ApplicationLoadResult result = RuntimeModelIo.loadApplication((File)directory);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.applicationTemplate);
        Assert.assertEquals((int)2, (int)result.applicationTemplate.externalExports.size());
        Assert.assertEquals((String)"DEP.c", (String)((String)result.applicationTemplate.externalExports.get("VM.config")));
        Assert.assertEquals((String)"DEP.ip", (String)((String)result.applicationTemplate.externalExports.get("App.ip")));
        Assert.assertEquals((int)2, (int)result.loadErrors.size());
        for (RoboconfError error : result.loadErrors) {
            Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)error.getErrorCode());
        }
        Assert.assertEquals((String)"app-with-dep", (String)result.applicationTemplate.getName());
        Assert.assertNotNull((Object)result.applicationTemplate.getGraphs());
        Graphs g = result.applicationTemplate.getGraphs();
        Assert.assertEquals((int)1, (int)g.getRootComponents().size());
        Component vmComponent = (Component)g.getRootComponents().iterator().next();
        Assert.assertEquals((String)"VM", (String)vmComponent.getName());
        Assert.assertEquals((String)"target", (String)vmComponent.getInstallerName());
        Assert.assertEquals((int)0, (int)vmComponent.getFacets().size());
        Collection children = ComponentHelpers.findAllChildren((Component)vmComponent);
        Assert.assertEquals((int)1, (int)children.size());
        Component childComponent = (Component)children.iterator().next();
        Assert.assertEquals((String)"App", (String)childComponent.getName());
        Assert.assertEquals((String)"logger", (String)childComponent.getInstallerName());
        Assert.assertEquals((int)0, (int)childComponent.getChildren().size());
        Assert.assertEquals((int)1, (int)childComponent.exportedVariables.size());
        Assert.assertNull(childComponent.exportedVariables.get("App.ip"));
        Assert.assertEquals((int)2, (int)childComponent.importedVariables.size());
        Assert.assertTrue((boolean)childComponent.importedVariables.containsKey("VM.config"));
        Assert.assertFalse((boolean)((ImportedVariable)childComponent.importedVariables.get("VM.config")).isOptional());
        Assert.assertFalse((boolean)((ImportedVariable)childComponent.importedVariables.get("VM.config")).isExternal());
        Assert.assertTrue((boolean)childComponent.importedVariables.containsKey("App1.test"));
        Assert.assertFalse((boolean)((ImportedVariable)childComponent.importedVariables.get("App1.test")).isOptional());
        Assert.assertTrue((boolean)((ImportedVariable)childComponent.importedVariables.get("App1.test")).isExternal());
    }

    @Test
    public void testLoadApplicationErrors() throws Exception {
        File tempDirectory = this.folder.newFolder();
        Iterator iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_DESC_DIR, (Object)((RoboconfError)iterator.next()).getErrorCode());
        File appDir = new File(tempDirectory, "descriptor");
        if (!appDir.mkdir()) {
            throw new IOException("Failed to create the descriptor directory.");
        }
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_DESC_FILE, (Object)((RoboconfError)iterator.next()).getErrorCode());
        Properties props = new Properties();
        props.setProperty("application-name", "app-name");
        props.setProperty("application-qualifier", "snapshot");
        props.setProperty("application-dsl-id", "roboconf-1.0");
        props.setProperty("graph-entry-point", "main.graph");
        Utils.writePropertiesFile((Properties)props, (File)new File(appDir, "application.properties"));
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_GRAPH_DIR, (Object)((RoboconfError)iterator.next()).getErrorCode());
        File graphDir = new File(tempDirectory, "graph");
        if (!graphDir.mkdir()) {
            throw new IOException("Failed to create the graph directory.");
        }
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.PROJ_MISSING_GRAPH_EP, (Object)((RoboconfError)iterator.next()).getErrorCode());
        File graphFile = new File(graphDir, "main.graph");
        if (!graphFile.createNewFile()) {
            throw new IOException("Faild to create a graph file.");
        }
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.P_NO_FILE_TYPE, (Object)((RoboconfError)iterator.next()).getErrorCode());
        String fileContent = "instanceof Toto {\n\tname: toto;\n}";
        Utils.copyStream((InputStream)new ByteArrayInputStream(fileContent.getBytes("UTF-8")), (File)graphFile);
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.PM_PROPERTY_NOT_APPLIABLE, (Object)((RoboconfError)iterator.next()).getErrorCode());
        fileContent = "instance of Toto {\n\tname: toto;\n}";
        Utils.copyStream((InputStream)new ByteArrayInputStream(fileContent.getBytes("UTF-8")), (File)graphFile);
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.CO_NOT_A_GRAPH, (Object)((RoboconfError)iterator.next()).getErrorCode());
        fileContent = "facet MyFacet {\n}\n\nA {\n\tinstaller: target;\n}";
        Utils.copyStream((InputStream)new ByteArrayInputStream(fileContent.getBytes("UTF-8")), (File)graphFile);
        Collection errors = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors;
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)((RoboconfError)errors.iterator().next()).getErrorCode());
        props.setProperty("instance-entry-point", "init.instances");
        Utils.writePropertiesFile((Properties)props, (File)new File(appDir, "application.properties"));
        File instDir = new File(tempDirectory, "instances");
        if (!instDir.mkdir()) {
            throw new IOException("Failed to create the instances directory.");
        }
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)((RoboconfError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.PROJ_MISSING_INSTANCE_EP, (Object)((RoboconfError)iterator.next()).getErrorCode());
        File instancesFile = new File(instDir, "init.instances");
        fileContent = "facet MyFacet {\n}\n\nA {\n\tinstaller: script;\n}";
        Utils.copyStream((InputStream)new ByteArrayInputStream(fileContent.getBytes("UTF-8")), (File)instancesFile);
        iterator = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)((RoboconfError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.CO_NOT_INSTANCES, (Object)((RoboconfError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        fileContent = "instance of A {\n\tname: toto;\n}";
        Utils.copyStream((InputStream)new ByteArrayInputStream(fileContent.getBytes("UTF-8")), (File)instancesFile);
        errors = RuntimeModelIo.loadApplication((File)tempDirectory).loadErrors;
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)((RoboconfError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testLoadApplication_KarafJoramJndi() throws Exception {
        File directory = TestUtils.findTestFile("/applications/karaf-joram-jndi");
        RuntimeModelIo.ApplicationLoadResult result = RuntimeModelIo.loadApplication((File)directory);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.applicationTemplate);
        Assert.assertEquals((int)6, (int)result.loadErrors.size());
        for (RoboconfError error : result.loadErrors) {
            Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)error.getErrorCode());
        }
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/vmec2karaf"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/vmec2karaf/karafec21"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/vmec2karaf/karafec21/jndiec2"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/vmec2karaf/karafec22"));
        Assert.assertNotNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)result.getApplicationTemplate(), (String)"/vmec2karaf/karafec22/joramec2"));
    }

    @Test
    public void testInvalidApplicationDescriptor() throws Exception {
        File appDirectory = this.folder.newFolder();
        File descDirectory = new File(appDirectory, "descriptor");
        if (!descDirectory.mkdir()) {
            throw new IOException();
        }
        File descFile = new File(descDirectory, "application.properties");
        if (!descFile.createNewFile()) {
            throw new IOException();
        }
        String content = "fail.read = true";
        Utils.copyStream((InputStream)new ByteArrayInputStream(content.getBytes("UTF-8")), (File)descFile);
        RuntimeModelIo.ApplicationLoadResult lr = RuntimeModelIo.loadApplication((File)appDirectory);
        Assert.assertTrue((lr.getLoadErrors().size() > 1 ? 1 : 0) != 0);
        Assert.assertEquals((Object)ErrorCode.PROJ_READ_DESC_FILE, (Object)((RoboconfError)lr.getLoadErrors().iterator().next()).getErrorCode());
    }

    @Test
    public void testWriteInstances_empty() throws Exception {
        File targetFile = this.folder.newFile();
        RuntimeModelIo.writeInstances((File)targetFile, new ArrayList(0));
        Assert.assertTrue((boolean)targetFile.exists());
        Assert.assertEquals((long)0L, (long)targetFile.length());
    }

    @Test
    public void testWriteInstances_notEmpty() throws Exception {
        Component component = new Component("comp");
        Instance instance = new Instance("inst").component(component).status(Instance.InstanceStatus.DEPLOYING).channel("c");
        instance.overriddenExports.put("check", "true");
        instance.data.put("something", "else");
        File targetFile = this.folder.newFile();
        RuntimeModelIo.writeInstances((File)targetFile, Arrays.asList(instance));
        Assert.assertTrue((boolean)targetFile.exists());
        Assert.assertTrue((0L < targetFile.length() ? 1 : 0) != 0);
    }

    @Test
    public void testApplicationWithMissingGraph() throws Exception {
        File dir = this.folder.newFolder();
        Assert.assertTrue((boolean)new File(dir, "descriptor").mkdir());
        Assert.assertTrue((boolean)new File(dir, "graph").mkdir());
        Assert.assertTrue((boolean)new File(dir, "instances").mkdir());
        Assert.assertTrue((boolean)new File(dir, "instances/model.instances").createNewFile());
        ApplicationTemplateDescriptor desc = new ApplicationTemplateDescriptor();
        desc.setName("app name");
        desc.setQualifier("qualifier");
        desc.setInstanceEntryPoint("model.instances");
        desc.setDslId("roboconf-1.0");
        ApplicationTemplateDescriptor.save((File)new File(dir, "descriptor/application.properties"), (ApplicationTemplateDescriptor)desc);
        Iterator it = RuntimeModelIo.loadApplicationFlexibly((File)dir).loadErrors.iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GEP, (Object)((RoboconfError)it.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.CO_GRAPH_COULD_NOT_BE_BUILT, (Object)((RoboconfError)it.next()).getErrorCode());
    }

    @Test
    public void testApplicationWithoutInstances() throws Exception {
        File dir = this.folder.newFolder();
        Assert.assertTrue((boolean)new File(dir, "descriptor").mkdir());
        Assert.assertTrue((boolean)new File(dir, "graph").mkdir());
        Assert.assertTrue((boolean)new File(dir, "instances").mkdir());
        Assert.assertTrue((boolean)new File(dir, "graph/VM").mkdir());
        Assert.assertTrue((boolean)new File(dir, "graph/VM/target.properties").createNewFile());
        File graphFile = new File(dir, "graph/app.graph");
        Assert.assertTrue((boolean)graphFile.createNewFile());
        ApplicationTemplateDescriptor desc = new ApplicationTemplateDescriptor();
        desc.setName("app name");
        desc.setQualifier("qualifier");
        desc.setGraphEntryPoint("app.graph");
        desc.setDslId("roboconf-1.0");
        ApplicationTemplateDescriptor.save((File)new File(dir, "descriptor/application.properties"), (ApplicationTemplateDescriptor)desc);
        Utils.writeStringInto((String)"VM {\ninstaller:target;\n}", (File)graphFile);
        Assert.assertEquals((int)0, (int)RuntimeModelIo.loadApplication((File)dir).loadErrors.size());
    }

    @Test
    public void testParsingWithRecipeProject() throws Exception {
        File dir = TestUtils.findTestFile("/reusable.recipe");
        Assert.assertTrue((boolean)dir.exists());
        RuntimeModelIo.ApplicationLoadResult alr = RuntimeModelIo.loadApplication((File)dir);
        RoboconfErrorHelpers.filterErrorsForRecipes((RuntimeModelIo.ApplicationLoadResult)alr);
        Assert.assertEquals((int)1, (int)alr.getLoadErrors().size());
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_DESC_DIR, (Object)((RoboconfError)alr.getLoadErrors().iterator().next()).getErrorCode());
        alr = RuntimeModelIo.loadApplicationFlexibly((File)dir);
        RoboconfErrorHelpers.filterErrorsForRecipes((RuntimeModelIo.ApplicationLoadResult)alr);
        Assert.assertEquals((int)0, (int)alr.getLoadErrors().size());
    }

    @Test
    public void testParsingWithInvalidRecipeProject() throws Exception {
        File dir = TestUtils.findTestFile("/reusable.recipe.with.errors");
        Assert.assertTrue((boolean)dir.exists());
        RuntimeModelIo.ApplicationLoadResult alr = RuntimeModelIo.loadApplicationFlexibly((File)dir);
        RoboconfErrorHelpers.filterErrorsForRecipes((RuntimeModelIo.ApplicationLoadResult)alr);
        Assert.assertEquals((int)1, (int)alr.getLoadErrors().size());
        Assert.assertEquals((Object)ErrorCode.RM_UNRESOLVABLE_VARIABLE, (Object)((RoboconfError)alr.getLoadErrors().iterator().next()).getErrorCode());
        Assert.assertTrue((boolean)((RoboconfError)alr.getLoadErrors().iterator().next()).getDetails().contains("f.*"));
    }

    @Test
    public void testGraphFileFilter() throws Exception {
        RuntimeModelIo.GraphFileFilter filter = new RuntimeModelIo.GraphFileFilter();
        Assert.assertFalse((boolean)filter.accept(new File("inexisting")));
        Assert.assertTrue((boolean)filter.accept(this.folder.newFile("toto.graph")));
        Assert.assertFalse((boolean)filter.accept(this.folder.newFile("toto.txt")));
        Assert.assertFalse((boolean)filter.accept(this.folder.newFolder(new String[]{"sth.graph"})));
    }
}

