/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.dsl.ParsingModelIo;
import net.roboconf.core.dsl.ParsingModelValidator;
import net.roboconf.core.dsl.converters.FromGraphDefinition;
import net.roboconf.core.dsl.converters.FromInstanceDefinition;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.ApplicationTemplateDescriptor;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.RuntimeModelValidator;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class RuntimeModelValidatorTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testComponent() {
        Component comp = new Component();
        Iterator iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_COMPONENT_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_COMPONENT_INSTALLER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.setName("my # component");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_COMPONENT_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_COMPONENT_INSTALLER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.setName("my.component");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_DOT_IS_NOT_ALLOWED, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_COMPONENT_INSTALLER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.setName("comp");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_COMPONENT_INSTALLER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.setInstallerName("my installer !!");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_COMPONENT_INSTALLER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.setInstallerName("my installer");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_ROOT_INSTALLER_MUST_BE_TARGET, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.setInstallerName("target");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)comp).size());
        comp.associateFacet(new Facet(""));
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)comp).size());
        iterator = RuntimeModelValidator.validate((Facet)((Facet)comp.getFacets().iterator().next())).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_FACET_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.disassociateFacet((Facet)comp.getFacets().iterator().next());
        comp.associateFacet(new Facet("!nvalid-facet-n@me"));
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)comp).size());
        iterator = RuntimeModelValidator.validate((Facet)((Facet)comp.getFacets().iterator().next())).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_FACET_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.disassociateFacet((Facet)comp.getFacets().iterator().next());
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)comp).size());
        comp.exportedVariables.put("comp.ip", null);
        comp.exportedVariables.put("comp.port", "9000");
        comp.addImportedVariable(new ImportedVariable("comp.ip", false, false));
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_COMPONENT_IMPORTS_EXPORTS, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.addImportedVariable(new ImportedVariable("comp.ip", true, false));
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)comp).size());
        comp.addImportedVariable(new ImportedVariable("", false, false));
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.importedVariables.clear();
        comp.addImportedVariable(new ImportedVariable("comp.inva!id", false, false));
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.importedVariables.clear();
        comp.exportedVariables.put("toto", "");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.exportedVariables.clear();
        comp.exportedVariables.put("toto.ip", "");
        iterator = RuntimeModelValidator.validate((Component)comp).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        comp.exportedVariables.clear();
    }

    @Test
    public void testFacet() {
        Facet facet = new Facet();
        Iterator iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_FACET_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.setName("my # facet");
        iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_FACET_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.setName("my.facet");
        iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_DOT_IS_NOT_ALLOWED, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.setName("facet");
        iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.exportedVariables.put("", "value");
        iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.exportedVariables.clear();
        facet.exportedVariables.put("facet.inva!id", "value");
        iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.exportedVariables.clear();
        facet.exportedVariables.put("toto", "");
        iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.exportedVariables.clear();
        facet.exportedVariables.put("toto.ip", "");
        iterator = RuntimeModelValidator.validate((Facet)facet).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        facet.exportedVariables.clear();
    }

    @Test
    public void testCycleInComponentInheritance() {
        Component c1 = new Component("c1").installerName("target");
        Component c2 = new Component("c2").installerName("target");
        Component c3 = new Component("c3").installerName("target");
        Component c4 = new Component("c4").installerName("target");
        c1.extendComponent(c2);
        c2.extendComponent(c3);
        c3.extendComponent(c4);
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)c1).size());
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)c2).size());
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)c3).size());
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)c4).size());
        c4.extendComponent(c1);
        Iterator iterator = RuntimeModelValidator.validate((Component)c1).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_CYCLE_IN_COMPONENTS_INHERITANCE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = RuntimeModelValidator.validate((Component)c1).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_CYCLE_IN_COMPONENTS_INHERITANCE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = RuntimeModelValidator.validate((Component)c2).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_CYCLE_IN_COMPONENTS_INHERITANCE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        iterator = RuntimeModelValidator.validate((Component)c4).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_CYCLE_IN_COMPONENTS_INHERITANCE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        c1.extendComponent(c1);
        iterator = RuntimeModelValidator.validate((Component)c1).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_CYCLE_IN_COMPONENTS_INHERITANCE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testGraphs_withCaseErrorInImports() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/graph-with-invalid-case-imports.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs g = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Collection errors = RuntimeModelValidator.validate((Graphs)g);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.RM_UNRESOLVABLE_VARIABLE, (Object)((ModelError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testGraphs() {
        Graphs graphs = new Graphs();
        Iterator iterator = RuntimeModelValidator.validate((Graphs)graphs).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_NO_ROOT_COMPONENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        Component comp1 = new Component("comp1").installerName("target");
        graphs.getRootComponents().add(comp1);
        Component duplicateComp1 = new Component("comp1").installerName("target");
        graphs.getRootComponents().add(duplicateComp1);
        iterator = RuntimeModelValidator.validate((Graphs)graphs).iterator();
        if (iterator.hasNext()) {
            Assert.assertFalse((boolean)iterator.hasNext());
        }
        graphs.getRootComponents().clear();
        graphs.getRootComponents().add(comp1);
        comp1.addImportedVariable(new ImportedVariable("tomcat.port", false, false));
        iterator = RuntimeModelValidator.validate((Graphs)graphs).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_UNRESOLVABLE_VARIABLE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp1.addImportedVariable(new ImportedVariable("tomcat.port", true, false));
        iterator = RuntimeModelValidator.validate((Graphs)graphs).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_UNRESOLVABLE_VARIABLE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        comp1.importedVariables.clear();
        Component comp2 = new Component("comp2").installerName("installer-2");
        Component comp3 = new Component("comp3").installerName("installer-3");
        comp1.addChild((AbstractType)comp2);
        comp2.addChild((AbstractType)comp3);
        comp3.addChild((AbstractType)comp2);
        Collection errors = RuntimeModelValidator.validate((Graphs)graphs);
        Assert.assertEquals((int)2, (int)errors.size());
        for (ModelError error : errors) {
            Assert.assertEquals((Object)ErrorCode.RM_CYCLE_IN_COMPONENTS, (Object)error.getErrorCode());
        }
    }

    @Test
    public void testGraphs_notRoot() {
        Component comp1 = new Component("comp1").installerName("target");
        Component comp2 = new Component("comp2").installerName("target");
        comp1.addChild((AbstractType)comp2);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(comp2);
        Iterator iterator = RuntimeModelValidator.validate((Graphs)graphs).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_NOT_A_ROOT_COMPONENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testInstance() {
        Instance inst = new Instance();
        Iterator iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_INSTANCE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_INSTANCE_COMPONENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        inst.setName("?my instance?");
        iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_INSTANCE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_INSTANCE_COMPONENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        inst.setName("my-instance");
        iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_INSTANCE_COMPONENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        inst.setComponent(new Component("comp"));
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Instance)inst).size());
        inst.setName("my instance");
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Instance)inst).size());
        inst.overriddenExports.put("inst.value", "whatever");
        iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testInstance_noVariableValue() {
        Instance inst = new Instance("my instance");
        Iterator iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_INSTANCE_COMPONENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        Component comp = new Component("comp").installerName("target");
        comp.exportedVariables.put("ip", "");
        comp.exportedVariables.put("p1", "value1");
        comp.exportedVariables.put("p2", "");
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)comp).size());
        inst.setComponent(comp);
        iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_VARIABLE_VALUE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        inst.overriddenExports.put("inst.value1", "whatever");
        inst.overriddenExports.put("comp.p2", "a default value");
        iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        inst.overriddenExports.put("something else", "");
        iterator = RuntimeModelValidator.validate((Instance)inst).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_VARIABLE_VALUE, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testInstances() {
        ArrayList<Instance> instances = new ArrayList<Instance>();
        for (int i = 0; i < 10; ++i) {
            Instance inst = new Instance("inst-" + i).component(new Component("comp"));
            instances.add(inst);
        }
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate(instances).size());
    }

    @Test
    public void testApplication() {
        ApplicationTemplate app = new ApplicationTemplate();
        Iterator iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_QUALIFIER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GRAPHS, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.setName("My Application #!");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_QUALIFIER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GRAPHS, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.setQualifier("Snapshot Build #2401");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GRAPHS, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.setGraphs(new Graphs());
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_NO_ROOT_COMPONENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        Component comp = new Component("root").installerName("target");
        app.getGraphs().getRootComponents().add(comp);
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((ApplicationTemplate)app).size());
        app.externalExports.put("comp.!nvalid", "ko");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_EXPORT_PREFIX, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_EXTERNAL_EXPORT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.externalExports.remove("comp.!nvalid");
        app.externalExports.put("comp.valid", "!invalid");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_EXPORT_PREFIX, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_EXTERNAL_EXPORT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.externalExports.put("comp.valid", "ok");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_EXPORT_PREFIX, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_EXTERNAL_EXPORT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.externalExports.remove("comp.valid");
        comp.exportedVariables.put("test", "default");
        app.externalExports.put("root.test", "alias");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_EXPORT_PREFIX, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.setExternalExportsPrefix("inval!d prefix");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_APPLICATION_EXPORT_PREFIX, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        app.setExternalExportsPrefix("prefix");
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((ApplicationTemplate)app).size());
        comp.exportedVariables.put("test-bis", "default");
        app.externalExports.put("root.test-bis", "alias");
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_ALREADY_DEFINED_EXTERNAL_EXPORT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testApplicationDescriptor() {
        ApplicationTemplateDescriptor desc = new ApplicationTemplateDescriptor();
        Iterator iterator = RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_QUALIFIER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_DSL_ID, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GEP, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        desc.setName("My Application #!");
        iterator = RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_QUALIFIER, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_DSL_ID, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GEP, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        desc.setQualifier("Snapshot Build #2401");
        iterator = RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_DSL_ID, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GEP, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        desc.setDslId("roboconf-1.0");
        iterator = RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_APPLICATION_GEP, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        desc.setGraphEntryPoint("graph.graph");
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).size());
        desc.invalidExternalExports.add("oops");
        iterator = RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).iterator();
        Assert.assertEquals((Object)ErrorCode.PROJ_INVALID_EXTERNAL_EXPORTS, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        desc.invalidExternalExports.clear();
        desc.externalExports.put("comp.valid", "ok");
        desc.externalExports.put("comp.!nvalid", "ko");
        iterator = RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        desc.externalExports.remove("comp.!nvalid");
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).size());
        desc.externalExports.put("comp.valid", "!nvalid");
        iterator = RuntimeModelValidator.validate((ApplicationTemplateDescriptor)desc).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testSelfImports() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/component-self-imports.graph");
        FileDefinition def = ParsingModelIo.readConfigurationFile((File)f, (boolean)true);
        Assert.assertEquals((int)0, (int)def.getParsingErrors().size());
        Collection validationErrors = ParsingModelValidator.validate((FileDefinition)def);
        Assert.assertEquals((int)0, (int)validationErrors.size());
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Iterator iterator = RuntimeModelValidator.validate((Graphs)graphs).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_COMPONENT_IMPORTS_EXPORTS, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertEquals((Object)ErrorCode.RM_COMPONENT_IMPORTS_EXPORTS, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testExportedVariableNames() throws Exception {
        Component component = new Component("my-component").installerName("target");
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)component).size());
        component.exportedVariables.put("ip", null);
        Iterator iterator = RuntimeModelValidator.validate((Component)component).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        component.exportedVariables.clear();
        component.exportedVariables.put("my-component.ip", null);
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)component).size());
        component.exportedVariables.put("ip", null);
        iterator = RuntimeModelValidator.validate((Component)component).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        component.exportedVariables.clear();
        component.exportedVariables.put("my-component.ip", null);
        component.exportedVariables.put("another-prefix.ip", null);
        iterator = RuntimeModelValidator.validate((Component)component).iterator();
        Assert.assertFalse((boolean)iterator.hasNext());
        component.associateFacet(new Facet("my-facet"));
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((Component)component).size());
        component.exportedVariables.clear();
        component.exportedVariables.put("my-component.@", "yo");
        iterator = RuntimeModelValidator.validate((Component)component).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        component.exportedVariables.clear();
        component.exportedVariables.put("my-component.inva!id", null);
        iterator = RuntimeModelValidator.validate((Component)component).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        component.exportedVariables.clear();
        component.exportedVariables.put("", null);
        iterator = RuntimeModelValidator.validate((Component)component).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_EMPTY_VARIABLE_NAME, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testInvalidChildInstance_1() throws Exception {
        Component vmComponent1 = new Component("VM_type1").installerName("target");
        Component vmComponent2 = new Component("VM_type2").installerName("target");
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        vmComponent1.addChild((AbstractType)tomcatComponent);
        vmComponent2.addChild((AbstractType)tomcatComponent);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent1);
        graphs.getRootComponents().add(vmComponent2);
        Instance vmInstance1 = new Instance("vm1").component(vmComponent1);
        Instance vmInstance2 = new Instance("vm2").component(vmComponent1);
        InstanceHelpers.insertChild((Instance)vmInstance1, (Instance)vmInstance2);
        ApplicationTemplate app = new ApplicationTemplate("app").qualifier("snapshot").graphs(graphs);
        app.getRootInstances().add(vmInstance1);
        Iterator iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_INSTANCE_PARENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        Instance tomcatInstance = new Instance("tomcat").component(tomcatComponent);
        app.getRootInstances().clear();
        app.getRootInstances().add(tomcatInstance);
        iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_MISSING_INSTANCE_PARENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
        vmInstance1.getChildren().clear();
        InstanceHelpers.insertChild((Instance)vmInstance1, (Instance)tomcatInstance);
        app.getRootInstances().clear();
        app.getRootInstances().add(vmInstance1);
        Assert.assertEquals((int)0, (int)RuntimeModelValidator.validate((ApplicationTemplate)app).size());
    }

    @Test
    public void testInvalidChildInstance_2() throws Exception {
        Component vmComponent = new Component("VM").installerName("target");
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent);
        Instance vmInstance = new Instance("vm").component(vmComponent);
        Instance tomcatInstance = new Instance("tomcat").component(tomcatComponent);
        InstanceHelpers.insertChild((Instance)vmInstance, (Instance)tomcatInstance);
        ApplicationTemplate app = new ApplicationTemplate("app").qualifier("snapshot").graphs(graphs);
        app.getRootInstances().add(vmInstance);
        Iterator iterator = RuntimeModelValidator.validate((ApplicationTemplate)app).iterator();
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_INSTANCE_PARENT, (Object)((ModelError)iterator.next()).getErrorCode());
        Assert.assertFalse((boolean)iterator.hasNext());
    }

    @Test
    public void testTargetInstaller() throws Exception {
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(new Component("VM").installerName("target"));
        File appDir = this.folder.newFolder();
        Collection errors = RuntimeModelValidator.validate((Graphs)graphs, (File)appDir);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)((ModelError)errors.iterator().next()).getErrorCode());
        File componentDir = new File(appDir, "graph/VM");
        Assert.assertTrue((boolean)componentDir.mkdirs());
        errors = RuntimeModelValidator.validate((Graphs)graphs, (File)appDir);
        Assert.assertEquals((int)0, (int)errors.size());
        File targetPropertiesFile = new File(componentDir, "target.properties");
        Assert.assertTrue((boolean)targetPropertiesFile.createNewFile());
        errors = RuntimeModelValidator.validate((Graphs)graphs, (File)appDir);
        Assert.assertEquals((int)0, (int)errors.size());
    }

    @Test
    public void testAnalyzeOverriddenExport() {
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("Tomcat.ip", null);
        tomcatComponent.exportedVariables.put("Tomcat.port", "8080");
        Instance tomcatInstance = new Instance("tomcat").component(tomcatComponent);
        Collection errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)0, (int)errors.size());
        tomcatInstance.overriddenExports.put("Tomcat.port", "whatever");
        errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)0, (int)errors.size());
        tomcatInstance.overriddenExports.put("oops", "whatever");
        errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, (Object)((ModelError)errors.iterator().next()).getErrorCode());
        tomcatInstance.overriddenExports.remove("oops");
        tomcatInstance.overriddenExports.put("port", "whatever");
        errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)0, (int)errors.size());
        tomcatInstance.overriddenExports.remove("Tomcat.port");
        errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)0, (int)errors.size());
        Facet facet = new Facet("facet");
        facet.exportedVariables.put("ip", null);
        tomcatComponent.associateFacet(facet);
        errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)0, (int)errors.size());
        tomcatInstance.overriddenExports.put("ip", "localhost");
        errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.RM_AMBIGUOUS_OVERRIDING, (Object)((ModelError)errors.iterator().next()).getErrorCode());
        tomcatInstance.overriddenExports.remove("ip");
        tomcatInstance.overriddenExports.put("facet.ip", "localhost");
        errors = RuntimeModelValidator.validate((Instance)tomcatInstance);
        Assert.assertEquals((int)0, (int)errors.size());
    }

    @Test
    public void testOverriddenExports() throws Exception {
        Component vmComponent = new Component("VM").installerName("target");
        Component tomcatComponent = new Component("Tomcat").installerName("puppet");
        tomcatComponent.exportedVariables.put("Tomcat.ip", null);
        tomcatComponent.exportedVariables.put("Tomcat.port", "8080");
        vmComponent.addChild((AbstractType)tomcatComponent);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(vmComponent);
        File f = TestUtils.findTestFile("/configurations/valid/instance-overridden-exports.instances");
        FromInstanceDefinition fromDef = new FromInstanceDefinition(f.getParentFile());
        Collection rootInstances = fromDef.buildInstances(graphs, f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Assert.assertEquals((int)1, (int)rootInstances.size());
        Instance rootInstance = (Instance)rootInstances.iterator().next();
        List instances = InstanceHelpers.buildHierarchicalList((Instance)rootInstance);
        Assert.assertEquals((int)2, (int)instances.size());
        Collection errors = RuntimeModelValidator.validate((Collection)instances);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.RM_MAGIC_INSTANCE_VARIABLE, (Object)((ModelError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testCycleInFacet() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/cycle-in-facet.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Collection errors = RuntimeModelValidator.validate((Graphs)graphs);
        Assert.assertEquals((int)3, (int)errors.size());
        HashSet<String> messages = new HashSet<String>();
        for (ModelError error : errors) {
            Assert.assertEquals((Object)ErrorCode.RM_CYCLE_IN_FACETS_INHERITANCE, (Object)error.getErrorCode());
            messages.add(error.getDetails());
        }
        Assert.assertEquals((int)3, (int)messages.size());
    }

    @Test
    public void testWildcardImports() throws Exception {
        File f = TestUtils.findTestFile("/configurations/valid/graph-with-wildcards.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Collection errors = RuntimeModelValidator.validate((Graphs)graphs);
        Assert.assertEquals((int)0, (int)errors.size());
        Component component = ComponentHelpers.findComponent((Graphs)graphs, (String)"app");
        Assert.assertNotNull((Object)component);
        Map exports = ComponentHelpers.findAllExportedVariables((Component)component);
        Assert.assertEquals((int)2, (int)exports.size());
        Assert.assertNull(exports.get("app.ip"));
        Assert.assertEquals((String)"toto", (String)((String)exports.get("app.port")));
        Map imports = ComponentHelpers.findAllImportedVariables((Component)component);
        Assert.assertEquals((int)2, (int)imports.size());
        Assert.assertNotNull(imports.get("database.*"));
        Assert.assertFalse((boolean)((ImportedVariable)imports.get("database.*")).isOptional());
        Assert.assertNotNull(imports.get("f-messaging-2.*"));
        Assert.assertFalse((boolean)((ImportedVariable)imports.get("f-messaging-2.*")).isOptional());
    }

    @Test
    public void testWildcardImports_withErrors() throws Exception {
        File f = TestUtils.findTestFile("/configurations/invalid/graph-with-wildcards-and-errors.graph");
        FromGraphDefinition fromDef = new FromGraphDefinition(f.getParentFile());
        Graphs graphs = fromDef.buildGraphs(f);
        Assert.assertEquals((int)0, (int)fromDef.getErrors().size());
        Collection errors = RuntimeModelValidator.validate((Graphs)graphs);
        Assert.assertEquals((int)1, (int)errors.size());
        ModelError error = (ModelError)errors.iterator().next();
        Assert.assertEquals((Object)ErrorCode.RM_UNRESOLVABLE_VARIABLE, (Object)error.getErrorCode());
        Assert.assertEquals((Object)new Component("app"), (Object)error.getModelObject());
        Assert.assertTrue((boolean)error.getDetails().contains("messaging.*"));
    }
}

