/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import java.util.HashSet;
import junit.framework.Assert;
import net.roboconf.core.internal.tests.TestApplicationTemplate;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import org.junit.Test;

public class ApplicationTest {
    @Test
    public void testEqualsAndHashCode_1() {
        Application app1 = new Application((ApplicationTemplate)new TestApplicationTemplate());
        app1.setName("app");
        Application app2 = new Application(new ApplicationTemplate());
        app2.setName("app");
        HashSet<Application> set = new HashSet<Application>(2);
        set.add(app1);
        set.add(app2);
        Assert.assertEquals((int)1, (int)set.size());
    }

    @Test
    public void testEqualsAndHashCode_2() {
        Application app1 = new Application((ApplicationTemplate)new TestApplicationTemplate());
        app1.setName("app");
        Application app2 = new Application(app1.getTemplate());
        app2.setName("app");
        HashSet<Application> set = new HashSet<Application>(2);
        set.add(app1);
        set.add(app2);
        Assert.assertEquals((int)1, (int)set.size());
    }

    @Test
    public void testEqualsAndHashCode_3() {
        Application app1 = new Application((ApplicationTemplate)new TestApplicationTemplate());
        Application app2 = new Application("app", app1.getTemplate());
        HashSet<Application> set = new HashSet<Application>(2);
        set.add(app1);
        set.add(app2);
        Assert.assertEquals((int)2, (int)set.size());
    }

    @Test
    public void testEquals() {
        Application app = new Application("app", new ApplicationTemplate());
        Assert.assertFalse((boolean)app.equals(null));
        Assert.assertFalse((boolean)app.equals((Object)new Application(app.getTemplate())));
        Assert.assertFalse((boolean)app.equals(new Object()));
        Assert.assertEquals((Object)app, (Object)app);
        Assert.assertEquals((Object)app, (Object)new Application("app", app.getTemplate()));
        Assert.assertEquals((Object)app, (Object)new Application("app", new ApplicationTemplate("whatever")));
    }

    @Test
    public void testChain() {
        Application app = new Application(new ApplicationTemplate()).name("ins").description("desc");
        Assert.assertEquals((String)"ins", (String)app.getName());
        Assert.assertEquals((String)"desc", (String)app.getDescription());
    }

    @Test
    public void testAssociations() {
        ApplicationTemplate tpl = new ApplicationTemplate();
        Assert.assertEquals((int)0, (int)tpl.getAssociatedApplications().size());
        Application app1 = new Application("1", tpl);
        Assert.assertEquals((int)1, (int)tpl.getAssociatedApplications().size());
        Application app2 = new Application("2", tpl);
        Assert.assertEquals((int)2, (int)tpl.getAssociatedApplications().size());
        app1.removeAssociationWithTemplate();
        Assert.assertEquals((int)1, (int)tpl.getAssociatedApplications().size());
        app2.removeAssociationWithTemplate();
        Assert.assertEquals((int)0, (int)tpl.getAssociatedApplications().size());
        app1.removeAssociationWithTemplate();
        Application app3 = new Application(null);
        app3.removeAssociationWithTemplate();
    }

    @Test
    public void checkInstanceReplication() {
        TestApplicationTemplate tpl = new TestApplicationTemplate();
        Application app = new Application((ApplicationTemplate)tpl);
        Assert.assertEquals((int)5, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Assert.assertEquals((int)5, (int)InstanceHelpers.getAllInstances((AbstractApplication)tpl).size());
        for (Instance inst : InstanceHelpers.getAllInstances((AbstractApplication)tpl)) {
            String instancePath = InstanceHelpers.computeInstancePath((Instance)inst);
            Instance copiedInstance = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)instancePath);
            Assert.assertNotNull((Object)copiedInstance);
            Assert.assertEquals((String)inst.getName(), (String)copiedInstance.getName());
            Assert.assertEquals((Object)inst.getComponent(), (Object)copiedInstance.getComponent());
            Assert.assertEquals((Object)inst.getImports(), (Object)copiedInstance.getImports());
            Assert.assertEquals((Object)inst.getParent(), (Object)copiedInstance.getParent());
            Assert.assertEquals((int)inst.getChildren().size(), (int)copiedInstance.getChildren().size());
            Assert.assertEquals((Object)inst.getChildren(), (Object)copiedInstance.getChildren());
            Assert.assertEquals((Object)inst.channels, (Object)copiedInstance.channels);
            Assert.assertEquals((Object)inst.overriddenExports, (Object)copiedInstance.overriddenExports);
            Assert.assertEquals((Object)inst.data, (Object)copiedInstance.data);
            Assert.assertFalse((inst == copiedInstance ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExternalExports() {
        TestApplicationTemplate tpl = new TestApplicationTemplate();
        Application app = new Application((ApplicationTemplate)tpl);
        Assert.assertEquals((Object)app.getExternalExports(), (Object)tpl.externalExports);
        tpl.externalExports.put("something", "here");
        Assert.assertEquals((Object)app.getExternalExports(), (Object)tpl.externalExports);
    }
}

