/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.beans;

import junit.framework.Assert;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import org.junit.Test;

public class ComponentTest {
    @Test
    public void testChain() {
        Component c = new Component("c");
        Component comp = new Component().name("ins").installerName("my-installer");
        comp.extendComponent(c);
        Assert.assertEquals((String)"ins", (String)comp.getName());
        Assert.assertEquals((String)"my-installer", (String)comp.getInstallerName());
        Assert.assertEquals((Object)c, (Object)comp.getExtendedComponent());
    }

    @Test
    public void testHashCode() {
        Component comp = new Component();
        Assert.assertTrue((comp.hashCode() > 0 ? 1 : 0) != 0);
        comp.setName("comp");
        Assert.assertTrue((comp.hashCode() > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        Component comp = new Component("comp");
        Assert.assertFalse((boolean)comp.equals(null));
        Assert.assertFalse((boolean)comp.equals((Object)new Component("comp2")));
        Assert.assertFalse((boolean)comp.equals((Object)new Facet("comp")));
        Assert.assertEquals((Object)comp, (Object)comp);
        Assert.assertEquals((Object)comp, (Object)new Component("comp"));
    }

    @Test
    public void testInsertChild() {
        Component component_1 = new Component("comp 1");
        Component component_1_1 = new Component("comp 11");
        Assert.assertEquals((int)0, (int)component_1.getAncestors().size());
        Assert.assertEquals((int)0, (int)component_1.getChildren().size());
        Assert.assertEquals((int)0, (int)component_1_1.getAncestors().size());
        Assert.assertEquals((int)0, (int)component_1_1.getChildren().size());
        component_1.addChild((AbstractType)component_1_1);
        Assert.assertEquals((int)0, (int)component_1.getAncestors().size());
        Assert.assertEquals((int)1, (int)component_1.getChildren().size());
        Assert.assertEquals((int)1, (int)component_1_1.getAncestors().size());
        Assert.assertEquals((int)0, (int)component_1_1.getChildren().size());
        Assert.assertEquals((Object)component_1_1, component_1.getChildren().iterator().next());
        Assert.assertEquals((Object)component_1, component_1_1.getAncestors().iterator().next());
        Assert.assertNotSame((Object)component_1, (Object)component_1_1);
    }

    @Test
    public void testAssociateFacet() {
        Component component = new Component("comp");
        Facet facet = new Facet("facet");
        Assert.assertEquals((int)0, (int)component.getFacets().size());
        Assert.assertEquals((int)0, (int)facet.getAssociatedComponents().size());
        component.associateFacet(facet);
        Assert.assertEquals((int)1, (int)component.getFacets().size());
        Assert.assertEquals((int)1, (int)facet.getAssociatedComponents().size());
        Assert.assertEquals((Object)facet, component.getFacets().iterator().next());
        Assert.assertEquals((Object)component, facet.getAssociatedComponents().iterator().next());
    }
}

