/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.comparators;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Assert;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.comparators.AbstractTypeComparator;
import org.junit.Test;

public class AbstractTypeComparatorTest {
    @Test
    public void testComponentsSorting() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(new Component("z"));
        components.add(new Component("m"));
        components.add(new Component("a"));
        components.add(new Component("b"));
        Assert.assertEquals((String)"z", (String)((Component)components.get(0)).getName());
        Collections.sort(components, new AbstractTypeComparator());
        Assert.assertEquals((String)"a", (String)((Component)components.get(0)).getName());
        Assert.assertEquals((String)"b", (String)((Component)components.get(1)).getName());
        Assert.assertEquals((String)"m", (String)((Component)components.get(2)).getName());
        Assert.assertEquals((String)"z", (String)((Component)components.get(3)).getName());
    }

    @Test
    public void testFacetsSorting() {
        ArrayList<Facet> facets = new ArrayList<Facet>();
        facets.add(new Facet("z"));
        facets.add(new Facet("m"));
        facets.add(new Facet("a"));
        facets.add(new Facet("b"));
        Assert.assertEquals((String)"z", (String)((Facet)facets.get(0)).getName());
        Collections.sort(facets, new AbstractTypeComparator());
        Assert.assertEquals((String)"a", (String)((Facet)facets.get(0)).getName());
        Assert.assertEquals((String)"b", (String)((Facet)facets.get(1)).getName());
        Assert.assertEquals((String)"m", (String)((Facet)facets.get(2)).getName());
        Assert.assertEquals((String)"z", (String)((Facet)facets.get(3)).getName());
    }

    @Test
    public void testMixedSorting() {
        ArrayList<Object> types = new ArrayList<Object>();
        types.add(new Facet("z"));
        types.add(new Component("m"));
        types.add(new Component("a"));
        types.add(new Facet("b"));
        Assert.assertEquals((String)"z", (String)((AbstractType)types.get(0)).getName());
        Collections.sort(types, new AbstractTypeComparator());
        Assert.assertEquals((String)"a", (String)((AbstractType)types.get(0)).getName());
        Assert.assertEquals((String)"b", (String)((AbstractType)types.get(1)).getName());
        Assert.assertEquals((String)"m", (String)((AbstractType)types.get(2)).getName());
        Assert.assertEquals((String)"z", (String)((AbstractType)types.get(3)).getName());
    }

    @Test
    public void testSortingWithNull() {
        ArrayList<Object> types = new ArrayList<Object>();
        types.add(new Facet("z"));
        types.add(null);
        types.add(new Component("m"));
        Assert.assertEquals((String)"z", (String)((AbstractType)types.get(0)).getName());
        Collections.sort(types, new AbstractTypeComparator());
        Assert.assertEquals((String)"m", (String)((AbstractType)types.get(0)).getName());
        Assert.assertEquals((String)"z", (String)((AbstractType)types.get(1)).getName());
        Assert.assertNull(types.get(2));
    }
}

