/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.comparators;

import java.util.ArrayList;
import java.util.Collections;
import junit.framework.Assert;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.comparators.InstanceComparator;
import net.roboconf.core.model.helpers.InstanceHelpers;
import org.junit.Test;

public class InstanceComparatorTest {
    @Test
    public void testRootInstances() {
        Instance i1 = new Instance("root1");
        Instance i2 = new Instance("root2");
        Instance i3 = new Instance("1");
        Instance i4 = new Instance("_1");
        Instance i5 = new Instance("root11");
        ArrayList<Instance> instances = new ArrayList<Instance>();
        instances.add(i1);
        instances.add(i2);
        instances.add(i3);
        instances.add(i4);
        instances.add(i5);
        Collections.sort(instances, new InstanceComparator());
        Assert.assertEquals((Object)i3, instances.get(0));
        Assert.assertEquals((Object)i4, instances.get(1));
        Assert.assertEquals((Object)i1, instances.get(2));
        Assert.assertEquals((Object)i5, instances.get(3));
        Assert.assertEquals((Object)i2, instances.get(4));
    }

    @Test
    public void testOneRootInstanceWithChildren() {
        Instance i1 = new Instance("root1");
        Instance i11 = new Instance("child");
        Instance i12 = new Instance("child2");
        Instance i2 = new Instance("1");
        Instance i3 = new Instance("root11");
        InstanceHelpers.insertChild((Instance)i1, (Instance)i12);
        InstanceHelpers.insertChild((Instance)i1, (Instance)i11);
        ArrayList<Instance> instances = new ArrayList<Instance>();
        instances.add(i1);
        instances.add(i2);
        instances.add(i12);
        instances.add(i3);
        instances.add(i11);
        Collections.sort(instances, new InstanceComparator());
        Assert.assertEquals((Object)i2, instances.get(0));
        Assert.assertEquals((Object)i1, instances.get(1));
        Assert.assertEquals((Object)i11, instances.get(2));
        Assert.assertEquals((Object)i12, instances.get(3));
        Assert.assertEquals((Object)i3, instances.get(4));
    }

    @Test
    public void testOnlyVmHavedifferentNames() {
        Instance i1 = new Instance("vmec2tomcatrubis1");
        Instance i2 = new Instance("vmec2tomcatrubis2");
        Instance i10 = new Instance("vmec2tomcatrubis10");
        Instance i11 = new Instance("vmec2tomcatrubis11");
        Instance i1_1 = new Instance("tomcat");
        Instance i2_1 = new Instance("tomcat");
        Instance i10_1 = new Instance("tomcat");
        Instance i11_1 = new Instance("tomcat");
        Instance i11_2 = new Instance("tomcat2");
        Instance i11_2_1 = new Instance("app");
        InstanceHelpers.insertChild((Instance)i1, (Instance)i1_1);
        InstanceHelpers.insertChild((Instance)i2, (Instance)i2_1);
        InstanceHelpers.insertChild((Instance)i10, (Instance)i10_1);
        InstanceHelpers.insertChild((Instance)i11, (Instance)i11_1);
        InstanceHelpers.insertChild((Instance)i11, (Instance)i11_2);
        InstanceHelpers.insertChild((Instance)i11_2, (Instance)i11_2_1);
        ArrayList<Instance> instances = new ArrayList<Instance>();
        instances.add(i1);
        instances.add(i2);
        instances.add(i10);
        instances.add(i11);
        instances.add(i1_1);
        instances.add(i2_1);
        instances.add(i10_1);
        instances.add(i11_1);
        instances.add(i11_2);
        instances.add(i11_2_1);
        Collections.sort(instances, new InstanceComparator());
        Assert.assertEquals((Object)i1, instances.get(0));
        Assert.assertEquals((Object)i1_1, instances.get(1));
        Assert.assertEquals((Object)i10, instances.get(2));
        Assert.assertEquals((Object)i10_1, instances.get(3));
        Assert.assertEquals((Object)i11, instances.get(4));
        Assert.assertEquals((Object)i11_1, instances.get(5));
        Assert.assertEquals((Object)i11_2, instances.get(6));
        Assert.assertEquals((Object)i11_2_1, instances.get(7));
        Assert.assertEquals((Object)i2, instances.get(8));
        Assert.assertEquals((Object)i2_1, instances.get(9));
    }

    @Test
    public void testWithInvalidInstancePath() {
        Instance inst1 = new Instance("inst");
        Instance inst2 = new Instance();
        Instance inst3 = new Instance();
        Instance inst4 = new Instance("instance");
        ArrayList<Instance> instances = new ArrayList<Instance>();
        instances.add(inst1);
        instances.add(inst2);
        instances.add(inst3);
        instances.add(inst4);
        Collections.sort(instances, new InstanceComparator());
        Assert.assertEquals((Object)inst2, instances.get(0));
        Assert.assertEquals((Object)inst3, instances.get(1));
        Assert.assertEquals((Object)inst1, instances.get(2));
        Assert.assertEquals((Object)inst4, instances.get(3));
        instances.clear();
        instances.add(inst2);
        instances.add(inst1);
        instances.add(inst3);
        instances.add(inst4);
        Collections.sort(instances, new InstanceComparator());
        Assert.assertEquals((Object)inst2, instances.get(0));
        Assert.assertEquals((Object)inst3, instances.get(1));
        Assert.assertEquals((Object)inst1, instances.get(2));
        Assert.assertEquals((Object)inst4, instances.get(3));
    }
}

