/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.internal.tests.ComplexApplicationFactory1;
import net.roboconf.core.internal.tests.TestApplication;
import net.roboconf.core.internal.tests.TestApplicationTemplate;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.helpers.ComponentHelpers;
import org.junit.Test;

public class ComponentHelpersTest {
    @Test
    public void testFindComponent() {
        Graphs g = new Graphs();
        Assert.assertNull((Object)ComponentHelpers.findComponent((Graphs)g, (String)"c"));
        Component c1 = new Component("c1");
        g.getRootComponents().add(c1);
        Assert.assertEquals((Object)c1, (Object)ComponentHelpers.findComponent((Graphs)g, (String)"c1"));
        Component c2 = new Component("c2");
        g.getRootComponents().add(c2);
        Assert.assertEquals((Object)c2, (Object)ComponentHelpers.findComponent((Graphs)g, (String)"c2"));
        Component c21 = new Component("c21");
        c2.addChild((AbstractType)c21);
        Assert.assertEquals((Object)c21, (Object)ComponentHelpers.findComponent((Graphs)g, (String)"c21"));
        Component duplicateC1 = new Component("c1");
        g.getRootComponents().add(duplicateC1);
        Assert.assertNotNull((Object)ComponentHelpers.findComponent((Graphs)g, (String)"c1"));
        TestApplication app = new TestApplication();
        Assert.assertNotNull((Object)ComponentHelpers.findComponent((Application)app, (String)"tomcat"));
        Assert.assertNull((Object)ComponentHelpers.findComponent((Application)app, (String)"tommy"));
    }

    @Test
    public void testFindComponentFrom() {
        TestApplicationTemplate app = new TestApplicationTemplate();
        Component comp = app.getTomcatVm().getComponent();
        Assert.assertNull((Object)ComponentHelpers.findComponentFrom((Component)comp, (String)"inexisting"));
        Assert.assertNull((Object)ComponentHelpers.findComponentFrom(null, (String)"inexisting"));
        Assert.assertEquals((Object)comp, (Object)ComponentHelpers.findComponentFrom((Component)comp, (String)comp.getName()));
        Component targetComp = app.getTomcat().getComponent();
        Assert.assertEquals((Object)targetComp, (Object)ComponentHelpers.findComponentFrom((Component)comp, (String)targetComp.getName()));
        targetComp = app.getWar().getComponent();
        Assert.assertEquals((Object)targetComp, (Object)ComponentHelpers.findComponentFrom((Component)comp, (String)targetComp.getName()));
    }

    @Test
    public void testSearchForLoop() {
        Component c1 = new Component("c1");
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c1));
        Component c11 = new Component("c11");
        c1.addChild((AbstractType)c11);
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c1));
        Component c12 = new Component("c1");
        c1.addChild((AbstractType)c12);
        Assert.assertEquals((String)"c1 -> c1", (String)ComponentHelpers.searchForLoop((Component)c1));
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c11));
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c12));
        c12.setName("c12");
        Component c121 = new Component("c1");
        c12.addChild((AbstractType)c121);
        Assert.assertEquals((String)"c1 -> c12 -> c1", (String)ComponentHelpers.searchForLoop((Component)c1));
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c11));
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c12));
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c121));
        c121.setName("c121");
        c121.addChild((AbstractType)c1);
        Assert.assertEquals((String)"c1 -> c12 -> c121 -> c1", (String)ComponentHelpers.searchForLoop((Component)c1));
        Assert.assertEquals((String)"c12 -> c121 -> c1 -> c12", (String)ComponentHelpers.searchForLoop((Component)c12));
        Assert.assertEquals((String)"c121 -> c1 -> c12 -> c121", (String)ComponentHelpers.searchForLoop((Component)c121));
        Assert.assertNull((Object)ComponentHelpers.searchForLoop((Component)c11));
    }

    @Test
    public void testFindAllComponents_simple() {
        ApplicationTemplate app = new ApplicationTemplate();
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        Graphs graphs = new Graphs();
        app.setGraphs(graphs);
        Component comp1 = new Component("comp1");
        graphs.getRootComponents().add(comp1);
        Assert.assertEquals((int)1, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        comp1.addChild((AbstractType)new Component("comp-2"));
        Assert.assertEquals((int)2, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        Component comp3 = new Component("comp_3");
        graphs.getRootComponents().add(comp3);
        comp3.addChild((AbstractType)new Component("comp-2"));
        Assert.assertEquals((int)3, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
    }

    @Test
    public void testFindAllComponents_complex1() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Assert.assertEquals((int)10, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
    }

    @Test
    public void testFindAllComponents_appInstance() {
        ApplicationTemplate tpl = ComplexApplicationFactory1.newApplication();
        Application app = new Application(tpl);
        Assert.assertEquals((int)10, (int)ComponentHelpers.findAllComponents((Application)app).size());
        app = new Application(null);
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllComponents((Application)app).size());
    }

    @Test
    public void testFindAllComponents_extended() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        app.getGraphs().getRootComponents().clear();
        Component root1 = new Component("root1").installerName("target");
        Component root2 = new Component("root2");
        Component root3 = new Component("root3");
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        app.getGraphs().getRootComponents().add(root1);
        Assert.assertEquals((int)1, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        root2.extendComponent(root1);
        Assert.assertEquals((int)2, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        root3.extendComponent(root2);
        Assert.assertEquals((int)3, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        app.getGraphs().getRootComponents().add(root2);
        app.getGraphs().getRootComponents().add(root3);
        Assert.assertEquals((int)3, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
        Component childComponent = new Component("child").installerName("script");
        root3.addChild((AbstractType)childComponent);
        Assert.assertEquals((int)4, (int)ComponentHelpers.findAllComponents((ApplicationTemplate)app).size());
    }

    @Test
    public void testFindAllChildren_complex1() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component root1 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root1");
        Assert.assertNotNull((Object)root1);
        Assert.assertEquals((int)1, (int)root1.getChildren().size());
        Collection children = ComponentHelpers.findAllChildren((Component)root1);
        Assert.assertEquals((int)5, (int)children.size());
        Assert.assertTrue((boolean)children.contains(new Component("glassfish")));
        Assert.assertTrue((boolean)children.contains(new Component("tomcat")));
        Assert.assertTrue((boolean)children.contains(new Component("tomcat8")));
        Assert.assertTrue((boolean)children.contains(new Component("MySql")));
        Assert.assertTrue((boolean)children.contains(new Component("MongoDB")));
        Component root2 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root2");
        Assert.assertNotNull((Object)root2);
        Assert.assertEquals((int)0, (int)root2.getChildren().size());
        children = ComponentHelpers.findAllChildren((Component)root2);
        Assert.assertEquals((int)4, (int)children.size());
        Assert.assertTrue((boolean)children.contains(new Component("glassfish")));
        Assert.assertTrue((boolean)children.contains(new Component("tomcat")));
        Assert.assertTrue((boolean)children.contains(new Component("tomcat8")));
        Assert.assertTrue((boolean)children.contains(new Component("MySql")));
        Component c = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"glassfish");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((int)0, (int)c.getChildren().size());
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllChildren((Component)c).size());
        c = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"MongoDB");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((int)0, (int)c.getChildren().size());
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllChildren((Component)c).size());
        c = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat8");
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((int)1, (int)c.getChildren().size());
        Assert.assertEquals((String)"app3", (String)((AbstractType)c.getChildren().iterator().next()).getName());
        ArrayList lastChildren = new ArrayList();
        lastChildren.addAll(ComponentHelpers.findAllChildren((Component)c));
        Assert.assertEquals((int)3, (int)lastChildren.size());
        Assert.assertEquals((String)"app1", (String)((Component)lastChildren.get(0)).getName());
        Assert.assertEquals((String)"app2", (String)((Component)lastChildren.get(1)).getName());
        Assert.assertEquals((String)"app3", (String)((Component)lastChildren.get(2)).getName());
    }

    @Test
    public void testFindAllChildren_testApp() {
        TestApplicationTemplate app = new TestApplicationTemplate();
        Collection children = ComponentHelpers.findAllChildren((Component)app.getTomcat().getComponent());
        Assert.assertEquals((int)1, (int)children.size());
        Assert.assertTrue((boolean)children.contains(app.getWar().getComponent()));
        children = ComponentHelpers.findAllChildren((Component)app.getTomcatVm().getComponent());
        Assert.assertEquals((int)2, (int)children.size());
        Assert.assertTrue((boolean)children.contains(app.getTomcat().getComponent()));
        Assert.assertTrue((boolean)children.contains(app.getMySql().getComponent()));
        children = ComponentHelpers.findAllChildren((Component)app.getMySqlVm().getComponent());
        Assert.assertEquals((int)2, (int)children.size());
        Assert.assertTrue((boolean)children.contains(app.getTomcat().getComponent()));
        Assert.assertTrue((boolean)children.contains(app.getMySql().getComponent()));
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllChildren((Component)app.getMySql().getComponent()).size());
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllChildren((Component)app.getWar().getComponent()).size());
    }

    @Test
    public void testFixVariableName() {
        Component comp = new Component("coMp");
        Assert.assertEquals((String)"coMp.ip", (String)ComponentHelpers.fixVariableName((AbstractType)comp, (String)"ip"));
        Assert.assertEquals((String)"coMp.ip", (String)ComponentHelpers.fixVariableName((AbstractType)comp, (String)"coMp.ip"));
        Facet facet = new Facet("f");
        Assert.assertEquals((String)"f.port", (String)ComponentHelpers.fixVariableName((AbstractType)facet, (String)"port"));
        Assert.assertEquals((String)"f.ip", (String)ComponentHelpers.fixVariableName((AbstractType)facet, (String)"f.ip"));
    }

    @Test
    public void testFindFacets() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component root1 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root1");
        Assert.assertNotNull((Object)root1);
        Assert.assertEquals((int)1, (int)root1.getFacets().size());
        Facet vm = (Facet)root1.getFacets().iterator().next();
        Assert.assertEquals((String)"VM", (String)vm.getName());
        Assert.assertEquals((int)1, (int)vm.getChildren().size());
        Facet deployable = (Facet)vm.getChildren().iterator().next();
        Assert.assertEquals((String)"deployable", (String)deployable.getName());
        Collection facets = ComponentHelpers.findAllExtendingFacets((Facet)deployable);
        Assert.assertEquals((int)4, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("Database")));
        Assert.assertTrue((boolean)facets.contains(new Facet("JEE")));
        Assert.assertTrue((boolean)facets.contains(new Facet("Storage")));
        Assert.assertTrue((boolean)facets.contains(new Facet("Web")));
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllExtendingFacets((Facet)vm).size());
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllExtendedFacets((Facet)vm).size());
        Facet web = this.findFacetByName(facets, "Web");
        Assert.assertNotNull((Object)web);
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllExtendingFacets((Facet)web).size());
        Facet db = this.findFacetByName(facets, "Database");
        Assert.assertNotNull((Object)db);
        Facet storage = this.findFacetByName(facets, "Storage");
        Assert.assertNotNull((Object)storage);
        facets = ComponentHelpers.findAllExtendingFacets((Facet)db);
        Assert.assertEquals((int)1, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("Storage")));
        facets = ComponentHelpers.findAllExtendedFacets((Facet)db);
        Assert.assertEquals((int)1, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("deployable")));
        facets = ComponentHelpers.findAllExtendingFacets((Facet)storage);
        Assert.assertEquals((int)0, (int)facets.size());
        facets = ComponentHelpers.findAllExtendedFacets((Facet)storage);
        Assert.assertEquals((int)2, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("deployable")));
        Assert.assertTrue((boolean)facets.contains(new Facet("Database")));
    }

    @Test
    public void testFindAllFacets() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component root1 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root1");
        Assert.assertNotNull((Object)root1);
        Collection facets = ComponentHelpers.findAllFacets((Component)root1);
        Assert.assertEquals((int)1, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("VM")));
        Component mongoDb = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"MongoDB");
        Assert.assertNotNull((Object)mongoDb);
        facets = ComponentHelpers.findAllFacets((Component)mongoDb);
        Assert.assertEquals((int)0, (int)facets.size());
        Component glassfish = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"glassfish");
        Assert.assertNotNull((Object)glassfish);
        facets = ComponentHelpers.findAllFacets((Component)glassfish);
        Assert.assertEquals((int)3, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("JEE")));
        Assert.assertTrue((boolean)facets.contains(new Facet("Web")));
        Assert.assertTrue((boolean)facets.contains(new Facet("deployable")));
        Component tomcat = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat");
        Assert.assertNotNull((Object)tomcat);
        facets = ComponentHelpers.findAllFacets((Component)tomcat);
        Assert.assertEquals((int)2, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("Web")));
        Assert.assertTrue((boolean)facets.contains(new Facet("deployable")));
        Component tomcat8 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat8");
        Assert.assertNotNull((Object)tomcat8);
        facets = ComponentHelpers.findAllFacets((Component)tomcat8);
        Assert.assertEquals((int)2, (int)facets.size());
        Assert.assertTrue((boolean)facets.contains(new Facet("Web")));
        Assert.assertTrue((boolean)facets.contains(new Facet("deployable")));
    }

    @Test
    public void testFindAllExtendedComponents_complex1() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component tomcat = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat");
        Assert.assertNotNull((Object)tomcat);
        List extended = ComponentHelpers.findAllExtendedComponents((Component)tomcat);
        Assert.assertEquals((int)1, (int)extended.size());
        Assert.assertTrue((boolean)extended.contains(tomcat));
        Component tomcat8 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat8");
        Assert.assertNotNull((Object)tomcat8);
        extended = ComponentHelpers.findAllExtendedComponents((Component)tomcat8);
        Assert.assertEquals((int)2, (int)extended.size());
        Assert.assertTrue((boolean)extended.contains(tomcat));
        Assert.assertTrue((boolean)extended.contains(tomcat8));
    }

    @Test
    public void testFindAllExtendedComponents_cycle() {
        Component c1 = new Component("c1");
        Component c2 = new Component("c2");
        Component c3 = new Component("c3");
        c3.extendComponent(c2);
        c2.extendComponent(c1);
        List extended = ComponentHelpers.findAllExtendedComponents((Component)c1);
        Assert.assertEquals((int)1, (int)extended.size());
        extended = ComponentHelpers.findAllExtendedComponents((Component)c2);
        Assert.assertEquals((int)2, (int)extended.size());
        Assert.assertTrue((boolean)extended.contains(c1));
        Assert.assertTrue((boolean)extended.contains(c2));
        extended = ComponentHelpers.findAllExtendedComponents((Component)c3);
        Assert.assertEquals((int)3, (int)extended.size());
        Assert.assertTrue((boolean)extended.contains(c1));
        Assert.assertTrue((boolean)extended.contains(c2));
        Assert.assertTrue((boolean)extended.contains(c3));
        c1.extendComponent(c3);
        Assert.assertEquals((int)3, (int)ComponentHelpers.findAllExtendedComponents((Component)c1).size());
        Assert.assertEquals((int)3, (int)ComponentHelpers.findAllExtendedComponents((Component)c2).size());
        Assert.assertEquals((int)3, (int)ComponentHelpers.findAllExtendedComponents((Component)c3).size());
    }

    @Test
    public void testFindAllExtendingComponents_complex1() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component tomcat8 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat8");
        Assert.assertNotNull((Object)tomcat8);
        Collection extending = ComponentHelpers.findAllExtendingComponents((Component)tomcat8);
        Assert.assertEquals((int)0, (int)extending.size());
        Component tomcat = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat");
        Assert.assertNotNull((Object)tomcat);
        extending = ComponentHelpers.findAllExtendingComponents((Component)tomcat);
        Assert.assertEquals((int)1, (int)extending.size());
        Assert.assertTrue((boolean)extending.contains(tomcat8));
    }

    @Test
    public void testFindAllExtendingComponents_cycle() {
        Component c1 = new Component("c1");
        Component c2 = new Component("c2");
        Component c3 = new Component("c3");
        c3.extendComponent(c2);
        c2.extendComponent(c1);
        Collection extending = ComponentHelpers.findAllExtendingComponents((Component)c3);
        Assert.assertEquals((int)0, (int)extending.size());
        extending = ComponentHelpers.findAllExtendingComponents((Component)c2);
        Assert.assertEquals((int)1, (int)extending.size());
        Assert.assertTrue((boolean)extending.contains(c3));
        extending = ComponentHelpers.findAllExtendingComponents((Component)c1);
        Assert.assertEquals((int)2, (int)extending.size());
        Assert.assertTrue((boolean)extending.contains(c2));
        Assert.assertTrue((boolean)extending.contains(c3));
        c1.extendComponent(c3);
        Assert.assertEquals((int)2, (int)ComponentHelpers.findAllExtendingComponents((Component)c1).size());
        Assert.assertEquals((int)2, (int)ComponentHelpers.findAllExtendingComponents((Component)c2).size());
        Assert.assertEquals((int)2, (int)ComponentHelpers.findAllExtendingComponents((Component)c3).size());
    }

    @Test
    public void testFindAllAncestors_testApp() {
        TestApplicationTemplate app = new TestApplicationTemplate();
        Collection ancestors = ComponentHelpers.findAllAncestors((Component)app.getTomcat().getComponent());
        Assert.assertEquals((int)1, (int)ancestors.size());
        Assert.assertTrue((boolean)ancestors.contains(app.getMySqlVm().getComponent()));
        Assert.assertTrue((boolean)ancestors.contains(app.getTomcatVm().getComponent()));
        ancestors = ComponentHelpers.findAllAncestors((Component)app.getMySql().getComponent());
        Assert.assertEquals((int)1, (int)ancestors.size());
        Assert.assertTrue((boolean)ancestors.contains(app.getMySqlVm().getComponent()));
        Assert.assertTrue((boolean)ancestors.contains(app.getTomcatVm().getComponent()));
        ancestors = ComponentHelpers.findAllAncestors((Component)app.getWar().getComponent());
        Assert.assertEquals((int)1, (int)ancestors.size());
        Assert.assertTrue((boolean)ancestors.contains(app.getTomcat().getComponent()));
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllAncestors((Component)app.getMySqlVm().getComponent()).size());
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllAncestors((Component)app.getTomcatVm().getComponent()).size());
    }

    @Test
    public void testFindAllAncestors_complex1() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component root1 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root1");
        Assert.assertNotNull((Object)root1);
        Collection ancestors = ComponentHelpers.findAllAncestors((Component)root1);
        Assert.assertEquals((int)0, (int)ancestors.size());
        Component root2 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root2");
        Assert.assertNotNull((Object)root2);
        ancestors = ComponentHelpers.findAllAncestors((Component)root2);
        Assert.assertEquals((int)0, (int)ancestors.size());
        Component mongoDb = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"MongoDB");
        Assert.assertNotNull((Object)mongoDb);
        ancestors = ComponentHelpers.findAllAncestors((Component)mongoDb);
        Assert.assertEquals((int)1, (int)ancestors.size());
        Assert.assertTrue((boolean)ancestors.contains(root1));
        Component glassfish = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"glassfish");
        Assert.assertNotNull((Object)glassfish);
        ancestors = ComponentHelpers.findAllAncestors((Component)glassfish);
        Assert.assertEquals((int)2, (int)ancestors.size());
        Assert.assertTrue((boolean)ancestors.contains(root1));
        Assert.assertTrue((boolean)ancestors.contains(root2));
        Component tomcat = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat");
        Assert.assertNotNull((Object)tomcat);
        ancestors = ComponentHelpers.findAllAncestors((Component)tomcat);
        Assert.assertEquals((int)2, (int)ancestors.size());
        Assert.assertTrue((boolean)ancestors.contains(root1));
        Assert.assertTrue((boolean)ancestors.contains(root2));
        Component tomcat8 = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"tomcat8");
        Assert.assertNotNull((Object)tomcat8);
        ancestors = ComponentHelpers.findAllAncestors((Component)tomcat8);
        Assert.assertEquals((int)2, (int)ancestors.size());
        Assert.assertTrue((boolean)ancestors.contains(root1));
        Assert.assertTrue((boolean)ancestors.contains(root2));
    }

    @Test
    public void testfindAllImportedVariables() {
        Component root = new Component("root");
        Component serverWithApp = new Component("server with app");
        Component serverWithAnotherApp = new Component("server with another app");
        Component db = new Component("database");
        root.addChild((AbstractType)db);
        root.addChild((AbstractType)serverWithAnotherApp);
        root.addChild((AbstractType)serverWithApp);
        serverWithApp.addImportedVariable(new ImportedVariable("database.ip", false, false));
        serverWithApp.addImportedVariable(new ImportedVariable("database.port", true, false));
        serverWithApp.exportedVariables.put("url", "something");
        serverWithAnotherApp.extendComponent(serverWithApp);
        serverWithAnotherApp.addImportedVariable(new ImportedVariable("database.port", false, false));
        serverWithAnotherApp.addImportedVariable(new ImportedVariable("whatever", false, false));
        db.exportedVariables.put("ip", null);
        db.exportedVariables.put("port", "3306");
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllImportedVariables((Component)db).size());
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllImportedVariables((Component)root).size());
        Map imports = ComponentHelpers.findAllImportedVariables((Component)serverWithApp);
        Assert.assertEquals((int)2, (int)imports.size());
        Assert.assertTrue((boolean)imports.containsKey("database.ip"));
        Assert.assertTrue((boolean)imports.containsKey("database.port"));
        Assert.assertTrue((boolean)((ImportedVariable)imports.get("database.port")).isOptional());
        Assert.assertFalse((boolean)((ImportedVariable)imports.get("database.ip")).isOptional());
        imports = ComponentHelpers.findAllImportedVariables((Component)serverWithAnotherApp);
        Assert.assertEquals((int)3, (int)imports.size());
        Assert.assertTrue((boolean)imports.containsKey("database.ip"));
        Assert.assertTrue((boolean)imports.containsKey("database.port"));
        Assert.assertTrue((boolean)imports.containsKey("whatever"));
        Assert.assertFalse((boolean)((ImportedVariable)imports.get("database.ip")).isOptional());
        Assert.assertFalse((boolean)((ImportedVariable)imports.get("database.port")).isOptional());
        Assert.assertFalse((boolean)((ImportedVariable)imports.get("whatever")).isOptional());
    }

    @Test
    public void testfindAllExportedVariables_simple() {
        Component comp = new Component("comp");
        Map exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)0, (int)exports.size());
        comp.exportedVariables.put("test", "ok");
        exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)1, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
    }

    @Test
    public void testfindAllExportedVariables_withFacet() {
        Component comp = new Component("comp");
        comp.exportedVariables.put("test", "ok");
        Facet f = new Facet("facet");
        f.exportedVariables.put("property", "value");
        comp.associateFacet(f);
        Map exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"value", (String)((String)exports.get("facet.property")));
        Assert.assertEquals((String)"value", (String)((String)exports.get("comp.property")));
        comp.exportedVariables.put("facet.property", "something different");
        exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"something different", (String)((String)exports.get("facet.property")));
        Assert.assertEquals((String)"something different", (String)((String)exports.get("comp.property")));
        comp.exportedVariables.remove("facet.property");
        comp.exportedVariables.put("property", "great");
        exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"great", (String)((String)exports.get("facet.property")));
        Assert.assertEquals((String)"great", (String)((String)exports.get("comp.property")));
        comp.exportedVariables.remove("property");
        comp.exportedVariables.put("comp.property", "ha! ha!");
        exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"value", (String)((String)exports.get("facet.property")));
        Assert.assertEquals((String)"ha! ha!", (String)((String)exports.get("comp.property")));
    }

    @Test
    public void testfindAllExportedVariables_withComponentExtension() {
        Component comp = new Component("comp");
        comp.exportedVariables.put("test", "ok");
        Component parent = new Component("parent");
        parent.exportedVariables.put("property", "value");
        comp.extendComponent(parent);
        Map exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"value", (String)((String)exports.get("parent.property")));
        Assert.assertEquals((String)"value", (String)((String)exports.get("comp.property")));
        comp.exportedVariables.put("parent.property", "something different");
        exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"something different", (String)((String)exports.get("parent.property")));
        Assert.assertEquals((String)"something different", (String)((String)exports.get("comp.property")));
        comp.exportedVariables.remove("parent.property");
        comp.exportedVariables.put("property", "great");
        exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"great", (String)((String)exports.get("parent.property")));
        Assert.assertEquals((String)"great", (String)((String)exports.get("comp.property")));
        comp.exportedVariables.remove("property");
        comp.exportedVariables.put("comp.property", "ha! ha!");
        exports = ComponentHelpers.findAllExportedVariables((Component)comp);
        Assert.assertEquals((int)3, (int)exports.size());
        Assert.assertEquals((String)"ok", (String)((String)exports.get("comp.test")));
        Assert.assertEquals((String)"value", (String)((String)exports.get("parent.property")));
        Assert.assertEquals((String)"ha! ha!", (String)((String)exports.get("comp.property")));
    }

    @Test
    public void testfindAllExportedVariables_veryComplex() {
        Component root = new Component("root");
        Component serverWithApp = new Component("server with app");
        Component serverWithAnotherApp = new Component("server with another app");
        Component db = new Component("database");
        root.addChild((AbstractType)db);
        root.addChild((AbstractType)serverWithAnotherApp);
        root.addChild((AbstractType)serverWithApp);
        serverWithAnotherApp.extendComponent(serverWithApp);
        Facet serverFacet = new Facet("server facet");
        Facet anotherServerFacet = new Facet("another server facet");
        anotherServerFacet.extendFacet(serverFacet);
        serverFacet.exportedVariables.put("url-suffix", "some/path");
        serverWithApp.associateFacet(anotherServerFacet);
        serverWithApp.exportedVariables.put("ip", null);
        serverWithApp.exportedVariables.put(serverWithApp.getName() + ".port", "8080");
        serverWithApp.exportedVariables.put("env", "test");
        serverWithAnotherApp.exportedVariables.put(serverFacet.getName() + ".url-suffix", "another/path");
        serverWithAnotherApp.exportedVariables.put("whatever", "something");
        serverWithAnotherApp.exportedVariables.put("env", "prod");
        db.exportedVariables.put("ip", null);
        db.exportedVariables.put("port", "3306");
        Assert.assertEquals((int)0, (int)ComponentHelpers.findAllExportedVariables((Component)root).size());
        Map exports = ComponentHelpers.findAllExportedVariables((Component)db);
        Assert.assertEquals((int)2, (int)exports.size());
        Assert.assertTrue((boolean)exports.containsKey("database.ip"));
        Assert.assertNull(exports.get("database.ip"));
        Assert.assertEquals((String)"3306", (String)((String)exports.get("database.port")));
        exports = ComponentHelpers.findAllExportedVariables((Component)serverWithApp);
        Assert.assertEquals((int)5, (int)exports.size());
        Assert.assertTrue((boolean)exports.containsKey(serverWithApp.getName() + ".ip"));
        Assert.assertNull(exports.get(serverWithApp.getName() + ".ip"));
        Assert.assertEquals((String)"8080", (String)((String)exports.get(serverWithApp.getName() + ".port")));
        Assert.assertEquals((String)"test", (String)((String)exports.get(serverWithApp.getName() + ".env")));
        Assert.assertEquals((String)"some/path", (String)((String)exports.get(serverWithApp.getName() + ".url-suffix")));
        Assert.assertEquals((String)"some/path", (String)((String)exports.get(serverFacet.getName() + ".url-suffix")));
        exports = ComponentHelpers.findAllExportedVariables((Component)serverWithAnotherApp);
        Assert.assertEquals((int)10, (int)exports.size());
        Assert.assertTrue((boolean)exports.containsKey(serverWithApp.getName() + ".ip"));
        Assert.assertNull(exports.get(serverWithApp.getName() + ".ip"));
        Assert.assertTrue((boolean)exports.containsKey(serverWithAnotherApp.getName() + ".ip"));
        Assert.assertNull(exports.get(serverWithAnotherApp.getName() + ".ip"));
        Assert.assertEquals((String)"8080", (String)((String)exports.get(serverWithApp.getName() + ".port")));
        Assert.assertEquals((String)"8080", (String)((String)exports.get(serverWithAnotherApp.getName() + ".port")));
        Assert.assertEquals((String)"another/path", (String)((String)exports.get(serverFacet.getName() + ".url-suffix")));
        Assert.assertEquals((String)"some/path", (String)((String)exports.get(serverWithApp.getName() + ".url-suffix")));
        Assert.assertEquals((String)"some/path", (String)((String)exports.get(serverWithAnotherApp.getName() + ".url-suffix")));
        Assert.assertEquals((String)"something", (String)((String)exports.get(serverWithAnotherApp.getName() + ".whatever")));
        Assert.assertEquals((String)"prod", (String)((String)exports.get(serverWithApp.getName() + ".env")));
        Assert.assertEquals((String)"prod", (String)((String)exports.get(serverWithAnotherApp.getName() + ".env")));
    }

    @Test
    public void testExtractNames() {
        ArrayList<Component> components = new ArrayList<Component>();
        components.add(new Component("c1"));
        components.add(new Component("c2"));
        List names = ComponentHelpers.extractNames(components);
        Assert.assertEquals((int)2, (int)names.size());
        Assert.assertEquals((String)"c1", (String)((String)names.get(0)));
        Assert.assertEquals((String)"c2", (String)((String)names.get(1)));
    }

    @Test
    public void testFindComponentDependenciesFor_namesOnly() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root1");
        Assert.assertNotNull((Object)comp);
        Map map = ComponentHelpers.findComponentDependenciesFor((Component)comp);
        Assert.assertEquals((int)0, (int)map.size());
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"app1");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentDependenciesFor((Component)comp);
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertTrue((boolean)map.containsKey("Database"));
        Assert.assertTrue((boolean)((Boolean)map.get("Database")));
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"app2");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentDependenciesFor((Component)comp);
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertTrue((boolean)map.containsKey("MySql"));
        Assert.assertFalse((boolean)((Boolean)map.get("MySql")));
        Assert.assertTrue((boolean)map.containsKey("MongoDB"));
        Assert.assertTrue((boolean)((Boolean)map.get("MongoDB")));
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"app3");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentDependenciesFor((Component)comp);
        Assert.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testFindComponentDependenciesFor_resolvedComponents() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root1");
        Assert.assertNotNull((Object)comp);
        Map map = ComponentHelpers.findComponentDependenciesFor((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)0, (int)map.size());
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"app1");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentDependenciesFor((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)1, (int)map.size());
        Component key = new Component("MySql");
        Assert.assertTrue((boolean)map.containsKey(key));
        Assert.assertTrue((boolean)((Boolean)map.get(key)));
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"app2");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentDependenciesFor((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)2, (int)map.size());
        key = new Component("MySql");
        Assert.assertTrue((boolean)map.containsKey(key));
        Assert.assertFalse((boolean)((Boolean)map.get(key)));
        key = new Component("MongoDB");
        Assert.assertTrue((boolean)map.containsKey(key));
        Assert.assertTrue((boolean)((Boolean)map.get(key)));
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"app3");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentDependenciesFor((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testFindComponentsThatDependOn() {
        ApplicationTemplate app = ComplexApplicationFactory1.newApplication();
        Component comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"root1");
        Assert.assertNotNull((Object)comp);
        Map map = ComponentHelpers.findComponentsThatDependOn((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)0, (int)map.size());
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"MySql");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentsThatDependOn((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)2, (int)map.size());
        Component key = new Component("app1");
        Assert.assertTrue((boolean)map.containsKey(key));
        Assert.assertTrue((boolean)((Boolean)map.get(key)));
        key = new Component("app2");
        Assert.assertTrue((boolean)map.containsKey(key));
        Assert.assertFalse((boolean)((Boolean)map.get(key)));
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"MongoDB");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentsThatDependOn((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)1, (int)map.size());
        key = new Component("app2");
        Assert.assertTrue((boolean)map.containsKey(key));
        Assert.assertTrue((boolean)((Boolean)map.get(key)));
        comp = ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"app3");
        Assert.assertNotNull((Object)comp);
        map = ComponentHelpers.findComponentsThatDependOn((Component)comp, (ApplicationTemplate)app);
        Assert.assertEquals((int)0, (int)map.size());
    }

    private Facet findFacetByName(Collection<Facet> facets, String facetName) {
        Facet result = null;
        for (Facet f : facets) {
            if (!facetName.equals(f.getName())) continue;
            result = f;
            break;
        }
        return result;
    }
}

