/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import junit.framework.Assert;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Import;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ImportHelpers;
import org.junit.Test;

public class ImportHelpersTest {
    @Test
    public void testHasAllRequiredImports_optional() throws Exception {
        Component clusterNodeComponent = new Component("cluster").installerName("whatever");
        clusterNodeComponent.addImportedVariable(new ImportedVariable("cluster.ip", true, false));
        clusterNodeComponent.addImportedVariable(new ImportedVariable("cluster.port", true, false));
        clusterNodeComponent.exportedVariables.put("cluster.ip", null);
        clusterNodeComponent.exportedVariables.put("cluster.port", "9007");
        Instance i1 = new Instance("inst 1").component(clusterNodeComponent);
        i1.overriddenExports.put("cluster.ip", "192.168.1.15");
        i1.setStatus(Instance.InstanceStatus.STARTING);
        Instance i2 = new Instance("inst 2").component(clusterNodeComponent);
        i2.overriddenExports.put("cluster.ip", "192.168.1.28");
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)i1, null));
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)i2, null));
        ImportHelpers.addImport((Instance)i1, (String)"cluster", (Import)new Import(i2));
        i1.setStatus(Instance.InstanceStatus.STARTING);
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)i1, null));
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)i2, null));
        i1.getImports().clear();
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)i1, null));
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)i2, null));
    }

    @Test
    public void testHasAllRequiredImports_required() throws Exception {
        Component dbComponent = new Component("database").installerName("whatever");
        dbComponent.exportedVariables.put("database.ip", null);
        dbComponent.exportedVariables.put("database.port", "3009");
        dbComponent.exportedVariables.put("database.collection", "whatever");
        Component appServerComponent = new Component("app-server").installerName("whatever");
        appServerComponent.exportedVariables.put("app-server.ip", null);
        appServerComponent.exportedVariables.put("app-server.port", "8009");
        appServerComponent.addImportedVariable(new ImportedVariable("database.ip", false, false));
        appServerComponent.addImportedVariable(new ImportedVariable("database.port", false, false));
        appServerComponent.addImportedVariable(new ImportedVariable("database.collection", true, false));
        Instance appServer = new Instance("app server").component(appServerComponent);
        appServer.overriddenExports.put("app-server.ip", "192.168.1.15");
        appServer.setStatus(Instance.InstanceStatus.STARTING);
        Instance database = new Instance("database").component(dbComponent);
        database.overriddenExports.put("database.ip", "192.168.1.28");
        Assert.assertFalse((boolean)ImportHelpers.hasAllRequiredImports((Instance)appServer, (Logger)Logger.getAnonymousLogger()));
        ImportHelpers.addImport((Instance)appServer, (String)"database", (Import)new Import(database));
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)appServer, null));
        appServer.getImports().clear();
        Assert.assertFalse((boolean)ImportHelpers.hasAllRequiredImports((Instance)appServer, null));
    }

    @Test
    public void testHasAllRequiredImports_withWildcard() throws Exception {
        Component dbComponent = new Component("database").installerName("whatever");
        dbComponent.exportedVariables.put("database.ip", null);
        dbComponent.exportedVariables.put("database.port", "3009");
        dbComponent.exportedVariables.put("database.collection", "whatever");
        Component appServerComponent = new Component("app-server").installerName("whatever");
        appServerComponent.exportedVariables.put("app-server.ip", null);
        appServerComponent.exportedVariables.put("app-server.port", "8009");
        appServerComponent.addImportedVariable(new ImportedVariable("database.*", false, false));
        Instance appServer = new Instance("app server").component(appServerComponent);
        appServer.overriddenExports.put("app-server.ip", "192.168.1.15");
        appServer.setStatus(Instance.InstanceStatus.STARTING);
        Instance database = new Instance("database").component(dbComponent);
        database.overriddenExports.put("database.ip", "192.168.1.28");
        Assert.assertFalse((boolean)ImportHelpers.hasAllRequiredImports((Instance)appServer, (Logger)Logger.getAnonymousLogger()));
        ImportHelpers.addImport((Instance)appServer, (String)"database", (Import)new Import(database));
        Assert.assertTrue((boolean)ImportHelpers.hasAllRequiredImports((Instance)appServer, null));
        appServer.getImports().clear();
        Assert.assertFalse((boolean)ImportHelpers.hasAllRequiredImports((Instance)appServer, null));
    }

    @Test
    public void testUpdateImports() {
        HashMap<String, List<Import>> prefixToImports = new HashMap<String, List<Import>>();
        prefixToImports.put("comp", Arrays.asList(new Import("/root1", "comp1"), new Import("/root2", "comp1")));
        Instance inst = new Instance("inst");
        Assert.assertEquals((int)0, (int)inst.getImports().size());
        ImportHelpers.updateImports((Instance)inst, prefixToImports);
        Assert.assertEquals((int)1, (int)inst.getImports().size());
        Iterator iterator = ((Collection)inst.getImports().get("comp")).iterator();
        Assert.assertEquals((String)"/root1", (String)((Import)iterator.next()).getInstancePath());
        Assert.assertEquals((String)"/root2", (String)((Import)iterator.next()).getInstancePath());
        Assert.assertFalse((boolean)iterator.hasNext());
        prefixToImports.put("comp", Arrays.asList(new Import("/root1", "comp1")));
        ImportHelpers.updateImports((Instance)inst, prefixToImports);
        Assert.assertEquals((int)1, (int)inst.getImports().size());
        iterator = ((Collection)inst.getImports().get("comp")).iterator();
        Assert.assertEquals((String)"/root1", (String)((Import)iterator.next()).getInstancePath());
        Assert.assertFalse((boolean)iterator.hasNext());
        ImportHelpers.updateImports((Instance)inst, null);
        Assert.assertEquals((int)0, (int)inst.getImports().size());
    }

    @Test
    public void testAddImport() {
        HashMap<String, ArrayList<Import>> prefixToImports = new HashMap<String, ArrayList<Import>>();
        prefixToImports.put("comp", new ArrayList<Import>(Arrays.asList(new Import("/root1", "comp1"), new Import("/root2", "comp1"))));
        Instance inst = new Instance("inst");
        inst.getImports().putAll(prefixToImports);
        Assert.assertEquals((int)1, (int)inst.getImports().keySet().size());
        Assert.assertTrue((boolean)inst.getImports().keySet().contains("comp"));
        ImportHelpers.addImport((Instance)inst, (String)"wow", (Import)new Import("/root", "comp1"));
        Assert.assertEquals((int)2, (int)inst.getImports().keySet().size());
        Assert.assertTrue((boolean)inst.getImports().keySet().contains("comp"));
        Assert.assertTrue((boolean)inst.getImports().keySet().contains("wow"));
        Assert.assertEquals((int)2, (int)((Collection)inst.getImports().get("comp")).size());
        ImportHelpers.addImport((Instance)inst, (String)"comp", (Import)new Import("/root3", "comp1"));
        Assert.assertEquals((int)3, (int)((Collection)inst.getImports().get("comp")).size());
        Assert.assertEquals((int)2, (int)inst.getImports().keySet().size());
        ImportHelpers.addImport((Instance)inst, (String)"comp", (Import)new Import("/root3", "comp1"));
        Assert.assertEquals((int)3, (int)((Collection)inst.getImports().get("comp")).size());
        Assert.assertEquals((int)2, (int)inst.getImports().keySet().size());
    }

    @Test
    public void testBuildTailoredImport() {
        String instancePath = "/whatever/this/is/a-test";
        Component comp = new Component("comp");
        comp.addImportedVariable(new ImportedVariable("comp1.port", false, false));
        comp.addImportedVariable(new ImportedVariable("comp1.ip", false, false));
        comp.addImportedVariable(new ImportedVariable("comp2.option", true, false));
        Instance inst = new Instance("inst").component(comp);
        Import imp = ImportHelpers.buildTailoredImport((Instance)inst, (String)instancePath, (String)"comp", null);
        Assert.assertEquals((String)instancePath, (String)imp.getInstancePath());
        Assert.assertEquals((int)0, (int)imp.getExportedVars().size());
        imp = ImportHelpers.buildTailoredImport((Instance)inst, (String)instancePath, (String)"comp", new HashMap());
        Assert.assertEquals((int)0, (int)imp.getExportedVars().size());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("comp1.ip", "127.0.0.1");
        map.put("comp2.option", "ciao!");
        map.put("not.a.valid.variable", "yeah");
        map.put(null, "null");
        map.put("", "hop");
        imp = ImportHelpers.buildTailoredImport((Instance)inst, (String)instancePath, (String)"comp", map);
        Assert.assertEquals((String)instancePath, (String)imp.getInstancePath());
        Assert.assertEquals((int)2, (int)imp.getExportedVars().size());
        Assert.assertEquals((String)"comp", (String)imp.getComponentName());
        Assert.assertEquals((String)"127.0.0.1", (String)((String)imp.getExportedVars().get("comp1.ip")));
        Assert.assertEquals((String)"ciao!", (String)((String)imp.getExportedVars().get("comp2.option")));
    }

    @Test
    public void testBuildTailoredImport_withWildcard() {
        String instancePath = "/whatever/this/is/a-test";
        Component comp = new Component("comp");
        comp.addImportedVariable(new ImportedVariable("comp1.*", false, false));
        comp.addImportedVariable(new ImportedVariable("comp2.option", true, false));
        Instance inst = new Instance("inst").component(comp);
        Import imp = ImportHelpers.buildTailoredImport((Instance)inst, (String)instancePath, (String)"comp", null);
        Assert.assertEquals((String)instancePath, (String)imp.getInstancePath());
        Assert.assertEquals((int)0, (int)imp.getExportedVars().size());
        imp = ImportHelpers.buildTailoredImport((Instance)inst, (String)instancePath, (String)"comp", new HashMap());
        Assert.assertEquals((int)0, (int)imp.getExportedVars().size());
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("comp1.ip", "127.0.0.1");
        map.put("comp2.option", "ciao!");
        map.put("not.a.valid.variable", "yeah");
        map.put(null, "null");
        map.put("", "hop");
        imp = ImportHelpers.buildTailoredImport((Instance)inst, (String)instancePath, (String)"comp", map);
        Assert.assertEquals((String)instancePath, (String)imp.getInstancePath());
        Assert.assertEquals((int)2, (int)imp.getExportedVars().size());
        Assert.assertEquals((String)"comp", (String)imp.getComponentName());
        Assert.assertEquals((String)"127.0.0.1", (String)((String)imp.getExportedVars().get("comp1.ip")));
        Assert.assertEquals((String)"ciao!", (String)((String)imp.getExportedVars().get("comp2.option")));
    }

    @Test
    public void testFindImportByExportingInstance() {
        HashSet<Import> imports = new HashSet<Import>();
        imports.add(new Import("/some/path", "comp1"));
        imports.add(new Import("/some/path/deeper", "comp1"));
        imports.add(new Import("/some/other-path", "comp1"));
        Assert.assertNull((Object)ImportHelpers.findImportByExportingInstance(null, null));
        Assert.assertNull((Object)ImportHelpers.findImportByExportingInstance(null, (String)"/some/path"));
        Assert.assertNull((Object)ImportHelpers.findImportByExportingInstance(imports, null));
        Assert.assertNull((Object)ImportHelpers.findImportByExportingInstance(imports, (String)"/wrong/path"));
        Assert.assertEquals((String)"/some/path", (String)ImportHelpers.findImportByExportingInstance(imports, (String)"/some/path").getInstancePath());
        Assert.assertEquals((String)"/some/path/deeper", (String)ImportHelpers.findImportByExportingInstance(imports, (String)"/some/path/deeper").getInstancePath());
    }
}

