/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.ComponentHelpers;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.helpers.RoboconfErrorHelpers;
import org.junit.Test;

public class InstanceHelpersTest {
    @Test
    public void testComputeInstancePath() {
        Instance instance1 = new Instance();
        Assert.assertEquals((String)"/", (String)InstanceHelpers.computeInstancePath((Instance)instance1));
        instance1.setName("inst1");
        Assert.assertEquals((String)"/inst1", (String)InstanceHelpers.computeInstancePath((Instance)instance1));
        Instance instance2 = new Instance("inst2");
        Assert.assertEquals((String)"/inst2", (String)InstanceHelpers.computeInstancePath((Instance)instance2));
        instance1.getChildren().add(instance2);
        instance2.setParent(instance1);
        Assert.assertEquals((String)"/inst1", (String)InstanceHelpers.computeInstancePath((Instance)instance1));
        Assert.assertEquals((String)"/inst1/inst2", (String)InstanceHelpers.computeInstancePath((Instance)instance2));
    }

    @Test
    public void testHaveSamePath() {
        Instance instance1 = new Instance("inst1");
        Assert.assertTrue((boolean)InstanceHelpers.haveSamePath((Instance)instance1, (Instance)instance1));
        Instance instance2 = new Instance("inst2");
        Assert.assertFalse((boolean)InstanceHelpers.haveSamePath((Instance)instance1, (Instance)instance2));
        instance2.setName("inst1");
        Assert.assertTrue((boolean)InstanceHelpers.haveSamePath((Instance)instance1, (Instance)instance2));
    }

    @Test
    public void testBuildHierarchicalList() {
        List instances = InstanceHelpers.buildHierarchicalList(null);
        Assert.assertEquals((int)0, (int)instances.size());
        Instance instance_1 = new Instance("inst 1");
        instances = InstanceHelpers.buildHierarchicalList((Instance)instance_1);
        Assert.assertEquals((int)1, (int)instances.size());
        Assert.assertEquals((Object)instance_1, instances.get(0));
        Instance instance_1_1 = new Instance("inst 11");
        InstanceHelpers.insertChild((Instance)instance_1, (Instance)instance_1_1);
        instances = InstanceHelpers.buildHierarchicalList((Instance)instance_1);
        Assert.assertEquals((int)2, (int)instances.size());
        Assert.assertEquals((Object)instance_1, instances.get(0));
        Assert.assertEquals((Object)instance_1_1, instances.get(1));
        Instance instance_1_2 = new Instance("inst 12");
        InstanceHelpers.insertChild((Instance)instance_1, (Instance)instance_1_2);
        Instance instance_1_1_1 = new Instance("inst 111");
        InstanceHelpers.insertChild((Instance)instance_1_1, (Instance)instance_1_1_1);
        Instance instance_1_2_1 = new Instance("inst 121");
        InstanceHelpers.insertChild((Instance)instance_1_2, (Instance)instance_1_2_1);
        instances = InstanceHelpers.buildHierarchicalList((Instance)instance_1);
        Assert.assertEquals((int)5, (int)instances.size());
        Assert.assertEquals((Object)instance_1, instances.get(0));
        Assert.assertEquals((Object)instance_1_1, instances.get(1));
        Assert.assertEquals((Object)instance_1_2, instances.get(2));
        Assert.assertEquals((Object)instance_1_1_1, instances.get(3));
        Assert.assertEquals((Object)instance_1_2_1, instances.get(4));
    }

    @Test
    public void testInsertChild() {
        Instance instance_1 = new Instance("inst 1");
        Instance instance_1_1 = new Instance("inst 11");
        Assert.assertNull((Object)instance_1.getParent());
        Assert.assertNull((Object)instance_1_1.getParent());
        Assert.assertEquals((int)0, (int)instance_1.getChildren().size());
        InstanceHelpers.insertChild((Instance)instance_1, (Instance)instance_1_1);
        Assert.assertEquals((int)1, (int)instance_1.getChildren().size());
        Assert.assertEquals((Object)instance_1_1, instance_1.getChildren().iterator().next());
        Assert.assertEquals((Object)instance_1, (Object)instance_1_1.getParent());
        Assert.assertTrue((boolean)instance_1.getChildren().contains(instance_1_1));
        Assert.assertNull((Object)instance_1.getParent());
        Assert.assertNotSame((Object)instance_1, (Object)instance_1_1);
    }

    @Test
    public void testFindAllExportedVariables() {
        Instance instance = new Instance("inst 1");
        Assert.assertEquals((int)0, (int)InstanceHelpers.findAllExportedVariables((Instance)instance).size());
        instance.overriddenExports.put("var1", "value1");
        Map map = InstanceHelpers.findAllExportedVariables((Instance)instance);
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((String)"value1", (String)((String)map.get("var1")));
        Component component = new Component("comp 1");
        component.exportedVariables.put("var1", "another value");
        component.exportedVariables.put("var2", "value2");
        instance.setComponent(component);
        map = InstanceHelpers.findAllExportedVariables((Instance)instance);
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertEquals((String)"value1", (String)((String)map.get("comp 1.var1")));
        Assert.assertEquals((String)"value2", (String)((String)map.get("comp 1.var2")));
        instance.overriddenExports.clear();
        map = InstanceHelpers.findAllExportedVariables((Instance)instance);
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertEquals((String)"another value", (String)((String)map.get("comp 1.var1")));
        Assert.assertEquals((String)"value2", (String)((String)map.get("comp 1.var2")));
    }

    @Test
    public void testFindAllExportedVariables_withFacets() {
        Component component = new Component("comp 1");
        component.exportedVariables.put("var1", "another value");
        component.exportedVariables.put("var2", "var 2 value");
        component.exportedVariables.put("ip", null);
        Facet f1 = new Facet("f1");
        f1.exportedVariables.put("param1", "value1");
        component.associateFacet(f1);
        Facet f2 = new Facet("f2");
        f2.exportedVariables.put("param2", "value2");
        component.associateFacet(f2);
        Facet f3 = new Facet("f3");
        f3.exportedVariables.put("param3", "value3");
        component.associateFacet(f3);
        component.exportedVariables.put("f3.param3", "component overrides facet");
        Facet f4 = new Facet("f4");
        f4.exportedVariables.put("param4-1", "value4");
        f4.exportedVariables.put("param4-2", "value4");
        f2.extendFacet(f4);
        f2.exportedVariables.put("f4.param4-1", "facet overrides facet");
        Instance instance = new Instance("inst 1");
        instance.setComponent(component);
        instance.overriddenExports.put("var1", "some value");
        instance.overriddenExports.put("toto.ip", null);
        instance.overriddenExports.put("f1.param1", "my-value");
        instance.data.put("ip.address", "192.168.1.18");
        Component extendedComponent = new Component("extended");
        extendedComponent.exportedVariables.put("v", "hop");
        component.extendComponent(extendedComponent);
        component.exportedVariables.put("extended.v", "nop");
        Map map = InstanceHelpers.findAllExportedVariables((Instance)instance);
        Assert.assertEquals((int)16, (int)map.size());
        Assert.assertEquals((String)"some value", (String)((String)map.get("comp 1.var1")));
        Assert.assertEquals((String)"var 2 value", (String)((String)map.get("comp 1.var2")));
        Assert.assertEquals((String)"192.168.1.18", (String)((String)map.get("comp 1.ip")));
        Assert.assertEquals((String)"192.168.1.18", (String)((String)map.get("toto.ip")));
        Assert.assertEquals((String)"nop", (String)((String)map.get("extended.v")));
        Assert.assertEquals((String)"my-value", (String)((String)map.get("f1.param1")));
        Assert.assertEquals((String)"value1", (String)((String)map.get("comp 1.param1")));
        Assert.assertEquals((String)"value2", (String)((String)map.get("f2.param2")));
        Assert.assertEquals((String)"value2", (String)((String)map.get("comp 1.param2")));
        Assert.assertEquals((String)"component overrides facet", (String)((String)map.get("f3.param3")));
        Assert.assertEquals((String)"component overrides facet", (String)((String)map.get("comp 1.param3")));
        Assert.assertEquals((String)"facet overrides facet", (String)((String)map.get("f4.param4-1")));
        Assert.assertEquals((String)"value4", (String)((String)map.get("f4.param4-2")));
    }

    @Test
    public void testCountInstances() {
        Assert.assertEquals((int)0, (int)InstanceHelpers.countInstances((String)""));
        Assert.assertEquals((int)0, (int)InstanceHelpers.countInstances((String)"toto"));
        Assert.assertEquals((int)1, (int)InstanceHelpers.countInstances((String)"/root-instance"));
        Assert.assertEquals((int)2, (int)InstanceHelpers.countInstances((String)"/root-instance/apache"));
        Assert.assertEquals((int)3, (int)InstanceHelpers.countInstances((String)"/root-instance/apache/war"));
    }

    @Test
    public void testFindInstanceDirectoryOnAgent() {
        File f = InstanceHelpers.findInstanceDirectoryOnAgent((Instance)new Instance("inst").component(new Component("c").installerName("my-plugin")));
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        Assert.assertTrue((boolean)f.getAbsolutePath().startsWith(tempDir.getAbsolutePath()));
        Assert.assertTrue((boolean)f.getAbsolutePath().contains("inst"));
        Assert.assertTrue((boolean)f.getAbsolutePath().contains("my-plugin"));
    }

    @Test
    public void testGetAllInstances() {
        Application app = new Application(new ApplicationTemplate());
        Instance[] rootInstances = new Instance[8];
        for (int i = 0; i < rootInstances.length; ++i) {
            rootInstances[i] = new Instance("i-" + i);
            InstanceHelpers.insertChild((Instance)rootInstances[i], (Instance)new Instance("child-" + i));
        }
        app.getRootInstances().addAll(Arrays.asList(rootInstances));
        List allInstances = InstanceHelpers.getAllInstances((AbstractApplication)app);
        Assert.assertEquals((int)(rootInstances.length * 2), (int)allInstances.size());
        for (Instance rootInstance : rootInstances) {
            Assert.assertTrue((String)rootInstance.getName(), (boolean)allInstances.contains(rootInstance));
        }
    }

    @Test
    public void testFindRootInstance() {
        Instance inst = new Instance("inst");
        Assert.assertEquals((Object)inst, (Object)InstanceHelpers.findRootInstance((Instance)inst));
        Instance childInstance = new Instance("child-instance");
        InstanceHelpers.insertChild((Instance)inst, (Instance)childInstance);
        Assert.assertEquals((Object)inst, (Object)InstanceHelpers.findRootInstance((Instance)inst));
        Assert.assertEquals((Object)inst, (Object)InstanceHelpers.findRootInstance((Instance)childInstance));
        Instance lastChild = childInstance;
        for (int i = 0; i < 8; ++i) {
            Instance tempInstance = new Instance("child-" + i);
            InstanceHelpers.insertChild((Instance)lastChild, (Instance)tempInstance);
            lastChild = tempInstance;
        }
        Assert.assertEquals((Object)inst, (Object)InstanceHelpers.findRootInstance((Instance)lastChild));
    }

    @Test
    public void testFindInstancesByComponentName() {
        ApplicationTemplate app = new ApplicationTemplate();
        Component tomcat = new Component("tomcat").installerName("puppet");
        Component other = new Component("other").installerName("chef");
        Instance i1 = new Instance("i1").component(tomcat);
        Instance i2 = new Instance("i2").component(tomcat);
        Instance i3 = new Instance("i3").component(other);
        Instance i4 = new Instance("i4").component(other);
        Graphs graphs = new Graphs();
        graphs.getRootComponents().add(other);
        graphs.getRootComponents().add(tomcat);
        app.setGraphs(graphs);
        InstanceHelpers.insertChild((Instance)i3, (Instance)i1);
        app.getRootInstances().add(i2);
        app.getRootInstances().add(i3);
        app.getRootInstances().add(i4);
        List tomcatInstances = InstanceHelpers.findInstancesByComponentName((AbstractApplication)app, (String)tomcat.getName());
        Assert.assertEquals((int)2, (int)tomcatInstances.size());
        Assert.assertTrue((boolean)tomcatInstances.contains(i1));
        Assert.assertTrue((boolean)tomcatInstances.contains(i2));
        List otherInstances = InstanceHelpers.findInstancesByComponentName((AbstractApplication)app, (String)other.getName());
        Assert.assertEquals((int)2, (int)otherInstances.size());
        Assert.assertTrue((boolean)otherInstances.contains(i3));
        Assert.assertTrue((boolean)otherInstances.contains(i4));
        Assert.assertEquals((int)0, (int)InstanceHelpers.findInstancesByComponentName((AbstractApplication)app, (String)"whatever").size());
    }

    @Test
    public void testFindInstanceByPath() {
        Instance rootInstance;
        Instance current = rootInstance = new Instance("root");
        for (int i = 1; i < 8; ++i) {
            Instance tempInstance = new Instance("i-" + i);
            InstanceHelpers.insertChild((Instance)current, (Instance)tempInstance);
            current = tempInstance;
        }
        Assert.assertEquals((String)"root", (String)InstanceHelpers.findInstanceByPath((Instance)rootInstance, (String)"/root").getName());
        Assert.assertEquals((String)"i-4", (String)InstanceHelpers.findInstanceByPath((Instance)rootInstance, (String)"/root/i-1/i-2/i-3/i-4").getName());
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((Instance)rootInstance, (String)"whatever"));
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((Instance)rootInstance, (String)"/root/whatever"));
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((Instance)rootInstance, (String)"/root/i-1/i-3"));
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((Instance)null, (String)"/root/i-1/i-3"));
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((Instance)rootInstance, null));
        Assert.assertNull((Object)InstanceHelpers.findInstanceByPath((AbstractApplication)((Application)null), (String)"/root"));
    }

    @Test
    public void testTryToInsertChildInstance() throws Exception {
        File directory = TestUtils.findTestFile("/applications/lamp-legacy-with-only-components");
        RuntimeModelIo.ApplicationLoadResult result = RuntimeModelIo.loadApplication((File)directory);
        Assert.assertNotNull((Object)result);
        Assert.assertNotNull((Object)result.getApplicationTemplate());
        Assert.assertFalse((boolean)RoboconfErrorHelpers.containsCriticalErrors((Collection)result.getLoadErrors()));
        ApplicationTemplate app = result.getApplicationTemplate();
        app.getRootInstances().clear();
        Assert.assertEquals((int)0, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Instance vmInstance = new Instance("vm-1").component(ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"VM"));
        Assert.assertTrue((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, null, (Instance)vmInstance));
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, null, (Instance)vmInstance));
        Assert.assertEquals((int)1, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Instance tomcatInstance_1 = new Instance("tomcat-1").component(ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"Tomcat"));
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, null, (Instance)tomcatInstance_1));
        Assert.assertTrue((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)vmInstance, (Instance)tomcatInstance_1));
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)vmInstance, (Instance)tomcatInstance_1));
        Assert.assertEquals((int)2, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Instance mySqlInstance_1 = new Instance("MySQL-1").component(ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"MySQL"));
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)tomcatInstance_1, (Instance)mySqlInstance_1));
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)mySqlInstance_1, (Instance)tomcatInstance_1));
        Assert.assertEquals((int)2, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)vmInstance, (Instance)mySqlInstance_1));
        mySqlInstance_1.overriddenExports.put("port", "3307");
        Assert.assertTrue((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)vmInstance, (Instance)mySqlInstance_1));
        Assert.assertEquals((int)3, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Instance instanceWithNoComponent = new Instance("MySQL-2");
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)vmInstance, (Instance)instanceWithNoComponent));
        Assert.assertEquals((int)3, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        Instance instWithInvalidName = new Instance("inst!!!").component(ComponentHelpers.findComponent((Graphs)app.getGraphs(), (String)"Apache"));
        Assert.assertFalse((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)vmInstance, (Instance)instWithInvalidName));
        Assert.assertEquals((int)3, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
        instWithInvalidName.setName("whatever");
        Assert.assertTrue((boolean)InstanceHelpers.tryToInsertChildInstance((AbstractApplication)app, (Instance)vmInstance, (Instance)instWithInvalidName));
        Assert.assertEquals((int)4, (int)InstanceHelpers.getAllInstances((AbstractApplication)app).size());
    }

    @Test
    public void testDuplicateInstance_singleInstance() {
        Instance original = new Instance("inst").channel("chan").component(new Component("comp"));
        original.overriddenExports.put("test", "test");
        original.overriddenExports.put("A.port", "8012");
        original.data.put("some", "data");
        original.getImports().put("facet-name", new ArrayList());
        Instance copy = InstanceHelpers.replicateInstance((Instance)original);
        Assert.assertEquals((String)original.getName(), (String)copy.getName());
        Assert.assertEquals((Object)original.channels, (Object)copy.channels);
        Assert.assertEquals((int)original.overriddenExports.size(), (int)copy.overriddenExports.size());
        Assert.assertEquals((String)"test", (String)((String)copy.overriddenExports.get("test")));
        Assert.assertEquals((String)"8012", (String)((String)copy.overriddenExports.get("A.port")));
        Assert.assertEquals((int)0, (int)copy.getImports().size());
        Assert.assertEquals((Object)original.getComponent(), (Object)copy.getComponent());
    }

    @Test
    public void testDuplicateInstance_withChildren() {
        Instance original_1 = new Instance("inst-1").channel("chan").component(new Component("comp-1"));
        original_1.overriddenExports.put("test", "test");
        original_1.overriddenExports.put("A.port", "8012");
        Instance original_2 = new Instance("inst-2").channel("chan").component(new Component("comp-2"));
        original_2.overriddenExports.put("port", "8012");
        Instance original_22 = new Instance("inst-22").channel("chan").component(new Component("comp-78"));
        Instance original_3 = new Instance("inst-3").channel("chan").component(new Component("comp-3"));
        original_3.overriddenExports.put("ip", "localhost");
        InstanceHelpers.insertChild((Instance)original_1, (Instance)original_2);
        InstanceHelpers.insertChild((Instance)original_1, (Instance)original_22);
        InstanceHelpers.insertChild((Instance)original_2, (Instance)original_3);
        Instance copy = InstanceHelpers.replicateInstance((Instance)original_1);
        Assert.assertEquals((String)original_1.getName(), (String)copy.getName());
        Assert.assertEquals((Object)original_1.channels, (Object)copy.channels);
        Assert.assertEquals((int)original_1.overriddenExports.size(), (int)copy.overriddenExports.size());
        Assert.assertEquals((String)"test", (String)((String)copy.overriddenExports.get("test")));
        Assert.assertEquals((String)"8012", (String)((String)copy.overriddenExports.get("A.port")));
        Assert.assertEquals((Object)original_1.getComponent(), (Object)copy.getComponent());
        Assert.assertEquals((int)2, (int)copy.getChildren().size());
        Assert.assertNull((Object)copy.getParent());
        Instance[] children = copy.getChildren().toArray(new Instance[0]);
        Assert.assertEquals((String)original_2.getName(), (String)children[0].getName());
        Assert.assertEquals((Object)original_2.channels, (Object)children[0].channels);
        Assert.assertEquals((int)original_2.overriddenExports.size(), (int)children[0].overriddenExports.size());
        Assert.assertEquals((String)"8012", (String)((String)children[0].overriddenExports.get("port")));
        Assert.assertEquals((Object)original_2.getComponent(), (Object)children[0].getComponent());
        Assert.assertEquals((int)1, (int)children[0].getChildren().size());
        Assert.assertEquals((Object)copy, (Object)children[0].getParent());
        Assert.assertEquals((String)original_22.getName(), (String)children[1].getName());
        Assert.assertEquals((Object)original_22.channels, (Object)children[1].channels);
        Assert.assertEquals((int)0, (int)children[1].overriddenExports.size());
        Assert.assertEquals((Object)original_22.getComponent(), (Object)children[1].getComponent());
        Assert.assertEquals((int)0, (int)children[1].getChildren().size());
        Assert.assertEquals((Object)copy, (Object)children[1].getParent());
        Instance lastChild = (Instance)children[0].getChildren().iterator().next();
        Assert.assertEquals((String)original_3.getName(), (String)lastChild.getName());
        Assert.assertEquals((Object)original_3.channels, (Object)lastChild.channels);
        Assert.assertEquals((int)original_3.overriddenExports.size(), (int)lastChild.overriddenExports.size());
        Assert.assertEquals((String)"localhost", (String)((String)lastChild.overriddenExports.get("ip")));
        Assert.assertEquals((Object)original_3.getComponent(), (Object)lastChild.getComponent());
        Assert.assertEquals((int)0, (int)lastChild.getChildren().size());
        Assert.assertEquals((Object)children[0], (Object)lastChild.getParent());
        copy = InstanceHelpers.replicateInstance((Instance)original_2);
        Assert.assertEquals((String)original_2.getName(), (String)copy.getName());
        Assert.assertEquals((Object)original_2.channels, (Object)copy.channels);
        Assert.assertEquals((int)original_2.overriddenExports.size(), (int)copy.overriddenExports.size());
        Assert.assertEquals((String)"8012", (String)((String)copy.overriddenExports.get("port")));
        Assert.assertEquals((Object)original_2.getComponent(), (Object)copy.getComponent());
        Assert.assertEquals((int)1, (int)copy.getChildren().size());
        Assert.assertNull((Object)copy.getParent());
        Assert.assertNotNull((Object)original_2.getParent());
        lastChild = (Instance)copy.getChildren().iterator().next();
        Assert.assertEquals((String)original_3.getName(), (String)lastChild.getName());
        Assert.assertEquals((Object)original_3.channels, (Object)lastChild.channels);
        Assert.assertEquals((int)original_3.overriddenExports.size(), (int)lastChild.overriddenExports.size());
        Assert.assertEquals((String)"localhost", (String)((String)lastChild.overriddenExports.get("ip")));
        Assert.assertEquals((Object)original_3.getComponent(), (Object)lastChild.getComponent());
        Assert.assertEquals((int)0, (int)lastChild.getChildren().size());
        Assert.assertEquals((Object)copy, (Object)lastChild.getParent());
    }

    @Test
    public void testIsTarget() {
        Instance inst = new Instance("i");
        Assert.assertFalse((boolean)InstanceHelpers.isTarget((Instance)inst));
        inst.setComponent(new Component("comp").installerName("whatever"));
        Assert.assertFalse((boolean)InstanceHelpers.isTarget((Instance)inst));
        inst.getComponent().setInstallerName("target");
        Assert.assertTrue((boolean)InstanceHelpers.isTarget((Instance)inst));
    }

    @Test
    public void testFindRootInstancePath() {
        Assert.assertEquals((String)"", (String)InstanceHelpers.findRootInstancePath(null));
        Assert.assertEquals((String)"", (String)InstanceHelpers.findRootInstancePath((String)"  "));
        Assert.assertEquals((String)"root", (String)InstanceHelpers.findRootInstancePath((String)"root"));
        Assert.assertEquals((String)"root", (String)InstanceHelpers.findRootInstancePath((String)"/root"));
        Assert.assertEquals((String)"root", (String)InstanceHelpers.findRootInstancePath((String)"/root/"));
        Assert.assertEquals((String)"root", (String)InstanceHelpers.findRootInstancePath((String)"//root//"));
        Assert.assertEquals((String)"", (String)InstanceHelpers.findRootInstancePath((String)"/"));
        Assert.assertEquals((String)"root", (String)InstanceHelpers.findRootInstancePath((String)"/root/server/whatever"));
        Assert.assertEquals((String)"root", (String)InstanceHelpers.findRootInstancePath((String)"root/invalid"));
    }

    @Test
    public void testRemoveOffScopeInstances_zero() {
        Instance root = new Instance("root").component(new Component("Root").installerName("target"));
        Instance server = new Instance("server").component(new Component("Server").installerName("whatever"));
        Instance app1 = new Instance("app1").component(new Component("Application").installerName("whatever"));
        Instance app2 = new Instance("app2").component(new Component("Application").installerName("whatever"));
        Instance server2 = new Instance("server2").component(new Component("Server").installerName("whatever"));
        InstanceHelpers.insertChild((Instance)root, (Instance)server);
        InstanceHelpers.insertChild((Instance)root, (Instance)server2);
        InstanceHelpers.insertChild((Instance)server, (Instance)app1);
        InstanceHelpers.insertChild((Instance)server, (Instance)app2);
        Assert.assertEquals((int)5, (int)InstanceHelpers.buildHierarchicalList((Instance)root).size());
        InstanceHelpers.removeOffScopeInstances((Instance)root);
        Assert.assertEquals((int)5, (int)InstanceHelpers.buildHierarchicalList((Instance)root).size());
    }

    @Test
    public void testRemoveOffScopeInstances_oneTarget() {
        Instance root = new Instance("root").component(new Component("Root").installerName("target"));
        Instance server = new Instance("server").component(new Component("Server").installerName("target"));
        Instance app1 = new Instance("app1").component(new Component("Application").installerName("whatever"));
        Instance app2 = new Instance("app2").component(new Component("Application").installerName("whatever"));
        Instance server2 = new Instance("server2").component(new Component("Server").installerName("whatever"));
        InstanceHelpers.insertChild((Instance)root, (Instance)server);
        InstanceHelpers.insertChild((Instance)root, (Instance)server2);
        InstanceHelpers.insertChild((Instance)server, (Instance)app1);
        InstanceHelpers.insertChild((Instance)server2, (Instance)app2);
        Assert.assertEquals((int)5, (int)InstanceHelpers.buildHierarchicalList((Instance)root).size());
        InstanceHelpers.removeOffScopeInstances((Instance)root);
        List instances = InstanceHelpers.buildHierarchicalList((Instance)root);
        Assert.assertEquals((int)3, (int)instances.size());
        Assert.assertTrue((boolean)instances.contains(root));
        Assert.assertTrue((boolean)instances.contains(server2));
        Assert.assertTrue((boolean)instances.contains(app2));
    }

    @Test
    public void testRemoveOffScopeInstances_oneMiddleTarget() {
        Instance root = new Instance("root").component(new Component("Root").installerName("target"));
        Instance server = new Instance("server").component(new Component("Server").installerName("target"));
        Instance app1 = new Instance("app1").component(new Component("Application").installerName("target"));
        Instance app2 = new Instance("app2").component(new Component("Application").installerName("whatever"));
        Instance server2 = new Instance("server2").component(new Component("Server").installerName("whatever"));
        InstanceHelpers.insertChild((Instance)root, (Instance)server);
        InstanceHelpers.insertChild((Instance)root, (Instance)server2);
        InstanceHelpers.insertChild((Instance)server, (Instance)app1);
        InstanceHelpers.insertChild((Instance)server2, (Instance)app2);
        Assert.assertEquals((int)5, (int)InstanceHelpers.buildHierarchicalList((Instance)root).size());
        Assert.assertEquals((int)2, (int)InstanceHelpers.buildHierarchicalList((Instance)server).size());
        InstanceHelpers.removeOffScopeInstances((Instance)server);
        Assert.assertEquals((int)4, (int)InstanceHelpers.buildHierarchicalList((Instance)root).size());
        List instances = InstanceHelpers.buildHierarchicalList((Instance)server);
        Assert.assertEquals((int)1, (int)instances.size());
        Assert.assertTrue((boolean)instances.contains(server));
    }

    @Test
    public void testFindScopedInstance() {
        Instance root = new Instance("root").component(new Component("Root").installerName("target"));
        Instance server = new Instance("server").component(new Component("Server").installerName("target"));
        Instance app1 = new Instance("app1").component(new Component("Application").installerName("whatever"));
        Instance app2 = new Instance("app2").component(new Component("Application").installerName("whatever"));
        Instance server2 = new Instance("server2").component(new Component("Server").installerName("whatever"));
        InstanceHelpers.insertChild((Instance)root, (Instance)server);
        InstanceHelpers.insertChild((Instance)root, (Instance)server2);
        InstanceHelpers.insertChild((Instance)server, (Instance)app1);
        InstanceHelpers.insertChild((Instance)server2, (Instance)app2);
        Assert.assertEquals((Object)root, (Object)InstanceHelpers.findScopedInstance((Instance)root));
        Assert.assertEquals((Object)server, (Object)InstanceHelpers.findScopedInstance((Instance)server));
        Assert.assertEquals((Object)server, (Object)InstanceHelpers.findScopedInstance((Instance)app1));
        Assert.assertEquals((Object)root, (Object)InstanceHelpers.findScopedInstance((Instance)app2));
    }

    @Test
    public void testFindAllScopedInstances() {
        Instance root = new Instance("root").component(new Component("Root").installerName("target"));
        Instance server = new Instance("server").component(new Component("Server").installerName("target"));
        Instance app1 = new Instance("app1").component(new Component("Application").installerName("whatever"));
        Instance app2 = new Instance("app2").component(new Component("Application").installerName("target"));
        Instance server2 = new Instance("server2").component(new Component("Server").installerName("whatever"));
        InstanceHelpers.insertChild((Instance)root, (Instance)server);
        InstanceHelpers.insertChild((Instance)root, (Instance)server2);
        InstanceHelpers.insertChild((Instance)server, (Instance)app1);
        InstanceHelpers.insertChild((Instance)server2, (Instance)app2);
        Application app = new Application("test", new ApplicationTemplate());
        app.getRootInstances().add(root);
        List instances = InstanceHelpers.findAllScopedInstances((Application)app);
        Assert.assertEquals((int)3, (int)instances.size());
        Assert.assertTrue((boolean)instances.contains(root));
        Assert.assertTrue((boolean)instances.contains(server));
        Assert.assertTrue((boolean)instances.contains(app2));
    }

    @Test
    public void testFixOverriddenExports() {
        Component comp = new Component("comp");
        comp.exportedVariables.put("comp.export1", "c1");
        comp.exportedVariables.put("comp.export2", "c2");
        comp.exportedVariables.put("comp.export3", "c3");
        Instance inst = new Instance("inst").component(comp);
        Assert.assertEquals((int)0, (int)inst.overriddenExports.size());
        InstanceHelpers.fixOverriddenExports((Instance)inst);
        Assert.assertEquals((int)0, (int)inst.overriddenExports.size());
        inst.overriddenExports.put("inst.export1", "i1");
        inst.overriddenExports.put("comp.export2", "c2");
        inst.overriddenExports.put("comp.export3", "i3");
        InstanceHelpers.fixOverriddenExports((Instance)inst);
        Assert.assertEquals((int)comp.exportedVariables.size(), (int)3);
        Assert.assertEquals((String)((String)comp.exportedVariables.get("comp.export1")), (String)"c1");
        Assert.assertEquals((String)((String)comp.exportedVariables.get("comp.export2")), (String)"c2");
        Assert.assertEquals((String)((String)comp.exportedVariables.get("comp.export3")), (String)"c3");
        Assert.assertEquals((int)inst.overriddenExports.size(), (int)2);
        Assert.assertEquals((String)((String)inst.overriddenExports.get("inst.export1")), (String)"i1");
        Assert.assertEquals((String)((String)inst.overriddenExports.get("comp.export3")), (String)"i3");
    }
}

