/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import junit.framework.Assert;
import net.roboconf.core.ErrorCode;
import net.roboconf.core.RoboconfError;
import net.roboconf.core.model.ModelError;
import net.roboconf.core.model.ParsingError;
import net.roboconf.core.model.RuntimeModelIo;
import net.roboconf.core.model.SourceReference;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.helpers.RoboconfErrorHelpers;
import org.junit.Test;

public class RoboconfErrorHelpersTest {
    @Test
    public void testContainsCriticalErrors() {
        ArrayList<RoboconfError> errors = new ArrayList<RoboconfError>();
        Assert.assertFalse((boolean)RoboconfErrorHelpers.containsCriticalErrors(errors));
        errors.add(new RoboconfError(ErrorCode.PM_MALFORMED_COMMENT));
        Assert.assertFalse((boolean)RoboconfErrorHelpers.containsCriticalErrors(errors));
        errors.add(new RoboconfError(ErrorCode.PM_DUPLICATE_PROPERTY));
        Assert.assertTrue((boolean)RoboconfErrorHelpers.containsCriticalErrors(errors));
    }

    @Test
    public void testFindWarnings() {
        Collection errors = new ArrayList<RoboconfError>();
        Assert.assertEquals((int)0, (int)RoboconfErrorHelpers.findWarnings(errors).size());
        errors.add(new RoboconfError(ErrorCode.PM_DUPLICATE_PROPERTY));
        Assert.assertEquals((int)0, (int)RoboconfErrorHelpers.findWarnings(errors).size());
        errors.add(new RoboconfError(ErrorCode.PROJ_NO_RESOURCE_DIRECTORY));
        errors = RoboconfErrorHelpers.findWarnings(errors);
        Assert.assertEquals((int)1, (int)errors.size());
        Assert.assertEquals((Object)ErrorCode.PROJ_NO_RESOURCE_DIRECTORY, (Object)((RoboconfError)errors.iterator().next()).getErrorCode());
    }

    @Test
    public void testExtractAndFormatWarnings() {
        ArrayList<RoboconfError> errors = new ArrayList<RoboconfError>();
        Assert.assertEquals((int)0, (int)RoboconfErrorHelpers.extractAndFormatWarnings(errors).size());
        RoboconfError error = new RoboconfError(ErrorCode.PROJ_NO_RESOURCE_DIRECTORY);
        errors.add(error);
        Assert.assertEquals((int)1, (int)RoboconfErrorHelpers.extractAndFormatWarnings(errors).size());
        error.setDetails("whatever");
        errors.add(new RoboconfError(ErrorCode.PM_DUPLICATE_PROPERTY));
        Assert.assertEquals((int)1, (int)RoboconfErrorHelpers.extractAndFormatWarnings(errors).size());
    }

    @Test
    public void testResolveErrorsWithLocation() {
        RuntimeModelIo.ApplicationLoadResult alr = new RuntimeModelIo.ApplicationLoadResult();
        Component c1 = new Component("comp1");
        Component c2 = new Component("comp2");
        Assert.assertEquals((int)0, (int)RoboconfErrorHelpers.resolveErrorsWithLocation((RuntimeModelIo.ApplicationLoadResult)alr).size());
        alr.getLoadErrors().add(new RoboconfError(ErrorCode.REC_SCRIPT_NO_SCRIPTS_DIR));
        alr.getLoadErrors().add(new ModelError(ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)c1));
        alr.getLoadErrors().add(new ModelError(ErrorCode.RM_INVALID_COMPONENT_INSTALLER, (Object)c2));
        List errors = RoboconfErrorHelpers.resolveErrorsWithLocation((RuntimeModelIo.ApplicationLoadResult)alr);
        Assert.assertEquals((int)alr.getLoadErrors().size(), (int)errors.size());
        Assert.assertEquals(RoboconfError.class, ((RoboconfError)errors.get(0)).getClass());
        Assert.assertEquals(ModelError.class, ((RoboconfError)errors.get(1)).getClass());
        Assert.assertEquals(ModelError.class, ((RoboconfError)errors.get(2)).getClass());
        alr.getObjectToSource().put(c1, new SourceReference((Object)c1, new File("whatever"), 5));
        errors = RoboconfErrorHelpers.resolveErrorsWithLocation((RuntimeModelIo.ApplicationLoadResult)alr);
        Assert.assertEquals((int)alr.getLoadErrors().size(), (int)errors.size());
        Assert.assertEquals(RoboconfError.class, ((RoboconfError)errors.get(0)).getClass());
        Assert.assertEquals(ParsingError.class, ((RoboconfError)errors.get(1)).getClass());
        Assert.assertEquals((Object)ErrorCode.RM_INVALID_VARIABLE_NAME, (Object)((RoboconfError)errors.get(1)).getErrorCode());
        Assert.assertEquals((int)5, (int)((ParsingError)errors.get(1)).getLine());
        Assert.assertEquals(ModelError.class, ((RoboconfError)errors.get(2)).getClass());
    }
}

