/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.model.helpers;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Facet;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.VariableHelpers;
import org.junit.Test;

public class VariableHelpersTest {
    @Test
    public void testParseVariableName() {
        String[][] values;
        for (String[] value : values = new String[][]{{"facet", "variable"}, {"FacetName", "complex.variable.name"}, {"facet-Name", ""}, {"", "some_variable"}}) {
            String s = value[0] + "." + value[1];
            Map.Entry entry = VariableHelpers.parseVariableName((String)s);
            Assert.assertEquals((String)("Invalid component or facet name for " + s), (String)value[0], (String)((String)entry.getKey()));
            Assert.assertEquals((String)("Invalid simple name for " + s), (String)value[1], (String)((String)entry.getValue()));
        }
        Map.Entry entry = VariableHelpers.parseVariableName((String)"noPrefix");
        Assert.assertEquals((String)"noPrefix", (String)((String)entry.getValue()));
        Assert.assertEquals((String)"", (String)((String)entry.getKey()));
    }

    @Test
    public void testParseExportedVariable() {
        String[][] values;
        for (String[] value : values = new String[][]{{"variableName", ""}, {"variableName", "default value"}, {"complex.variable.name", "51"}, {"", "oops"}}) {
            String s = value[0] + " = " + value[1];
            Map.Entry entry = VariableHelpers.parseExportedVariable((String)s);
            Assert.assertEquals((String)("Invalid variable name for " + s), (String)value[0], (String)((String)entry.getKey()));
            Assert.assertEquals((String)("Invalid default value for " + s), (String)value[1], (String)((String)entry.getValue()));
        }
    }

    @Test
    public void testFindPrefixesForExportedVariables_withComponentVariables() {
        Component component = new Component("comp");
        component.exportedVariables.put("comp.ip", "");
        component.exportedVariables.put("comp.split.property", "");
        component.exportedVariables.put("comp.port", "8000");
        Instance instance = new Instance("inst").component(component);
        Set prefixes = VariableHelpers.findPrefixesForExportedVariables((Instance)instance);
        Assert.assertEquals((int)1, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("comp"));
        Facet facet = new Facet("facet");
        facet.exportedVariables.put("something", "value");
        component.associateFacet(facet);
        prefixes = VariableHelpers.findPrefixesForExportedVariables((Instance)instance);
        Assert.assertEquals((int)2, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("comp"));
        Assert.assertTrue((boolean)prefixes.contains("facet"));
    }

    @Test
    public void testFindPrefixesForExportedVariables_withVariable() {
        Instance instance = new Instance("inst").component(new Component("comp"));
        Set prefixes = VariableHelpers.findPrefixesForExportedVariables((Instance)instance);
        Assert.assertEquals((int)0, (int)prefixes.size());
    }

    @Test
    public void testFindPrefixesForExportedVariables_withInstanceVariablesOnly() {
        Instance instance = new Instance("inst").component(new Component("comp"));
        instance.overriddenExports.put("comp.ip", "");
        instance.overriddenExports.put("comp.split.property", "");
        instance.overriddenExports.put("comp.port", "8000");
        instance.overriddenExports.put("facet.desc", "some description");
        Set prefixes = VariableHelpers.findPrefixesForExportedVariables((Instance)instance);
        Assert.assertEquals((int)2, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("comp"));
        Assert.assertTrue((boolean)prefixes.contains("facet"));
    }

    @Test
    public void testFindPrefixesForImportedVariables() {
        Component component = new Component("comp");
        component.addImportedVariable(new ImportedVariable("comp.ip", false, false));
        component.addImportedVariable(new ImportedVariable("comp.split.property", false, false));
        component.addImportedVariable(new ImportedVariable("comp.port", false, false));
        component.addImportedVariable(new ImportedVariable("facet.desc", false, false));
        Instance instance = new Instance("inst").component(component);
        Set prefixes = VariableHelpers.findPrefixesForImportedVariables((Instance)instance);
        Assert.assertEquals((int)2, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("comp"));
        Assert.assertTrue((boolean)prefixes.contains("facet"));
        component.importedVariables.clear();
        prefixes = VariableHelpers.findPrefixesForImportedVariables((Instance)instance);
        Assert.assertEquals((int)0, (int)prefixes.size());
    }

    @Test
    public void testFindPrefixesForMandatoryImportedVariables() {
        Component component = new Component("comp");
        component.addImportedVariable(new ImportedVariable("comp.ip", false, false));
        component.addImportedVariable(new ImportedVariable("comp.split.property", false, false));
        component.addImportedVariable(new ImportedVariable("comp.port", false, false));
        component.addImportedVariable(new ImportedVariable("facet.desc", true, false));
        component.addImportedVariable(new ImportedVariable("facet-n.prop1", true, false));
        component.addImportedVariable(new ImportedVariable("facet-n.prop2", false, false));
        Instance instance = new Instance("inst").component(component);
        Set prefixes = VariableHelpers.findPrefixesForMandatoryImportedVariables((Instance)instance);
        Assert.assertEquals((int)2, (int)prefixes.size());
        Assert.assertTrue((boolean)prefixes.contains("comp"));
        Assert.assertTrue((boolean)prefixes.contains("facet-n"));
        component.importedVariables.clear();
        prefixes = VariableHelpers.findPrefixesForMandatoryImportedVariables((Instance)instance);
        Assert.assertEquals((int)0, (int)prefixes.size());
    }

    @Test
    public void testUpdateNetworkVariables() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("comp.ip", "");
        map.put("ip", "");
        map.put("not-ip", "");
        String ip = "127.0.0.1";
        VariableHelpers.updateNetworkVariables(map, (String)"127.0.0.1");
        Assert.assertEquals((String)"127.0.0.1", (String)((String)map.get("comp.ip")));
        Assert.assertEquals((String)"127.0.0.1", (String)((String)map.get("ip")));
        Assert.assertEquals((String)"", (String)((String)map.get("not-ip")));
    }
}

