/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.File;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.internal.tests.TestApplicationTemplate;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.utils.IconUtils;
import net.roboconf.core.utils.Utils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class IconUtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testFindMimeType() {
        Assert.assertEquals((String)"application/octet-stream", (String)IconUtils.findMimeType((File)new File("toto.mp4")));
        Assert.assertEquals((String)"image/gif", (String)IconUtils.findMimeType((File)new File("toto.gif")));
        Assert.assertEquals((String)"image/jpeg", (String)IconUtils.findMimeType((File)new File("toto.jpg")));
        Assert.assertEquals((String)"image/jpeg", (String)IconUtils.findMimeType((File)new File("toto.jpEg")));
        Assert.assertEquals((String)"image/png", (String)IconUtils.findMimeType((File)new File("toto.png")));
        Assert.assertEquals((String)"image/svg+xml", (String)IconUtils.findMimeType((File)new File("toto.svg")));
    }

    @Test
    public void testEncodeAndDecode() {
        String name = "app";
        String qualifier = null;
        Assert.assertEquals((String)"", (String)IconUtils.encodeIconUrl((String)name, qualifier, null));
        File iconFile = new File("whatever.jpg");
        String path = IconUtils.encodeIconUrl((String)name, qualifier, (File)iconFile);
        Assert.assertEquals((String)"/app/whatever.jpg", (String)path);
        Map.Entry entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertEquals((String)name, (String)((String)entry.getKey()));
        Assert.assertNull(qualifier, entry.getValue());
        name = "app2";
        qualifier = "";
        path = IconUtils.encodeIconUrl((String)name, (String)qualifier, (File)iconFile);
        entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertEquals((String)name, (String)((String)entry.getKey()));
        Assert.assertNull((String)qualifier, entry.getValue());
        name = "app2";
        qualifier = "v2";
        path = IconUtils.encodeIconUrl((String)name, (String)qualifier, (File)iconFile);
        Assert.assertEquals((String)"/app2/v2/whatever.jpg", (String)path);
        entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertEquals((String)name, (String)((String)entry.getKey()));
        Assert.assertEquals((String)qualifier, (String)((String)entry.getValue()));
    }

    @Test
    public void testDecodeUrl() {
        String path = "/app/qualifier/img.jpg";
        Map.Entry entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertEquals((String)"app", (String)((String)entry.getKey()));
        Assert.assertEquals((String)"qualifier", (String)((String)entry.getValue()));
        path = "app/qualifier/img.jpg";
        entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertEquals((String)"app", (String)((String)entry.getKey()));
        Assert.assertEquals((String)"qualifier", (String)((String)entry.getValue()));
        path = "app/qualifier/oops/";
        entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertEquals((String)"app", (String)((String)entry.getKey()));
        Assert.assertEquals((String)"qualifier", (String)((String)entry.getValue()));
        path = "/app/qualifier/oops/";
        entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertEquals((String)"app", (String)((String)entry.getKey()));
        Assert.assertEquals((String)"qualifier", (String)((String)entry.getValue()));
        path = "app/qualifier/oops.jpg/whatever";
        entry = IconUtils.decodeIconUrl((String)path);
        Assert.assertNull(entry.getKey());
        Assert.assertNull(entry.getValue());
    }

    @Test
    public void testFindIcon_app() throws Exception {
        File appDir = this.folder.newFolder();
        File descDir = new File(appDir, "descriptor");
        Assert.assertTrue((boolean)descDir.mkdirs());
        File trickFile = new File(descDir, "directory.jpg");
        Assert.assertTrue((boolean)trickFile.mkdirs());
        Application app = new Application("app", (ApplicationTemplate)new TestApplicationTemplate()).directory(appDir);
        Assert.assertNull((Object)IconUtils.findIcon((AbstractApplication)app));
        File singleJpgFile = new File(descDir, "whatever.jpg");
        Assert.assertTrue((boolean)singleJpgFile.createNewFile());
        Assert.assertEquals((Object)singleJpgFile, (Object)IconUtils.findIcon((AbstractApplication)app));
        File defaultFile = new File(descDir, "application.sVg");
        Assert.assertTrue((boolean)defaultFile.createNewFile());
        Assert.assertEquals((Object)defaultFile, (Object)IconUtils.findIcon((AbstractApplication)app));
    }

    @Test
    public void testFindIcon_tpl() throws Exception {
        File appDir = this.folder.newFolder();
        ApplicationTemplate tpl = new ApplicationTemplate("app").qualifier("v1").directory(appDir);
        File descDir = new File(appDir, "descriptor");
        Assert.assertTrue((boolean)descDir.mkdirs());
        File trickFile = new File(descDir, "file.txt");
        Assert.assertTrue((boolean)trickFile.createNewFile());
        Assert.assertNull((Object)IconUtils.findIcon((AbstractApplication)tpl));
        File singleJpgFile = new File(descDir, "whatever.jpg");
        Assert.assertTrue((boolean)singleJpgFile.createNewFile());
        Assert.assertEquals((Object)singleJpgFile, (Object)IconUtils.findIcon((AbstractApplication)tpl));
        File defaultFile = new File(descDir, "application.sVg");
        Assert.assertTrue((boolean)defaultFile.createNewFile());
        Assert.assertEquals((Object)defaultFile, (Object)IconUtils.findIcon((AbstractApplication)tpl));
        Assert.assertNull((Object)IconUtils.findIcon((AbstractApplication)new ApplicationTemplate("app").qualifier("")));
        Assert.assertNull((Object)IconUtils.findIcon((AbstractApplication)new ApplicationTemplate("app").qualifier("")));
        Assert.assertNull((Object)IconUtils.findIcon((AbstractApplication)new ApplicationTemplate("app").qualifier("v2")));
    }

    @Test
    public void testFindIconUrl() throws Exception {
        ApplicationTemplate tpl = new ApplicationTemplate("tpl").qualifier("v1").directory(this.folder.newFolder());
        File descDir = new File(tpl.getDirectory(), "descriptor");
        Assert.assertTrue((boolean)descDir.mkdirs());
        Assert.assertTrue((boolean)new File(descDir, "tp.jpg").createNewFile());
        Application app = new Application("app", tpl).directory(this.folder.newFolder());
        descDir = new File(app.getDirectory(), "descriptor");
        Assert.assertTrue((boolean)descDir.mkdirs());
        Assert.assertTrue((boolean)new File(descDir, "whatever.jpg").createNewFile());
        Assert.assertEquals((String)"/tpl/v1/tp.jpg", (String)IconUtils.findIconUrl((AbstractApplication)tpl));
        Assert.assertEquals((String)"/app/whatever.jpg", (String)IconUtils.findIconUrl((AbstractApplication)app));
        Utils.deleteFilesRecursively((File[])new File[]{descDir});
        Assert.assertEquals((String)"", (String)IconUtils.findIconUrl((AbstractApplication)app));
    }

    @Test
    public void testFindIcon_nullConfigDirectory() throws Exception {
        ApplicationTemplate tpl = new ApplicationTemplate("app").qualifier("v1");
        Assert.assertNull((Object)IconUtils.findIcon((AbstractApplication)tpl));
    }
}

