/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.util.Properties;
import junit.framework.Assert;
import net.roboconf.core.utils.ManifestUtils;
import org.junit.Test;

public class ManifestUtilsTest {
    @Test
    public void testFindBundleVersion() {
        Assert.assertNull((Object)ManifestUtils.findBundleVersion());
        Properties props = new Properties();
        Assert.assertNull((Object)ManifestUtils.findBundleVersion((Properties)props));
        String version = "1.2";
        props.put("bundle-version", version);
        Assert.assertEquals((String)version, (String)ManifestUtils.findBundleVersion((Properties)props));
    }

    @Test
    public void testFindMavenVersion() {
        Assert.assertEquals((String)"0.4", (String)ManifestUtils.findMavenVersion((String)"0.4"));
        Assert.assertEquals((String)"0.4", (String)ManifestUtils.findMavenVersion((String)"0.4.0"));
        Assert.assertEquals((String)"0.4.1", (String)ManifestUtils.findMavenVersion((String)"0.4.1"));
        Assert.assertEquals((String)"0.4-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"0.4.0-SNAPSHOT"));
        Assert.assertEquals((String)"0.4.1-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"0.4.1-SNAPSHOT"));
        Assert.assertEquals((String)"0.4-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"0.4.SNAPSHOT"));
        Assert.assertEquals((String)"0.4-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"0.4.0.SNAPSHOT"));
        Assert.assertEquals((String)"0.4.1-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"0.4.1.SNAPSHOT"));
        Assert.assertEquals((String)"12.52", (String)ManifestUtils.findMavenVersion((String)"12.52.0"));
        Assert.assertEquals((String)"12.52-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"12.52.0-SNAPSHOT"));
        Assert.assertEquals((String)"12.52.1-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"12.52.1-SNAPSHOT"));
        Assert.assertEquals((String)"12.52.1-SNAPSHOT", (String)ManifestUtils.findMavenVersion((String)"12.52.1-snapshoT"));
        Assert.assertEquals((String)"0.4.0.1", (String)ManifestUtils.findMavenVersion((String)"0.4.0.1"));
        Assert.assertEquals((String)"whatever", (String)ManifestUtils.findMavenVersion((String)"whatever"));
        Assert.assertEquals((String)"", (String)ManifestUtils.findMavenVersion((String)""));
        Assert.assertNull((Object)ManifestUtils.findMavenVersion(null));
    }
}

