/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.dsl.parsing.AbstractBlockHolder;
import net.roboconf.core.dsl.parsing.BlockFacet;
import net.roboconf.core.dsl.parsing.BlockProperty;
import net.roboconf.core.dsl.parsing.FileDefinition;
import net.roboconf.core.utils.ModelUtils;
import org.junit.Test;

public class ModelUtilsTest {
    @Test
    public void testGetPropertyValue() {
        FileDefinition def = new FileDefinition(null);
        BlockFacet holder = new BlockFacet(def);
        holder.getInnerBlocks().add(new BlockProperty(def, "name", "value"));
        holder.getInnerBlocks().add(new BlockProperty(def, "address", null));
        holder.getInnerBlocks().add(new BlockProperty(def, "age", "30"));
        holder.getInnerBlocks().add(new BlockProperty(def, "alias", ""));
        Assert.assertEquals((String)"value", (String)ModelUtils.getPropertyValue((AbstractBlockHolder)holder, (String)"name"));
        Assert.assertEquals((String)"30", (String)ModelUtils.getPropertyValue((AbstractBlockHolder)holder, (String)"age"));
        Assert.assertEquals((String)"", (String)ModelUtils.getPropertyValue((AbstractBlockHolder)holder, (String)"alias"));
        Assert.assertNull((Object)ModelUtils.getPropertyValue((AbstractBlockHolder)holder, (String)"address"));
        Assert.assertNull((Object)ModelUtils.getPropertyValue((AbstractBlockHolder)holder, (String)"oops"));
    }

    @Test
    public void testGetPropertyValues() {
        FileDefinition def = new FileDefinition(null);
        BlockFacet holder = new BlockFacet(def);
        holder.getInnerBlocks().add(new BlockProperty(def, "names", "value1, value2 , value3, value 4  "));
        holder.getInnerBlocks().add(new BlockProperty(def, "address", null));
        holder.getInnerBlocks().add(new BlockProperty(def, "age", "30"));
        holder.getInnerBlocks().add(new BlockProperty(def, "alias", ""));
        List values = ModelUtils.getPropertyValues((AbstractBlockHolder)holder, (String)"names");
        Assert.assertEquals((int)4, (int)values.size());
        Assert.assertEquals((String)"value1", (String)((String)values.get(0)));
        Assert.assertEquals((String)"value2", (String)((String)values.get(1)));
        Assert.assertEquals((String)"value3", (String)((String)values.get(2)));
        Assert.assertEquals((String)"value 4", (String)((String)values.get(3)));
        values = ModelUtils.getPropertyValues((AbstractBlockHolder)holder, (String)"age");
        Assert.assertEquals((int)1, (int)values.size());
        Assert.assertEquals((String)"30", (String)((String)values.get(0)));
        values = ModelUtils.getPropertyValues((AbstractBlockHolder)holder, (String)"alias");
        Assert.assertEquals((int)0, (int)values.size());
        values = ModelUtils.getPropertyValues((AbstractBlockHolder)holder, (String)"address");
        Assert.assertEquals((int)0, (int)values.size());
        values = ModelUtils.getPropertyValues((AbstractBlockHolder)holder, (String)"oops");
        Assert.assertEquals((int)0, (int)values.size());
    }

    @Test
    public void testGetExportedVariables() {
        String holderName = "facet-name";
        FileDefinition def = new FileDefinition(null);
        BlockFacet holder = new BlockFacet(def);
        holder.setName(holderName);
        BlockProperty prop = new BlockProperty(def, "exports", "");
        holder.getInnerBlocks().add(prop);
        String varName1 = "var1";
        prop.setValue("var1");
        Map map = ModelUtils.getExportedVariables((AbstractBlockHolder)holder);
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertTrue((boolean)map.containsKey(varName1));
        Assert.assertNull(map.get(varName1));
        prop.setValue("var1 = 5");
        map = ModelUtils.getExportedVariables((AbstractBlockHolder)holder);
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((String)"5", (String)((String)map.get(varName1)));
        prop.setValue("var1=5");
        map = ModelUtils.getExportedVariables((AbstractBlockHolder)holder);
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((String)"5", (String)((String)map.get(varName1)));
        prop.setValue("var1= 5895");
        map = ModelUtils.getExportedVariables((AbstractBlockHolder)holder);
        Assert.assertEquals((int)1, (int)map.size());
        Assert.assertEquals((String)"5895", (String)((String)map.get(varName1)));
        String varName2 = "var2";
        prop.setValue("var1, var2");
        map = ModelUtils.getExportedVariables((AbstractBlockHolder)holder);
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertTrue((boolean)map.containsKey(varName1));
        Assert.assertTrue((boolean)map.containsKey(varName2));
        Assert.assertNull(map.get(varName1));
        Assert.assertNull(map.get(varName2));
        prop.setValue("var1, var2 = 587");
        map = ModelUtils.getExportedVariables((AbstractBlockHolder)holder);
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertTrue((boolean)map.containsKey(varName1));
        Assert.assertNull(map.get(varName1));
        Assert.assertEquals((String)"587", (String)((String)map.get(varName2)));
        prop.setValue("var1 = abc, var2 = 587");
        map = ModelUtils.getExportedVariables((AbstractBlockHolder)holder);
        Assert.assertEquals((int)2, (int)map.size());
        Assert.assertEquals((String)"abc", (String)((String)map.get(varName1)));
        Assert.assertEquals((String)"587", (String)((String)map.get(varName2)));
    }
}

