/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.logging.Logger;
import junit.framework.Assert;
import net.roboconf.core.utils.ProgramUtils;
import org.junit.Assume;
import org.junit.Test;

public class ProgramUtilsTest {
    @Test
    public void testNonNullMap_Windows() throws Exception {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        Assume.assumeTrue((boolean)isWin);
        ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("cmd", "/C", "dir"), null, new HashMap(0));
    }

    @Test
    public void testNonNullMap_UnixFamily() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUnix = osName.contains("linux") || osName.contains("unix") || osName.contains("freebsd");
        Assume.assumeTrue((boolean)isUnix);
        ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("/bin/sh", "-c", "pwd"), null, new HashMap(0));
    }

    @Test
    public void testNonEmptyMap_Windows() throws Exception {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        Assume.assumeTrue((boolean)isWin);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(null, "null key");
        map.put("null value", null);
        map.put("key", "value");
        ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("cmd", "/C", "dir"), null, map);
    }

    @Test
    public void testNonEmptyMap_UnixFamily() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUnix = osName.contains("linux") || osName.contains("unix") || osName.contains("freebsd");
        Assume.assumeTrue((boolean)isUnix);
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(null, "null key");
        map.put("null value", null);
        map.put("key", "value");
        ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("/bin/sh", "-c", "pwd"), null, map);
    }

    @Test
    public void testNullMap_Windows() throws Exception {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        Assume.assumeTrue((boolean)isWin);
        ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("cmd", "/C", "dir"), null, null);
    }

    @Test
    public void testNullMap_UnixFamily() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUnix = osName.contains("linux") || osName.contains("unix") || osName.contains("freebsd");
        Assume.assumeTrue((boolean)isUnix);
        ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("/bin/sh", "-c", "pwd"), null, null);
    }

    @Test
    public void testExecutionFailure_Windows() throws Exception {
        boolean isWin = System.getProperty("os.name").toLowerCase().contains("win");
        Assume.assumeTrue((boolean)isWin);
        int exitCode = ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("help"), null, null);
        Assert.assertNotSame((Object)0, (Object)exitCode);
    }

    @Test
    public void testExecutionFailure_UnixFamily() throws Exception {
        String osName = System.getProperty("os.name").toLowerCase();
        boolean isUnix = osName.contains("linux") || osName.contains("unix") || osName.contains("freebsd");
        Assume.assumeTrue((boolean)isUnix);
        int exitCode = ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("/bin/sh", "-c", "apt-get-update"), null, new HashMap(0));
        Assert.assertNotSame((Object)0, (Object)exitCode);
    }

    @Test(expected=IOException.class)
    public void testInvalidCommand() throws Exception {
        ProgramUtils.executeCommand((Logger)Logger.getLogger(this.getClass().getName()), Arrays.asList("whatever"), null, null);
    }
}

