/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.File;
import java.util.Map;
import junit.framework.Assert;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.ResourceUtils;
import net.roboconf.core.utils.Utils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class ResourceUtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testFindInstanceResourcesDirectory_success() throws Exception {
        File appDir = this.folder.newFolder();
        Component c1 = new Component("c1");
        Component c2 = new Component("c2");
        File expectedFile = new File(appDir, "graph" + File.separator + c1.getName());
        Assert.assertEquals((Object)expectedFile, (Object)ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)c1));
        Assert.assertNotSame((Object)expectedFile, (Object)ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)c2));
        c2.extendComponent(c1);
        Assert.assertEquals((Object)expectedFile, (Object)ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)c2));
        Instance instance = new Instance("whatever").component(c2);
        Assert.assertEquals((Object)expectedFile, (Object)ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Instance)instance));
    }

    @Test
    public void testFindInstanceResourcesDirectory_withCycle() throws Exception {
        File appDir = this.folder.newFolder();
        Component c1 = new Component("c1");
        Component c2 = new Component("c2");
        Component c3 = new Component("c3");
        c1.extendComponent(c2);
        c2.extendComponent(c3);
        c3.extendComponent(c1);
        Assert.assertFalse((boolean)ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)c1).exists());
        Assert.assertFalse((boolean)ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)c2).exists());
        Assert.assertFalse((boolean)ResourceUtils.findInstanceResourcesDirectory((File)appDir, (Component)c3).exists());
        Map map = ResourceUtils.storeInstanceResources((File)appDir, (Instance)new Instance("i").component(c3));
        Assert.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testStoreInstanceResources_inexistingDirectory() throws Exception {
        Instance instance = new Instance("whatever").component(new Component("comp"));
        Map map = ResourceUtils.storeInstanceResources((File)new File("file/does/not/exist"), (Instance)instance);
        Assert.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testStoreInstanceResources_notADirectory() throws Exception {
        File appDir = this.folder.newFolder();
        String componentName = "my-component";
        File componentDirectory = new File(appDir, "graph" + File.separator + "my-component");
        Assert.assertTrue((boolean)componentDirectory.getParentFile().mkdirs());
        Assert.assertTrue((boolean)componentDirectory.createNewFile());
        Instance instance = new Instance("whatever").component(new Component("my-component"));
        Map map = ResourceUtils.storeInstanceResources((File)appDir, (Instance)instance);
        Assert.assertEquals((int)0, (int)map.size());
    }

    @Test
    public void testStoreInstanceResources() throws Exception {
        File appDir = this.folder.newFolder();
        String componentName = "my-component";
        File componentDirectory = new File(appDir, "graph" + File.separator + "my-component");
        Assert.assertTrue((boolean)componentDirectory.mkdirs());
        Instance instance = new Instance("whatever").component(new Component("my-component"));
        Map map = ResourceUtils.storeInstanceResources((File)appDir, (Instance)instance);
        Assert.assertEquals((int)0, (int)map.size());
        File recipeFile = new File(componentDirectory, "recipe.txt");
        Assert.assertTrue((boolean)recipeFile.createNewFile());
        map = ResourceUtils.storeInstanceResources((File)appDir, (Instance)instance);
        Assert.assertEquals((int)1, (int)map.size());
        File autonomicDir = new File(appDir, "autonomic");
        Assert.assertTrue((boolean)autonomicDir.mkdir());
        File propertiesFile = new File(autonomicDir, "my-component.measures.properties");
        Assert.assertTrue((boolean)propertiesFile.createNewFile());
        map = ResourceUtils.storeInstanceResources((File)appDir, (Instance)instance);
        Assert.assertEquals((int)1, (int)map.size());
        File measuresFile = new File(autonomicDir, "my-component.measures");
        Assert.assertTrue((boolean)measuresFile.createNewFile());
        map = ResourceUtils.storeInstanceResources((File)appDir, (Instance)instance);
        Assert.assertEquals((int)3, (int)map.size());
        Utils.deleteFilesRecursively((File[])new File[]{propertiesFile});
        map = ResourceUtils.storeInstanceResources((File)appDir, (Instance)instance);
        Assert.assertEquals((int)2, (int)map.size());
    }
}

