/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import junit.framework.Assert;
import net.roboconf.core.utils.UriUtils;
import org.junit.Test;

public class UriUtilsTest {
    @Test
    public void testUrlToUri_1() throws Exception {
        URL url = new URL("http://roboconf.net");
        Assert.assertEquals((Object)url.toURI(), (Object)UriUtils.urlToUri((URL)url));
    }

    @Test
    public void testUrlToUri_2() throws Exception {
        URL url = new URL("http://url.com/some%20folder");
        Assert.assertEquals((Object)url.toURI(), (Object)UriUtils.urlToUri((URL)url));
    }

    @Test
    public void testUrlToUri_3() throws Exception {
        URL url = new URL("http://url.com/some folder");
        Assert.assertEquals((Object)new URI("http://url.com/some%20folder"), (Object)UriUtils.urlToUri((URL)url));
    }

    @Test
    public void testUrlToUri_4() throws Exception {
        String url = "http://roboconf.net";
        Assert.assertEquals((Object)new URI(url), (Object)UriUtils.urlToUri((String)url));
    }

    @Test
    public void testUrlToUri_5() throws Exception {
        String url = "http://url.com/some%20folder";
        Assert.assertEquals((Object)new URI(url), (Object)UriUtils.urlToUri((String)url));
    }

    @Test
    public void testUrlToUri_6() throws Exception {
        String url = "http://url.com/some folder";
        Assert.assertEquals((Object)new URI("http://url.com/some%20folder"), (Object)UriUtils.urlToUri((String)url));
    }

    @Test(expected=URISyntaxException.class)
    public void testUrlToUri_exception1() throws Exception {
        String url = "http://url with spaces.com";
        UriUtils.urlToUri((String)url);
    }

    @Test(expected=URISyntaxException.class)
    public void testUrlToUri_exception2() throws Exception {
        String url = "http://url with two:dots.com";
        UriUtils.urlToUri((String)url);
    }

    @Test
    public void testBuildNewURI_1() throws Exception {
        String suffix = "http://absolute-url.fr";
        Assert.assertEquals((Object)new URI(suffix), (Object)UriUtils.buildNewURI(null, (String)suffix));
    }

    @Test
    public void testBuildNewURI_2() throws Exception {
        String url = "http://absolute-url.fr/";
        String suffix = "readme.txt";
        Assert.assertEquals((Object)new URI(url + suffix), (Object)UriUtils.buildNewURI((URI)new URI(url), (String)suffix));
    }

    @Test
    public void testBuildNewURI_3() throws Exception {
        String url = "http://absolute-url.fr";
        String suffix = "/readme.txt";
        Assert.assertEquals((Object)new URI(url + suffix), (Object)UriUtils.buildNewURI((URI)new URI(url), (String)suffix));
    }

    @Test
    public void testBuildNewURI_4() throws Exception {
        String url = "http://absolute-url.fr";
        String suffix = "readme.txt";
        Assert.assertEquals((Object)new URI(url + "/" + suffix), (Object)UriUtils.buildNewURI((URI)new URI(url), (String)suffix));
    }

    @Test
    public void testBuildNewURI_5() throws Exception {
        String url = "http://absolute-url.fr/folder";
        String suffix = "readme.txt";
        Assert.assertEquals((Object)new URI(url + "/" + suffix), (Object)UriUtils.buildNewURI((URI)new URI(url), (String)suffix));
    }

    @Test
    public void testBuildNewURI_6() throws Exception {
        String url = "http://absolute-url.fr/folder";
        String suffix = "../readme.txt";
        Assert.assertEquals((Object)new URI("http://absolute-url.fr/readme.txt"), (Object)UriUtils.buildNewURI((URI)new URI(url), (String)suffix));
    }

    @Test
    public void testBuildNewURI_7() throws Exception {
        String url = "http://absolute-url.fr/folder";
        String suffix = "./readme.txt";
        Assert.assertEquals((Object)new URI("http://absolute-url.fr/folder/readme.txt"), (Object)UriUtils.buildNewURI((URI)new URI(url), (String)suffix));
    }

    @Test
    public void testBuildNewURI_8() throws Exception {
        String url = "http://absolute-url.fr/folder";
        String suffix = "f1/f2/f3/readme.txt";
        Assert.assertEquals((Object)new URI("http://absolute-url.fr/folder/f1/f2/f3/readme.txt"), (Object)UriUtils.buildNewURI((URI)new URI(url), (String)suffix));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBuildNewURI_9() throws Exception {
        UriUtils.buildNewURI((URI)new URI("http://absolute-url.fr/folder"), null);
    }

    @Test(expected=URISyntaxException.class)
    public void testBuildNewURI_10() throws Exception {
        String url = "http://absolute-url.fr/folder";
        String suffix = ":f1/readme.txt";
        UriUtils.buildNewURI((URI)new URI(url), (String)suffix);
    }
}

