/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.core.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import junit.framework.Assert;
import net.roboconf.core.internal.tests.TestUtils;
import net.roboconf.core.utils.Utils;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class UtilsTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Test
    public void testDeleteFilesRecursively() {
        String[] dirs;
        File tmpDir = new File(System.getProperty("java.io.tmpdir"), UUID.randomUUID().toString());
        if (!tmpDir.mkdir()) {
            Assert.fail((String)"Could not create a temporary directory.");
        }
        for (String dir : dirs = new String[]{"dir1", "dir1/dir2", "dir1/dir2/dir3", "dir1/dir2/dir4", "dir2", "dir1/dir54"}) {
            File f = new File(tmpDir, dir);
            if (f.mkdir()) continue;
            Assert.fail((String)("Could not create a sub-directory: " + dir));
        }
        String[] files = new String[]{"test.txt", "te.txt", "dir1/test.txt", "dir2/some.txt", "dir1/dir2/dir3/pol.txt"};
        try {
            for (String file : files) {
                File f = new File(tmpDir, file);
                if (f.createNewFile()) continue;
                Assert.fail((String)("Could not create a file: " + file));
            }
        }
        catch (IOException e) {
            Assert.fail((String)("Could not create a file. " + e.getMessage()));
        }
        Assert.assertTrue((boolean)tmpDir.exists());
        try {
            Utils.deleteFilesRecursively((File[])new File[]{tmpDir});
            Assert.assertFalse((String)("Temp directory could not be deleted: " + tmpDir.getName()), (boolean)tmpDir.exists());
        }
        catch (IOException e) {
            Assert.fail((String)"Failed to delete the temporary directory.");
        }
        try {
            Utils.deleteFilesRecursively((File[])new File[]{null});
        }
        catch (IOException e) {
            Assert.fail((String)"Null file must be supported");
        }
        try {
            Utils.deleteFilesRecursively((File[])null);
        }
        catch (IOException e) {
            Assert.fail((String)"Null file array must be supported");
        }
        try {
            File[] nullFiles = new File[]{null, null};
            Utils.deleteFilesRecursively((File[])nullFiles);
        }
        catch (IOException e) {
            Assert.fail((String)"Array of null files must be supported");
        }
        try {
            Utils.deleteFilesRecursively((File[])new File[]{new File("inexisting-file")});
        }
        catch (IOException e) {
            Assert.fail((String)"Inexisting files must be supported");
        }
        Utils.deleteFilesRecursivelyAndQuietly((File[])new File[]{new File("another-inexisting-file")});
    }

    @Test
    public void testCopyStreamSafely() throws Exception {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream("toto".getBytes());
        Utils.copyStreamSafely((InputStream)in, (ByteArrayOutputStream)os);
        Assert.assertEquals((String)"toto", (String)os.toString("UTF-8"));
    }

    @Test
    public void testSplitNicely() {
        List result = Utils.splitNicely((String)"once, upon, a , time   ", (String)",");
        Assert.assertEquals((int)4, (int)result.size());
        Assert.assertEquals((String)"once", (String)((String)result.get(0)));
        Assert.assertEquals((String)"upon", (String)((String)result.get(1)));
        Assert.assertEquals((String)"a", (String)((String)result.get(2)));
        Assert.assertEquals((String)"time", (String)((String)result.get(3)));
        result = Utils.splitNicely((String)"once \n\n, upon, a , time \n  ", (String)"\n");
        Assert.assertEquals((int)4, (int)result.size());
        Assert.assertEquals((String)"once", (String)((String)result.get(0)));
        Assert.assertEquals((String)"", (String)((String)result.get(1)).trim());
        Assert.assertEquals((String)", upon, a , time", (String)((String)result.get(2)));
        Assert.assertEquals((String)"", (String)((String)result.get(3)).trim());
        result = Utils.splitNicely((String)"once $ $a$ $$ time", (String)"$");
        Assert.assertEquals((int)6, (int)result.size());
        Assert.assertEquals((String)"once", (String)((String)result.get(0)));
        Assert.assertEquals((String)"", (String)((String)result.get(1)).trim());
        Assert.assertEquals((String)"a", (String)((String)result.get(2)));
        Assert.assertEquals((String)"", (String)((String)result.get(3)).trim());
        Assert.assertEquals((String)"", (String)((String)result.get(4)).trim());
        Assert.assertEquals((String)"time", (String)((String)result.get(5)));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSplitNicely_illegalArgument_1() {
        Utils.splitNicely((String)"once, upon, a , time   ", (String)"");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSplitNicely_illegalArgument_2() {
        Utils.splitNicely((String)"once, upon, a , time   ", null);
    }

    @Test
    public void testWriteStringInto() throws Exception {
        File f = this.folder.newFile();
        String content = "whatever\n\thop   ";
        Utils.writeStringInto((String)content, (File)f);
        Assert.assertEquals((String)content, (String)Utils.readFileContent((File)f));
    }

    @Test
    public void testIsEmptyOrWhitespaces() {
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces(null));
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)""));
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)"   "));
        Assert.assertTrue((boolean)Utils.isEmptyOrWhitespaces((String)" \n  \t"));
        Assert.assertFalse((boolean)Utils.isEmptyOrWhitespaces((String)" a\n  \t"));
        Assert.assertFalse((boolean)Utils.isEmptyOrWhitespaces((String)"b"));
    }

    @Test
    public void testExpandString() {
        Assert.assertEquals((String)"toto", (String)Utils.expandTemplate((String)"toto", null));
        Properties params = new Properties();
        Assert.assertEquals((String)"toto", (String)Utils.expandTemplate((String)"toto", (Properties)params));
        params.setProperty("firstname", "James");
        params.setProperty("lastname", "Bond");
        String tmpl = "My name is {{lastname}}, {{ firstname }} {{ lastname }}!";
        Assert.assertEquals((String)"My name is Bond, James Bond!", (String)Utils.expandTemplate((String)tmpl, (Properties)params));
        tmpl = "This is an {{ unknown }} parameter";
        Assert.assertEquals((String)tmpl, (String)Utils.expandTemplate((String)tmpl, (Properties)params));
    }

    @Test
    public void testExtractZipArchive() throws Exception {
        File zipFile = this.folder.newFile("roboconf_test.zip");
        Map<String, String> entryToContent = TestUtils.buildZipContent();
        TestUtils.createZipFile(entryToContent, zipFile);
        TestUtils.compareZipContent(zipFile, entryToContent);
        File existingDirectory = this.folder.newFolder(new String[]{"roboconf_test"});
        Assert.assertTrue((boolean)existingDirectory.exists());
        Assert.assertEquals((int)0, (int)Utils.listAllFiles((File)existingDirectory).size());
        Utils.extractZipArchive((File)zipFile, (File)existingDirectory);
        Assert.assertNotSame((Object)0, (Object)Utils.listAllFiles((File)existingDirectory).size());
        Map fileToContent = Utils.storeDirectoryResourcesAsString((File)existingDirectory);
        for (Map.Entry entry : fileToContent.entrySet()) {
            Assert.assertTrue((boolean)entryToContent.containsKey(entry.getKey()));
            String value = entryToContent.remove(entry.getKey());
            Assert.assertEquals((String)((String)entry.getValue()), (String)value);
        }
        for (Map.Entry<Object, Object> entry : entryToContent.entrySet()) {
            Assert.assertNull((String)((String)entry.getKey()), (Object)entry.getValue());
        }
    }

    @Test
    public void testExtractZipArchive_withOptions() throws Exception {
        File zipFile = this.folder.newFile("roboconf_test.zip");
        Map<String, String> entryToContent = TestUtils.buildZipContent();
        TestUtils.createZipFile(entryToContent, zipFile);
        TestUtils.compareZipContent(zipFile, entryToContent);
        File existingDirectory = this.folder.newFolder(new String[]{"roboconf_test"});
        Assert.assertTrue((boolean)existingDirectory.exists());
        Assert.assertEquals((int)0, (int)Utils.listAllFiles((File)existingDirectory).size());
        String pattern = "graph/.*";
        Utils.extractZipArchive((File)zipFile, (File)existingDirectory, (String)"graph/.*", (String)"graph/");
        Assert.assertNotSame((Object)0, (Object)Utils.listAllFiles((File)existingDirectory).size());
        Map fileToContent = Utils.storeDirectoryResourcesAsString((File)existingDirectory);
        Assert.assertEquals((int)3, (int)fileToContent.size());
        for (Map.Entry entry : fileToContent.entrySet()) {
            Assert.assertTrue((boolean)entryToContent.containsKey("graph/" + (String)entry.getKey()));
            String value = entryToContent.remove("graph/" + (String)entry.getKey());
            Assert.assertEquals((String)((String)entry.getValue()), (String)value);
        }
    }

    @Test
    public void testExtractZipArchive_withOptions_invalidPrefix() throws Exception {
        File zipFile = this.folder.newFile("roboconf_test.zip");
        Map<String, String> entryToContent = TestUtils.buildZipContent();
        TestUtils.createZipFile(entryToContent, zipFile);
        TestUtils.compareZipContent(zipFile, entryToContent);
        File existingDirectory = this.folder.newFolder(new String[]{"roboconf_test"});
        Assert.assertTrue((boolean)existingDirectory.exists());
        Assert.assertEquals((int)0, (int)Utils.listAllFiles((File)existingDirectory).size());
        String pattern = "graph/.*";
        Utils.extractZipArchive((File)zipFile, (File)existingDirectory, (String)"graph/.*", (String)"invalid/");
        Assert.assertEquals((int)3, (int)Utils.listAllFiles((File)existingDirectory).size());
        Map fileToContent = Utils.storeDirectoryResourcesAsString((File)existingDirectory);
        for (Map.Entry entry : fileToContent.entrySet()) {
            Assert.assertTrue((boolean)entryToContent.containsKey(entry.getKey()));
            String value = entryToContent.remove(entry.getKey());
            Assert.assertEquals((String)((String)entry.getValue()), (String)value);
        }
    }

    @Test
    public void testExtractZipArchive_inexistingDirectory() throws Exception {
        File zipFile = this.folder.newFile("roboconf_test.zip");
        Map<String, String> entryToContent = TestUtils.buildZipContent();
        TestUtils.createZipFile(entryToContent, zipFile);
        File unexistingDirectory = this.folder.newFolder(new String[]{"roboconf_test"});
        if (!unexistingDirectory.delete()) {
            throw new IOException("Failed to delete a directory.");
        }
        Assert.assertFalse((boolean)unexistingDirectory.exists());
        Utils.extractZipArchive((File)zipFile, (File)unexistingDirectory);
        Assert.assertTrue((boolean)unexistingDirectory.exists());
        Assert.assertNotSame((Object)0, (Object)Utils.listAllFiles((File)unexistingDirectory).size());
        Map fileToContent = Utils.storeDirectoryResourcesAsString((File)unexistingDirectory);
        for (Map.Entry entry : fileToContent.entrySet()) {
            Assert.assertTrue((boolean)entryToContent.containsKey(entry.getKey()));
            String value = entryToContent.remove(entry.getKey());
            Assert.assertEquals((String)((String)entry.getValue()), (String)value);
        }
        for (Map.Entry<Object, Object> entry : entryToContent.entrySet()) {
            Assert.assertNull((String)((String)entry.getKey()), (Object)entry.getValue());
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExtractZipArchive_illegalArgument_1() throws Exception {
        File existingFile = new File(System.getProperty("java.io.tmpdir"));
        Utils.extractZipArchive((File)new File("file-that-does-not.exists"), (File)existingFile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExtractZipArchive_illegalArgument_2() throws Exception {
        File existingFile = new File(System.getProperty("java.io.tmpdir"));
        Utils.extractZipArchive(null, (File)existingFile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExtractZipArchive_illegalArgument_3() throws Exception {
        File existingFile = new File(System.getProperty("java.io.tmpdir"));
        Utils.extractZipArchive((File)existingFile, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExtractZipArchive_illegalArgument_4() throws Exception {
        File existingFile = new File(System.getProperty("java.io.tmpdir"));
        File unexistingFile = new File(existingFile, UUID.randomUUID().toString());
        Assert.assertFalse((boolean)unexistingFile.exists());
        Utils.extractZipArchive((File)existingFile, (File)unexistingFile);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExtractZipArchive_illegalArgument_5() throws Exception {
        File tempZip = this.folder.newFile("roboconf_test_zip.zip");
        File tempFile = this.folder.newFile("roboconf_test.txt");
        Utils.extractZipArchive((File)tempZip, (File)tempFile);
    }

    @Test
    public void testCreateDirectory() throws Exception {
        File dir = this.folder.newFolder();
        File target = new File(dir, "toto/pom");
        Utils.createDirectory((File)target);
        Assert.assertTrue((boolean)target.exists());
    }

    @Test(expected=IOException.class)
    public void testCreateDirectory_error() throws Exception {
        File dir = this.folder.newFolder();
        File target = new File(dir, "toto/pom");
        Assert.assertTrue((boolean)target.getParentFile().createNewFile());
        Utils.createDirectory((File)target);
    }

    @Test
    public void testCloseQuietly() throws Exception {
        ByteArrayInputStream in = null;
        Utils.closeQuietly(in);
        in = new ByteArrayInputStream(new byte[0]);
        Utils.closeQuietly((InputStream)in);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Utils.closeQuietly((OutputStream)out);
        out = null;
        Utils.closeQuietly((OutputStream)out);
        CharArrayReader reader = null;
        Utils.closeQuietly(reader);
        reader = new CharArrayReader(new char[0]);
        Utils.closeQuietly((Reader)reader);
        StringWriter writer = null;
        Utils.closeQuietly(writer);
        writer = new StringWriter();
        Utils.closeQuietly((Writer)writer);
    }

    @Test
    public void testCloseQuietly_silentInput() throws Exception {
        InputStream in = new InputStream(){

            @Override
            public int read() throws IOException {
                return 0;
            }

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        Utils.closeQuietly((InputStream)in);
    }

    @Test
    public void testCloseQuietly_silentOutput() throws Exception {
        OutputStream out = new OutputStream(){

            @Override
            public void write(int b) throws IOException {
            }

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        Utils.closeQuietly((OutputStream)out);
    }

    @Test
    public void testCloseQuietly_silentReader() throws Exception {
        Reader reader = new Reader(){

            @Override
            public int read(char[] cbuf, int off, int len) throws IOException {
                return 0;
            }

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        Utils.closeQuietly((Reader)reader);
    }

    @Test
    public void testCloseQuietly_silentWriter() throws Exception {
        Writer writer = new Writer(){

            @Override
            public void write(char[] arg0, int arg1, int arg2) throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                throw new IOException();
            }
        };
        Utils.closeQuietly((Writer)writer);
    }

    @Test
    public void testWriteException() {
        String msg = "Hello from Roboconf.";
        String stackTrace = Utils.writeException((Exception)new Exception(msg));
        Assert.assertTrue((boolean)stackTrace.contains(msg));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testComputeFileRelativeLocation_failure_notASubFile() {
        File rootDir = new File(System.getProperty("java.io.tmpdir"), "does-not-exist");
        Utils.computeFileRelativeLocation((File)rootDir, (File)new File("invalid-path"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testComputeFileRelativeLocation_failure_sameFile() {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        Utils.computeFileRelativeLocation((File)rootDir, (File)rootDir);
    }

    @Test
    public void testComputeFileRelativeLocation_success() {
        File rootDir = new File(System.getProperty("java.io.tmpdir"));
        File directChildFile = new File(rootDir, "woo.txt");
        Assert.assertEquals((String)directChildFile.getName(), (String)Utils.computeFileRelativeLocation((File)rootDir, (File)directChildFile));
        String indirectChildPath = "dir1/dir2/script.sh";
        File indirectChildFile = new File(rootDir, indirectChildPath);
        Assert.assertEquals((String)indirectChildPath, (String)Utils.computeFileRelativeLocation((File)rootDir, (File)indirectChildFile));
    }

    @Test
    public void testListAllFiles() throws Exception {
        String[] paths;
        File tempDir = this.folder.newFolder(new String[]{"roboconf_test"});
        for (String path : paths = new String[]{"dir1", "dir2", "dir1/dir3"}) {
            if (new File(tempDir, path).mkdir()) continue;
            throw new IOException("Failed to create " + path);
        }
        for (String path : paths = new String[]{"dir1/toto.txt", "dir2/script.sh", "dir1/dir3/smart.png"}) {
            if (new File(tempDir, path).createNewFile()) continue;
            throw new IOException("Failed to create " + path);
        }
        List files = Utils.listAllFiles((File)tempDir);
        Assert.assertEquals((int)3, (int)files.size());
        for (String path : paths) {
            Assert.assertTrue((String)path, (boolean)files.contains(new File(tempDir, path)));
        }
    }

    @Test
    public void testListAllFilesAndDirectories() throws Exception {
        String[] paths;
        File tempDir = this.folder.newFolder(new String[]{"roboconf_test"});
        for (String path : paths = new String[]{"dir1", "dir2", "dir1/dir3", "dir4"}) {
            if (new File(tempDir, path).mkdir()) continue;
            throw new IOException("Failed to create " + path);
        }
        for (String path : paths = new String[]{"dir1/toto.txt", "dir2/script.sh", "dir1/dir3/smart.png"}) {
            if (new File(tempDir, path).createNewFile()) continue;
            throw new IOException("Failed to create " + path);
        }
        List files = Utils.listAllFiles((File)tempDir, (boolean)true);
        Assert.assertEquals((int)8, (int)files.size());
        for (String path : paths) {
            Assert.assertTrue((String)path, (boolean)files.contains(new File(tempDir, path)));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListAllFiles_inexistingFile() throws Exception {
        Utils.listAllFiles((File)new File("not/existing/file"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testListAllFiles_invalidParameter() throws Exception {
        Utils.listAllFiles((File)this.folder.newFile("roboconf.txt"));
    }

    @Test
    public void testFilesListingAreSortedAlphabetically() {
        ArrayList<File> list = new ArrayList<File>();
        list.add(new File("a/toto"));
        list.add(new File("a/zorro"));
        list.add(new File("d/toto"));
        list.add(new File("c/arbitrary"));
        Assert.assertEquals((String)"toto", (String)((File)list.get(0)).getName());
        Assert.assertEquals((String)"zorro", (String)((File)list.get(1)).getName());
        Assert.assertEquals((String)"toto", (String)((File)list.get(2)).getName());
        Assert.assertEquals((String)"arbitrary", (String)((File)list.get(3)).getName());
        Collections.sort(list, new Utils.FileNameComparator());
        Assert.assertEquals((String)"arbitrary", (String)((File)list.get(0)).getName());
        Assert.assertEquals((String)"toto", (String)((File)list.get(1)).getName());
        Assert.assertEquals((String)"toto", (String)((File)list.get(2)).getName());
        Assert.assertEquals((String)"zorro", (String)((File)list.get(3)).getName());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreDirectoryResourcesAsBytes_illegalArgument_1() throws Exception {
        Utils.storeDirectoryResourcesAsBytes((File)new File("not/existing/file"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testStoreDirectoryResourcesAsBytes_illegalArgument_2() throws Exception {
        Utils.storeDirectoryResourcesAsBytes((File)this.folder.newFile("roboconf.txt"));
    }

    @Test
    public void testIsAncestorFile() throws Exception {
        File parent = new File("home/toto/whatever");
        Assert.assertTrue((boolean)Utils.isAncestorFile((File)parent, (File)parent));
        File comp = new File("home/toto/whatever/");
        Assert.assertTrue((boolean)Utils.isAncestorFile((File)parent, (File)comp));
        comp = new File("home/toto/./whatever/");
        Assert.assertTrue((boolean)Utils.isAncestorFile((File)parent, (File)comp));
        comp = new File("home/toto/../toto/whatever/");
        Assert.assertTrue((boolean)Utils.isAncestorFile((File)parent, (File)comp));
        comp = new File("home/toto/whatever/some-file.txt");
        Assert.assertTrue((boolean)Utils.isAncestorFile((File)parent, (File)comp));
        comp = new File("home/toto/whatever/some/dir/some-file.txt");
        Assert.assertTrue((boolean)Utils.isAncestorFile((File)parent, (File)comp));
        comp = new File("home/toto/");
        Assert.assertFalse((boolean)Utils.isAncestorFile((File)parent, (File)comp));
        comp = new File("home/toto/whateve");
        Assert.assertFalse((boolean)Utils.isAncestorFile((File)parent, (File)comp));
        comp = new File("home/toto/whatevereeeeeee");
        Assert.assertFalse((boolean)Utils.isAncestorFile((File)parent, (File)comp));
    }

    @Test
    public void testCopyDirectory_existingTarget() throws Exception {
        File source = this.folder.newFolder();
        File dir1 = new File(source, "lol/whatever/sub");
        Assert.assertTrue((boolean)dir1.mkdirs());
        File dir2 = new File(source, "sub");
        Assert.assertTrue((boolean)dir2.mkdirs());
        Utils.copyStream((InputStream)new ByteArrayInputStream(",kklmsdff sdfl sdfkkl".getBytes("UTF-8")), (File)new File(dir1, "f1"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), (File)new File(dir1, "f2"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sd".getBytes("UTF-8")), (File)new File(dir1, "f3"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sd\ndsfg".getBytes("UTF-8")), (File)new File(source, "f"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sd\ndsfg".getBytes("UTF-8")), (File)new File(dir2, "f1"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sdf df fg".getBytes("UTF-8")), (File)new File(dir2, "f45678"));
        File target = this.folder.newFolder();
        Assert.assertEquals((int)0, (int)Utils.listAllFiles((File)target).size());
        Utils.copyDirectory((File)source, (File)target);
        Assert.assertEquals((int)6, (int)Utils.listAllFiles((File)target).size());
    }

    @Test
    public void testCopyDirectory_inexistingTarget() throws Exception {
        File source = this.folder.newFolder();
        File dir1 = new File(source, "lol/whatever/sub/many/more/");
        Assert.assertTrue((boolean)dir1.mkdirs());
        File dir2 = new File(source, "sub");
        Assert.assertTrue((boolean)dir2.mkdirs());
        Utils.copyStream((InputStream)new ByteArrayInputStream(",kklmsdff sdfl sdfkkl".getBytes("UTF-8")), (File)new File(dir1, "f1"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), (File)new File(dir1, "f2"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sd".getBytes("UTF-8")), (File)new File(dir1, "f3"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sd\ndsfg".getBytes("UTF-8")), (File)new File(source, "f"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sd\ndsfg".getBytes("UTF-8")), (File)new File(dir2, "f1"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("".getBytes("UTF-8")), (File)new File(dir2, "f4"));
        Utils.copyStream((InputStream)new ByteArrayInputStream("sdf df fg".getBytes("UTF-8")), (File)new File(dir2, "f45678"));
        File target = new File(this.folder.newFolder(), "some");
        Assert.assertFalse((boolean)target.exists());
        Utils.copyDirectory((File)source, (File)target);
        Assert.assertTrue((boolean)target.exists());
        Assert.assertEquals((int)7, (int)Utils.listAllFiles((File)target).size());
    }

    @Test
    public void testLogException() {
        final StringBuffer sb = new StringBuffer();
        Logger logger = Logger.getLogger(this.getClass().getName());
        logger.setLevel(Level.FINEST);
        logger.addHandler(new Handler(){

            @Override
            public void close() throws SecurityException {
            }

            @Override
            public void flush() {
            }

            @Override
            public void publish(LogRecord record) {
                sb.append(record.getMessage());
            }
        });
        Assert.assertEquals((String)"", (String)sb.toString());
        Utils.logException((Logger)logger, (Exception)new Exception("boo!"));
        Assert.assertTrue((boolean)sb.toString().startsWith("java.lang.Exception: boo!"));
        logger.setLevel(Level.INFO);
        Assert.assertFalse((boolean)logger.isLoggable(Level.FINEST));
        Assert.assertTrue((boolean)logger.isLoggable(Level.INFO));
        sb.delete(0, sb.length());
        Assert.assertEquals((String)"", (String)sb.toString());
        Utils.logException((Logger)logger, (Exception)new Exception("boo!"));
        Assert.assertEquals((String)"", (String)sb.toString());
        Utils.logException((Logger)logger, (Level)Level.INFO, (Exception)new Exception("boo!"));
        Assert.assertTrue((boolean)sb.toString().startsWith("java.lang.Exception: boo!"));
    }

    @Test
    public void testFindUrlAndPort() throws Exception {
        Map.Entry entry = Utils.findUrlAndPort((String)"http://localhost");
        Assert.assertEquals((String)"http://localhost", (String)((String)entry.getKey()));
        Assert.assertEquals((int)-1, (int)((Integer)entry.getValue()));
        entry = Utils.findUrlAndPort((String)"http://localhost:9989");
        Assert.assertEquals((String)"http://localhost", (String)((String)entry.getKey()));
        Assert.assertEquals((int)9989, (int)((Integer)entry.getValue()));
        entry = Utils.findUrlAndPort((String)"http://roboconf.net/some/arbitrary/path");
        Assert.assertEquals((String)"http://roboconf.net/some/arbitrary/path", (String)((String)entry.getKey()));
        Assert.assertEquals((int)-1, (int)((Integer)entry.getValue()));
        entry = Utils.findUrlAndPort((String)"http://roboconf.net:2727/some/arbitrary/path");
        Assert.assertEquals((String)"http://roboconf.net/some/arbitrary/path", (String)((String)entry.getKey()));
        Assert.assertEquals((int)2727, (int)((Integer)entry.getValue()));
        File f = new File(System.getProperty("java.io.tmpdir"));
        entry = Utils.findUrlAndPort((String)f.toURI().toString());
        Assert.assertEquals((Object)f.toURI(), (Object)new URI((String)entry.getKey()));
        Assert.assertEquals((int)-1, (int)((Integer)entry.getValue()));
        entry = Utils.findUrlAndPort((String)"ftp://some.host.com:4811/path");
        Assert.assertEquals((String)"ftp://some.host.com/path", (String)((String)entry.getKey()));
        Assert.assertEquals((int)4811, (int)((Integer)entry.getValue()));
    }

    @Test
    public void testCapitalize() {
        Assert.assertEquals((String)"", (String)Utils.capitalize((String)""));
        Assert.assertNull((Object)Utils.capitalize(null));
        Assert.assertEquals((String)"Toto", (String)Utils.capitalize((String)"Toto"));
        Assert.assertEquals((String)"Toto", (String)Utils.capitalize((String)"tOTo"));
        Assert.assertEquals((String)"Toto oops", (String)Utils.capitalize((String)"tOTo oops"));
    }

    @Test
    public void testDirectoryFileFilter() throws Exception {
        Utils.DirectoryFileFilter filter = new Utils.DirectoryFileFilter();
        Assert.assertTrue((boolean)filter.accept(this.folder.newFolder()));
        Assert.assertFalse((boolean)filter.accept(this.folder.newFile()));
        Assert.assertFalse((boolean)filter.accept(new File("inexisting")));
    }

    @Test
    public void testListDirectories() throws Exception {
        File root = new File("inexisting");
        Assert.assertEquals((int)0, (int)Utils.listDirectories((File)root).size());
        root = this.folder.newFolder();
        Assert.assertEquals((int)0, (int)Utils.listDirectories((File)root).size());
        Assert.assertTrue((boolean)new File(root, "toto.txt").createNewFile());
        Assert.assertTrue((boolean)new File(root, "dir").mkdir());
        Assert.assertTrue((boolean)new File(root, "dir/dir1").mkdir());
        List directories = Utils.listDirectories((File)root);
        Assert.assertEquals((int)1, (int)directories.size());
        Assert.assertEquals((String)"dir", (String)((File)directories.get(0)).getName());
    }

    @Test
    public void testReadPropertiesFileQuietly() throws Exception {
        File f = this.folder.newFile();
        Utils.writeStringInto((String)"prop: op", (File)f);
        Logger logger = Logger.getLogger(this.getClass().getName());
        Properties props = Utils.readPropertiesFileQuietly((File)f, (Logger)logger);
        Assert.assertEquals((int)1, (int)props.size());
        Assert.assertEquals((Object)"op", (Object)props.get("prop"));
        props = Utils.readPropertiesFileQuietly((File)new File("inexisting"), (Logger)logger);
        Assert.assertEquals((int)0, (int)props.size());
    }
}

