/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.swagger.models.Contact;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Operation;
import io.swagger.models.Path;
import io.swagger.models.Response;
import io.swagger.models.Swagger;
import io.swagger.models.Tag;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.util.Json;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.EventType;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.rest.commons.beans.WebSocketMessage;
import net.roboconf.dm.rest.commons.json.JSonBindingUtils;
import net.roboconf.swagger.UpdateSwaggerJson;

public class GenerateSwaggerJsonForWebSockets {
    private static final String INSTANCE = "instance";
    private static final String APPLICATION = "application";
    private static final String APPLICATION_TEMPLATE = "applicationTemplate";
    private static final String TEXT = "text";
    static final Map<String, String> NAME_TO_DESC = new TreeMap<String, String>();
    static final Map<String, String> NAME_TO_PARAM = new HashMap<String, String>();

    public static void main(String[] args) {
        try {
            new GenerateSwaggerJsonForWebSockets().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(5);
        }
    }

    public void run(String[] args) throws Exception {
        File baseDirectory = null;
        if (args.length != 2 || !(baseDirectory = new File(args[0])).exists()) {
            throw new RuntimeException("The path of the module's directory was expected as an argument.");
        }
        File f = new File(baseDirectory, "target/docs/apidocs/ui/swagger-websocket.json");
        this.generate(args[1], f);
    }

    void generate(String roboconfVersion, File jsonFile) throws Exception {
        Swagger swagger = new Swagger();
        swagger.setBasePath("/roboconf-dm-websocket");
        swagger.setHost("localhost:8181");
        Tag tag = new Tag();
        tag.setName("FromServer");
        swagger.setTags(Arrays.asList(tag));
        Contact contact = new Contact();
        contact.setName("the Roboconf team");
        contact.setUrl("http://roboconf.net");
        License license = new License();
        license.setUrl("http://www.apache.org/licenses/LICENSE-2.0.txt");
        license.setName("The Apache Software License, Version 2.0");
        Info info = new Info();
        info.setContact(contact);
        info.setLicense(license);
        info.setVersion(roboconfVersion);
        info.setTitle("Web Socket API");
        info.setDescription("The Web Socket API for Roboconf's Administration");
        swagger.setInfo(info);
        HashMap<String, Path> paths = new HashMap<String, Path>(NAME_TO_DESC.size());
        swagger.setPaths(paths);
        for (Map.Entry<String, String> entry : NAME_TO_DESC.entrySet()) {
            ModelImpl model = new ModelImpl();
            model.setType("object");
            model.setTitle(entry.getKey());
            swagger.addDefinition("json_" + entry.getKey(), (Model)model);
            Operation operation = new Operation();
            operation.setDescription(entry.getValue());
            operation.setSummary(entry.getValue());
            operation.setTags(Arrays.asList(tag.getName()));
            operation.setOperationId(entry.getKey());
            operation.setProduces(Arrays.asList("application/json"));
            Response response = new Response();
            response.setDescription(NAME_TO_PARAM.get(entry.getKey()));
            RefProperty schema = new RefProperty();
            schema.set$ref("json_" + entry.getKey());
            response.setSchema((Property)schema);
            operation.addResponse("default", response);
            Path path = new Path();
            path.setPost(operation);
            paths.put(entry.getKey(), path);
        }
        String swaggerJson = Json.pretty().writeValueAsString((Object)swagger);
        Map<String, String> definitions = this.prepareNewDefinitions();
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonTree = jsonParser.parse(swaggerJson);
        for (Map.Entry<String, String> entry : NAME_TO_DESC.entrySet()) {
            String serialization = definitions.get(entry.getKey());
            JsonElement serializationAsJson = jsonParser.parse(serialization);
            jsonTree.getAsJsonObject().get("definitions").getAsJsonObject().get("json_" + entry.getKey()).getAsJsonObject().add("example", serializationAsJson);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        swaggerJson = gson.toJson(jsonTree);
        Utils.writeStringInto((String)swaggerJson, (File)jsonFile);
    }

    public Map<String, String> prepareNewDefinitions() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        ObjectMapper mapper = JSonBindingUtils.createObjectMapper();
        StringWriter writer = new StringWriter();
        Application app = UpdateSwaggerJson.newTestApplication();
        Instance tomcat = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/tomcat-vm/tomcat-server");
        Objects.requireNonNull(tomcat);
        WebSocketMessage msg = new WebSocketMessage(tomcat, app, EventType.CHANGED);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)msg);
        result.put(INSTANCE, writer.toString());
        msg = new WebSocketMessage(app, EventType.CREATED);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)msg);
        result.put(APPLICATION, writer.toString());
        msg = new WebSocketMessage(app.getTemplate(), EventType.DELETED);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)msg);
        result.put(APPLICATION_TEMPLATE, writer.toString());
        msg = new WebSocketMessage("A text message.");
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)msg);
        result.put(TEXT, writer.toString());
        return result;
    }

    static {
        NAME_TO_DESC.put(INSTANCE, "Internal method invoked when an instance is created, deleted or modified.");
        NAME_TO_DESC.put(APPLICATION, "Internal method invoked when an application is created, deleted or modified.");
        NAME_TO_DESC.put(APPLICATION_TEMPLATE, "Internal method invoked when an application template is created, deleted or modified.");
        NAME_TO_DESC.put(TEXT, "Internal method invoked when a raw text message must be propagated.");
        StringBuilder sb = new StringBuilder();
        sb.append("The instance that was created, deleted or modified, as well as the context.\n");
        sb.append("The context includes the application the instance belongs to.\n");
        sb.append("It also includes the event type: CREATED, DELETED, CHANGED.\n");
        NAME_TO_PARAM.put(INSTANCE, sb.toString());
        sb = new StringBuilder();
        sb.append("The application that was created, deleted or modified, as well as the context.");
        sb.append("The context includes the event type: CREATED, DELETED, CHANGED.\n");
        NAME_TO_PARAM.put(APPLICATION, sb.toString());
        sb = new StringBuilder();
        sb.append("The application template that was created, deleted or modified, as well as the context.\n");
        sb.append("The context includes the event type: CREATED, DELETED, CHANGED.\n");
        NAME_TO_PARAM.put(APPLICATION_TEMPLATE, sb.toString());
        sb = new StringBuilder();
        sb.append("The message that was pushed directly from the DM.\n");
        NAME_TO_PARAM.put(TEXT, sb.toString());
    }
}

