/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.swagger;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import net.roboconf.core.model.beans.AbstractApplication;
import net.roboconf.core.model.beans.AbstractType;
import net.roboconf.core.model.beans.Application;
import net.roboconf.core.model.beans.ApplicationTemplate;
import net.roboconf.core.model.beans.Component;
import net.roboconf.core.model.beans.ExportedVariable;
import net.roboconf.core.model.beans.Graphs;
import net.roboconf.core.model.beans.ImportedVariable;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.model.runtime.Preference;
import net.roboconf.core.model.runtime.ScheduledJob;
import net.roboconf.core.model.runtime.TargetUsageItem;
import net.roboconf.core.model.runtime.TargetWrapperDescriptor;
import net.roboconf.core.utils.Utils;
import net.roboconf.dm.rest.commons.Diagnostic;
import net.roboconf.dm.rest.commons.beans.TargetAssociation;
import net.roboconf.dm.rest.commons.json.JSonBindingUtils;

public class UpdateSwaggerJson {
    final Set<Class<?>> processedClasses = new HashSet();

    public static void main(String[] args) {
        try {
            new UpdateSwaggerJson().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(3);
        }
    }

    public void run(String[] args) throws Exception {
        File baseDirectory = null;
        if (args.length != 1 || !(baseDirectory = new File(args[0])).exists()) {
            throw new RuntimeException("The path of the module's directory was expected as an argument.");
        }
        UpdateSwaggerJson updater = new UpdateSwaggerJson();
        JsonObject newDef = updater.prepareNewDefinitions();
        updater.updateSwaggerJson(baseDirectory, newDef);
    }

    public JsonObject prepareNewDefinitions() throws IOException {
        ObjectMapper mapper = JSonBindingUtils.createObjectMapper();
        StringWriter writer = new StringWriter();
        JsonObject newDef = new JsonObject();
        Application app = UpdateSwaggerJson.newTestApplication();
        app.bindWithApplication("externalExportPrefix1", "application 1");
        app.bindWithApplication("externalExportPrefix1", "application 2");
        app.bindWithApplication("externalExportPrefix2", "application 3");
        app.setName("My Application with special ch\u00e0r\u00e0cters");
        app.getTemplate().externalExports.put("internalGraphVariable", "variableAlias");
        app.getTemplate().setExternalExportsPrefix("externalExportPrefix");
        app.getTemplate().setDescription("some description");
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)app);
        String s = writer.toString();
        this.convertToTypes(s, Application.class, newDef);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)app.getTemplate());
        s = writer.toString();
        this.convertToTypes(s, ApplicationTemplate.class, newDef);
        Instance war = InstanceHelpers.findInstanceByPath((AbstractApplication)app, (String)"/tomcat-vm/tomcat-server/hello-world");
        Objects.requireNonNull(war);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)war.getComponent());
        s = writer.toString();
        this.convertToTypes(s, Component.class, newDef);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)war);
        s = writer.toString();
        this.convertToTypes(s, Instance.class, newDef);
        Diagnostic diag = new Diagnostic("/vm1/server1");
        Diagnostic.DependencyInformation di = new Diagnostic.DependencyInformation("facetOrComponentName", true, false);
        diag.getDependenciesInformation().add(di);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)diag);
        s = writer.toString();
        this.convertToTypes(s, Diagnostic.class, newDef);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)di);
        s = writer.toString();
        this.convertToTypes(s, Diagnostic.DependencyInformation.class, newDef);
        TargetWrapperDescriptor twd = new TargetWrapperDescriptor();
        twd.setId("target-id");
        twd.setDescription("some description");
        twd.setHandler("iaas-ec2");
        twd.setName("target name");
        twd.setDefault(true);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)twd);
        s = writer.toString();
        this.convertToTypes(s, TargetWrapperDescriptor.class, newDef);
        TargetUsageItem tui = new TargetUsageItem();
        tui.setName("app or template name");
        tui.setVersion("template qualifier (null for applications)");
        tui.setReferencing(true);
        tui.setUsing(true);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)tui);
        s = writer.toString();
        this.convertToTypes(s, TargetUsageItem.class, newDef);
        TargetAssociation ta = new TargetAssociation("/vm-1", "VM", twd);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)ta);
        s = writer.toString();
        this.convertToTypes(s, TargetAssociation.class, newDef);
        Preference pref = new Preference("key", "value", Preference.PreferenceKeyCategory.AUTONOMIC);
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)pref);
        s = writer.toString();
        this.convertToTypes(s, Preference.class, newDef);
        ScheduledJob job = new ScheduledJob();
        job.setAppName("application name");
        job.setCmdName("command name");
        job.setCron("0 0 12 ? * WED");
        job.setJobId("job-id");
        job.setJobName("job name");
        writer = new StringWriter();
        mapper.writeValue((Writer)writer, (Object)job);
        s = writer.toString();
        this.convertToTypes(s, ScheduledJob.class, newDef);
        return newDef;
    }

    private void updateSwaggerJson(File baseDirectory, JsonObject newDef) throws IOException {
        File f = new File(baseDirectory, "target/docs/apidocs/ui/swagger.json");
        if (!f.exists()) {
            throw new RuntimeException("The swagger.json file was not found.");
        }
        JsonParser jsonParser = new JsonParser();
        String content = Utils.readFileContent((File)f);
        content = content.replaceAll("\"type\"\\s*:\\s*\"file\",?", "");
        content = content.replaceAll("\"type\"\\s*:\\s*\"\",?", "");
        content = content.replaceAll("\"headers\"\\s*:\\s*\\{\\},?", "");
        content = content.replaceAll("\"schema\": \\{\\s*\"description\"\\s*:\\s*\"\"\\s*\\s*},?", "");
        content = content.replaceAll(",\\s+(\n[ \t]+\\})", "$1");
        StringBuilder sb = new StringBuilder();
        sb.append("(\\s*\"items\": \\{\n)");
        sb.append("\\s*\"type\": \"array\",\n");
        sb.append("\\s*\"items\": \\{\n");
        sb.append("(\\s*\"\\$ref\": \"[^\"]+\"\n)");
        sb.append("\\s*\\}");
        content = content.replaceAll(sb.toString(), "$1$2");
        JsonElement jsonTree = jsonParser.parse(content);
        HashSet currentTypes = new HashSet();
        for (Iterator entry : jsonTree.getAsJsonObject().get("definitions").getAsJsonObject().entrySet()) {
            currentTypes.add(entry.getKey());
        }
        HashSet newTypes = new HashSet();
        for (Map.Entry entry : newDef.entrySet()) {
            newTypes.add(entry.getKey());
        }
        currentTypes.removeAll(newTypes);
        for (String s : currentTypes) {
            System.out.println("Type not appearing in the updated swagger definitions: " + s);
        }
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        jsonTree.getAsJsonObject().add("definitions", jsonParser.parse(gson.toJson((JsonElement)newDef)));
        String json = gson.toJson(jsonTree);
        Utils.writeStringInto((String)json, (File)f);
    }

    public void convertToTypes(String serialization, Class<?> clazz, JsonObject newDef) {
        UpdateSwaggerJson.convertToTypes(serialization, clazz.getSimpleName(), newDef);
        this.processedClasses.add(clazz);
    }

    public static void convertToTypes(String serialization, String className, JsonObject newDef) {
        JsonParser jsonParser = new JsonParser();
        JsonElement jsonTree = jsonParser.parse(serialization);
        JsonObject innerObject = new JsonObject();
        innerObject.addProperty("title", className);
        innerObject.addProperty("definition", "");
        innerObject.addProperty("type", jsonTree.isJsonObject() ? "object" : (jsonTree.isJsonArray() ? "array" : "string"));
        innerObject.addProperty("properties", "");
        innerObject.add("example", (JsonElement)jsonTree.getAsJsonObject());
        newDef.add("json_" + className, (JsonElement)innerObject);
    }

    static Application newTestApplication() {
        ApplicationTemplate tpl = new ApplicationTemplate();
        tpl.setName("test-app");
        tpl.setVersion("test");
        Component vmComponent = new Component("vm").installerName("target");
        Instance tomcatVm = new Instance("tomcat-vm").component(vmComponent);
        Instance mySqlVm = new Instance("mysql-vm").component(vmComponent);
        Component tomcatComponent = new Component("tomcat").installerName("puppet");
        Instance tomcat = new Instance("tomcat-server").component(tomcatComponent);
        Component mySqlComponent = new Component("mysql").installerName("puppet");
        mySqlComponent.addExportedVariable(new ExportedVariable("port", "3306"));
        mySqlComponent.addExportedVariable(new ExportedVariable("ip", null));
        Instance mySql = new Instance("mysql-server").component(mySqlComponent);
        Component warComponent = new Component("war").installerName("script");
        warComponent.addExportedVariable(new ExportedVariable("port", "8080"));
        warComponent.addExportedVariable(new ExportedVariable("ip", null));
        warComponent.addImportedVariable(new ImportedVariable("mysql.port", false, false));
        warComponent.addImportedVariable(new ImportedVariable("mysql.ip", false, false));
        Instance war = new Instance("hello-world").component(warComponent);
        InstanceHelpers.insertChild((Instance)tomcatVm, (Instance)tomcat);
        InstanceHelpers.insertChild((Instance)tomcat, (Instance)war);
        InstanceHelpers.insertChild((Instance)mySqlVm, (Instance)mySql);
        vmComponent.addChild((AbstractType)mySqlComponent);
        vmComponent.addChild((AbstractType)tomcatComponent);
        tomcatComponent.addChild((AbstractType)warComponent);
        tpl.setGraphs(new Graphs());
        tpl.getGraphs().getRootComponents().add(vmComponent);
        tpl.getRootInstances().add(mySqlVm);
        tpl.getRootInstances().add(tomcatVm);
        Application app = new Application("test", tpl);
        return app;
    }
}

