/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.swagger;

import io.swagger.models.Swagger;
import io.swagger.parser.SwaggerParser;
import io.swagger.parser.util.SwaggerDeserializationResult;
import java.io.File;
import net.roboconf.swagger.UpdateSwaggerJson;

public class ValidateSwaggerJsonFiles {
    public static void main(String[] args) {
        try {
            new UpdateSwaggerJson().run(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(4);
        }
    }

    public void run(String[] args) throws Exception {
        String[] filesToValidate;
        File baseDirectory = null;
        if (args.length != 1 || !(baseDirectory = new File(args[0])).exists()) {
            throw new RuntimeException("The path of the module's directory was expected as an argument.");
        }
        for (String path : filesToValidate = new String[]{"target/docs-rest-api/apidocs/ui/swagger.json", "target/docs-rest-api/apidocs/ui/swagger-websocket.json"}) {
            File f = new File(baseDirectory, path);
            if (!f.exists()) {
                throw new RuntimeException(path + " was not found.");
            }
            ValidateSwaggerJsonFiles.validate(f);
        }
    }

    static Swagger validate(File jsonFile) throws Exception {
        SwaggerDeserializationResult res = new SwaggerParser().readWithInfo(jsonFile.getAbsolutePath(), null, true);
        if (!res.getMessages().isEmpty()) {
            for (String s : res.getMessages()) {
                System.out.println(s);
            }
            throw new Exception("Errors were found in a Swagger definition: " + jsonFile.getAbsolutePath());
        }
        return res.getSwagger();
    }
}

