/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Request;
import com.amazonaws.handlers.RequestHandler;
import com.amazonaws.http.AmazonHttpClient;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.http.HttpRequest;
import com.amazonaws.metrics.AwsSdkMetrics;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.regions.Region;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AmazonWebServiceClient {
    protected URI endpoint;
    protected ClientConfiguration clientConfiguration;
    protected AmazonHttpClient client;
    protected final List<RequestHandler> requestHandlers;
    protected int timeOffset;

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public AmazonWebServiceClient(ClientConfiguration clientConfiguration, RequestMetricCollector requestMetricCollector) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration, requestMetricCollector);
        this.requestHandlers = new CopyOnWriteArrayList<RequestHandler>();
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.clientConfiguration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            this.endpoint = new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setRegion(Region region) throws IllegalArgumentException {
        if (region == null) {
            throw new IllegalArgumentException("No region provided");
        }
        if (!region.isServiceSupported(this.getServiceAbbreviation())) {
            throw new IllegalArgumentException(this.getServiceAbbreviation() + " isn't supported in region " + region.getName());
        }
        String serviceEndpoint = region.getServiceEndpoint(this.getServiceAbbreviation());
        int protocolIdx = serviceEndpoint.indexOf("://");
        if (protocolIdx >= 0) {
            serviceEndpoint = serviceEndpoint.substring(protocolIdx + "://".length());
        }
        this.setEndpoint(serviceEndpoint);
    }

    protected String getServiceAbbreviation() {
        return "NO_SERVICE_ABBREVIATION_SPECIFIED";
    }

    public void setConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new AmazonHttpClient(clientConfiguration);
    }

    public void shutdown() {
        this.client.shutdown();
    }

    @Deprecated
    protected <T> HttpRequest convertToHttpRequest(Request<T> request, HttpMethodName methodName) {
        HttpRequest httpRequest = new HttpRequest(methodName);
        for (Map.Entry<String, String> parameter : request.getParameters().entrySet()) {
            httpRequest.addParameter(parameter.getKey(), parameter.getValue());
        }
        for (Map.Entry<String, String> parameter : request.getHeaders().entrySet()) {
            httpRequest.addHeader(parameter.getKey(), parameter.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        httpRequest.setOriginalRequest(request.getOriginalRequest());
        return httpRequest;
    }

    public void addRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.add(requestHandler);
    }

    public void removeRequestHandler(RequestHandler requestHandler) {
        this.requestHandlers.remove(requestHandler);
    }

    protected final ExecutionContext createExecutionContext(AmazonWebServiceRequest req) {
        boolean isMetricsEnabled = this.isRequestMetricsEnabled(req) || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandlers, isMetricsEnabled);
    }

    @Deprecated
    protected final ExecutionContext createExecutionContext() {
        boolean isMetricsEnabled = this.isRMCEnabledAtClientOrSdkLevel() || AmazonWebServiceClient.isProfilingEnabled();
        return new ExecutionContext(this.requestHandlers, isMetricsEnabled);
    }

    private static boolean isProfilingEnabled() {
        return System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    private boolean isRequestMetricsEnabled(AmazonWebServiceRequest req) {
        RequestMetricCollector c = req.getRequestMetricCollector();
        if (c != null && c.isEnabled()) {
            return true;
        }
        return this.isRMCEnabledAtClientOrSdkLevel();
    }

    private boolean isRMCEnabledAtClientOrSdkLevel() {
        RequestMetricCollector c = this.requestMetricCollector();
        return c != null && c.isEnabled();
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public AmazonWebServiceClient withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }

    public RequestMetricCollector getRequestMetricsCollector() {
        return this.client.getRequestMetricCollector();
    }

    protected RequestMetricCollector requestMetricCollector() {
        RequestMetricCollector mc = this.client.getRequestMetricCollector();
        return mc == null ? AwsSdkMetrics.getRequestMetricCollector() : mc;
    }
}

