/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.event;

import com.amazonaws.event.ProgressEvent;
import com.amazonaws.event.ProgressListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProgressListenerChain
implements ProgressListener {
    private final List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private static final Log log = LogFactory.getLog(ProgressListenerChain.class);

    public ProgressListenerChain(ProgressListener ... listeners) {
        for (ProgressListener listener : listeners) {
            this.addProgressListener(listener);
        }
    }

    public synchronized void addProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.add(listener);
    }

    public synchronized void removeProgressListener(ProgressListener listener) {
        if (listener == null) {
            return;
        }
        this.listeners.remove(listener);
    }

    public void progressChanged(ProgressEvent progressEvent) {
        for (ProgressListener listener : this.listeners) {
            try {
                listener.progressChanged(progressEvent);
            }
            catch (RuntimeException e) {
                log.warn("Couldn't update progress listener", e);
            }
        }
    }
}

