/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.metrics;

import com.amazonaws.metrics.MetricType;
import com.amazonaws.metrics.RequestMetricCollector;
import com.amazonaws.util.AWSRequestMetrics;
import com.amazonaws.util.jmx.MBeans;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum AwsSdkMetrics {

    public static final String METRICS_NAMESPACE = "AWSSDK/Java";
    private static final String MBEAN_OBJECT_NAME = "com.amazonaws.management:type=" + AwsSdkMetrics.class.getSimpleName();
    public static final String DEFAULT_METRICS_SYSTEM_PROPERTY = "com.amazonaws.sdk.enableDefaultMetrics";
    private static final String DEFAULT_REQUEST_METRIC_COLLECTOR_FACTORY = "com.amazonaws.metrics.internal.cloudwatch.DefaultRequestMetricCollectorFactory";
    private static final boolean defaultMetricsEnabled = System.getProperty("com.amazonaws.sdk.enableDefaultMetrics") != null;
    private static final MetricRegistry registry = new MetricRegistry();
    private static volatile RequestMetricCollector mc;
    private static boolean dirtyEnabling;

    public static <T extends RequestMetricCollector> T getRequestMetricCollector() {
        if (mc == null && AwsSdkMetrics.isDefaultMetricsEnabled()) {
            AwsSdkMetrics.enableDefaultMetrics();
        }
        RequestMetricCollector t = mc == null ? RequestMetricCollector.NONE : mc;
        return (T)t;
    }

    public static synchronized void setRequestMetricCollector(RequestMetricCollector mc) {
        RequestMetricCollector old = AwsSdkMetrics.mc;
        AwsSdkMetrics.mc = mc;
        if (old != null) {
            old.stop();
        }
    }

    public static boolean isDefaultMetricsEnabled() {
        return defaultMetricsEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized boolean enableDefaultMetrics() {
        if (mc == null || !mc.isEnabled()) {
            if (dirtyEnabling) {
                throw new IllegalStateException("Reentrancy is not allowed");
            }
            dirtyEnabling = true;
            try {
                Class<?> c = Class.forName(DEFAULT_REQUEST_METRIC_COLLECTOR_FACTORY);
                RequestMetricCollector.Factory f = (RequestMetricCollector.Factory)c.newInstance();
                RequestMetricCollector instance = f.getInstance();
                if (instance != null) {
                    AwsSdkMetrics.setRequestMetricCollector(instance);
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception e) {
                LogFactory.getLog(AwsSdkMetrics.class).warn("Failed to enable the default metrics", e);
            }
            finally {
                dirtyEnabling = false;
            }
        }
        return false;
    }

    public static void disableMetrics() {
        AwsSdkMetrics.setRequestMetricCollector(RequestMetricCollector.NONE);
    }

    public static boolean add(MetricType type) {
        return registry.addMetricType(type);
    }

    public static <T extends MetricType> boolean addAll(Collection<T> types) {
        return registry.addMetricTypes(types);
    }

    public static boolean remove(MetricType type) {
        return registry.removeMetricType(type);
    }

    public static Set<MetricType> getPredefinedMetrics() {
        return registry.predefinedMetrics();
    }

    static {
        try {
            MBeans.registerMBean(MBEAN_OBJECT_NAME, new Admin());
        }
        catch (Exception ex) {
            LogFactory.getLog(AwsSdkMetrics.class).warn("", ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MetricRegistry {
        private final Set<MetricType> metricTypes = new HashSet<MetricType>();
        private volatile Set<MetricType> readOnly;

        MetricRegistry() {
            this.metricTypes.add(AWSRequestMetrics.Field.ClientExecuteTime);
            this.metricTypes.add(AWSRequestMetrics.Field.HttpRequestTime);
            this.metricTypes.add(AWSRequestMetrics.Field.RequestCount);
            this.metricTypes.add(AWSRequestMetrics.Field.RequestSigningTime);
            this.metricTypes.add(AWSRequestMetrics.Field.ResponseProcessingTime);
            this.metricTypes.add(AWSRequestMetrics.Field.RetryCount);
            this.syncReadOnly();
        }

        private void syncReadOnly() {
            this.readOnly = Collections.unmodifiableSet(new HashSet<MetricType>(this.metricTypes));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean addMetricType(MetricType type) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean added = this.metricTypes.add(type);
                if (added) {
                    this.syncReadOnly();
                }
                return added;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public <T extends MetricType> boolean addMetricTypes(Collection<T> types) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean added = this.metricTypes.addAll(types);
                if (added) {
                    this.syncReadOnly();
                }
                return added;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean removeMetricType(MetricType type) {
            Set<MetricType> set = this.metricTypes;
            synchronized (set) {
                boolean removed = this.metricTypes.remove(type);
                if (removed) {
                    this.syncReadOnly();
                }
                return removed;
            }
        }

        public Set<MetricType> predefinedMetrics() {
            return this.readOnly;
        }
    }

    private static class Admin
    implements AdminMBean {
        private Admin() {
        }

        public boolean enableDefaultMetrics() {
            return AwsSdkMetrics.enableDefaultMetrics();
        }

        public void disableMetrics() {
            AwsSdkMetrics.disableMetrics();
        }

        public String getRequestMetricCollector() {
            RequestMetricCollector mc = mc;
            return mc == null || mc == RequestMetricCollector.NONE ? "NONE" : mc.getClass().getName();
        }

        public boolean isMetricsEnabled() {
            RequestMetricCollector mc = mc;
            return mc != null && mc.isEnabled();
        }
    }

    public static interface AdminMBean {
        public boolean isMetricsEnabled();

        public String getRequestMetricCollector();

        public boolean enableDefaultMetrics();

        public void disableMetrics();
    }
}

