/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.worker;

import com.amazonaws.services.simpleworkflow.flow.worker.BackoffThrottler;
import com.amazonaws.services.simpleworkflow.flow.worker.ExponentialRetryParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SynchronousRetrier {
    private static final Log log = LogFactory.getLog(SynchronousRetrier.class);
    private final ExponentialRetryParameters retryParameters;
    private final Class<?>[] exceptionsToNotRetry;

    public SynchronousRetrier(ExponentialRetryParameters retryParameters, Class<?> ... exceptionsToNotRetry) {
        if (retryParameters.getBackoffCoefficient() < 0.0) {
            throw new IllegalArgumentException("negative backoffCoefficient");
        }
        if (retryParameters.getInitialInterval() < 10L) {
            throw new IllegalArgumentException("initialInterval cannot be less then 10: " + retryParameters.getInitialInterval());
        }
        if (retryParameters.getExpirationInterval() < retryParameters.getInitialInterval()) {
            throw new IllegalArgumentException("expirationInterval < initialInterval");
        }
        if (retryParameters.getMaximumRetries() < retryParameters.getMinimumRetries()) {
            throw new IllegalArgumentException("maximumRetries < minimumRetries");
        }
        this.retryParameters = retryParameters;
        this.exceptionsToNotRetry = exceptionsToNotRetry;
    }

    public ExponentialRetryParameters getRetryParameters() {
        return this.retryParameters;
    }

    public Class<?>[] getExceptionsToNotRetry() {
        return this.exceptionsToNotRetry;
    }

    public void retry(Runnable r) {
        int attempt = 0;
        long startTime = System.currentTimeMillis();
        BackoffThrottler throttler = new BackoffThrottler(this.retryParameters.getInitialInterval(), this.retryParameters.getMaximumRetryInterval(), this.retryParameters.getBackoffCoefficient());
        boolean success = false;
        do {
            try {
                ++attempt;
                throttler.throttle();
                r.run();
                success = true;
                throttler.success();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return;
            }
            catch (RuntimeException e) {
                throttler.failure();
                for (Class<?> exceptionToNotRetry : this.exceptionsToNotRetry) {
                    if (!exceptionToNotRetry.isAssignableFrom(e.getClass())) continue;
                    throw e;
                }
                long elapsed = System.currentTimeMillis() - startTime;
                if (attempt > this.retryParameters.getMaximumRetries() || elapsed >= this.retryParameters.getExpirationInterval() && attempt > this.retryParameters.getMinimumRetries()) {
                    throw e;
                }
                log.warn("Retrying after failure", e);
            }
        } while (!success);
    }
}

