/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.util;

import com.amazonaws.AmazonClientException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ContentLengthValidationInputStream
extends FilterInputStream {
    private long expectedLength;
    private int bytesRead;
    private int mark;

    public ContentLengthValidationInputStream(InputStream in, long expectedLength) {
        super(in);
        this.expectedLength = expectedLength;
        this.bytesRead = 0;
        this.mark = 0;
    }

    public int read() throws IOException {
        int result = super.read();
        if (result != -1) {
            ++this.bytesRead;
        } else {
            this.validate();
        }
        return result;
    }

    public int read(byte[] arg0, int off, int len) throws IOException {
        int result = super.read(arg0, off, len);
        if (result != -1) {
            this.bytesRead += result;
        } else {
            this.validate();
        }
        return result;
    }

    public long skip(long n) throws IOException {
        long result = super.skip(n);
        if (result != -1L) {
            this.bytesRead = (int)((long)this.bytesRead + result);
        }
        return result;
    }

    public synchronized void mark(int readlimit) {
        super.mark(readlimit);
        this.mark = this.bytesRead;
    }

    public synchronized void reset() throws IOException {
        super.reset();
        if (super.markSupported()) {
            this.bytesRead = this.mark;
        }
    }

    private void validate() {
        if (this.expectedLength != (long)this.bytesRead) {
            throw new AmazonClientException("Unable to verify integrity of data download.  Client calculated content length didn't match content length received from Amazon S3.  The data may be corrupt.");
        }
    }
}

