/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.ec2.internal;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonServiceException;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.AmazonEC2Client;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.Placement;
import com.amazonaws.services.ec2.model.RunInstancesRequest;
import com.amazonaws.services.ec2.model.RunInstancesResult;
import com.amazonaws.services.ec2.model.TerminateInstancesRequest;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.roboconf.core.model.helpers.InstanceHelpers;
import net.roboconf.core.userdata.UserDataHelpers;
import net.roboconf.core.utils.Utils;
import net.roboconf.target.api.AbstractThreadedTargetHandler;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.api.TargetHandlerParameters;
import net.roboconf.target.ec2.internal.Ec2MachineConfigurator;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.InstanceManager;
import org.apache.felix.ipojo.Pojo;

public class Ec2IaasHandler
extends AbstractThreadedTargetHandler
implements Pojo {
    InstanceManager __IM;
    public static final String TARGET_ID = "iaas-ec2";
    static final String TPL_VOLUME_NAME = "%NAME%";
    static final String TPL_VOLUME_APP = "%APP%";
    static final String USE_BLOCK_STORAGE = "ec2.use-block-storage";
    static final String VOLUME_MOUNT_POINT_PREFIX = "ec2.ebs-mount-point.";
    static final String VOLUME_NAME_PREFIX = "ec2.ebs-snapshot-id.";
    static final String VOLUME_SIZE_GB_PREFIX = "ec2.ebs-size.";
    static final String VOLUME_DELETE_OT_PREFIX = "ec2.ebs-delete-on-termination.";
    static final String VOLUME_TYPE_PREFIX = "ec2.ebs-type.";
    static final Map<String, String> DEFAULTS = new HashMap<String, String>();
    boolean __MgetTargetId;
    boolean __McreateMachine$net_roboconf_target_api_TargetHandlerParameters;
    boolean __MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String;
    boolean __MprepareEC2RequestNode$java_util_Map$java_lang_String;

    public Ec2IaasHandler() {
        this(null);
    }

    private Ec2IaasHandler(InstanceManager _manager) {
        this._setInstanceManager(_manager);
    }

    public String getTargetId() {
        String string;
        if (!this.__MgetTargetId) {
            return this.__M_getTargetId();
        }
        try {
            this.__IM.onEntry((Object)this, "getTargetId", new Object[0]);
            string = this.__M_getTargetId();
            this.__IM.onExit((Object)this, "getTargetId", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "getTargetId", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_getTargetId() {
        return TARGET_ID;
    }

    public String createMachine(TargetHandlerParameters parameters) throws TargetException {
        String string;
        if (!this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters) {
            return this.__M_createMachine(parameters);
        }
        try {
            this.__IM.onEntry((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", new Object[]{parameters});
            string = this.__M_createMachine(parameters);
            this.__IM.onExit((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "createMachine$net_roboconf_target_api_TargetHandlerParameters", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_createMachine(TargetHandlerParameters parameters) throws TargetException {
        String instanceId;
        this.logger.fine("Creating a new machine on AWS.");
        if (InstanceHelpers.countInstances((String)parameters.getScopedInstancePath()) > 1) {
            throw new TargetException("Only root instances can be passed in arguments.");
        }
        String rootInstanceName = InstanceHelpers.findRootInstancePath((String)parameters.getScopedInstancePath());
        try {
            AmazonEC2 ec2 = Ec2IaasHandler.createEc2Client(parameters.getTargetProperties());
            String userData = UserDataHelpers.writeUserDataAsString((Map)parameters.getMessagingProperties(), (String)parameters.getDomain(), (String)parameters.getApplicationName(), (String)rootInstanceName);
            RunInstancesRequest runInstancesRequest = this.prepareEC2RequestNode(parameters.getTargetProperties(), userData);
            RunInstancesResult runInstanceResult = ec2.runInstances(runInstancesRequest);
            instanceId = runInstanceResult.getReservation().getInstances().get(0).getInstanceId();
        }
        catch (Exception e) {
            this.logger.severe("An error occurred while creating a new machine on EC2. " + e.getMessage());
            throw new TargetException((Throwable)e);
        }
        return instanceId;
    }

    public AbstractThreadedTargetHandler.MachineConfigurator machineConfigurator(TargetHandlerParameters parameters, String machineId) {
        AbstractThreadedTargetHandler.MachineConfigurator machineConfigurator;
        if (!this.__MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_machineConfigurator(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            machineConfigurator = this.__M_machineConfigurator(parameters, machineId);
            this.__IM.onExit((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)machineConfigurator);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return machineConfigurator;
    }

    private AbstractThreadedTargetHandler.MachineConfigurator __M_machineConfigurator(TargetHandlerParameters parameters, String machineId) {
        String rootInstanceName = InstanceHelpers.findRootInstancePath((String)parameters.getScopedInstancePath());
        return new Ec2MachineConfigurator(parameters.getTargetProperties(), machineId, parameters.getApplicationName(), rootInstanceName, parameters.getScopedInstance());
    }

    public boolean isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        boolean bl;
        if (!this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_isMachineRunning(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            bl = this.__M_isMachineRunning(parameters, machineId);
            this.__IM.onExit((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)new Boolean(bl));
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return bl;
    }

    private boolean __M_isMachineRunning(TargetHandlerParameters parameters, String machineId) throws TargetException {
        boolean result = false;
        try {
            AmazonEC2 ec2 = Ec2IaasHandler.createEc2Client(parameters.getTargetProperties());
            DescribeInstancesRequest dis = new DescribeInstancesRequest();
            dis.setInstanceIds(Collections.singletonList(machineId));
            DescribeInstancesResult disresult = ec2.describeInstances(dis);
            result = !disresult.getReservations().isEmpty();
        }
        catch (AmazonServiceException ec2) {
        }
        catch (AmazonClientException e) {
            this.logger.severe("An error occurred while checking whether a machine is running on Amazon EC2. " + e.getMessage());
            throw new TargetException((Throwable)e);
        }
        return result;
    }

    public void terminateMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        if (!this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            this.__M_terminateMachine(parameters, machineId);
            return;
        }
        try {
            this.__IM.onEntry((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            this.__M_terminateMachine(parameters, machineId);
            this.__IM.onExit((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", null);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
    }

    private void __M_terminateMachine(TargetHandlerParameters parameters, String machineId) throws TargetException {
        this.logger.fine("Terminating machine '" + machineId + "'.");
        this.cancelMachineConfigurator(machineId);
        try {
            AmazonEC2 ec2 = Ec2IaasHandler.createEc2Client(parameters.getTargetProperties());
            TerminateInstancesRequest terminateInstancesRequest = new TerminateInstancesRequest();
            terminateInstancesRequest.withInstanceIds(machineId);
            ec2.terminateInstances(terminateInstancesRequest);
        }
        catch (Exception e) {
            this.logger.severe("An error occurred while terminating a machine on Amazon EC2. " + e.getMessage());
            throw new TargetException((Throwable)e);
        }
    }

    public String retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        String string;
        if (!this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String) {
            return this.__M_retrievePublicIpAddress(parameters, machineId);
        }
        try {
            this.__IM.onEntry((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", new Object[]{parameters, machineId});
            string = this.__M_retrievePublicIpAddress(parameters, machineId);
            this.__IM.onExit((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", (Object)string);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String", throwable);
            throw throwable;
        }
        return string;
    }

    private String __M_retrievePublicIpAddress(TargetHandlerParameters parameters, String machineId) throws TargetException {
        String result = null;
        try {
            AmazonEC2 ec2 = Ec2IaasHandler.createEc2Client(parameters.getTargetProperties());
            DescribeInstancesRequest dis = new DescribeInstancesRequest();
            dis.setInstanceIds(Collections.singletonList(machineId));
            DescribeInstancesResult disresult = ec2.describeInstances(dis);
            if (!disresult.getReservations().isEmpty()) {
                result = disresult.getReservations().get(0).getInstances().get(0).getPublicIpAddress();
            }
        }
        catch (AmazonServiceException ec2) {
        }
        catch (Exception e) {
            this.logger.severe("An error occurred while retrieving a public IP address from Amazon EC2. " + e.getMessage());
            throw new TargetException((Throwable)e);
        }
        return result;
    }

    static void parseProperties(Map<String, String> targetProperties) throws TargetException {
        String[] properties;
        for (String property : properties = new String[]{"ec2.endpoint", "ec2.access.key", "ec2.secret.key", "ec2.ami", "ec2.instance.type", "ec2.ssh.key", "ec2.security.group"}) {
            if (!StringUtils.isBlank(targetProperties.get(property))) continue;
            throw new TargetException("The value for " + property + " cannot be null or empty.");
        }
    }

    public static AmazonEC2 createEc2Client(Map<String, String> targetProperties) throws TargetException {
        Ec2IaasHandler.parseProperties(targetProperties);
        BasicAWSCredentials credentials = new BasicAWSCredentials(targetProperties.get("ec2.access.key"), targetProperties.get("ec2.secret.key"));
        AmazonEC2Client ec2 = new AmazonEC2Client(credentials);
        ec2.setEndpoint(targetProperties.get("ec2.endpoint"));
        return ec2;
    }

    private RunInstancesRequest prepareEC2RequestNode(Map<String, String> targetProperties, String userData) throws UnsupportedEncodingException {
        RunInstancesRequest runInstancesRequest;
        if (!this.__MprepareEC2RequestNode$java_util_Map$java_lang_String) {
            return this.__M_prepareEC2RequestNode(targetProperties, userData);
        }
        try {
            this.__IM.onEntry((Object)this, "prepareEC2RequestNode$java_util_Map$java_lang_String", new Object[]{targetProperties, userData});
            runInstancesRequest = this.__M_prepareEC2RequestNode(targetProperties, userData);
            this.__IM.onExit((Object)this, "prepareEC2RequestNode$java_util_Map$java_lang_String", (Object)runInstancesRequest);
        }
        catch (Throwable throwable) {
            this.__IM.onError((Object)this, "prepareEC2RequestNode$java_util_Map$java_lang_String", throwable);
            throw throwable;
        }
        return runInstancesRequest;
    }

    private RunInstancesRequest __M_prepareEC2RequestNode(Map<String, String> targetProperties, String userData) throws UnsupportedEncodingException {
        RunInstancesRequest runInstancesRequest = new RunInstancesRequest();
        String flavor = targetProperties.get("ec2.instance.type");
        if (Utils.isEmptyOrWhitespaces((String)flavor)) {
            flavor = "t1.micro";
        }
        runInstancesRequest.setInstanceType(flavor);
        runInstancesRequest.setImageId(targetProperties.get("ec2.ami"));
        runInstancesRequest.setMinCount(1);
        runInstancesRequest.setMaxCount(1);
        runInstancesRequest.setKeyName(targetProperties.get("ec2.ssh.key"));
        String secGroup = targetProperties.get("ec2.security.group");
        if (Utils.isEmptyOrWhitespaces((String)secGroup)) {
            secGroup = "default";
        }
        runInstancesRequest.setSecurityGroups(Collections.singletonList(secGroup));
        String availabilityZone = targetProperties.get("ec2.availability.zone");
        if (!Utils.isEmptyOrWhitespaces((String)availabilityZone)) {
            runInstancesRequest.setPlacement(new Placement(availabilityZone));
        }
        String encodedUserData = new String(Base64.encodeBase64(userData.getBytes(StandardCharsets.UTF_8)), "UTF-8");
        runInstancesRequest.setUserData(encodedUserData);
        return runInstancesRequest;
    }

    static List<String> findStorageIds(Map<String, String> targetProperties) {
        ArrayList<String> result = new ArrayList<String>();
        String prop = targetProperties.get(USE_BLOCK_STORAGE);
        if (!Utils.isEmptyOrWhitespaces((String)prop)) {
            for (String s : Utils.splitNicely((String)prop, (String)",")) {
                if (Utils.isEmptyOrWhitespaces((String)s)) continue;
                result.add(s);
            }
        }
        return result;
    }

    static String findStorageProperty(Map<String, String> targetProperties, String storageId, String propertyPrefix) {
        String property = propertyPrefix + storageId;
        String value = targetProperties.get(property);
        return Utils.isEmptyOrWhitespaces((String)value) ? DEFAULTS.get(propertyPrefix) : value.trim();
    }

    static String expandVolumeName(String nameTemplate, String appName, String instanceName) {
        if (!Utils.isEmptyOrWhitespaces((String)nameTemplate)) {
            String name = nameTemplate.replace(TPL_VOLUME_NAME, instanceName);
            name = name.replace(TPL_VOLUME_APP, appName);
            name = name.replaceAll("[\\W_-]", "-");
            return name;
        }
        return nameTemplate;
    }

    static {
        DEFAULTS.put(VOLUME_MOUNT_POINT_PREFIX, "/dev/sdf");
        DEFAULTS.put(VOLUME_NAME_PREFIX, "roboconf-%APP%-%NAME%");
        DEFAULTS.put(VOLUME_SIZE_GB_PREFIX, "2");
        DEFAULTS.put(VOLUME_DELETE_OT_PREFIX, "false");
    }

    private void _setInstanceManager(InstanceManager instanceManager) {
        if (instanceManager == null) {
            return;
        }
        this.__IM = instanceManager;
        Set set = this.__IM.getRegistredFields();
        if (set != null) {
            // empty if block
        }
        if ((set = this.__IM.getRegistredMethods()) != null) {
            if (set.contains("getTargetId")) {
                this.__MgetTargetId = true;
            }
            if (set.contains("createMachine$net_roboconf_target_api_TargetHandlerParameters")) {
                this.__McreateMachine$net_roboconf_target_api_TargetHandlerParameters = true;
            }
            if (set.contains("machineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MmachineConfigurator$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("isMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MisMachineRunning$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("terminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MterminateMachine$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("retrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String")) {
                this.__MretrievePublicIpAddress$net_roboconf_target_api_TargetHandlerParameters$java_lang_String = true;
            }
            if (set.contains("prepareEC2RequestNode$java_util_Map$java_lang_String")) {
                this.__MprepareEC2RequestNode$java_util_Map$java_lang_String = true;
            }
        }
    }

    public ComponentInstance getComponentInstance() {
        return this.__IM;
    }
}

