/*
 * Decompiled with CFR 0.152.
 */
package net.roboconf.target.ec2.internal;

import com.amazonaws.services.ec2.AmazonEC2;
import com.amazonaws.services.ec2.model.AssociateAddressRequest;
import com.amazonaws.services.ec2.model.AttachVolumeRequest;
import com.amazonaws.services.ec2.model.CreateTagsRequest;
import com.amazonaws.services.ec2.model.CreateVolumeRequest;
import com.amazonaws.services.ec2.model.CreateVolumeResult;
import com.amazonaws.services.ec2.model.DescribeInstancesRequest;
import com.amazonaws.services.ec2.model.DescribeInstancesResult;
import com.amazonaws.services.ec2.model.DescribeVolumesRequest;
import com.amazonaws.services.ec2.model.DescribeVolumesResult;
import com.amazonaws.services.ec2.model.EbsInstanceBlockDeviceSpecification;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.InstanceBlockDeviceMappingSpecification;
import com.amazonaws.services.ec2.model.ModifyInstanceAttributeRequest;
import com.amazonaws.services.ec2.model.Tag;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.roboconf.core.model.beans.Instance;
import net.roboconf.core.utils.Utils;
import net.roboconf.target.api.AbstractThreadedTargetHandler;
import net.roboconf.target.api.TargetException;
import net.roboconf.target.ec2.internal.Ec2IaasHandler;

public class Ec2MachineConfigurator
implements AbstractThreadedTargetHandler.MachineConfigurator {
    private final Instance scopedInstance;
    private final String machineId;
    private final String tagName;
    private final String applicationName;
    private String availabilityZone;
    private final Map<String, String> targetProperties;
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    private final Map<String, String> storageIdToVolumeId = new HashMap<String, String>();
    private AmazonEC2 ec2Api;
    private State state = State.UNKNOWN_VM;
    private static final int DEFAULT_VOLUME_SIZE = 2;

    public Ec2MachineConfigurator(Map<String, String> targetProperties, String machineId, String applicationName, String rootInstanceName, Instance scopedInstance) {
        this.machineId = machineId;
        this.targetProperties = targetProperties;
        this.applicationName = applicationName;
        this.tagName = applicationName + "." + rootInstanceName;
        this.scopedInstance = scopedInstance;
        this.availabilityZone = targetProperties.get("ec2.availability.zone");
    }

    public Instance getScopedInstance() {
        return this.scopedInstance;
    }

    public void close() throws IOException {
    }

    public boolean configure() throws TargetException {
        if (this.ec2Api == null) {
            this.ec2Api = Ec2IaasHandler.createEc2Client(this.targetProperties);
        }
        if (this.state == State.UNKNOWN_VM && this.checkVmIsKnown()) {
            this.state = State.TAG_VM;
        }
        if (this.state == State.TAG_VM && this.tagResource(this.machineId, this.tagName)) {
            this.state = State.RUNNING_VM;
        }
        if (this.state == State.RUNNING_VM && this.checkVmIsStarted()) {
            this.state = State.ASSOCIATE_ELASTIC_IP;
        }
        if (this.state == State.ASSOCIATE_ELASTIC_IP && this.associateElasticIp()) {
            this.state = State.CREATE_VOLUME;
        }
        if (this.state == State.CREATE_VOLUME) {
            if (!this.volumesRequested()) {
                this.state = State.COMPLETE;
            } else if (this.createOrReuseVolumes()) {
                this.state = State.ATTACH_VOLUME;
            }
        }
        if (this.state == State.ATTACH_VOLUME && this.volumesCreated() && this.attachVolumes()) {
            this.state = State.COMPLETE;
        }
        return this.state == State.COMPLETE;
    }

    private boolean checkVmIsKnown() {
        DescribeInstancesRequest dis = new DescribeInstancesRequest();
        dis.setInstanceIds(Collections.singletonList(this.machineId));
        DescribeInstancesResult disresult = this.ec2Api.describeInstances(dis);
        return disresult.getReservations().size() > 0 && disresult.getReservations().get(0).getInstances().size() > 0;
    }

    private boolean tagResource(String resourceId, String tagName) {
        boolean result = false;
        if (!Utils.isEmptyOrWhitespaces((String)tagName)) {
            Tag tag = new Tag("Name", tagName);
            CreateTagsRequest ctr = new CreateTagsRequest(Collections.singletonList(resourceId), Arrays.asList(tag));
            try {
                this.ec2Api.createTags(ctr);
            }
            catch (Exception e) {
                this.logger.warning("Error tagging resource " + resourceId + " with name=" + tagName + ": " + e);
            }
            result = true;
        }
        return result;
    }

    private boolean associateElasticIp() {
        String elasticIp = this.targetProperties.get("ec2.elastic.ip");
        if (!Utils.isEmptyOrWhitespaces((String)elasticIp)) {
            this.logger.fine("Associating an elastic IP with the instance. IP = " + elasticIp);
            AssociateAddressRequest associateAddressRequest = new AssociateAddressRequest(this.machineId, elasticIp);
            this.ec2Api.associateAddress(associateAddressRequest);
        }
        return true;
    }

    private boolean checkVmIsStarted() {
        DescribeInstancesRequest dis = new DescribeInstancesRequest();
        dis.setInstanceIds(Collections.singletonList(this.machineId));
        DescribeInstancesResult disresult = this.ec2Api.describeInstances(dis);
        this.availabilityZone = disresult.getReservations().get(0).getInstances().get(0).getPlacement().getAvailabilityZone();
        return "running".equalsIgnoreCase(disresult.getReservations().get(0).getInstances().get(0).getState().getName());
    }

    private boolean volumesRequested() {
        return !Utils.isEmptyOrWhitespaces((String)this.targetProperties.get("ec2.use-block-storage"));
    }

    private boolean createOrReuseVolumes() {
        for (String storageId : Ec2IaasHandler.findStorageIds(this.targetProperties)) {
            String nameTemplate = Ec2IaasHandler.findStorageProperty(this.targetProperties, storageId, "ec2.ebs-snapshot-id.");
            String idOrName = Ec2IaasHandler.expandVolumeName(nameTemplate, this.applicationName, this.scopedInstance.getName());
            String volumeSnapshotOrId = this.lookupVolume(idOrName);
            if (volumeSnapshotOrId == null) {
                volumeSnapshotOrId = idOrName;
            }
            int size = 2;
            try {
                size = Integer.parseInt(Ec2IaasHandler.findStorageProperty(this.targetProperties, storageId, "ec2.ebs-size."));
            }
            catch (Exception nfe) {
                size = 2;
            }
            if (size <= 0) {
                size = 2;
            }
            String volumeId = volumeSnapshotOrId != null && this.volumeCreated(volumeSnapshotOrId) ? volumeSnapshotOrId : this.createVolume(storageId, volumeSnapshotOrId, size);
            this.logger.info("Volume " + volumeId + " was successfully created.");
            this.storageIdToVolumeId.put(storageId, volumeId);
        }
        return true;
    }

    private String createVolume(String storageId, String snapshotId, int size) {
        String volumeType = Ec2IaasHandler.findStorageProperty(this.targetProperties, storageId, "ec2.ebs-type.");
        if (volumeType == null) {
            volumeType = "standard";
        }
        CreateVolumeRequest createVolumeRequest = new CreateVolumeRequest().withAvailabilityZone(this.availabilityZone).withVolumeType(volumeType).withSize(size);
        if (!Utils.isEmptyOrWhitespaces((String)snapshotId) && snapshotId.startsWith("snap-")) {
            createVolumeRequest.withSnapshotId(snapshotId);
        }
        CreateVolumeResult createVolumeResult = this.ec2Api.createVolume(createVolumeRequest);
        return createVolumeResult.getVolume().getVolumeId();
    }

    private boolean volumeCreated(String volumeId) {
        DescribeVolumesRequest dvs = new DescribeVolumesRequest();
        ArrayList<String> volumeIds = new ArrayList<String>();
        volumeIds.add(volumeId);
        dvs.setVolumeIds(volumeIds);
        DescribeVolumesResult dvsresult = null;
        try {
            dvsresult = this.ec2Api.describeVolumes(dvs);
        }
        catch (Exception e) {
            dvsresult = null;
        }
        return dvsresult != null && "available".equals(dvsresult.getVolumes().get(0).getState());
    }

    private boolean volumesCreated() {
        for (Map.Entry<String, String> entry : this.storageIdToVolumeId.entrySet()) {
            String volumeId = entry.getValue();
            if (this.volumeCreated(volumeId)) continue;
            return false;
        }
        return true;
    }

    private String lookupVolume(String volumeIdOrName) {
        String ret = null;
        if (!Utils.isEmptyOrWhitespaces((String)volumeIdOrName)) {
            DescribeVolumesRequest dvs = new DescribeVolumesRequest(Collections.singletonList(volumeIdOrName));
            DescribeVolumesResult dvsresult = null;
            try {
                dvsresult = this.ec2Api.describeVolumes(dvs);
            }
            catch (Exception e) {
                dvsresult = null;
            }
            if (dvsresult == null || dvsresult.getVolumes() == null || dvsresult.getVolumes().size() < 1) {
                dvs = new DescribeVolumesRequest().withFilters(new Filter().withName("tag:Name").withValues(volumeIdOrName));
                try {
                    dvsresult = this.ec2Api.describeVolumes(dvs);
                }
                catch (Exception e) {
                    dvsresult = null;
                }
            }
            if (dvsresult != null && dvsresult.getVolumes() != null && dvsresult.getVolumes().size() > 0) {
                ret = dvsresult.getVolumes().get(0).getVolumeId();
            }
        }
        return ret;
    }

    private boolean attachVolumes() {
        for (Map.Entry<String, String> entry : this.storageIdToVolumeId.entrySet()) {
            String volumeId = entry.getValue();
            String storageId = entry.getKey();
            String nameTemplate = Ec2IaasHandler.findStorageProperty(this.targetProperties, storageId, "ec2.ebs-snapshot-id.");
            String name = Ec2IaasHandler.expandVolumeName(nameTemplate, this.applicationName, this.scopedInstance.getName());
            if (Utils.isEmptyOrWhitespaces((String)name)) {
                name = "Created by Roboconf for " + this.tagName;
            }
            this.tagResource(volumeId, name);
            String mountPoint = Ec2IaasHandler.findStorageProperty(this.targetProperties, storageId, "ec2.ebs-mount-point.");
            if (Utils.isEmptyOrWhitespaces((String)mountPoint)) {
                mountPoint = "/dev/sdf";
            }
            AttachVolumeRequest attachRequest = new AttachVolumeRequest().withInstanceId(this.machineId).withDevice(mountPoint).withVolumeId(volumeId);
            try {
                this.ec2Api.attachVolume(attachRequest);
            }
            catch (Exception e) {
                this.logger.warning("EBS Volume attachment error: " + e);
            }
            if (!Boolean.parseBoolean(Ec2IaasHandler.findStorageProperty(this.targetProperties, storageId, "ec2.ebs-delete-on-termination."))) continue;
            EbsInstanceBlockDeviceSpecification ebsSpecification = new EbsInstanceBlockDeviceSpecification().withVolumeId(volumeId).withDeleteOnTermination(true);
            InstanceBlockDeviceMappingSpecification mappingSpecification = new InstanceBlockDeviceMappingSpecification().withDeviceName(mountPoint).withEbs(ebsSpecification);
            ModifyInstanceAttributeRequest request = new ModifyInstanceAttributeRequest().withInstanceId(this.machineId).withBlockDeviceMappings(mappingSpecification);
            this.ec2Api.modifyInstanceAttribute(request);
        }
        return true;
    }

    public static enum State {
        UNKNOWN_VM,
        TAG_VM,
        RUNNING_VM,
        ASSOCIATE_ELASTIC_IP,
        CREATE_VOLUME,
        ATTACH_VOLUME,
        COMPLETE;

    }
}

