/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal;

import java.io.File;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javassist.ClassPool;
import net.roseboy.classfinal.util.ClassUtils;
import net.roseboy.classfinal.util.EncryptUtils;
import net.roseboy.classfinal.util.IoUtils;
import net.roseboy.classfinal.util.JarUtils;

public class JarEncryptor {
    private String jarPath = null;
    private List<String> packages = null;
    private List<String> includeJars = null;
    private List<String> excludeClass = null;
    private String password = null;
    private String jarOrWar = null;
    private String targetDir = null;
    private Integer encryptFileCount = null;

    public JarEncryptor() {
    }

    public JarEncryptor(String jarPath, String password, List<String> packages, List<String> includeJars, List<String> excludeClass) {
        this.jarPath = jarPath;
        this.packages = packages;
        this.includeJars = includeJars;
        this.excludeClass = excludeClass;
        this.password = password;
    }

    public String doEncryptJar() {
        if (!this.jarPath.endsWith(".jar") && !this.jarPath.endsWith(".war")) {
            throw new RuntimeException("jar/war\u6587\u4ef6\u683c\u5f0f\u6709\u8bef");
        }
        if (this.password == null || this.password.length() == 0) {
            throw new RuntimeException("\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.jarOrWar = this.jarPath.substring(this.jarPath.lastIndexOf(".") + 1);
        this.targetDir = this.jarPath.replace("." + this.jarOrWar, "_temp");
        List<String> allFile = JarUtils.unJar(this.jarPath, this.targetDir, this.includeJars);
        Map<String, List<String>> jarClasses = this.groupByJarName(allFile);
        List<String> encryptClass = this.encryptClass(jarClasses);
        this.encryptFileCount = encryptClass.size();
        this.clearClassMethod(jarClasses);
        String result = this.packageJar(jarClasses);
        return result;
    }

    public String doEncryptJar(String jarPath, String password, List<String> packages, List<String> includeJars, List<String> excludeClass) {
        this.jarPath = jarPath;
        this.packages = packages;
        this.includeJars = includeJars;
        this.excludeClass = excludeClass;
        this.password = password;
        return this.doEncryptJar();
    }

    private Map<String, List<String>> groupByJarName(List<String> allFile) {
        HashMap<String, List<String>> jarClasses = new HashMap<String, List<String>>(200);
        for (String file : allFile) {
            String clsName;
            String jarName;
            if (!file.endsWith(".class")) continue;
            file = (file = file.replace(this.targetDir, "")).startsWith("/") ? file.substring(1) : file;
            file = file.replace("/", ".");
            if (((file = file.substring(0, file.length() - 6)).contains("BOOT-INF.lib") || file.contains("WEB-INF.lib")) && file.contains("_temp")) {
                file = file.replace("BOOT-INF.lib.", "").replace("WEB-INF.lib.", "");
                jarName = file.substring(0, file.indexOf("_temp"));
                clsName = file.substring(file.indexOf("_temp") + "_temp".length() + 1);
            } else if (file.contains("BOOT-INF.classes") || file.contains("WEB-INF.classes")) {
                file = file.replace("BOOT-INF.classes.", "").replace("WEB-INF.classes.", "");
                jarName = "CLASSES";
                clsName = file;
            } else {
                jarName = "ROOT";
                clsName = file;
            }
            if (!ClassUtils.isPackage(this.packages, clsName) || this.excludeClass != null && this.excludeClass.size() != 0 && this.excludeClass.contains(clsName)) continue;
            List jarCls = (List)jarClasses.get(jarName);
            jarCls = jarCls == null ? new ArrayList() : jarCls;
            jarCls.add(clsName);
            jarClasses.put(jarName, jarCls);
        }
        return jarClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> encryptClass(Map<String, List<String>> jarClasses) {
        ArrayList<String> encryptClasses = new ArrayList<String>();
        ZipOutputStream zos = null;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(new File(this.targetDir + "/" + "META-INF" + "/" + "classes.dat"));
            zos = new ZipOutputStream(out);
            for (Map.Entry<String, List<String>> entry : jarClasses.entrySet()) {
                for (String classname : entry.getValue()) {
                    String classPath = this.targetDir + "/" + this.realPath(entry.getKey(), classname, this.jarOrWar);
                    File sourceFile = new File(classPath);
                    zos.putNextEntry(new ZipEntry(classname));
                    byte[] bytes = IoUtils.readFileToByte(sourceFile);
                    bytes = EncryptUtils.enSimple(bytes, this.password + classname);
                    zos.write(bytes, 0, bytes.length);
                    zos.closeEntry();
                    encryptClasses.add(classname);
                }
            }
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                IoUtils.close(zos, out);
                throw throwable;
            }
            IoUtils.close(zos, out);
        }
        IoUtils.close(zos, out);
        return encryptClasses;
    }

    private void clearClassMethod(Map<String, List<String>> jarClasses) {
        String libpath = this.targetDir + "/" + ("jar".equals(this.jarOrWar) ? "BOOT-INF" : "WEB-INF") + "/" + "lib" + "/";
        try {
            for (Map.Entry<String, List<String>> entry : jarClasses.entrySet()) {
                ClassPool pool = ClassPool.getDefault();
                ClassUtils.loadClassPath(pool, new String[]{libpath});
                pool.insertClassPath(this.targetDir + "/" + this.realPath(entry.getKey(), null, this.jarOrWar));
                for (String classname : entry.getValue()) {
                    byte[] bts = ClassUtils.rewriteAllMethods(pool, classname);
                    if (bts == null) continue;
                    String path = this.targetDir + "/" + this.realPath(entry.getKey(), classname, this.jarOrWar);
                    IoUtils.writeFile(new File(path), bts);
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    private String packageJar(Map<String, List<String>> jarClasses) {
        String jarOrWar = this.jarPath.substring(this.jarPath.lastIndexOf(".") + 1);
        String libpath = this.targetDir + "/" + ("jar".equals(jarOrWar) ? "BOOT-INF" : "WEB-INF") + "/" + "lib" + "/";
        for (Map.Entry<String, List<String>> entry : jarClasses.entrySet()) {
            if ("CLASSES".equals(entry.getKey()) || "ROOT".equals(entry.getKey())) continue;
            JarUtils.doJar(libpath + entry.getKey() + "_temp", libpath + entry.getKey() + ".jar");
        }
        for (String file : this.includeJars) {
            File dir = new File(libpath + file.replace(".jar", "_temp"));
            if (!dir.exists()) continue;
            IoUtils.delete(dir);
        }
        String result = JarUtils.doJar(this.targetDir, this.jarPath.replace("." + jarOrWar, "-encrypted." + jarOrWar));
        File dir = new File(this.targetDir);
        if (dir.exists()) {
            IoUtils.delete(dir);
        }
        return result;
    }

    private String realPath(String jar, String className, String warOrJar) {
        String inf;
        String string = inf = "jar".equals(warOrJar) ? "BOOT-INF" : "WEB-INF";
        String path = "ROOT".equals(jar) ? "" : ("CLASSES".equals(jar) ? inf + "/" + "classes" : inf + "/" + "lib" + "/" + jar + "_temp");
        if (className == null || className.length() == 0) {
            return path;
        }
        path = path + (path.length() == 0 ? "" : "/") + className.replace(".", "/") + ".class";
        return path;
    }

    public Integer getEncryptFileCount() {
        return this.encryptFileCount;
    }
}

