/*
 * Decompiled with CFR 0.152.
 */
package net.roseboy.classfinal.util;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.Cipher;

public class EncryptUtils {
    private static final String SALT = "whoisyourdaddy#$@#@";
    private static int KEY_LENGTH = 1024;

    public static byte[] enSimple(byte[] msg, int start, int end, String key) {
        byte[] keys = EncryptUtils.merger(EncryptUtils.md5byte(key + SALT), EncryptUtils.md5byte(SALT + key));
        for (int i = start; i <= end; ++i) {
            msg[i] = (byte)(msg[i] ^ keys[i % keys.length]);
        }
        return msg;
    }

    public static byte[] deSimple(byte[] msg, int start, int end, String key) {
        byte[] keys = EncryptUtils.merger(EncryptUtils.md5byte(key + SALT), EncryptUtils.md5byte(SALT + key));
        for (int i = start; i <= end; ++i) {
            msg[i] = (byte)(msg[i] ^ keys[i % keys.length]);
        }
        return msg;
    }

    public static byte[] enSimple(byte[] msg, String key) {
        return EncryptUtils.enSimple(msg, 0, msg.length - 1, key);
    }

    public static byte[] deSimple(byte[] msg, String key) {
        return EncryptUtils.deSimple(msg, 0, msg.length - 1, key);
    }

    public static byte[] md5byte(String str) {
        byte[] b = null;
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(str.getBytes());
            b = md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return b;
    }

    private static byte[] merger(byte[] ... bts) {
        int lenght = 0;
        for (byte[] b : bts) {
            lenght += b.length;
        }
        byte[] bt = new byte[lenght];
        int lastLength = 0;
        for (byte[] b : bts) {
            System.arraycopy(b, 0, bt, lastLength, b.length);
            lastLength = b.length;
        }
        return bt;
    }

    public static String enRSA(String str, String publicKey) {
        try {
            byte[] in = str.getBytes("UTF-8");
            byte[] out = EncryptUtils.enRSA(in, publicKey);
            String outStr = Base64.getEncoder().encodeToString(out);
            return outStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] enRSA(byte[] msg, String publicKey) {
        try {
            byte[] decoded = Base64.getDecoder().decode(publicKey.getBytes("UTF-8"));
            RSAPublicKey pubKey = (RSAPublicKey)KeyFactory.getInstance("RSA").generatePublic(new X509EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(1, pubKey);
            return EncryptUtils.cipherDoFinal(cipher, msg, 1);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String deRSA(String str, String privateKey) {
        try {
            byte[] inputByte = Base64.getDecoder().decode(str.getBytes("UTF-8"));
            String outStr = new String(EncryptUtils.deRSA(inputByte, privateKey));
            return outStr;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] deRSA(byte[] msg, String privateKey) {
        try {
            byte[] decoded = Base64.getDecoder().decode(privateKey.getBytes("UTF-8"));
            RSAPrivateKey priKey = (RSAPrivateKey)KeyFactory.getInstance("RSA").generatePrivate(new PKCS8EncodedKeySpec(decoded));
            Cipher cipher = Cipher.getInstance("RSA");
            cipher.init(2, priKey);
            return EncryptUtils.cipherDoFinal(cipher, msg, 2);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static byte[] cipherDoFinal(Cipher cipher, byte[] msg, int mode) throws Exception {
        int in_length = 0;
        if (mode == 1) {
            in_length = KEY_LENGTH / 8 - 11;
        } else if (mode == 2) {
            in_length = KEY_LENGTH / 8;
        }
        byte[] in = new byte[in_length];
        byte[] out = new byte[]{};
        for (int i = 0; i < msg.length; ++i) {
            if (msg.length - i < in_length && i % in_length == 0) {
                in = new byte[msg.length - i];
            }
            in[i % in_length] = msg[i];
            if (i != msg.length - 1 && i % in_length + 1 != in_length) continue;
            out = EncryptUtils.merger(out, cipher.doFinal(in));
        }
        return out;
    }

    public static Map<Integer, String> genKeyPair() throws NoSuchAlgorithmException {
        KeyPairGenerator keyPairGen = KeyPairGenerator.getInstance("RSA");
        keyPairGen.initialize(KEY_LENGTH, new SecureRandom());
        KeyPair keyPair = keyPairGen.generateKeyPair();
        RSAPrivateKey privateKey = (RSAPrivateKey)keyPair.getPrivate();
        RSAPublicKey publicKey = (RSAPublicKey)keyPair.getPublic();
        BigInteger publicExponent = publicKey.getPublicExponent();
        BigInteger modulus = publicKey.getModulus();
        String publicKeyString = new String(Base64.getEncoder().encode(publicKey.getEncoded()));
        String privateKeyString = new String(Base64.getEncoder().encode(privateKey.getEncoded()));
        HashMap<Integer, String> keyMap = new HashMap<Integer, String>();
        keyMap.put(0, publicKeyString);
        keyMap.put(1, privateKeyString);
        keyMap.put(2, modulus.toString(16));
        keyMap.put(3, publicExponent.toString(16));
        return keyMap;
    }

    public static void main(String[] args) throws Exception {
        Map<Integer, String> keyMap = EncryptUtils.genKeyPair();
        String message = "\u6d4b\u8bd5abcd1234\uff01@#\u00a5";
        for (int i = 0; i <= 10; ++i) {
            message = message + message;
        }
        System.out.println("\u516c\u94a5:" + keyMap.get(0));
        System.out.println("\u79c1\u94a5:" + keyMap.get(1));
        String messageEn = EncryptUtils.enRSA(message, keyMap.get(0));
        System.out.println("\u5bc6\u6587:" + messageEn);
        String messageDe = EncryptUtils.deRSA(messageEn, keyMap.get(1));
        System.out.println("\u660e\u6587:" + message);
        System.out.println("\u660e\u6587:" + messageDe);
    }
}

